/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.changes;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.ui.Scroll;
import com.intellij.space.utils.UtilitiesKt;
import com.intellij.space.vcs.changes.SpaceChange;
import com.intellij.space.vcs.changes.SpaceChangesTree;
import com.intellij.space.vcs.changes.SpaceChangesVm;
import com.intellij.space.vcs.changes.SpaceDiffFileProvider;
import com.intellij.space.vcs.changes.SpaceEditorDiffPreview;
import com.intellij.ui.components.JBLoadingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.CellableKt;
import runtime.reactive.LoadingValue;
import runtime.reactive.MutableProperty;
import runtime.reactive.Property;
import runtime.reactive.Source;
import runtime.reactive.SourceKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u001d\u001a\u00020\u001eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Lcom/intellij/space/vcs/changes/SpaceChangesTreeComponent;", "", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "parentPanel", "Ljavax/swing/JComponent;", "changesVm", "Lcom/intellij/space/vcs/changes/SpaceChangesVm;", "spaceDiffFileProvider", "Lcom/intellij/space/vcs/changes/SpaceDiffFileProvider;", "statsPlace", "Lcom/intellij/space/stats/SpaceStatsCounterCollector$DiffPlace;", "(Llibraries/coroutines/extra/Lifetime;Lcom/intellij/openapi/project/Project;Ljavax/swing/JComponent;Lcom/intellij/space/vcs/changes/SpaceChangesVm;Lcom/intellij/space/vcs/changes/SpaceDiffFileProvider;Lcom/intellij/space/stats/SpaceStatsCounterCollector$DiffPlace;)V", "_loaded", "Lruntime/reactive/MutableProperty;", "", "changesTree", "Lcom/intellij/space/vcs/changes/SpaceChangesTree;", "getChangesTree", "()Lcom/intellij/space/vcs/changes/SpaceChangesTree;", "loaded", "Lruntime/reactive/Property;", "getLoaded", "()Lruntime/reactive/Property;", "view", "getView", "()Ljavax/swing/JComponent;", "createChangesBrowserToolbar", "Lcom/intellij/openapi/vcs/changes/ui/TreeActionsToolbarPanel;", "Companion", "intellij.space"})
public final class SpaceChangesTreeComponent {
    @NotNull
    private final SpaceChangesTree changesTree;
    @NotNull
    private final JComponent view;
    private final MutableProperty<Boolean> _loaded;
    @NotNull
    private final Property<Boolean> loaded;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final SpaceChangesTree getChangesTree() {
        return this.changesTree;
    }

    @NotNull
    public final JComponent getView() {
        return this.view;
    }

    @NotNull
    public final Property<Boolean> getLoaded() {
        return this.loaded;
    }

    @NotNull
    public final TreeActionsToolbarPanel createChangesBrowserToolbar() {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction("space.review.changes.toolbar");
        if (anAction == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        }
        ActionGroup changesToolbarActionGroup = (ActionGroup)anAction;
        ActionToolbar actionToolbar = actionManager.createActionToolbar("ChangesBrowser", changesToolbarActionGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"actionManager.createActi\u2026ToolbarActionGroup, true)");
        ActionToolbar changesToolbar = actionToolbar;
        DefaultActionGroup treeActionsGroup = new DefaultActionGroup(new AnAction[]{actionManager.getAction("ExpandAll"), actionManager.getAction("CollapseAll")});
        return new TreeActionsToolbarPanel(changesToolbar, (ActionGroup)treeActionsGroup, this.view);
    }

    public SpaceChangesTreeComponent(@NotNull Lifetime lifetime, @NotNull Project project, @NotNull JComponent parentPanel, final @NotNull SpaceChangesVm changesVm2, @NotNull SpaceDiffFileProvider spaceDiffFileProvider, @NotNull SpaceStatsCounterCollector.DiffPlace statsPlace) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentPanel, (String)"parentPanel");
        Intrinsics.checkNotNullParameter((Object)changesVm2, (String)"changesVm");
        Intrinsics.checkNotNullParameter((Object)spaceDiffFileProvider, (String)"spaceDiffFileProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)statsPlace), (String)"statsPlace");
        this.changesTree = new SpaceChangesTree(project);
        this._loaded = CellableKt.mutableProperty((Object)false);
        this.loaded = (Property)this._loaded;
        Disposable disposable = UtilitiesKt.nestedDisposable(lifetime);
        final JBLoadingPanel loadingPane = new JBLoadingPanel((LayoutManager)new BorderLayout(), disposable, 300);
        SourceKt.view((Source)((Source)changesVm2.getChanges()), (Lifetime)lifetime, (Function2)((Function2)new Function2<Lifetime, LoadingValue<? extends List<? extends SpaceChange>>, Unit>(){

            public final void invoke(@NotNull Lifetime changesStateLifetime, @NotNull LoadingValue<? extends List<SpaceChange>> loadingChanges) {
                block1: {
                    LoadingValue<? extends List<SpaceChange>> loadingValue;
                    block2: {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)changesStateLifetime, (String)"changesStateLifetime");
                            Intrinsics.checkNotNullParameter(loadingChanges, (String)"loadingChanges");
                            _loaded.setValue((Object)false);
                            this.getChangesTree().setChanges(CollectionsKt.emptyList());
                            loadingValue = loadingChanges;
                            if (!(loadingValue instanceof LoadingValue.Loaded)) break block0;
                            loadingPane.stopLoading();
                            this.getChangesTree().setChanges((List)((LoadingValue.Loaded)loadingChanges).getValue());
                            this.getChangesTree().getSelection().forEach(changesStateLifetime, (Function1)new Function1<ListSelection<SpaceChange>, Unit>(){

                                public final void invoke(@NotNull ListSelection<SpaceChange> selection2) {
                                    Intrinsics.checkNotNullParameter(selection2, (String)"selection");
                                    if (!selection2.isEmpty()) {
                                        changesVm2.setSelectedChanges(selection2);
                                    }
                                }
                            });
                            _loaded.setValue((Object)true);
                            break block1;
                        }
                        if (!Intrinsics.areEqual(loadingValue, (Object)LoadingValue.Loading.INSTANCE)) break block2;
                        loadingPane.startLoading();
                        this.getChangesTree().setEmptyText("");
                        break block1;
                    }
                    if (!(loadingValue instanceof LoadingValue.Failure)) break block1;
                    loadingPane.stopLoading();
                    LOG.info("Could not load changes for selected commits", ((LoadingValue.Failure)loadingChanges).getError());
                    this.getChangesTree().setEmptyText(SpaceBundle.message("review.changes.browser.failure.text", new Object[0]));
                    _loaded.setValue((Object)true);
                }
            }
        }));
        changesVm2.getSelectedFilePath().forEach(lifetime, (Function1)new Function1<FilePath, Unit>(this.changesTree){

            public final void invoke(@Nullable FilePath p1) {
                ((SpaceChangesTree)((Object)this.receiver)).selectFile(p1);
            }
        });
        SpaceEditorDiffPreview editorDiffPreview = new SpaceEditorDiffPreview(project, this.changesTree, spaceDiffFileProvider, statsPlace);
        this.changesTree.installDiffPreview(editorDiffPreview);
        DataManager.registerDataProvider((JComponent)parentPanel, (DataProvider)new DataProvider(){

            @Nullable
            public final Object getData(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.getChangesTree().isShowing() ? this.getChangesTree().getData(it) : null;
            }
        });
        AnAction anAction = ActionManager.getInstance().getAction("space.review.changes.popup");
        if (anAction == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        }
        this.changesTree.installPopupHandler((ActionGroup)anAction);
        JBLoadingPanel jBLoadingPanel = loadingPane;
        boolean bl = false;
        boolean bl2 = false;
        JBLoadingPanel $this$apply = jBLoadingPanel;
        boolean bl3 = false;
        $this$apply.add((Component)Scroll.INSTANCE.wrapWithScrollPane((JComponent)((Object)this.changesTree)), (Object)"Center");
        this.view = (JComponent)loadingPane;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SpaceChangesTreeComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/space/vcs/changes/SpaceChangesTreeComponent$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.space"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

