/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.ArtifactInfoGroup;
import org.sonatype.nexus.index.ArtifactScanningListener;
import org.sonatype.nexus.index.FlatSearchRequest;
import org.sonatype.nexus.index.FlatSearchResponse;
import org.sonatype.nexus.index.GroupedSearchRequest;
import org.sonatype.nexus.index.GroupedSearchResponse;
import org.sonatype.nexus.index.Grouping;
import org.sonatype.nexus.index.context.IndexCreator;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.context.UnsupportedExistingLuceneIndexException;
import org.sonatype.nexus.index.creator.JarFileContentsIndexCreator;
import org.sonatype.nexus.index.creator.MinimalArtifactInfoIndexCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface NexusIndexer {
    public static final String ROLE = NexusIndexer.class.getName();
    public static final List<? extends IndexCreator> MINIMAL_INDEX = Arrays.asList(new MinimalArtifactInfoIndexCreator());
    public static final List<? extends IndexCreator> FULL_INDEX = Arrays.asList(new MinimalArtifactInfoIndexCreator(), new JarFileContentsIndexCreator());
    public static final List<? extends IndexCreator> DEFAULT_INDEX = FULL_INDEX;

    public IndexingContext addIndexingContext(String var1, String var2, File var3, File var4, String var5, String var6, List<? extends IndexCreator> var7) throws IOException, UnsupportedExistingLuceneIndexException;

    public IndexingContext addIndexingContextForced(String var1, String var2, File var3, File var4, String var5, String var6, List<? extends IndexCreator> var7) throws IOException;

    public IndexingContext addIndexingContext(String var1, String var2, File var3, File var4, String var5, String var6, List<? extends IndexCreator> var7, boolean var8) throws IOException, UnsupportedExistingLuceneIndexException;

    public IndexingContext addIndexingContext(String var1, String var2, File var3, Directory var4, String var5, String var6, List<? extends IndexCreator> var7) throws IOException, UnsupportedExistingLuceneIndexException;

    public IndexingContext addIndexingContextForced(String var1, String var2, File var3, Directory var4, String var5, String var6, List<? extends IndexCreator> var7) throws IOException;

    public IndexingContext addIndexingContext(String var1, String var2, File var3, Directory var4, String var5, String var6, List<? extends IndexCreator> var7, boolean var8) throws IOException, UnsupportedExistingLuceneIndexException;

    public void removeIndexingContext(IndexingContext var1, boolean var2) throws IOException;

    public Map<String, IndexingContext> getIndexingContexts();

    public void scan(IndexingContext var1) throws IOException;

    public void scan(IndexingContext var1, ArtifactScanningListener var2) throws IOException;

    public void scan(IndexingContext var1, ArtifactScanningListener var2, boolean var3) throws IOException;

    public void artifactDiscovered(ArtifactContext var1, IndexingContext var2) throws IOException;

    public void addArtifactToIndex(ArtifactContext var1, IndexingContext var2) throws IOException;

    public void deleteArtifactFromIndex(ArtifactContext var1, IndexingContext var2) throws IOException;

    public Collection<ArtifactInfo> searchFlat(Query var1) throws IOException;

    public Collection<ArtifactInfo> searchFlat(Query var1, IndexingContext var2) throws IOException;

    public Collection<ArtifactInfo> searchFlat(Comparator<ArtifactInfo> var1, Query var2) throws IOException;

    public Collection<ArtifactInfo> searchFlat(Comparator<ArtifactInfo> var1, Query var2, IndexingContext var3) throws IOException;

    public FlatSearchResponse searchFlat(FlatSearchRequest var1) throws IOException;

    public Map<String, ArtifactInfoGroup> searchGrouped(Grouping var1, Query var2) throws IOException;

    public Map<String, ArtifactInfoGroup> searchGrouped(Grouping var1, Query var2, IndexingContext var3) throws IOException;

    public Map<String, ArtifactInfoGroup> searchGrouped(Grouping var1, Comparator<String> var2, Query var3) throws IOException;

    public Map<String, ArtifactInfoGroup> searchGrouped(Grouping var1, Comparator<String> var2, Query var3, IndexingContext var4) throws IOException;

    public GroupedSearchResponse searchGrouped(GroupedSearchRequest var1) throws IOException;

    public Query constructQuery(String var1, String var2);

    public ArtifactInfo identify(File var1) throws IOException;

    public ArtifactInfo identify(String var1, String var2) throws IOException;

    public ArtifactInfo identify(Query var1) throws IOException;

    public ArtifactInfo identify(Query var1, Collection<IndexingContext> var2) throws IOException;
}

