/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.codeInspection;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesList;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PropertiesInspectionSuppressor
implements InspectionSuppressor {
    private static final Logger LOG = Logger.getInstance(PropertiesInspectionSuppressor.class);

    public SuppressQuickFix @NotNull [] getSuppressActions(PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            PropertiesInspectionSuppressor.$$$reportNull$$$0(0);
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new SuppressSinglePropertyFix(toolId), new SuppressForFile(toolId)};
        if (suppressQuickFixArray == null) {
            PropertiesInspectionSuppressor.$$$reportNull$$$0(1);
        }
        return suppressQuickFixArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        String text;
        PropertiesFile file;
        Property property;
        if (element == null) {
            PropertiesInspectionSuppressor.$$$reportNull$$$0(2);
        }
        if (toolId == null) {
            PropertiesInspectionSuppressor.$$$reportNull$$$0(3);
        }
        if ((property = (Property)PsiTreeUtil.getParentOfType((PsiElement)element, Property.class, (boolean)false)) == null) {
            PsiFile containingFile = element.getContainingFile();
            if (!(containingFile instanceof PropertiesFile)) return false;
            file = (PropertiesFile)containingFile;
        } else {
            PsiElement prev = property.getPrevSibling();
            while (prev instanceof PsiWhiteSpace || prev instanceof PsiComment) {
                if (prev instanceof PsiComment && (text = prev.getText()).contains("suppress") && text.contains("\"" + toolId + "\"")) {
                    return true;
                }
                prev = prev.getPrevSibling();
            }
            file = property.getPropertiesFile();
        }
        PsiElement leaf = file.getContainingFile().findElementAt(0);
        while (leaf instanceof PsiWhiteSpace) {
            leaf = leaf.getNextSibling();
        }
        while (leaf instanceof PsiComment) {
            text = leaf.getText();
            if (text.contains("suppress") && text.contains("\"" + toolId + "\"") && text.contains("file")) {
                return true;
            }
            if ((leaf = leaf.getNextSibling()) instanceof PsiWhiteSpace) {
                leaf = leaf.getNextSibling();
            }
            if (!(leaf instanceof PropertiesList) || leaf.getFirstChild() != property || !text.contains("suppress") || !text.contains("\"" + toolId + "\"")) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/codeInspection/PropertiesInspectionSuppressor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/codeInspection/PropertiesInspectionSuppressor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SuppressForFile
    implements SuppressQuickFix {
        private final String shortName;

        private SuppressForFile(String shortName) {
            this.shortName = shortName;
        }

        @NotNull
        public String getFamilyName() {
            String string = PropertiesBundle.message("unused.property.suppress.for.file", new Object[0]);
            if (string == null) {
                SuppressForFile.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                SuppressForFile.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                SuppressForFile.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getStartElement();
            PsiFile file = element.getContainingFile();
            @NonNls Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            LOG.assertTrue(doc != null, (Object)file);
            doc.insertString(0, (CharSequence)("# suppress inspection \"" + this.shortName + "\" for whole file\n"));
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            if (project == null) {
                SuppressForFile.$$$reportNull$$$0(3);
            }
            if (context == null) {
                SuppressForFile.$$$reportNull$$$0(4);
            }
            return context.isValid() && context.getContainingFile() instanceof PropertiesFile;
        }

        public boolean isSuppressAll() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/properties/codeInspection/PropertiesInspectionSuppressor$SuppressForFile";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/properties/codeInspection/PropertiesInspectionSuppressor$SuppressForFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class SuppressSinglePropertyFix
    implements SuppressQuickFix {
        private final String shortName;

        private SuppressSinglePropertyFix(String shortName) {
            this.shortName = shortName;
        }

        @NotNull
        public String getFamilyName() {
            String string = PropertiesBundle.message("unused.property.suppress.for.property", new Object[0]);
            if (string == null) {
                SuppressSinglePropertyFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                SuppressSinglePropertyFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                SuppressSinglePropertyFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getStartElement();
            PsiFile file = element.getContainingFile();
            Property property = (Property)PsiTreeUtil.getParentOfType((PsiElement)element, Property.class);
            LOG.assertTrue(property != null);
            int start = property.getTextRange().getStartOffset();
            @NonNls Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            LOG.assertTrue(doc != null);
            int line = doc.getLineNumber(start);
            int lineStart = doc.getLineStartOffset(line);
            doc.insertString(lineStart, (CharSequence)("# suppress inspection \"" + this.shortName + "\"\n"));
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            Property property;
            if (project == null) {
                SuppressSinglePropertyFix.$$$reportNull$$$0(3);
            }
            if (context == null) {
                SuppressSinglePropertyFix.$$$reportNull$$$0(4);
            }
            return (property = (Property)PsiTreeUtil.getParentOfType((PsiElement)context, Property.class)) != null && property.isValid();
        }

        public boolean isSuppressAll() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/properties/codeInspection/PropertiesInspectionSuppressor$SuppressSinglePropertyFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/properties/codeInspection/PropertiesInspectionSuppressor$SuppressSinglePropertyFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

