/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonReaderBuilder;
import com.intellij.util.ThrowableConsumer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingConfig;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingModel;
import org.jetbrains.plugins.gradle.tooling.internal.AnnotationProcessingConfigImpl;
import org.jetbrains.plugins.gradle.tooling.internal.AnnotationProcessingModelImpl;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingStreamApiUtils;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.Supplier;
import org.jetbrains.plugins.gradle.tooling.util.IntObjectMap;
import org.jetbrains.plugins.gradle.tooling.util.ObjectCollector;

public final class AnnotationProcessingModelSerializationService
implements SerializationService<AnnotationProcessingModel> {
    private final WriteContext myWriteContext = new WriteContext();
    private final ReadContext myReadContext = new ReadContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] write(AnnotationProcessingModel annotationProcessingModel, Class<? extends AnnotationProcessingModel> modelClazz) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IonWriter writer = ToolingStreamApiUtils.createIonWriter().build((OutputStream)out);
        try {
            AnnotationProcessingModelSerializationService.write(writer, this.myWriteContext, annotationProcessingModel);
        }
        finally {
            writer.close();
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotationProcessingModel read(byte[] object, Class<? extends AnnotationProcessingModel> modelClazz) throws IOException {
        IonReader reader = IonReaderBuilder.standard().build(object);
        try {
            AnnotationProcessingModel annotationProcessingModel = AnnotationProcessingModelSerializationService.read(reader, this.myReadContext);
            return annotationProcessingModel;
        }
        finally {
            reader.close();
        }
    }

    private static void write(final IonWriter writer, final WriteContext context, final AnnotationProcessingModel model) throws IOException {
        context.objectCollector.add(model, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    AnnotationProcessingModelSerializationService.writeConfigs(writer, context, model.allConfigs());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeConfigs(final IonWriter writer, final WriteContext context, Map<String, AnnotationProcessingConfig> configs) throws IOException {
        ToolingStreamApiUtils.writeMap(writer, "configs", configs, new ThrowableConsumer<String, IOException>(){

            public void consume(String s) throws IOException {
                writer.writeString(s);
            }
        }, new ThrowableConsumer<AnnotationProcessingConfig, IOException>(){

            public void consume(AnnotationProcessingConfig config) throws IOException {
                AnnotationProcessingModelSerializationService.writeConfig(writer, context, config);
            }
        });
    }

    private static void writeConfig(final IonWriter writer, WriteContext context, final AnnotationProcessingConfig config) throws IOException {
        context.configCollector.add(config, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeStrings(writer, "args", config.getAnnotationProcessorArguments());
                    ToolingStreamApiUtils.writeStrings(writer, "paths", config.getAnnotationProcessorPath());
                    ToolingStreamApiUtils.writeString(writer, "output", config.getProcessorOutput());
                    ToolingStreamApiUtils.writeBoolean(writer, "isTestSources", config.isTestSources());
                }
                writer.stepOut();
            }
        });
    }

    private static AnnotationProcessingModel read(final IonReader reader, final ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        AnnotationProcessingModelImpl model = (AnnotationProcessingModelImpl)context.objectMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.SimpleObjectFactory<AnnotationProcessingModelImpl>(){

            public AnnotationProcessingModelImpl create() {
                Map configs = AnnotationProcessingModelSerializationService.readConfigs(reader, context);
                return new AnnotationProcessingModelImpl(configs);
            }
        });
        reader.stepOut();
        return model;
    }

    private static Map<String, AnnotationProcessingConfig> readConfigs(final IonReader reader, final ReadContext context) {
        return ToolingStreamApiUtils.readMap(reader, new Supplier<String>(){

            public String get() {
                return ToolingStreamApiUtils.readString(reader, null);
            }
        }, new Supplier<AnnotationProcessingConfig>(){

            public AnnotationProcessingConfig get() {
                return AnnotationProcessingModelSerializationService.readConfig(reader, context);
            }
        });
    }

    private static AnnotationProcessingConfig readConfig(final IonReader reader, ReadContext context) {
        reader.next();
        reader.stepIn();
        AnnotationProcessingConfigImpl config = (AnnotationProcessingConfigImpl)context.configMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.SimpleObjectFactory<AnnotationProcessingConfigImpl>(){

            public AnnotationProcessingConfigImpl create() {
                List<String> args = ToolingStreamApiUtils.readStringList(reader);
                List<File> files = ToolingStreamApiUtils.readFiles(reader);
                String output = ToolingStreamApiUtils.readString(reader, "output");
                boolean isTest = ToolingStreamApiUtils.readBoolean(reader, "isTestSources");
                return new AnnotationProcessingConfigImpl(files, args, output, isTest);
            }
        });
        reader.stepOut();
        return config;
    }

    public Class<? extends AnnotationProcessingModel> getModelClass() {
        return AnnotationProcessingModel.class;
    }

    private static class ReadContext {
        private final IntObjectMap<AnnotationProcessingModelImpl> objectMap = new IntObjectMap();
        private final IntObjectMap<AnnotationProcessingConfigImpl> configMap = new IntObjectMap();

        private ReadContext() {
        }
    }

    private static class WriteContext {
        private final ObjectCollector<AnnotationProcessingModel, IOException> objectCollector = new ObjectCollector();
        private final ObjectCollector<AnnotationProcessingConfig, IOException> configCollector = new ObjectCollector();

        private WriteContext() {
        }
    }
}

