/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.messages;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.incremental.messages.BuildMessage;

public class ProgressMessage
extends BuildMessage {
    private volatile float myDone;
    private final BuildTargetChunk myCurrentTargets;

    public ProgressMessage(@Nls(capitalization=Nls.Capitalization.Sentence) String messageText, BuildTargetChunk currentTargets) {
        this(messageText, -1.0f, currentTargets);
    }

    public ProgressMessage(@Nls(capitalization=Nls.Capitalization.Sentence) String messageText) {
        this(messageText, -1.0f);
    }

    public ProgressMessage(@Nls(capitalization=Nls.Capitalization.Sentence) String messageText, float done) {
        this(messageText, done, null);
    }

    private ProgressMessage(@Nls(capitalization=Nls.Capitalization.Sentence) String messageText, float done, BuildTargetChunk currentTargets) {
        super(messageText, BuildMessage.Kind.PROGRESS);
        this.myDone = done;
        this.myCurrentTargets = currentTargets;
    }

    public float getDone() {
        return this.myDone;
    }

    public void setDone(float done) {
        this.myDone = done;
    }

    @Nullable
    public BuildTargetChunk getCurrentTargets() {
        return this.myCurrentTargets;
    }
}

