/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import gnu.trove.TIntHashSet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;

public final class OutputToTargetRegistry
extends AbstractStateStorage<Integer, TIntHashSet> {
    private final PathRelativizerService myRelativizer;
    private static final DataExternalizer<TIntHashSet> DATA_EXTERNALIZER = new DataExternalizer<TIntHashSet>(){

        public void save(@NotNull DataOutput out, TIntHashSet value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            Ref exRef = Ref.create(null);
            value.forEach(value1 -> {
                try {
                    out.writeInt(value1);
                }
                catch (IOException e) {
                    exRef.set((Object)e);
                    return false;
                }
                return true;
            });
            IOException error = (IOException)exRef.get();
            if (error != null) {
                throw error;
            }
        }

        public TIntHashSet read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            TIntHashSet result = new TIntHashSet();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                result.add(in.readInt());
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/incremental/storage/OutputToTargetRegistry$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    OutputToTargetRegistry(File storePath, PathRelativizerService relativizer) throws IOException {
        super(storePath, EnumeratorIntegerDescriptor.INSTANCE, DATA_EXTERNALIZER);
        this.myRelativizer = relativizer;
    }

    void addMapping(String outputPath, int buildTargetId) throws IOException {
        this.addMapping(Collections.singleton(outputPath), buildTargetId);
    }

    void addMapping(Collection<String> outputPaths, int buildTargetId) throws IOException {
        TIntHashSet set = new TIntHashSet();
        set.add(buildTargetId);
        for (String outputPath : outputPaths) {
            this.appendData(FileUtil.pathHashCode((String)this.relativePath(outputPath)), set);
        }
    }

    public void removeMapping(String outputPath, int buildTargetId) throws IOException {
        this.removeMapping(Collections.singleton(outputPath), buildTargetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapping(Collection<String> outputPaths, int buildTargetId) throws IOException {
        if (outputPaths.isEmpty()) {
            return;
        }
        for (String outputPath : outputPaths) {
            int key = FileUtil.pathHashCode((String)this.relativePath(outputPath));
            Object object = this.myDataLock;
            synchronized (object) {
                TIntHashSet state = (TIntHashSet)this.getState(key);
                if (state != null) {
                    boolean removed = state.remove(buildTargetId);
                    if (state.isEmpty()) {
                        this.remove(key);
                    } else if (removed) {
                        this.update(key, state);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getSafeToDeleteOutputs(Collection<String> outputPaths, int currentTargetId) throws IOException {
        int size = outputPaths.size();
        if (size == 0) {
            return outputPaths;
        }
        ArrayList<String> result = new ArrayList<String>(size);
        for (String outputPath : outputPaths) {
            int key = FileUtil.pathHashCode((String)this.relativePath(outputPath));
            Object object = this.myDataLock;
            synchronized (object) {
                TIntHashSet associatedTargets = (TIntHashSet)this.getState(key);
                if (associatedTargets == null || associatedTargets.size() != 1) {
                    continue;
                }
                if (associatedTargets.contains(currentTargetId)) {
                    result.add(outputPath);
                }
            }
        }
        return result;
    }

    @NotNull
    private String relativePath(@NotNull String path) {
        if (path == null) {
            OutputToTargetRegistry.$$$reportNull$$$0(0);
        }
        String string = this.myRelativizer.toRelative(path);
        if (string == null) {
            OutputToTargetRegistry.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/OutputToTargetRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/OutputToTargetRegistry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "relativePath";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

