/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomReferenceInjector;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Referencing;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.ConverterManagerImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.GenericDomValueReference;
import com.intellij.xml.util.XmlEnumeratedValueReferenceProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class GenericValueReferenceProvider
extends PsiReferenceProvider {
    private static final Logger LOG = Logger.getInstance(GenericValueReferenceProvider.class);

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext context) {
        DomInvocationHandler handler;
        if (psiElement == null) {
            GenericValueReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GenericValueReferenceProvider.$$$reportNull$$$0(1);
        }
        DomManagerImpl domManager = DomManagerImpl.getDomManager(psiElement.getProject());
        if (psiElement instanceof XmlTag) {
            handler = domManager.getDomHandler((XmlElement)((XmlTag)psiElement));
        } else if (psiElement instanceof XmlAttributeValue && psiElement.getParent() instanceof XmlAttribute) {
            handler = domManager.getDomHandler((XmlElement)((XmlAttribute)psiElement.getParent()));
        } else {
            if (PsiReference.EMPTY_ARRAY == null) {
                GenericValueReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (handler == null || !GenericDomValue.class.isAssignableFrom(handler.getRawType())) {
            if (PsiReference.EMPTY_ARRAY == null) {
                GenericValueReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (psiElement instanceof XmlTag) {
            for (XmlText text : ((XmlTag)psiElement).getValue().getTextElements()) {
                if (!InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)text))) continue;
                if (PsiReference.EMPTY_ARRAY == null) {
                    GenericValueReferenceProvider.$$$reportNull$$$0(4);
                }
                return PsiReference.EMPTY_ARRAY;
            }
        } else if (InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)psiElement))) {
            if (PsiReference.EMPTY_ARRAY == null) {
                GenericValueReferenceProvider.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        GenericDomValue domValue = (GenericDomValue)handler.getProxy();
        Referencing referencing = handler.getAnnotation(Referencing.class);
        Object converter = referencing == null ? WrappingConverter.getDeepestConverter((Converter)domValue.getConverter(), (GenericDomValue)domValue) : ConverterManagerImpl.getOrCreateConverterInstance(referencing.value());
        PsiReference[] references = GenericValueReferenceProvider.createReferences(domValue, (XmlElement)psiElement, converter, handler, domManager);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (PsiReference reference : references) {
                if (reference.isSoft()) continue;
                LOG.error("dom reference should be soft: " + reference + " (created by " + converter + ")");
            }
        }
        if (references.length > 0) {
            if (converter instanceof EnumConverter && !((EnumConverter)((Object)converter)).isExhaustive()) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    GenericValueReferenceProvider.$$$reportNull$$$0(6);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            context.put(XmlEnumeratedValueReferenceProvider.SUPPRESS, (Object)Boolean.TRUE);
        }
        if (references == null) {
            GenericValueReferenceProvider.$$$reportNull$$$0(7);
        }
        return references;
    }

    private static PsiReference[] createReferences(GenericDomValue<?> domValue, XmlElement psiElement, Object converter, DomInvocationHandler handler, DomManager domManager) {
        XmlFile file = handler.getFile();
        DomFileDescription description = domManager.getDomFileDescription(file);
        if (description == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList result = new ArrayList();
        ConvertContext context = ConvertContextFactory.createConvertContext(domValue);
        List injectors = description.getReferenceInjectors();
        if (!injectors.isEmpty()) {
            String unresolvedText = ElementManipulators.getValueText((PsiElement)psiElement);
            for (DomReferenceInjector each : injectors) {
                Collections.addAll(result, each.inject(unresolvedText, (PsiElement)psiElement, context));
            }
        }
        Collections.addAll(result, GenericValueReferenceProvider.doCreateReferences(domValue, psiElement, converter, context));
        return result.toArray(PsiReference.EMPTY_ARRAY);
    }

    private static PsiReference @NotNull [] doCreateReferences(GenericDomValue domValue, XmlElement psiElement, Object converter, ConvertContext context) {
        PsiReference[] references;
        if (converter instanceof CustomReferenceConverter && ((references = ((CustomReferenceConverter)converter).createReferences(domValue, (PsiElement)psiElement, context)).length != 0 || !(converter instanceof ResolvingConverter))) {
            if (references == null) {
                GenericValueReferenceProvider.$$$reportNull$$$0(8);
            }
            return references;
        }
        if (converter instanceof ResolvingConverter) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new GenericDomValueReference(domValue)};
            if (psiReferenceArray == null) {
                GenericValueReferenceProvider.$$$reportNull$$$0(9);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            GenericValueReferenceProvider.$$$reportNull$$$0(10);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/GenericValueReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/GenericValueReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

