/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import junit.framework.ComparisonFailure;

public class ComparisonDetailsExtractor {
    private static final Map EXPECTED = new HashMap();
    private static final Map ACTUAL = new HashMap();
    protected String myActual = "";
    protected String myExpected = "";
    private final Throwable myAssertion;

    private static void init(Class exceptionClass) throws NoSuchFieldException {
        Field expectedField = exceptionClass.getDeclaredField("fExpected");
        expectedField.setAccessible(true);
        EXPECTED.put(exceptionClass, expectedField);
        Field actualField = exceptionClass.getDeclaredField("fActual");
        actualField.setAccessible(true);
        ACTUAL.put(exceptionClass, actualField);
    }

    public ComparisonDetailsExtractor(Throwable assertion, String expected, String actual) {
        this.myAssertion = assertion;
        this.myActual = actual;
        this.myExpected = expected;
    }

    public static String getActual(Throwable assertion) throws IllegalAccessException, NoSuchFieldException {
        return ComparisonDetailsExtractor.get(assertion, ACTUAL, "fActual");
    }

    public static String getExpected(Throwable assertion) throws IllegalAccessException, NoSuchFieldException {
        return ComparisonDetailsExtractor.get(assertion, EXPECTED, "fExpected");
    }

    private static String get(Throwable assertion, Map staticMap, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        String actual;
        if (assertion instanceof ComparisonFailure) {
            actual = (String)((Field)staticMap.get(ComparisonFailure.class)).get(assertion);
        } else if (assertion instanceof org.junit.ComparisonFailure) {
            actual = (String)((Field)staticMap.get(org.junit.ComparisonFailure.class)).get(assertion);
        } else {
            Field field = assertion.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            actual = (String)field.get(assertion);
        }
        return actual;
    }

    static {
        try {
            ComparisonDetailsExtractor.init(ComparisonFailure.class);
            ComparisonDetailsExtractor.init(org.junit.ComparisonFailure.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

