/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.lang.xpath.XPathElementTypes;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.XPathLexer;
import org.intellij.lang.xpath.XPathParser;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.psi.impl.XPathAxisSpecifierImpl;
import org.intellij.lang.xpath.psi.impl.XPathBinaryExpressionImpl;
import org.intellij.lang.xpath.psi.impl.XPathEmbeddedContentImpl;
import org.intellij.lang.xpath.psi.impl.XPathFilterExpressionImpl;
import org.intellij.lang.xpath.psi.impl.XPathFunctionCallImpl;
import org.intellij.lang.xpath.psi.impl.XPathLocationPathImpl;
import org.intellij.lang.xpath.psi.impl.XPathNodeTestImpl;
import org.intellij.lang.xpath.psi.impl.XPathNodeTypeTestImpl;
import org.intellij.lang.xpath.psi.impl.XPathNumberImpl;
import org.intellij.lang.xpath.psi.impl.XPathParenthesizedExpressionImpl;
import org.intellij.lang.xpath.psi.impl.XPathPredicateImpl;
import org.intellij.lang.xpath.psi.impl.XPathPrefixExpressionImpl;
import org.intellij.lang.xpath.psi.impl.XPathStepImpl;
import org.intellij.lang.xpath.psi.impl.XPathStringImpl;
import org.intellij.lang.xpath.psi.impl.XPathTokenImpl;
import org.intellij.lang.xpath.psi.impl.XPathVariableReferenceImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        Lexer lexer = XPathLexer.create(false);
        if (lexer == null) {
            XPathParserDefinition.$$$reportNull$$$0(0);
        }
        return lexer;
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = XPathElementTypes.FILE;
        if (iFileElementType == null) {
            XPathParserDefinition.$$$reportNull$$$0(1);
        }
        return iFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{XPathTokenTypes.WHITESPACE});
        if (tokenSet == null) {
            XPathParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            XPathParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{XPathTokenTypes.STRING_LITERAL});
        if (tokenSet == null) {
            XPathParserDefinition.$$$reportNull$$$0(4);
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new XPathParser();
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST_NOT;
        if (spaceRequirements == null) {
            XPathParserDefinition.$$$reportNull$$$0(5);
        }
        return spaceRequirements;
    }

    @NotNull
    public final PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        PsiElement element = this.createElement(type, node);
        if (element != null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                XPathParserDefinition.$$$reportNull$$$0(6);
            }
            return psiElement;
        }
        return new XPathTokenImpl(node);
    }

    @Nullable
    protected PsiElement createElement(IElementType type, ASTNode node) {
        if (type == XPathElementTypes.NUMBER) {
            return new XPathNumberImpl(node);
        }
        if (type == XPathElementTypes.STRING) {
            return new XPathStringImpl(node);
        }
        if (type == XPathElementTypes.BINARY_EXPRESSION) {
            return new XPathBinaryExpressionImpl(node);
        }
        if (type == XPathElementTypes.PREFIX_EXPRESSION) {
            return new XPathPrefixExpressionImpl(node);
        }
        if (type == XPathElementTypes.PARENTHESIZED_EXPR) {
            return new XPathParenthesizedExpressionImpl(node);
        }
        if (type == XPathElementTypes.FILTER_EXPRESSION) {
            return new XPathFilterExpressionImpl(node);
        }
        if (type == XPathElementTypes.FUNCTION_CALL) {
            return new XPathFunctionCallImpl(node);
        }
        if (type == XPathElementTypes.AXIS_SPECIFIER) {
            return new XPathAxisSpecifierImpl(node);
        }
        if (type == XPathElementTypes.PREDICATE) {
            return new XPathPredicateImpl(node);
        }
        if (type == XPathElementTypes.LOCATION_PATH) {
            return new XPathLocationPathImpl(node);
        }
        if (type == XPathElementTypes.STEP) {
            return new XPathStepImpl(node);
        }
        if (type == XPathElementTypes.NODE_TEST) {
            return new XPathNodeTestImpl(node);
        }
        if (type == XPathElementTypes.NODE_TYPE) {
            return new XPathNodeTypeTestImpl(node);
        }
        if (type == XPathElementTypes.VARIABLE_REFERENCE) {
            return new XPathVariableReferenceImpl(node);
        }
        if (type == XPathElementTypes.EMBEDDED_CONTENT) {
            return new XPathEmbeddedContentImpl(node);
        }
        return null;
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            XPathParserDefinition.$$$reportNull$$$0(7);
        }
        return new XPathFile(viewProvider, XPathFileType.XPATH);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/XPathParserDefinition";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceExistenceTypeBetweenTokens";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/XPathParserDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

