/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.datavis.r.inlays;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.JvmDefault;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.datavis.r.inlays.InlayOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0017J\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\nH\u0017J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0017R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0017"}, d2={"Lorg/intellij/datavis/r/inlays/InlayElementDescriptor;", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "cleanup", "Ljava/util/concurrent/Future;", "Ljava/lang/Void;", "psi", "Lcom/intellij/psi/PsiElement;", "getInlayOffset", "", "psiElement", "getInlayOutputs", "", "Lorg/intellij/datavis/r/inlays/InlayOutput;", "inlayElement", "isInlayElement", "", "shouldUpdateInlays", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "intellij.notebooks.visualization"})
public interface InlayElementDescriptor {
    @NotNull
    public PsiFile getPsiFile();

    public boolean isInlayElement(@NotNull PsiElement var1);

    @JvmDefault
    @Nullable
    default public List<InlayOutput> getInlayOutputs(@NotNull PsiElement inlayElement) {
        Intrinsics.checkNotNullParameter((Object)inlayElement, (String)"inlayElement");
        return null;
    }

    @JvmDefault
    @Nullable
    default public Future<Void> cleanup(@NotNull PsiElement psi) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        return null;
    }

    @JvmDefault
    default public int getInlayOffset(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        TextRange textRange = psiElement.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"psiElement.textRange");
        return textRange.getEndOffset() - 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmDefault
    default public boolean shouldUpdateInlays(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CharSequence charSequence = event.getOldFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"event.oldFragment");
        if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)"\n", (boolean)false, (int)2, null)) return true;
        CharSequence charSequence2 = event.getNewFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"event.newFragment");
        if (!StringsKt.contains$default((CharSequence)charSequence2, (CharSequence)"\n", (boolean)false, (int)2, null)) return false;
        return true;
    }
}

