/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.datavis.r.inlays.dataframe;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.intellij.datavis.r.inlays.dataframe.DataFrame;
import org.intellij.datavis.r.inlays.dataframe.columns.Column;
import org.intellij.datavis.r.inlays.dataframe.columns.DoubleArrayColumn;
import org.intellij.datavis.r.inlays.dataframe.columns.DoubleColumn;
import org.intellij.datavis.r.inlays.dataframe.columns.DoubleType;
import org.intellij.datavis.r.inlays.dataframe.columns.IntArrayColumn;
import org.intellij.datavis.r.inlays.dataframe.columns.IntColumn;
import org.intellij.datavis.r.inlays.dataframe.columns.IntType;
import org.intellij.datavis.r.inlays.dataframe.columns.StringArrayColumn;
import org.intellij.datavis.r.inlays.dataframe.columns.StringColumn;
import org.intellij.datavis.r.inlays.dataframe.columns.StringType;
import org.intellij.datavis.r.inlays.dataframe.columns.Type;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u001e\u0010\u0002\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004`\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J\u0015\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0014H\u0016R&\u0010\u0002\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/intellij/datavis/r/inlays/dataframe/DataFrameImpl;", "Lorg/intellij/datavis/r/inlays/dataframe/DataFrame;", "columns", "Ljava/util/ArrayList;", "Lorg/intellij/datavis/r/inlays/dataframe/columns/Column;", "Lkotlin/collections/ArrayList;", "(Ljava/util/ArrayList;)V", "dim", "Ljava/awt/Dimension;", "getDim", "()Ljava/awt/Dimension;", "get", "columnIndex", "", "columnName", "", "getColumns", "", "groupBy", "has", "", "sortBy", "", "sortDescending", "intellij.notebooks.visualization"})
public final class DataFrameImpl
extends DataFrame {
    private final ArrayList<Column<?>> columns;

    @Override
    @NotNull
    public Dimension getDim() {
        return new Dimension(this.columns.size(), this.columns.get(0).getSize());
    }

    @Override
    @NotNull
    public List<Column<?>> getColumns() {
        return this.columns;
    }

    @Override
    @NotNull
    public Column<?> get(@NotNull String columnName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            Iterable iterable = this.columns;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Column column = (Column)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)column.getName(), (Object)columnName)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    @Override
    @NotNull
    public Column<?> get(int columnIndex) {
        Column<?> column = this.columns.get(columnIndex);
        Intrinsics.checkNotNullExpressionValue(column, (String)"columns[columnIndex]");
        return column;
    }

    @Override
    public boolean has(@NotNull String columnName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            Iterable iterable = this.columns;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Column column = (Column)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)column.getName(), (Object)columnName)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sortBy(@NotNull String columnName, boolean sortDescending) {
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        Column<?> sortingColumn = this.get(columnName);
        int n = this.columns.get(0).getSize();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            void index;
            int n3 = n2;
            int n4 = n2++;
            int[] nArray2 = nArray;
            boolean bl = false;
            void var19_11 = index;
            nArray2[n4] = var19_11;
        }
        int[] indices = nArray;
        List sortedIndices = ArraysKt.sortedWith((int[])indices, sortingColumn.getComparator(sortDescending));
        int n5 = 0;
        n2 = this.columns.size();
        while (n5 < n2) {
            int it;
            int element$iv;
            Iterator iterator;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            ArrayList<Integer> data;
            void i;
            Type<?> type = this.columns.get((int)i).getType();
            if (type instanceof IntType) {
                Column<?> column = this.columns.get((int)i);
                if (column == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.intellij.datavis.r.inlays.dataframe.columns.IntColumn");
                }
                IntColumn intColumn = (IntColumn)column;
                data = new ArrayList<Integer>(intColumn.getSize());
                $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)sortedIndices.size());
                $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    data.add((Integer)intColumn.get(((Number)sortedIndices.get(it)).intValue()));
                }
                this.columns.set((int)i, new IntColumn(this.columns.get((int)i).getName(), data));
            } else if (type instanceof DoubleType) {
                Column<?> column = this.columns.get((int)i);
                if (column == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.intellij.datavis.r.inlays.dataframe.columns.DoubleColumn");
                }
                DoubleColumn doubleColumn = (DoubleColumn)column;
                data = new ArrayList(doubleColumn.getSize());
                $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)sortedIndices.size());
                $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    data.add((Integer)doubleColumn.get(((Number)sortedIndices.get(it)).intValue()));
                }
                this.columns.set((int)i, new DoubleColumn(this.columns.get((int)i).getName(), (ArrayList<Double>)data));
            } else if (type instanceof StringType) {
                Column<?> column = this.columns.get((int)i);
                if (column == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.intellij.datavis.r.inlays.dataframe.columns.StringColumn");
                }
                StringColumn stringColumn = (StringColumn)column;
                data = new ArrayList(stringColumn.getSize());
                $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)sortedIndices.size());
                $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    data.add((Integer)stringColumn.get(((Number)sortedIndices.get(it)).intValue()));
                }
                this.columns.set((int)i, new StringColumn(this.columns.get((int)i).getName(), (ArrayList<String>)data));
            } else {
                throw (Throwable)new Exception("Unsupported column type " + this.columns.get((int)i).getType() + " in sorting.");
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataFrame groupBy(@NotNull String columnName) {
        Object v0;
        block34: {
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            Iterable iterable = this.columns;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object object : iterable2) {
                Column column = (Column)object;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)column.getName(), (Object)columnName)) continue;
                v0 = object;
                break block34;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        Column groupingColumn = v0;
        if (groupingColumn.getType().isArray()) {
            throw (Throwable)new Exception("Currently cannot group on array-type columns");
        }
        HashMap alreadyProcessed = new HashMap();
        int[] indexes = new int[groupingColumn.getSize()];
        boolean bl = false;
        for (Object value : (Iterable)groupingColumn) {
            void i;
            Integer pos = (Integer)alreadyProcessed.get(value);
            if (pos == null) {
                pos = alreadyProcessed.size();
                ((Map)alreadyProcessed).put(value, pos);
            }
            indexes[i] = pos;
            ++i;
        }
        int newColumnsSize = alreadyProcessed.size();
        ArrayList newColumns = new ArrayList();
        for (Column column : this.columns) {
            Column column2;
            int value;
            int i;
            Column newColumn;
            Object object;
            int $i$f$forEach;
            Object newData;
            Type type;
            if (Intrinsics.areEqual((Object)column.getName(), (Object)columnName)) {
                int value2;
                Column column3;
                Object key;
                boolean bl2;
                Map.Entry entry;
                Map.Entry $dstr$key$value;
                Map.Entry element$iv;
                Iterator iterator;
                boolean bl3;
                Object $this$forEach$iv;
                type = column.getType();
                if (type instanceof IntType) {
                    newData = new int[newColumnsSize];
                    $this$forEach$iv = (String[])alreadyProcessed;
                    $i$f$forEach = 0;
                    object = $this$forEach$iv;
                    bl3 = false;
                    iterator = object.entrySet().iterator();
                    while (iterator.hasNext()) {
                        $dstr$key$value = element$iv = iterator.next();
                        boolean bl6 = false;
                        entry = $dstr$key$value;
                        bl2 = false;
                        Object k = entry.getKey();
                        entry = $dstr$key$value;
                        bl2 = false;
                        int value22 = ((Number)entry.getValue()).intValue();
                        Object k2 = key;
                        if (k2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        newData[value22] = (Integer)k2;
                    }
                    column3 = new IntColumn(column.getName(), (ArrayList)ArraysKt.toCollection((int[])newData, (Collection)new ArrayList()));
                } else if (type instanceof DoubleType) {
                    newData = new double[newColumnsSize];
                    $this$forEach$iv = alreadyProcessed;
                    $i$f$forEach = 0;
                    object = $this$forEach$iv;
                    bl3 = false;
                    iterator = object.entrySet().iterator();
                    while (iterator.hasNext()) {
                        $dstr$key$value = element$iv = iterator.next();
                        boolean bl7 = false;
                        entry = $dstr$key$value;
                        bl2 = false;
                        key = entry.getKey();
                        entry = $dstr$key$value;
                        bl2 = false;
                        value2 = ((Number)entry.getValue()).intValue();
                        Object k = key;
                        if (k == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        newData[value2] = (Double)k;
                    }
                    column3 = new DoubleColumn(column.getName(), (ArrayList)ArraysKt.toCollection((double[])newData, (Collection)new ArrayList()));
                } else if (type instanceof StringType) {
                    $this$forEach$iv = new String[newColumnsSize];
                    $i$f$forEach = 0;
                    while ($i$f$forEach < newColumnsSize) {
                        String string;
                        int n = $i$f$forEach;
                        int n2 = $i$f$forEach++;
                        String[] stringArray = $this$forEach$iv;
                        boolean bl8 = false;
                        stringArray[n2] = string = "";
                    }
                    newData = $this$forEach$iv;
                    $this$forEach$iv = alreadyProcessed;
                    $i$f$forEach = 0;
                    object = $this$forEach$iv;
                    bl3 = false;
                    iterator = object.entrySet().iterator();
                    while (iterator.hasNext()) {
                        $dstr$key$value = element$iv = iterator.next();
                        boolean bl9 = false;
                        entry = $dstr$key$value;
                        bl2 = false;
                        key = entry.getKey();
                        entry = $dstr$key$value;
                        bl2 = false;
                        value2 = ((Number)entry.getValue()).intValue();
                        Object k = key;
                        if (k == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        newData[value2] = (String)k;
                    }
                    column3 = new StringColumn(column.getName(), (ArrayList)ArraysKt.toCollection((Object[])newData, (Collection)new ArrayList()));
                } else {
                    throw (Throwable)new Exception("Unsupported column type " + column.getType() + " in grouping.");
                }
                newColumn = column3;
                newColumns.add(newColumn);
                continue;
            }
            type = column.getType();
            if (type instanceof IntType) {
                newData = new ArrayList(newColumnsSize);
                int $this$forEach$iv = 0;
                $i$f$forEach = newColumnsSize;
                while ($this$forEach$iv < $i$f$forEach) {
                    ((ArrayList)newData).add(new ArrayList());
                    ++i;
                }
                i = 0;
                Column column4 = column;
                if (column4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.intellij.datavis.r.inlays.dataframe.columns.IntColumn");
                }
                object = ((Iterable)((IntColumn)column4)).iterator();
                while (object.hasNext()) {
                    value = ((Number)object.next()).intValue();
                    ((ArrayList)((ArrayList)newData).get(indexes[i])).add(value);
                    ++i;
                }
                column2 = new IntArrayColumn(column.getName(), (ArrayList<ArrayList<Integer>>)newData);
            } else if (type instanceof DoubleType) {
                newData = new ArrayList(newColumnsSize);
                value = newColumnsSize;
                for (i = 0; i < value; ++i) {
                    ((ArrayList)newData).add(new ArrayList());
                }
                i = 0;
                Column column5 = column;
                if (column5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.intellij.datavis.r.inlays.dataframe.columns.DoubleColumn");
                }
                Iterator iterator = ((Iterable)((DoubleColumn)column5)).iterator();
                while (iterator.hasNext()) {
                    double value3 = ((Number)iterator.next()).doubleValue();
                    ((ArrayList)((ArrayList)newData).get(indexes[i])).add(value3);
                    ++i;
                }
                column2 = new DoubleArrayColumn(column.getName(), (ArrayList<ArrayList<Double>>)newData);
            } else if (type instanceof StringType) {
                newData = new ArrayList(newColumnsSize);
                int value3 = newColumnsSize;
                for (i = 0; i < value3; ++i) {
                    ((ArrayList)newData).add(new ArrayList());
                }
                i = 0;
                Column column6 = column;
                if (column6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.intellij.datavis.r.inlays.dataframe.columns.StringColumn");
                }
                for (String value4 : (Iterable)((StringColumn)column6)) {
                    ((ArrayList)((ArrayList)newData).get(indexes[i])).add(value4);
                    ++i;
                }
                column2 = new StringArrayColumn(column.getName(), (ArrayList<ArrayList<String>>)newData);
            } else {
                throw (Throwable)new Exception("Unsupported column type " + column.getType() + " in grouping.");
            }
            newColumn = column2;
            newColumns.add(newColumn);
        }
        return new DataFrameImpl(newColumns);
    }

    public DataFrameImpl(@NotNull ArrayList<Column<?>> columns) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.columns = columns;
    }
}

