/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.datavis.r.inlays.table.filters.gui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NotNullFunction;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;
import java.text.Format;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import org.intellij.datavis.r.inlays.table.filters.gui.FilterSettings;
import org.intellij.datavis.r.inlays.table.filters.gui.IFilterEditor;
import org.jetbrains.annotations.NotNull;

public abstract class CustomChoice
implements Serializable {
    private static final long serialVersionUID = -2894134608058210332L;
    public static final int DEFAULT_PRECEDENCE = 0;
    public static final int MATCH_ALL_PRECEDENCE = -255;
    static final RowFilter passAllRawFilter = new RowFilter(){

        public boolean include(RowFilter.Entry entry) {
            return true;
        }
    };
    public static final CustomChoice MATCH_ALL = new CustomChoice("", null, -255){
        private static final long serialVersionUID = -8964761397870138666L;

        @Override
        public RowFilter getFilter(IFilterEditor editor) {
            return passAllRawFilter;
        }
    };
    public static final CustomChoice MATCH_EMPTY = new CustomChoice(FilterSettings.matchEmptyFilterString, FilterSettings.matchEmptyFilterIcon){
        private static final long serialVersionUID = 5654162608079137456L;

        @Override
        public RowFilter getFilter(final IFilterEditor editor) {
            final int modelIndex = editor.getModelIndex();
            return new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object o = entry.getValue(modelIndex);
                    if (o == null) {
                        return true;
                    }
                    if (editor.getRenderer() != null) {
                        return false;
                    }
                    Format fmt = editor.getFormat();
                    String s = fmt == null ? o.toString() : fmt.format(o);
                    return s == null || s.trim().length() == 0;
                }
            };
        }
    };
    private Icon icon;
    private String str;
    private int precedence;
    @NotNull
    private static final NotNullFunction<String, String> escaper = StringUtil.escaper((boolean)true, (String)"\"");

    public static Set<CustomChoice> createSet(Object[] choices) {
        HashSet<CustomChoice> ret = new HashSet<CustomChoice>();
        for (Object o : choices) {
            ret.add(CustomChoice.create(o, o.toString()));
        }
        return ret;
    }

    public static Set<CustomChoice> createSet(Collection choices) {
        HashSet<CustomChoice> ret = new HashSet<CustomChoice>();
        for (Object o : choices) {
            ret.add(CustomChoice.create(o, o.toString()));
        }
        return ret;
    }

    public static CustomChoice create(Object choice) {
        return CustomChoice.create(choice, choice.toString());
    }

    public static CustomChoice create(final Object choice, String repr) {
        if (choice instanceof Pattern) {
            return new CustomChoice(repr){
                private static final long serialVersionUID = -3239105477862513930L;

                @Override
                public RowFilter getFilter(final IFilterEditor ed) {
                    final int index = ed.getModelIndex();
                    final Pattern pattern = (Pattern)choice;
                    return new RowFilter(){

                        public boolean include(RowFilter.Entry entry) {
                            Object o = entry.getValue(index);
                            if (o == null) {
                                return false;
                            }
                            Format fmt = ed.getFormat();
                            String s = fmt == null ? o.toString() : fmt.format(o);
                            return pattern.matcher(s).matches();
                        }
                    };
                }
            };
        }
        return new CustomChoice(repr){
            private static final long serialVersionUID = -3573642873044716998L;

            @Override
            public RowFilter getFilter(final IFilterEditor editor) {
                final int index = editor.getModelIndex();
                final String string = choice instanceof String ? (String)choice : null;
                return new RowFilter(){

                    public boolean include(RowFilter.Entry entry) {
                        Object o = entry.getValue(index);
                        if (string != null && o instanceof String && editor.isIgnoreCase()) {
                            return string.equalsIgnoreCase((String)o);
                        }
                        return choice.equals(o);
                    }
                };
            }
        };
    }

    public CustomChoice(String representation, Icon icon, int precedence) {
        this.icon = icon;
        this.str = representation;
        this.precedence = precedence;
    }

    public CustomChoice(String representation) {
        this(representation, null, 0);
    }

    public CustomChoice(String representation, Icon icon) {
        this(representation, icon, 0);
    }

    public Color getBackground(IFilterEditor editor, boolean isSelected) {
        return null;
    }

    public Color getForeground(IFilterEditor editor, boolean isSelected) {
        return null;
    }

    public Font getFont(IFilterEditor editor, boolean isSelected) {
        return null;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void decorateComponent(IFilterEditor editor, boolean isSelected, JComponent c, Graphics g) {
        if (this.icon != null) {
            Icon use = c.isEnabled() ? this.icon : UIManager.getLookAndFeel().getDisabledIcon(c, this.icon);
            FontMetrics metrics = g.getFontMetrics();
            int x = Math.max(4 + metrics.stringWidth(this.toString()), (c.getWidth() - use.getIconWidth()) / 2);
            int y = (c.getHeight() - use.getIconHeight()) / 2;
            use.paintIcon(c, g, x, y);
        }
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public void setPrecedence(int precedence) {
        this.precedence = precedence;
    }

    public String getRepresentation() {
        return this.str;
    }

    public void setRepresentation(String representation) {
        this.str = representation;
    }

    public abstract RowFilter getFilter(IFilterEditor var1);

    public final String toString() {
        return this.str;
    }
}

