/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.util.Function;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.javac.Iterators;

class LazyClassLoader
extends ClassLoader
implements Closeable {
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];
    private final ClassLoader myParent;
    private final Iterable<URL> myUrls;
    private volatile DelegateClassLoader myDelegate;

    LazyClassLoader(Iterable<URL> urls, ClassLoader parent) {
        super(null);
        this.myParent = parent;
        this.myUrls = urls;
    }

    @Nullable
    static LazyClassLoader createFrom(@Nullable Iterable<? extends File> files, ClassLoader parent) {
        return Iterators.isEmptyCollection(files) ? null : new LazyClassLoader(Iterators.map(files, new Function<File, URL>(){

            public URL fun(File f) {
                try {
                    return f.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }), parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DelegateClassLoader getDelegate() {
        DelegateClassLoader delegate = this.myDelegate;
        if (delegate == null) {
            Iterable<URL> iterable = this.myUrls;
            synchronized (iterable) {
                delegate = this.myDelegate;
                if (delegate == null) {
                    this.myDelegate = delegate = new DelegateClassLoader(Iterators.collect(this.myUrls, new ArrayList()).toArray(EMPTY_URL_ARRAY), this.myParent);
                }
            }
        }
        return delegate;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.getDelegate().loadClass(name);
    }

    @Override
    protected URL findResource(String name) {
        return this.getDelegate().findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.getDelegate().findResources(name);
    }

    @Override
    public void close() throws IOException {
        DelegateClassLoader delegate = this.myDelegate;
        if (delegate instanceof Closeable) {
            ((Closeable)delegate).close();
            this.myDelegate = null;
        }
    }

    private static class DelegateClassLoader
    extends URLClassLoader {
        DelegateClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public URL findResource(String name) {
            return super.findResource(name);
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            return super.findResources(name);
        }
    }
}

