/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.buildtool;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.FilePosition;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.events.impl.DerivedResultImpl;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.ArtifactSyncListener;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole$WhenMappings;
import org.jetbrains.idea.maven.buildtool.quickfix.OffMavenOfflineModeQuickFix;
import org.jetbrains.idea.maven.buildtool.quickfix.OpenMavenSettingsQuickFix;
import org.jetbrains.idea.maven.buildtool.quickfix.UseBundledMavenQuickFix;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.externalSystemIntegration.output.importproject.quickfixes.DownloadArtifactBuildIssue;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.server.CannotStartServerException;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 o2\u00020\u0001:\u0002noB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0019H\u0007J\"\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u00012\b\b\u0001\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\tH\u0002J\u0010\u0010*\u001a\u00020\u000f2\b\b\u0001\u0010,\u001a\u00020\u0007J\u0018\u0010*\u001a\u00020\u000f2\b\b\u0001\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\tJ\u001a\u0010.\u001a\u00020\u000f2\b\b\u0001\u0010,\u001a\u00020\u00072\b\b\u0001\u0010/\u001a\u00020\u0007J$\u0010.\u001a\u00020\u000f2\b\b\u0001\u0010,\u001a\u00020\u00072\b\b\u0001\u0010/\u001a\u00020\u00072\b\u00100\u001a\u0004\u0018\u000101J\u0010\u00102\u001a\u00020\u000f2\b\b\u0001\u0010,\u001a\u00020\u0007J\"\u00103\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u00012\b\b\u0001\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\u0007H\u0002J\u0010\u00109\u001a\u00020:2\u0006\u0010'\u001a\u00020(H\u0002J\r\u0010;\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0002J\u001c\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020\u00072\n\b\u0002\u0010>\u001a\u0004\u0018\u00010(H\u0002J\b\u0010?\u001a\u00020\u000fH\u0002J\u0017\u0010@\u001a\u00020\u000f2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0082\bJ\u0016\u0010B\u001a\u00020\u000f2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010C\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020EH\u0002J\u0018\u0010F\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\u0007H\u0002J0\u0010H\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\u00072\b\b\u0001\u0010G\u001a\u00020\u00072\b\b\u0001\u0010I\u001a\u00020\u00072\n\b\u0001\u0010J\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010K\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\u0007H\u0002J\u0006\u0010L\u001a\u00020\u000fJ\u0012\u0010M\u001a\u00020\u000f2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(J\u0015\u0010N\u001a\u00070\u0007\u00a2\u0006\u0002\bO2\u0006\u0010'\u001a\u00020(H\u0002J\u000e\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020SJ\u000b\u0010T\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017J\u0010\u0010U\u001a\u00020\t2\u0006\u0010G\u001a\u00020\u0007H\u0002J\u0010\u0010V\u001a\u00020\t2\u0006\u0010=\u001a\u00020\u0007H\u0002J\u000e\u0010W\u001a\u00020\u000f2\u0006\u0010X\u001a\u00020YJ \u0010Z\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\u00072\u0006\u0010[\u001a\u00020\\H\u0002J\u0018\u0010]\u001a\u00020\u000f2\u0006\u0010^\u001a\u00020\u00072\u0006\u0010_\u001a\u00020#H\u0002J\u0018\u0010`\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\u0007H\u0002J\u000e\u0010a\u001a\u00020\u000f2\u0006\u0010b\u001a\u00020cJ\u0016\u0010d\u001a\u00020\u000f2\u0006\u0010e\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%J\u000e\u0010f\u001a\u00020\u000f2\u0006\u0010g\u001a\u00020\u0007J\u000e\u0010h\u001a\u00020\u000f2\u0006\u0010i\u001a\u00020\u0019J\u001a\u0010j\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u00012\b\b\u0001\u00104\u001a\u00020\u0007H\u0002J\u0006\u0010k\u001a\u00020\u000fJ\u000e\u0010l\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020EJ\f\u0010m\u001a\u000201*\u00020cH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0011\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00130\u0012j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0013`\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u001bj\b\u0012\u0004\u0012\u00020\u0007`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006p"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "JAVADOC_AND_SOURCE_CLASSIFIERS", "", "", "finished", "", "hasErrors", "hasUnresolved", "myPostponed", "Ljava/util/ArrayList;", "Lkotlin/Function0;", "", "Lkotlin/collections/ArrayList;", "myStartedSet", "Ljava/util/LinkedHashSet;", "Lkotlin/Pair;", "Lkotlin/collections/LinkedHashSet;", "mySyncId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "Lorg/jetbrains/annotations/NotNull;", "mySyncView", "Lcom/intellij/build/BuildProgressListener;", "shownIssues", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "started", "addBuildEvent", "buildEvent", "Lcom/intellij/build/events/BuildEvent;", "addBuildIssue", "issue", "Lcom/intellij/build/issue/BuildIssue;", "kind", "Lcom/intellij/build/events/MessageEvent$Kind;", "addException", "e", "", "progressListener", "addText", "parentId", "text", "stdout", "addWarning", "description", "filePosition", "Lcom/intellij/build/FilePosition;", "addWrapperProgressText", "completeTask", "taskName", "result", "Lcom/intellij/build/events/EventResult;", "completeUmbrellaEvents", "keyPrefix", "createMessageEvent", "Lcom/intellij/build/events/impl/MessageEventImpl;", "createTaskId", "debugLog", "s", "exception", "doFinish", "doIfImportInProcess", "action", "doIfImportInProcessOrPostpone", "doTerminate", "exitCode", "", "downloadEventCompleted", "dependency", "downloadEventFailed", "error", "stackTrace", "downloadEventStarted", "finishImport", "finishWrapperResolving", "getExceptionText", "Lcom/intellij/openapi/util/NlsSafe;", "getListener", "Lorg/jetbrains/idea/maven/buildtool/ArtifactSyncListener;", "type", "Lorg/jetbrains/idea/maven/server/MavenServerProgressIndicator$ResolveType;", "getTaskId", "isJavadocOrSource", "newIssue", "notifyReadingProblems", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "showBuildIssue", "quickFix", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "showBuildIssueNode", "key", "buildIssue", "showError", "showProblem", "problem", "Lorg/jetbrains/idea/maven/model/MavenProjectProblem;", "showQuickFixBadMaven", "message", "showQuickFixJDK", "version", "startImport", "syncView", "startTask", "startWrapperResolving", "terminated", "getPosition", "ArtifactSyncListenerImpl", "Companion", "intellij.maven"})
public final class MavenSyncConsole {
    private volatile BuildProgressListener mySyncView;
    private ExternalSystemTaskId mySyncId;
    private boolean finished;
    private boolean started;
    private boolean hasErrors;
    private boolean hasUnresolved;
    private final Set<String> JAVADOC_AND_SOURCE_CLASSIFIERS;
    private final HashSet<String> shownIssues;
    private final ArrayList<Function0<Unit>> myPostponed;
    private LinkedHashSet<Pair<Object, String>> myStartedSet;
    private final Project myProject;
    private static final int EXIT_CODE_OK;
    private static final int EXIT_CODE_SIGTERM;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public final synchronized void startImport(@NotNull BuildProgressListener syncView) {
        void $this$forEach$iv;
        DefaultBuildDescriptor descriptor2;
        Intrinsics.checkNotNullParameter((Object)syncView, (String)"syncView");
        if (this.started) {
            return;
        }
        AnAction restartAction2 = new AnAction(this){
            final /* synthetic */ MavenSyncConsole this$0;

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(!MavenSyncConsole.access$getStarted$p(this.this$0) || MavenSyncConsole.access$getFinished$p(this.this$0));
                Presentation presentation2 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
                presentation2.setIcon(AllIcons.Actions.Refresh);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Project project2 = e.getProject();
                    if (project2 == null) break block0;
                    Project project3 = project2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Project it = project3;
                    boolean bl3 = false;
                    MavenProjectsManager.getInstance(it).forceUpdateAllProjectsOrFindAllAvailablePomFiles();
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        this.started = true;
        this.finished = false;
        this.hasErrors = false;
        this.hasUnresolved = false;
        this.mySyncView = syncView;
        this.shownIssues.clear();
        this.mySyncId = this.createTaskId();
        String string = SyncBundle.message("maven.sync.title", new Object[0]);
        String string2 = this.myProject.getBasePath();
        Intrinsics.checkNotNull((Object)string2);
        DefaultBuildDescriptor defaultBuildDescriptor = descriptor2 = new DefaultBuildDescriptor((Object)this.mySyncId, string, string2, System.currentTimeMillis()).withRestartAction(restartAction2);
        Intrinsics.checkNotNullExpressionValue((Object)defaultBuildDescriptor, (String)"descriptor");
        defaultBuildDescriptor.setActivateToolWindowWhenFailed(true);
        descriptor2.setActivateToolWindowWhenAdded(false);
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new StartBuildEventImpl((BuildDescriptor)descriptor2, SyncBundle.message("maven.sync.project.title", this.myProject.getName())));
        MavenSyncConsole.debugLog$default(this, "maven sync: started importing " + this.myProject, null, 2, null);
        Iterable iterable = this.myPostponed;
        MavenSyncConsole mavenSyncConsole = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void this_$iv;
            Function0 p1 = (Function0)element$iv;
            boolean bl = false;
            MavenSyncConsole mavenSyncConsole2 = mavenSyncConsole;
            boolean $i$f$doIfImportInProcess = false;
            if (!((MavenSyncConsole)this_$iv).started || ((MavenSyncConsole)this_$iv).finished) continue;
            p1.invoke();
        }
        this.myPostponed.clear();
    }

    private final ExternalSystemTaskId createTaskId() {
        ExternalSystemTaskId externalSystemTaskId = ExternalSystemTaskId.create((ProjectSystemId)MavenUtil.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId, (String)"ExternalSystemTaskId.cre\u2026SOLVE_PROJECT, myProject)");
        return externalSystemTaskId;
    }

    @NotNull
    public final ExternalSystemTaskId getTaskId() {
        return this.mySyncId;
    }

    public final void addText(@Nls @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.addText(text, true);
    }

    public final synchronized void addText(@Nls @NotNull String text, boolean stdout) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.addText(this.mySyncId, text, true);
        }
    }

    public final synchronized void addWrapperProgressText(@Nls @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            String string = SyncBundle.message("maven.sync.wrapper", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SyncBundle.message(\"maven.sync.wrapper\")");
            this.addText(string, text, true);
        }
    }

    private final synchronized void addText(Object parentId, @Nls String text, boolean stdout) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            if (StringUtil.isEmpty((String)text)) {
                return;
            }
            String toPrint = StringsKt.endsWith$default((CharSequence)text, (char)'\n', (boolean)false, (int)2, null) ? text : text + '\n';
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new OutputBuildEventImpl(parentId, toPrint, stdout));
        }
    }

    public final synchronized void addBuildEvent(@NotNull BuildEvent buildEvent) {
        Intrinsics.checkNotNullParameter((Object)buildEvent, (String)"buildEvent");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.mySyncView.onEvent((Object)this.mySyncId, buildEvent);
        }
    }

    public final synchronized void addWarning(@Nls @NotNull String text, @Nls @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.addWarning(text, description, null);
    }

    public final void addBuildIssue(@NotNull BuildIssue issue, @NotNull MessageEvent.Kind kind) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        this.doIfImportInProcessOrPostpone((Function0<Unit>)((Function0)new Function0<Unit>(this, issue, kind){
            final /* synthetic */ MavenSyncConsole this$0;
            final /* synthetic */ BuildIssue $issue;
            final /* synthetic */ MessageEvent.Kind $kind;

            public final void invoke() {
                if (!MavenSyncConsole.access$newIssue(this.this$0, this.$issue.getTitle() + this.$issue.getDescription())) {
                    return;
                }
                MavenSyncConsole.access$getMySyncView$p(this.this$0).onEvent((Object)MavenSyncConsole.access$getMySyncId$p(this.this$0), (BuildEvent)new BuildIssueEventImpl((Object)MavenSyncConsole.access$getMySyncId$p(this.this$0), this.$issue, this.$kind));
                MavenSyncConsole.access$setHasErrors$p(this.this$0, MavenSyncConsole.access$getHasErrors$p(this.this$0) || this.$kind == MessageEvent.Kind.ERROR);
            }
            {
                this.this$0 = mavenSyncConsole;
                this.$issue = buildIssue;
                this.$kind = kind;
                super(0);
            }
        }));
    }

    public final synchronized void addWarning(@Nls @NotNull String text, @Nls @NotNull String description, @Nullable FilePosition filePosition) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            if (!this.newIssue(text + description + filePosition)) {
                return;
            }
            if (filePosition == null) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new MessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.WARNING, SyncBundle.message("maven.sync.group.compiler", new Object[0]), text, description));
            } else {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FileMessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.WARNING, SyncBundle.message("maven.sync.group.compiler", new Object[0]), text, description, filePosition));
            }
        }
    }

    private final boolean newIssue(String s) {
        return this.shownIssues.add(s);
    }

    public final synchronized void finishImport() {
        MavenSyncConsole.debugLog$default(this, "Maven sync: finishImport", null, 2, null);
        this.doFinish();
    }

    public final synchronized void terminated(int exitCode) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            if (EXIT_CODE_OK == exitCode || EXIT_CODE_SIGTERM == exitCode) {
                this.doFinish();
            } else {
                this.doTerminate(exitCode);
            }
        }
    }

    private final void doTerminate(int exitCode) {
        List tasks = CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)this.myStartedSet));
        MavenSyncConsole.debugLog$default(this, "Tasks " + tasks + " are not completed! Force complete", null, 2, null);
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            this.completeTask(it.getFirst(), (String)it.getSecond(), (EventResult)new FailureResultImpl(SyncBundle.message("maven.sync.failure.terminated", exitCode)));
        }
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FinishBuildEventImpl((Object)this.mySyncId, null, System.currentTimeMillis(), "", (EventResult)new FailureResultImpl(SyncBundle.message("maven.sync.failure.terminated", exitCode))));
        this.finished = true;
        this.started = false;
    }

    public final synchronized void startWrapperResolving() {
        if (!this.started || this.finished) {
            Object object = this.myProject.getService(SyncViewManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"myProject.getService(SyncViewManager::class.java)");
            this.startImport((BuildProgressListener)object);
        }
        String string = SyncBundle.message("maven.sync.wrapper", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SyncBundle.message(\"maven.sync.wrapper\")");
        this.startTask(this.mySyncId, string);
    }

    public final synchronized void finishWrapperResolving(@Nullable Throwable e) {
        if (e != null) {
            this.addBuildIssue(new BuildIssue(e){
                @NotNull
                private final String title;
                @NotNull
                private final String description;
                @NotNull
                private final List<BuildIssueQuickFix> quickFixes;
                final /* synthetic */ Throwable $e;

                @NotNull
                public String getTitle() {
                    return this.title;
                }

                @NotNull
                public String getDescription() {
                    return this.description;
                }

                @NotNull
                public List<BuildIssueQuickFix> getQuickFixes() {
                    return this.quickFixes;
                }

                @Nullable
                public Navigatable getNavigatable(@NotNull Project project2) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    return null;
                }
                {
                    this.$e = $captured_local_variable$0;
                    String string = SyncBundle.message("maven.sync.wrapper.failure", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SyncBundle.message(\"maven.sync.wrapper.failure\")");
                    this.title = string;
                    String string2 = SyncBundle.message("maven.sync.wrapper.failure.description", $captured_local_variable$0.getLocalizedMessage(), "open_maven_settings_quick_fix");
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SyncBundle.message(\"mave\u2026MavenSettingsQuickFix.ID)");
                    this.description = string2;
                    this.quickFixes = CollectionsKt.listOf((Object)new OpenMavenSettingsQuickFix());
                }
            }, MessageEvent.Kind.WARNING);
        }
        String string = SyncBundle.message("maven.sync.wrapper", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SyncBundle.message(\"maven.sync.wrapper\")");
        this.completeTask(this.mySyncId, string, (EventResult)new SuccessResultImpl());
    }

    public static /* synthetic */ void finishWrapperResolving$default(MavenSyncConsole mavenSyncConsole, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            throwable = null;
        }
        mavenSyncConsole.finishWrapperResolving(throwable);
    }

    public final synchronized void notifyReadingProblems(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            MavenSyncConsole.debugLog$default(this, "reading problems in " + file, null, 2, null);
            this.hasErrors = true;
            String desc = SyncBundle.message("maven.sync.failure.error.reading.file", file.getPath());
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FileMessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.ERROR, SyncBundle.message("maven.sync.group.error", new Object[0]), desc, desc, new FilePosition(new File(file.getPath()), -1, -1)));
        }
    }

    public final synchronized void showProblem(@NotNull MavenProjectProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.hasErrors = true;
            String group = SyncBundle.message("maven.sync.group.error", new Object[0]);
            String description = problem.getDescription();
            FilePosition position = this.getPosition(problem);
            FileMessageEventImpl eventImpl = new FileMessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.ERROR, group, description, description, position);
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)eventImpl);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FilePosition getPosition(MavenProjectProblem $this$getPosition) {
        File problemFile = new File($this$getPosition.getPath());
        try {
            if ($this$getPosition.getType() == MavenProjectProblem.ProblemType.STRUCTURE) {
                Regex pattern = new Regex("@(\\d+):(\\d+)");
                String string = $this$getPosition.getDescription();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"description");
                MatchResult matchedCoordinates = (MatchResult)SequencesKt.lastOrNull((Sequence)Regex.findAll$default((Regex)pattern, (CharSequence)string, (int)0, (int)2, null));
                if (matchedCoordinates != null) {
                    void line;
                    Object object = matchedCoordinates.getGroupValues();
                    List list = object;
                    boolean bl = false;
                    String string2 = (String)list.get(1);
                    list = object;
                    bl = false;
                    String offset = (String)list.get(2);
                    object = line;
                    boolean bl2 = false;
                    int n = Integer.parseInt((String)object) - 1;
                    object = offset;
                    bl2 = false;
                    return new FilePosition(problemFile, n, Integer.parseInt((String)object));
                }
            }
        }
        catch (Exception ex) {
            MavenLog.LOG.error((Throwable)ex);
        }
        return new FilePosition(problemFile, -1, -1);
    }

    @ApiStatus.Internal
    public final synchronized void addException(@NotNull Throwable e, @NotNull BuildProgressListener progressListener) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)progressListener, (String)"progressListener");
        if (this.started && !this.finished) {
            MavenLog.LOG.warn(e);
            this.hasErrors = true;
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)this.createMessageEvent(e));
        } else {
            this.startImport(progressListener);
            this.addException(e, progressListener);
            this.finishImport();
        }
    }

    private final MessageEventImpl createMessageEvent(Throwable e) {
        CannotStartServerException csse = (CannotStartServerException)ExceptionUtil.findCause((Throwable)e, CannotStartServerException.class);
        if (csse != null) {
            ExecutionException cause = (ExecutionException)((Object)ExceptionUtil.findCause((Throwable)csse, ExecutionException.class));
            if (cause != null) {
                return new MessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.ERROR, SyncBundle.message("build.event.title.internal.server.error", new Object[0]), this.getExceptionText(cause), this.getExceptionText(cause));
            }
            return new MessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.ERROR, SyncBundle.message("build.event.title.internal.server.error", new Object[0]), this.getExceptionText(csse), this.getExceptionText(csse));
        }
        return new MessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.ERROR, SyncBundle.message("build.event.title.error", new Object[0]), this.getExceptionText(e), this.getExceptionText(e));
    }

    private final String getExceptionText(Throwable e) {
        CharSequence charSequence;
        MavenWorkspaceSettingsComponent mavenWorkspaceSettingsComponent = MavenWorkspaceSettingsComponent.getInstance(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)mavenWorkspaceSettingsComponent, (String)"MavenWorkspaceSettingsCo\u2026nt.getInstance(myProject)");
        MavenGeneralSettings mavenGeneralSettings = mavenWorkspaceSettingsComponent.getSettings().getGeneralSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"MavenWorkspaceSettingsCo\u2026ings.getGeneralSettings()");
        if (mavenGeneralSettings.isPrintErrorStackTraces()) {
            String string = ExceptionUtil.getThrowableText((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExceptionUtil.getThrowableText(e)");
            return string;
        }
        CharSequence charSequence2 = e.getLocalizedMessage();
        boolean bl = false;
        CharSequence charSequence3 = charSequence2;
        boolean bl2 = false;
        if (charSequence3.length() == 0) {
            boolean bl3 = false;
            if (StringUtil.isEmpty((String)e.getMessage())) {
                charSequence = SyncBundle.message("build.event.title.error", new Object[0]);
            } else {
                String string = e.getMessage();
                charSequence = string;
                Intrinsics.checkNotNull((Object)string);
            }
        } else {
            charSequence = charSequence2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"e.localizedMessage.ifEmp\u2026rror\") else e.message!! }");
        return (String)charSequence;
    }

    @NotNull
    public final ArtifactSyncListener getListener(@NotNull MavenServerProgressIndicator.ResolveType type2) {
        ArtifactSyncListener artifactSyncListener;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        switch (MavenSyncConsole$WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                artifactSyncListener = new ArtifactSyncListenerImpl("maven.sync.plugins");
                break;
            }
            case 2: {
                artifactSyncListener = new ArtifactSyncListenerImpl("maven.sync.dependencies");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return artifactSyncListener;
    }

    private final synchronized void doFinish() {
        List tasks = CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)this.myStartedSet));
        MavenSyncConsole.debugLog$default(this, "Tasks " + tasks + " are not completed! Force complete", null, 2, null);
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            this.completeTask(it.getFirst(), (String)it.getSecond(), (EventResult)new DerivedResultImpl());
        }
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FinishBuildEventImpl((Object)this.mySyncId, null, System.currentTimeMillis(), "", this.hasErrors ? (EventResult)new FailureResultImpl() : (EventResult)new DerivedResultImpl()));
        MavenWorkspaceSettingsComponent mavenWorkspaceSettingsComponent = MavenWorkspaceSettingsComponent.getInstance(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)mavenWorkspaceSettingsComponent, (String)"MavenWorkspaceSettingsCo\u2026nt.getInstance(myProject)");
        MavenGeneralSettings generalSettings = mavenWorkspaceSettingsComponent.getSettings().generalSettings;
        if (this.hasUnresolved) {
            MavenGeneralSettings mavenGeneralSettings = generalSettings;
            Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"generalSettings");
            if (mavenGeneralSettings.isWorkOffline()) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)this.mySyncId, new BuildIssue(){
                    @NotNull
                    private final String title;
                    @NotNull
                    private final String description;
                    @NotNull
                    private final List<BuildIssueQuickFix> quickFixes;

                    @NotNull
                    public String getTitle() {
                        return this.title;
                    }

                    @NotNull
                    public String getDescription() {
                        return this.description;
                    }

                    @NotNull
                    public List<BuildIssueQuickFix> getQuickFixes() {
                        return this.quickFixes;
                    }

                    @Nullable
                    public Navigatable getNavigatable(@NotNull Project project2) {
                        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                        return null;
                    }
                    {
                        this.title = "Dependency Resolution Failed";
                        this.description = "<a href=\"off_maven_offline_mode_quick_fix\">Switch Off Offline Mode</a>\n";
                        this.quickFixes = CollectionsKt.listOf((Object)new OffMavenOfflineModeQuickFix());
                    }
                }, MessageEvent.Kind.ERROR));
            }
        }
        this.finished = true;
        this.started = false;
    }

    private final synchronized void showError(String keyPrefix, String dependency) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.hasErrors = true;
            this.hasUnresolved = true;
            String umbrellaString = SyncBundle.message(keyPrefix + ".resolve", new Object[0]);
            String errorString = SyncBundle.message(keyPrefix + ".resolve.error", dependency);
            String string = umbrellaString;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"umbrellaString");
            this.startTask(this.mySyncId, string);
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new MessageEventImpl((Object)umbrellaString, MessageEvent.Kind.ERROR, SyncBundle.message("maven.sync.group.error", new Object[0]), errorString, errorString));
            String string2 = errorString;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"errorString");
            this.addText(this.mySyncId, string2, false);
        }
    }

    private final synchronized void showBuildIssue(String keyPrefix, String dependency, BuildIssueQuickFix quickFix) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.hasErrors = true;
            this.hasUnresolved = true;
            String umbrellaString = SyncBundle.message(keyPrefix + ".resolve", new Object[0]);
            String errorString = SyncBundle.message(keyPrefix + ".resolve.error", dependency);
            String string = umbrellaString;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"umbrellaString");
            this.startTask(this.mySyncId, string);
            String string2 = errorString;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"errorString");
            BuildIssue buildIssue = DownloadArtifactBuildIssue.INSTANCE.getIssue(string2, quickFix);
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)umbrellaString, buildIssue, MessageEvent.Kind.ERROR));
            this.addText(this.mySyncId, errorString, false);
        }
    }

    private final synchronized void showBuildIssueNode(String key, BuildIssue buildIssue) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.hasErrors = true;
            this.hasUnresolved = true;
            this.startTask(this.mySyncId, key);
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)key, buildIssue, MessageEvent.Kind.ERROR));
        }
    }

    private final synchronized void startTask(Object parentId, @NlsSafe String taskName) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            MavenSyncConsole.debugLog$default(this, "Maven sync: start " + taskName, null, 2, null);
            if (this.myStartedSet.add((Pair<Object, String>)TuplesKt.to((Object)parentId, (Object)taskName))) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new StartEventImpl((Object)taskName, parentId, System.currentTimeMillis(), taskName));
            }
        }
    }

    private final synchronized void completeTask(Object parentId, @NlsSafe String taskName, EventResult result) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.hasErrors = this.hasErrors || result instanceof FailureResultImpl;
            MavenSyncConsole.debugLog$default(this, "Maven sync: complete " + taskName + " with " + result, null, 2, null);
            if (this.myStartedSet.remove(TuplesKt.to((Object)parentId, (Object)taskName))) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FinishEventImpl((Object)taskName, parentId, System.currentTimeMillis(), taskName, result));
            }
        }
    }

    private final void debugLog(String s, Throwable exception) {
        MavenLog.LOG.debug(s, exception);
    }

    static /* synthetic */ void debugLog$default(MavenSyncConsole mavenSyncConsole, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        mavenSyncConsole.debugLog(string, throwable);
    }

    private final synchronized void completeUmbrellaEvents(String keyPrefix) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            String taskName;
            boolean bl = false;
            String string = taskName = SyncBundle.message(keyPrefix + ".resolve", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"taskName");
            this.completeTask(this.mySyncId, string, (EventResult)new DerivedResultImpl());
        }
    }

    private final synchronized void downloadEventStarted(String keyPrefix, String dependency) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            String downloadString = SyncBundle.message(keyPrefix + ".download", new Object[0]);
            String downloadArtifactString = SyncBundle.message(keyPrefix + ".artifact.download", dependency);
            String string = downloadString;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"downloadString");
            this.startTask(this.mySyncId, string);
            String string2 = downloadArtifactString;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"downloadArtifactString");
            this.startTask(downloadString, string2);
        }
    }

    private final synchronized void downloadEventCompleted(String keyPrefix, String dependency) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            String downloadArtifactString;
            boolean bl = false;
            String downloadString = SyncBundle.message(keyPrefix + ".download", new Object[0]);
            String string = downloadArtifactString = SyncBundle.message(keyPrefix + ".artifact.download", dependency);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"downloadArtifactString");
            this.addText(string, downloadArtifactString, true);
            String string2 = downloadString;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"downloadString");
            this.completeTask(string2, downloadArtifactString, (EventResult)new SuccessResultImpl(false));
        }
    }

    private final synchronized void downloadEventFailed(String keyPrefix, @NlsSafe String dependency, @NlsSafe String error, @NlsSafe String stackTrace) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            String downloadString = SyncBundle.message(keyPrefix + ".download", new Object[0]);
            String downloadArtifactString = SyncBundle.message(keyPrefix + ".artifact.download", dependency);
            if (this.isJavadocOrSource(dependency)) {
                String string = downloadArtifactString;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"downloadArtifactString");
                String string2 = SyncBundle.message("maven.sync.failure.dependency.not.found", dependency);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SyncBundle.message(\"mave\u2026y.not.found\", dependency)");
                this.addText(string, string2, true);
                String string3 = downloadString;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"downloadString");
                this.completeTask(string3, downloadArtifactString, (EventResult)new MessageEventResult(this, keyPrefix, dependency, stackTrace, error){
                    final /* synthetic */ MavenSyncConsole this$0;
                    final /* synthetic */ String $keyPrefix$inlined;
                    final /* synthetic */ String $dependency$inlined;
                    final /* synthetic */ String $stackTrace$inlined;
                    final /* synthetic */ String $error$inlined;
                    {
                        this.this$0 = mavenSyncConsole;
                        this.$keyPrefix$inlined = string;
                        this.$dependency$inlined = string2;
                        this.$stackTrace$inlined = string3;
                        this.$error$inlined = string4;
                    }

                    @NotNull
                    public MessageEvent.Kind getKind() {
                        return MessageEvent.Kind.WARNING;
                    }

                    @Nullable
                    public String getDetails() {
                        return SyncBundle.message("maven.sync.failure.dependency.not.found", this.$dependency$inlined);
                    }
                });
            } else {
                if (stackTrace != null && Registry.is((String)"maven.spy.events.debug")) {
                    String string = downloadArtifactString;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"downloadArtifactString");
                    this.addText(string, stackTrace, false);
                } else {
                    String string = downloadArtifactString;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"downloadArtifactString");
                    this.addText(string, error, true);
                }
                String string = downloadString;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"downloadString");
                this.completeTask(string, downloadArtifactString, (EventResult)new FailureResultImpl(error));
            }
        }
    }

    public final synchronized void showQuickFixBadMaven(@NotNull String message, @NotNull MessageEvent.Kind kind) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        String bundledVersion = MavenServerManager.getMavenVersion("Bundled (Maven 3)");
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)this.mySyncId, new BuildIssue(message, bundledVersion){
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            final /* synthetic */ String $message;
            final /* synthetic */ String $bundledVersion;

            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                return null;
            }
            {
                this.$message = $captured_local_variable$0;
                this.$bundledVersion = $captured_local_variable$1;
                this.title = SyncBundle.message("maven.sync.version.issue.title", new Object[0]);
                this.description = $captured_local_variable$0 + '\n' + "- <a href=\"open_maven_settings_quick_fix\">" + SyncBundle.message("maven.sync.version.open.settings", new Object[0]) + "</a>\n" + "- <a href=\"use_bundled_maven_quick_fix\">" + SyncBundle.message("maven.sync.version.use.bundled", $captured_local_variable$1) + "</a>\n";
                this.quickFixes = CollectionsKt.listOf((Object[])new BuildIssueQuickFix[]{new OpenMavenSettingsQuickFix(), new UseBundledMavenQuickFix()});
            }
        }, kind));
    }

    public final synchronized void showQuickFixJDK(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)this.mySyncId, new BuildIssue(version2){
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            final /* synthetic */ String $version;

            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                return null;
            }
            {
                this.$version = $captured_local_variable$0;
                this.title = SyncBundle.message("maven.sync.quickfixes.maven.jdk.version.title", new Object[0]);
                this.description = SyncBundle.message("maven.sync.quickfixes.upgrade.to.jdk7", $captured_local_variable$0) + "\n" + "- <a href=\"open_maven_settings_quick_fix\">" + SyncBundle.message("maven.sync.quickfixes.open.settings", new Object[0]) + "</a>\n";
                this.quickFixes = CollectionsKt.listOf((Object)new OpenMavenSettingsQuickFix());
            }
        }, MessageEvent.Kind.ERROR));
    }

    private final boolean isJavadocOrSource(String dependency) {
        List split = StringsKt.split$default((CharSequence)dependency, (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null);
        if (split.size() < 4) {
            return false;
        }
        String classifier = (String)split.get(2);
        return this.JAVADOC_AND_SOURCE_CLASSIFIERS.contains(classifier);
    }

    private final void doIfImportInProcess(Function0<Unit> action) {
        int $i$f$doIfImportInProcess = 0;
        if (!this.started || this.finished) {
            return;
        }
        action.invoke();
    }

    private final void doIfImportInProcessOrPostpone(Function0<Unit> action) {
        if (!this.started || this.finished) {
            this.myPostponed.add(action);
        } else {
            action.invoke();
        }
    }

    public MavenSyncConsole(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.mySyncView = mySyncView.1.INSTANCE;
        this.mySyncId = this.createTaskId();
        this.JAVADOC_AND_SOURCE_CLASSIFIERS = SetsKt.setOf((Object[])new String[]{"javadoc", "sources", "test-javadoc", "test-sources"});
        this.shownIssues = new HashSet();
        this.myPostponed = new ArrayList();
        this.myStartedSet = new LinkedHashSet();
    }

    static {
        Companion = new Companion(null);
        EXIT_CODE_SIGTERM = 143;
    }

    public static final /* synthetic */ void access$setStarted$p(MavenSyncConsole $this, boolean bl) {
        $this.started = bl;
    }

    public static final /* synthetic */ void access$setFinished$p(MavenSyncConsole $this, boolean bl) {
        $this.finished = bl;
    }

    public static final /* synthetic */ boolean access$newIssue(MavenSyncConsole $this, String s) {
        return $this.newIssue(s);
    }

    public static final /* synthetic */ BuildProgressListener access$getMySyncView$p(MavenSyncConsole $this) {
        return $this.mySyncView;
    }

    public static final /* synthetic */ void access$setMySyncView$p(MavenSyncConsole $this, BuildProgressListener buildProgressListener) {
        $this.mySyncView = buildProgressListener;
    }

    public static final /* synthetic */ ExternalSystemTaskId access$getMySyncId$p(MavenSyncConsole $this) {
        return $this.mySyncId;
    }

    public static final /* synthetic */ void access$setMySyncId$p(MavenSyncConsole $this, ExternalSystemTaskId externalSystemTaskId) {
        $this.mySyncId = externalSystemTaskId;
    }

    public static final /* synthetic */ boolean access$getHasErrors$p(MavenSyncConsole $this) {
        return $this.hasErrors;
    }

    public static final /* synthetic */ void access$setHasErrors$p(MavenSyncConsole $this, boolean bl) {
        $this.hasErrors = bl;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\"\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole$ArtifactSyncListenerImpl;", "Lorg/jetbrains/idea/maven/buildtool/ArtifactSyncListener;", "keyPrefix", "", "(Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;Ljava/lang/String;)V", "getKeyPrefix", "()Ljava/lang/String;", "downloadCompleted", "", "dependency", "downloadFailed", "error", "stackTrace", "downloadStarted", "finish", "showBuildIssue", "buildIssue", "Lcom/intellij/build/issue/BuildIssue;", "quickFix", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "showError", "intellij.maven"})
    private final class ArtifactSyncListenerImpl
    implements ArtifactSyncListener {
        @NotNull
        private final String keyPrefix;

        @Override
        public void downloadStarted(@NotNull String dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            MavenSyncConsole.this.downloadEventStarted(this.keyPrefix, dependency);
        }

        @Override
        public void downloadCompleted(@NotNull String dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            MavenSyncConsole.this.downloadEventCompleted(this.keyPrefix, dependency);
        }

        @Override
        public void downloadFailed(@NotNull String dependency, @NotNull String error, @Nullable String stackTrace) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            MavenSyncConsole.this.downloadEventFailed(this.keyPrefix, dependency, error, stackTrace);
        }

        @Override
        public void finish() {
            MavenSyncConsole.this.completeUmbrellaEvents(this.keyPrefix);
        }

        @Override
        public void showError(@NotNull String dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            MavenSyncConsole.this.showError(this.keyPrefix, dependency);
        }

        @Override
        public void showBuildIssue(@NotNull String dependency, @NotNull BuildIssueQuickFix quickFix) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            Intrinsics.checkNotNullParameter((Object)quickFix, (String)"quickFix");
            MavenSyncConsole.this.showBuildIssue(this.keyPrefix, dependency, quickFix);
        }

        @Override
        public void showBuildIssue(@NotNull String dependency, @NotNull BuildIssue buildIssue) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            Intrinsics.checkNotNullParameter((Object)buildIssue, (String)"buildIssue");
            MavenSyncConsole.this.showBuildIssueNode(this.keyPrefix, buildIssue);
        }

        @NotNull
        public final String getKeyPrefix() {
            return this.keyPrefix;
        }

        public ArtifactSyncListenerImpl(String keyPrefix) {
            Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
            this.keyPrefix = keyPrefix;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole$Companion;", "", "()V", "EXIT_CODE_OK", "", "getEXIT_CODE_OK", "()I", "EXIT_CODE_SIGTERM", "getEXIT_CODE_SIGTERM", "intellij.maven"})
    public static final class Companion {
        public final int getEXIT_CODE_OK() {
            return EXIT_CODE_OK;
        }

        public final int getEXIT_CODE_SIGTERM() {
            return EXIT_CODE_SIGTERM;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

