/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.code;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomUtil;

public class MavenTypedHandlerDelegate
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project2 == null) {
            MavenTypedHandlerDelegate.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            MavenTypedHandlerDelegate.$$$reportNull$$$0(1);
        }
        if (file == null) {
            MavenTypedHandlerDelegate.$$$reportNull$$$0(2);
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                MavenTypedHandlerDelegate.$$$reportNull$$$0(3);
            }
            return result;
        }
        if (c != '{') {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                MavenTypedHandlerDelegate.$$$reportNull$$$0(4);
            }
            return result;
        }
        if (!MavenTypedHandlerDelegate.shouldProcess(file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                MavenTypedHandlerDelegate.$$$reportNull$$$0(5);
            }
            return result;
        }
        int offset = editor.getCaretModel().getOffset();
        if (MavenTypedHandlerDelegate.shouldCloseBrace(editor, offset, c)) {
            editor.getDocument().insertString(offset, (CharSequence)"}");
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                MavenTypedHandlerDelegate.$$$reportNull$$$0(6);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            MavenTypedHandlerDelegate.$$$reportNull$$$0(7);
        }
        return result;
    }

    private static boolean shouldCloseBrace(Editor editor, int offset, char c) {
        CharSequence text = editor.getDocument().getCharsSequence();
        if (offset < 2) {
            return false;
        }
        if (c != '{' || text.charAt(offset - 2) != '$') {
            return false;
        }
        if (offset < text.length()) {
            char next = text.charAt(offset);
            if (next == '}') {
                return false;
            }
            if (Character.isLetterOrDigit(next)) {
                return false;
            }
        }
        return true;
    }

    public static boolean shouldProcess(PsiFile file) {
        return MavenDomUtil.isMavenFile(file) || MavenDomUtil.isFilteredResourceFile((PsiElement)file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/code/MavenTypedHandlerDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/code/MavenTypedHandlerDelegate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

