/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesHelper;
import org.jetbrains.idea.maven.dom.converters.MavenConsumerPomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenDomSoftAwareConverter;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomExclusion;
import org.jetbrains.idea.maven.dom.model.MavenDomExtension;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugins;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenArtifactUtilKt;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.reposearch.DependencySearchService;

public abstract class MavenArtifactCoordinatesConverter
extends ResolvingConverter<String>
implements MavenDomSoftAwareConverter {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        MavenId id = MavenArtifactCoordinatesHelper.getId(context);
        Project contextProject = context.getProject();
        MavenProjectIndicesManager manager = MavenProjectIndicesManager.getInstance(contextProject);
        ConverterStrategy strategy = this.selectStrategy(context);
        boolean isValid = strategy.isValid(id, manager, context);
        if (!isValid) {
            File localRepository = MavenProjectsManager.getInstance(contextProject).getLocalRepository();
            VirtualFile file = MavenUtil.getRepositoryFile(contextProject, id, "pom", null);
            if (file != null) {
                File artifactFile = new File(file.getPath());
                MavenIndicesManager.getInstance(contextProject).fixArtifactIndexAsync(artifactFile, localRepository);
                return s;
            }
            return null;
        }
        return s;
    }

    protected abstract boolean doIsValid(MavenId var1, MavenProjectIndicesManager var2, ConvertContext var3);

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        DependencySearchService searchService = DependencySearchService.getInstance((Project)context.getProject());
        MavenId id = MavenArtifactCoordinatesHelper.getId(context);
        MavenDomShortArtifactCoordinates coordinates = MavenArtifactCoordinatesHelper.getCoordinates(context);
        Set<String> set = this.selectStrategy(context).getVariants(id, searchService, coordinates);
        if (set == null) {
            MavenArtifactCoordinatesConverter.$$$reportNull$$$0(0);
        }
        return set;
    }

    protected abstract Set<String> doGetVariants(MavenId var1, DependencySearchService var2);

    public PsiElement resolve(String o, ConvertContext context) {
        MavenId id = MavenArtifactCoordinatesHelper.getId(context);
        PsiFile result = this.selectStrategy(context).resolve(id, context);
        return result != null ? result : super.resolve((Object)o, context);
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return this.selectStrategy(context).getErrorMessage(s, context);
    }

    @Override
    public boolean isSoft(@NotNull DomElement element) {
        DomElement pluginsElement;
        DomElement dependencies;
        DomElement dependencyOrPluginElement;
        if (element == null) {
            MavenArtifactCoordinatesConverter.$$$reportNull$$$0(1);
        }
        return (dependencyOrPluginElement = element.getParent()) instanceof MavenDomDependency ? (dependencies = dependencyOrPluginElement.getParent()) instanceof MavenDomDependencies && dependencies.getParent() instanceof MavenDomDependencyManagement : dependencyOrPluginElement instanceof MavenDomPlugin && (pluginsElement = dependencyOrPluginElement.getParent()) instanceof MavenDomPlugins && pluginsElement.getParent() instanceof MavenDomPluginManagement;
    }

    @Nullable
    protected VirtualFile getMavenProjectFile(ConvertContext context) {
        PsiFile psiFile = context.getFile().getOriginalFile();
        return psiFile.getVirtualFile();
    }

    private ConverterStrategy selectStrategy(ConvertContext context) {
        DomElement parent = context.getInvocationElement().getParent();
        if (parent instanceof MavenDomProjectModel) {
            return new ProjectStrategy();
        }
        if (parent instanceof MavenDomParent) {
            return new ParentStrategy((MavenDomParent)parent);
        }
        if (parent instanceof MavenDomDependency) {
            return new DependencyStrategy((MavenDomDependency)parent);
        }
        if (parent instanceof MavenDomExclusion) {
            return new ExclusionStrategy();
        }
        if (parent instanceof MavenDomPlugin) {
            return new PluginOrExtensionStrategy(true);
        }
        if (parent instanceof MavenDomExtension) {
            return new PluginOrExtensionStrategy(false);
        }
        return new ConverterStrategy();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSoft";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PluginOrExtensionStrategy
    extends ConverterStrategy {
        private final boolean myPlugin;

        PluginOrExtensionStrategy(boolean isPlugin) {
            this.myPlugin = isPlugin;
        }

        @Override
        public String getErrorMessage(@Nullable String s, ConvertContext context) {
            return this.myPlugin ? MavenDomBundle.message("plugin.0.not.found", MavenArtifactCoordinatesHelper.getId(context)) : MavenDomBundle.message("build.extension.0.not.found", MavenArtifactCoordinatesHelper.getId(context));
        }

        @Override
        public boolean isValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
            if (StringUtil.isEmpty((String)id.getGroupId())) {
                for (String each : MavenArtifactUtil.DEFAULT_GROUPS) {
                    if (!super.isValid(id = new MavenId(each, id.getArtifactId(), id.getVersion()), manager, context)) continue;
                    return true;
                }
                return false;
            }
            return super.isValid(id, manager, context);
        }

        @Override
        public Set<String> getVariants(MavenId id, DependencySearchService searchService, MavenDomShortArtifactCoordinates coordinates) {
            if (StringUtil.isEmpty((String)id.getGroupId())) {
                HashSet<String> result = new HashSet<String>();
                for (String each : MavenArtifactUtil.DEFAULT_GROUPS) {
                    id = new MavenId(each, id.getArtifactId(), id.getVersion());
                    result.addAll(super.getVariants(id, searchService, coordinates));
                }
                return result;
            }
            return super.getVariants(id, searchService, coordinates);
        }

        @Override
        public PsiFile resolve(MavenId id, ConvertContext context) {
            MavenProject mavenProject2;
            PsiFile res = super.resolve(id, context);
            if (res != null) {
                return res;
            }
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(context.getProject());
            VirtualFile file = MavenArtifactCoordinatesConverter.this.getMavenProjectFile(context);
            MavenProject mavenProject3 = mavenProject2 = file == null ? null : projectsManager.findProject(file);
            if (mavenProject2 != null) {
                for (MavenPlugin plugin : mavenProject2.getPlugins()) {
                    if (!MavenArtifactUtil.isPluginIdEquals(id.getGroupId(), id.getArtifactId(), plugin.getGroupId(), plugin.getArtifactId())) continue;
                    return super.resolve(plugin.getMavenId(), context);
                }
            }
            PsiManager psiManager = context.getPsiManager();
            File artifactFile = MavenArtifactUtil.getArtifactFile(projectsManager.getLocalRepository(), id.getGroupId(), id.getArtifactId(), id.getVersion(), "pom");
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(artifactFile);
            if (virtualFile != null) {
                return psiManager.findFile(virtualFile);
            }
            return null;
        }
    }

    private class ExclusionStrategy
    extends ConverterStrategy {
        private ExclusionStrategy() {
        }

        @Override
        public PsiFile resolve(MavenId id, ConvertContext context) {
            return null;
        }

        @Override
        public boolean isValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
            return true;
        }
    }

    private class DependencyStrategy
    extends ConverterStrategy {
        private final MavenDomDependency myDependency;

        DependencyStrategy(MavenDomDependency dependency) {
            this.myDependency = dependency;
        }

        @Override
        public String getErrorMessage(@Nullable String s, ConvertContext context) {
            return MavenDomBundle.message("dependency.0.not.found", MavenArtifactCoordinatesHelper.getId(context));
        }

        @Override
        public PsiFile resolve(MavenId id, ConvertContext context) {
            MavenDomDependency managedDependency;
            MavenArtifact artifact;
            MavenProject mavenProject2;
            PsiFile res = super.resolve(id, context);
            if (res != null) {
                return res;
            }
            DomElement parent = context.getInvocationElement().getParent();
            if (!(parent instanceof MavenDomDependency)) {
                return null;
            }
            DependencyConflictId dependencyId = DependencyConflictId.create((MavenDomDependency)parent);
            if (dependencyId == null) {
                return null;
            }
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(context.getProject());
            VirtualFile file = MavenArtifactCoordinatesConverter.this.getMavenProjectFile(context);
            MavenProject mavenProject3 = mavenProject2 = file == null ? null : projectsManager.findProject(file);
            if (mavenProject2 != null && (artifact = mavenProject2.getDependencyArtifactIndex().findArtifacts(dependencyId)) != null && MavenArtifactUtilKt.resolved(artifact)) {
                return super.resolve(new MavenId(id.getGroupId(), id.getArtifactId(), artifact.getVersion()), context);
            }
            if (id.getVersion() == null && (managedDependency = MavenDomProjectProcessorUtils.searchManagingDependency((MavenDomDependency)parent)) != null) {
                GenericDomValue managedDependencyArtifactId = managedDependency.getArtifactId();
                return (PsiFile)RecursionManager.doPreventingRecursion((Object)managedDependencyArtifactId, (boolean)false, () -> {
                    PsiElement res1 = new GenericDomValueReference(managedDependencyArtifactId).resolve();
                    return res1 instanceof PsiFile ? (PsiFile)res1 : null;
                });
            }
            return null;
        }

        @Override
        public PsiFile resolveBySpecifiedPath() {
            return (PsiFile)this.myDependency.getSystemPath().getValue();
        }
    }

    private class ParentStrategy
    extends ConverterStrategy {
        private final MavenDomParent myParent;

        ParentStrategy(MavenDomParent parent) {
            this.myParent = parent;
        }

        @Override
        public String getErrorMessage(@Nullable String s, ConvertContext context) {
            return MavenDomBundle.message("project.0.not.found", MavenArtifactCoordinatesHelper.getId(context));
        }

        @Override
        public PsiFile resolveBySpecifiedPath() {
            return (PsiFile)this.myParent.getRelativePath().getValue();
        }
    }

    private class ProjectStrategy
    extends ConverterStrategy {
        private ProjectStrategy() {
        }

        @Override
        public PsiFile resolve(MavenId id, ConvertContext context) {
            return null;
        }

        @Override
        public boolean isValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
            return true;
        }
    }

    private class ConverterStrategy {
        private ConverterStrategy() {
        }

        @Nls
        public String getErrorMessage(@Nullable String s, ConvertContext context) {
            return MavenDomBundle.message("artifact.0.not.found", MavenArtifactCoordinatesHelper.getId(context));
        }

        public boolean isValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
            return MavenArtifactCoordinatesConverter.this.doIsValid(id, manager, context) || this.resolveBySpecifiedPath() != null;
        }

        public Set<String> getVariants(MavenId id, DependencySearchService searchService, MavenDomShortArtifactCoordinates coordinates) {
            return MavenArtifactCoordinatesConverter.this.doGetVariants(id, searchService);
        }

        public PsiFile resolve(MavenId id, ConvertContext context) {
            PsiManager psiManager = context.getPsiManager();
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(psiManager.getProject());
            PsiFile result = this.resolveBySpecifiedPath();
            if (result != null) {
                return result;
            }
            result = this.resolveInProjects(id, projectsManager, psiManager);
            if (result != null) {
                return result;
            }
            return this.resolveInLocalRepository(id, projectsManager, psiManager);
        }

        @Nullable
        protected PsiFile resolveBySpecifiedPath() {
            return null;
        }

        private PsiFile resolveInProjects(MavenId id, MavenProjectsManager projectsManager, PsiManager psiManager) {
            MavenProject project2 = this.resolveMavenProject(id, projectsManager);
            return project2 == null ? null : psiManager.findFile(project2.getFile());
        }

        private MavenProject resolveMavenProject(MavenId id, MavenProjectsManager projectsManager) {
            if (MavenConsumerPomUtil.isConsumerPomResolutionApplicable(projectsManager.getProject())) {
                return projectsManager.findSingleProjectInReactor(id);
            }
            return projectsManager.findProject(id);
        }

        private PsiFile resolveInLocalRepository(MavenId id, MavenProjectsManager projectsManager, PsiManager psiManager) {
            VirtualFile virtualFile = MavenUtil.getRepositoryFile(psiManager.getProject(), id, "pom", null);
            if (virtualFile == null) {
                return null;
            }
            return psiManager.findFile(virtualFile);
        }
    }

    public static class MyUpdateIndicesIntention
    implements IntentionAction {
        @NotNull
        public String getFamilyName() {
            String string = MavenDomBundle.message("inspection.group", new Object[0]);
            if (string == null) {
                MyUpdateIndicesIntention.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = MavenDomBundle.message("fix.update.indices", new Object[0]);
            if (string == null) {
                MyUpdateIndicesIntention.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project2 == null) {
                MyUpdateIndicesIntention.$$$reportNull$$$0(2);
            }
            MavenProjectIndicesManager.getInstance(project2).scheduleUpdateAll();
        }

        public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
            if (project2 == null) {
                MyUpdateIndicesIntention.$$$reportNull$$$0(3);
            }
            return MavenUtil.isPomFile(project2, file.getVirtualFile()) && MavenProjectIndicesManager.getInstance(project2).hasRemotesExceptCentral();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter$MyUpdateIndicesIntention";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter$MyUpdateIndicesIntention";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

