/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.project.Project;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomArtifactCoordinates;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.model.MavenId;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u000b\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesHelper;", "", "()V", "getCoordinates", "Lorg/jetbrains/idea/maven/dom/model/MavenDomShortArtifactCoordinates;", "context", "Lcom/intellij/util/xml/ConvertContext;", "getId", "Lorg/jetbrains/idea/maven/model/MavenId;", "getMavenId", "coords", "withVersion", "version", "", "intellij.maven"})
public final class MavenArtifactCoordinatesHelper {
    @NotNull
    public static final MavenArtifactCoordinatesHelper INSTANCE;

    @JvmStatic
    @NotNull
    public static final MavenId getId(@NotNull ConvertContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return MavenArtifactCoordinatesHelper.getMavenId(MavenArtifactCoordinatesHelper.getCoordinates(context), context);
    }

    @JvmStatic
    @Nullable
    public static final MavenDomShortArtifactCoordinates getCoordinates(@NotNull ConvertContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DomElement domElement = context.getInvocationElement();
        Intrinsics.checkNotNullExpressionValue((Object)domElement, (String)"context.invocationElement");
        DomElement domElement2 = domElement.getParent();
        if (domElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates");
        }
        return (MavenDomShortArtifactCoordinates)domElement2;
    }

    @JvmStatic
    @NotNull
    public static final MavenId getMavenId(@Nullable MavenDomShortArtifactCoordinates coords, @NotNull ConvertContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (coords instanceof MavenDomArtifactCoordinates) {
            GenericDomValue<String> genericDomValue = ((MavenDomArtifactCoordinates)coords).getVersion();
            Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"coords.version");
            String string = MavenDependencyCompletionUtil.removeDummy(genericDomValue.getStringValue());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MavenDependencyCompletio\u2026ords.version.stringValue)");
            String version2 = string;
            CharSequence charSequence = version2;
            boolean bl = false;
            if (!(charSequence.length() == 0)) {
                return MavenArtifactCoordinatesHelper.withVersion(coords, version2);
            }
        }
        DomFileElement domFileElement = DomManager.getDomManager((Project)context.getProject()).getFileElement(context.getFile(), MavenDomProjectModel.class);
        if (domFileElement == null) {
            return MavenArtifactCoordinatesHelper.withVersion((MavenDomShortArtifactCoordinates)coords, "");
        }
        Intrinsics.checkNotNullExpressionValue((Object)domFileElement, (String)"DomManager.getDomManager\u2026n withVersion(coords, \"\")");
        DomFileElement domModel = domFileElement;
        GenericDomValue<String> genericDomValue = coords;
        String string = MavenDependencyCompletionUtil.removeDummy(genericDomValue != null && (genericDomValue = genericDomValue.getGroupId()) != null ? genericDomValue.getStringValue() : null);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MavenDependencyCompletio\u2026ds?.groupId?.stringValue)");
        String groupId = string;
        GenericDomValue<String> genericDomValue2 = coords;
        String string2 = MavenDependencyCompletionUtil.removeDummy(genericDomValue2 != null && (genericDomValue2 = genericDomValue2.getArtifactId()) != null ? genericDomValue2.getStringValue() : null);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MavenDependencyCompletio\u2026.artifactId?.stringValue)");
        String artifactId = string2;
        CharSequence charSequence = artifactId;
        boolean bl = false;
        if (charSequence.length() > 0) {
            charSequence = groupId;
            bl = false;
            if (charSequence.length() > 0 && coords != null && !MavenDependencyCompletionUtil.isInsideManagedDependency(coords)) {
                GenericDomValue<String> managed = MavenDependencyCompletionUtil.findManagedDependency((MavenDomProjectModel)domModel.getRootElement(), context.getProject(), groupId, artifactId);
                Object object = managed;
                if (object == null || (object = object.getVersion()) == null || (object = object.getStringValue()) == null) {
                    object = "";
                }
                Intrinsics.checkNotNullExpressionValue(object, (String)"managed?.version?.stringValue ?: \"\"");
                return MavenArtifactCoordinatesHelper.withVersion(coords, object);
            }
        }
        return new MavenId(groupId, artifactId, "");
    }

    @JvmStatic
    @NotNull
    public static final MavenId withVersion(@Nullable MavenDomShortArtifactCoordinates coords, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        if (coords == null) {
            return new MavenId("", "", "");
        }
        GenericDomValue<String> genericDomValue = coords.getGroupId();
        Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"coords.groupId");
        String string = MavenDependencyCompletionUtil.removeDummy(genericDomValue.getStringValue());
        GenericDomValue<String> genericDomValue2 = coords.getArtifactId();
        Intrinsics.checkNotNullExpressionValue(genericDomValue2, (String)"coords.artifactId");
        return new MavenId(string, MavenDependencyCompletionUtil.removeDummy(genericDomValue2.getStringValue()), version2);
    }

    private MavenArtifactCoordinatesHelper() {
    }

    static {
        MavenArtifactCoordinatesHelper mavenArtifactCoordinatesHelper;
        INSTANCE = mavenArtifactCoordinatesHelper = new MavenArtifactCoordinatesHelper();
    }
}

