/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemModulePropertyManagerBridge;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.impl.ModulePathKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageDiffBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenModuleImporter;
import org.jetbrains.idea.maven.importing.MavenModuleNameMapper;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapterLegacyImpl;
import org.jetbrains.idea.maven.importing.ModifiableModelsProviderProxy;
import org.jetbrains.idea.maven.importing.ModifiableModelsProviderProxyImpl;
import org.jetbrains.idea.maven.importing.ModifiableModelsProviderProxyWrapper;
import org.jetbrains.idea.maven.importing.ModuleModelProxy;
import org.jetbrains.idea.maven.importing.configurers.MavenModuleConfigurer;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenArtifactUtilKt;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;

public class MavenProjectImporter {
    private static final Logger LOG = Logger.getInstance(MavenProjectImporter.class);
    private final Project myProject;
    private final MavenProjectsTree myProjectsTree;
    private final Map<VirtualFile, Module> myFileToModuleMapping;
    private volatile Map<MavenProject, MavenProjectChanges> myProjectsToImportWithChanges;
    private volatile Set<MavenProject> myAllProjects;
    private final boolean myImportModuleGroupsRequired;
    private final MavenImportingSettings myImportingSettings;
    private final IdeModifiableModelsProvider myIdeModifiableModelsProvider;
    private final WorkspaceEntityStorageBuilder myDiff;
    private ModifiableModelsProviderProxy myModelsProvider;
    private ModuleModelProxy myModuleModel;
    private final Module myDummyModule;
    private final List<Module> myCreatedModules = new ArrayList<Module>();
    private final Map<MavenProject, Module> myMavenProjectToModule = new HashMap<MavenProject, Module>();
    private final Map<MavenProject, String> myMavenProjectToModuleName = new HashMap<MavenProject, String>();
    private final Map<MavenProject, String> myMavenProjectToModulePath = new HashMap<MavenProject, String>();

    public MavenProjectImporter(Project p, MavenProjectsTree projectsTree, Map<VirtualFile, Module> fileToModuleMapping, Map<MavenProject, MavenProjectChanges> projectsToImportWithChanges, boolean importModuleGroupsRequired, IdeModifiableModelsProvider modelsProvider, MavenImportingSettings importingSettings, Module dummyModule) {
        this.myProject = p;
        this.myProjectsTree = projectsTree;
        this.myFileToModuleMapping = fileToModuleMapping;
        this.myProjectsToImportWithChanges = projectsToImportWithChanges;
        this.myImportModuleGroupsRequired = importModuleGroupsRequired;
        this.myImportingSettings = importingSettings;
        this.myDummyModule = dummyModule;
        this.myDiff = ((IdeModifiableModelsProviderImpl)modelsProvider).getActualStorageBuilder();
        this.myIdeModifiableModelsProvider = modelsProvider;
    }

    @Nullable
    public List<MavenProjectsProcessorTask> importProject() {
        this.myModelsProvider = MavenUtil.newModelEnabled(this.myProject) ? new ModifiableModelsProviderProxyImpl(this.myProject, this.myDiff) : new ModifiableModelsProviderProxyWrapper(this.myIdeModifiableModelsProvider);
        this.myModuleModel = this.myModelsProvider.getModuleModelProxy();
        return this.importProjectOldWay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<MavenProjectsProcessorTask> importProjectOldWay() {
        ArrayList<MavenProjectsProcessorTask> postTasks = new ArrayList<MavenProjectsProcessorTask>();
        this.myAllProjects = new LinkedHashSet<MavenProject>(this.myProjectsTree.getProjects());
        this.myAllProjects.addAll(this.myProjectsToImportWithChanges.keySet());
        boolean hasChanges = this.deleteIncompatibleModules();
        this.myProjectsToImportWithChanges = this.collectProjectsToImport(this.myProjectsToImportWithChanges);
        this.mapMavenProjectsToModulesAndNames();
        if (this.myProject.isDisposed()) {
            return null;
        }
        boolean projectsHaveChanges = this.projectsToImportHaveChanges();
        ArrayList<MavenModuleImporter> importers = new ArrayList<MavenModuleImporter>();
        if (projectsHaveChanges) {
            hasChanges = true;
            importers.addAll(this.importModules());
            this.scheduleRefreshResolvedArtifacts(postTasks);
        }
        if (projectsHaveChanges || this.myImportModuleGroupsRequired) {
            hasChanges = true;
            this.configModuleGroups();
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        List<Module> obsoleteModules = this.collectObsoleteModules();
        boolean isDeleteObsoleteModules = this.isDeleteObsoleteModules(obsoleteModules);
        if (hasChanges |= isDeleteObsoleteModules) {
            MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
                this.setMavenizedModules(obsoleteModules, false);
                if (isDeleteObsoleteModules) {
                    this.deleteModules(obsoleteModules);
                }
                this.removeUnusedProjectLibraries();
                this.myModelsProvider.commit();
                if (projectsHaveChanges) {
                    this.removeOutdatedCompilerConfigSettings();
                }
                if (projectsHaveChanges) {
                    this.setMavenizedModules(ContainerUtil.map(this.myProjectsToImportWithChanges.keySet(), this.myMavenProjectToModule::get), true);
                }
            }));
            if (!importers.isEmpty()) {
                IdeModifiableModelsProvider provider = ProjectDataManager.getInstance().createModifiableModelsProvider(this.myProject);
                try {
                    ArrayList<MavenModuleImporter> toRun = new ArrayList<MavenModuleImporter>(importers.size());
                    for (MavenModuleImporter importer : importers) {
                        if (importer.isModuleDisposed()) continue;
                        importer.setModifiableModelsProvider(provider);
                        toRun.add(importer);
                    }
                    this.configFacets(postTasks, toRun);
                }
                finally {
                    MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> provider.commit()));
                }
            }
            this.configureMavenProjects();
        } else {
            MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> this.setMavenizedModules(obsoleteModules, false));
            this.disposeModifiableModels();
        }
        return postTasks;
    }

    private void configureMavenProjects() {
        List<MavenModuleConfigurer> configurers = MavenModuleConfigurer.getConfigurers();
        MavenUtil.runInBackground(this.myProject, MavenProjectBundle.message("command.name.configuring.projects", new Object[0]), false, indicator -> {
            float count = 0.0f;
            for (MavenProject mavenProject2 : this.myAllProjects) {
                Module module = this.myMavenProjectToModule.get(mavenProject2);
                if (module == null) continue;
                float f = count;
                count = f + 1.0f;
                indicator.setFraction(f / (float)this.myAllProjects.size());
                indicator.setText2(MavenProjectBundle.message("progress.details.configuring.module", module.getName()));
                for (MavenModuleConfigurer configurer : configurers) {
                    configurer.configure(mavenProject2, this.myProject, module);
                }
            }
        });
    }

    private void disposeModifiableModels() {
        MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> this.myModelsProvider.dispose());
    }

    private boolean projectsToImportHaveChanges() {
        for (MavenProjectChanges each : this.myProjectsToImportWithChanges.values()) {
            if (!each.hasChanges()) continue;
            return true;
        }
        return false;
    }

    private Map<MavenProject, MavenProjectChanges> collectProjectsToImport(Map<MavenProject, MavenProjectChanges> projectsToImport) {
        HashMap<MavenProject, MavenProjectChanges> result = new HashMap<MavenProject, MavenProjectChanges>(projectsToImport);
        result.putAll(this.collectNewlyCreatedProjects());
        Set<MavenProject> allProjectsToImport = result.keySet();
        Set<MavenProject> selectedProjectsToImport = this.selectProjectsToImport(allProjectsToImport);
        Iterator<MavenProject> it = allProjectsToImport.iterator();
        while (it.hasNext()) {
            if (selectedProjectsToImport.contains(it.next())) continue;
            it.remove();
        }
        return result;
    }

    private Map<MavenProject, MavenProjectChanges> collectNewlyCreatedProjects() {
        HashMap<MavenProject, MavenProjectChanges> result = new HashMap<MavenProject, MavenProjectChanges>();
        for (MavenProject each : this.myAllProjects) {
            Module module = this.myFileToModuleMapping.get(each.getFile());
            if (module != null) continue;
            result.put(each, MavenProjectChanges.ALL);
        }
        return result;
    }

    private Set<MavenProject> selectProjectsToImport(Collection<MavenProject> originalProjects) {
        HashSet<MavenProject> result = new HashSet<MavenProject>();
        for (MavenProject each : originalProjects) {
            if (!this.shouldCreateModuleFor(each)) continue;
            result.add(each);
        }
        return result;
    }

    private boolean shouldCreateModuleFor(MavenProject project2) {
        if (this.myProjectsTree.isIgnored(project2)) {
            return false;
        }
        return !project2.isAggregator() || this.myImportingSettings.isCreateModulesForAggregators();
    }

    private boolean deleteIncompatibleModules() {
        Pair<List<Pair<MavenProject, Module>>, List<Pair<MavenProject, Module>>> incompatible = this.collectIncompatibleModulesWithProjects();
        List incompatibleMavenized = (List)incompatible.first;
        List incompatibleNotMavenized = (List)incompatible.second;
        if (incompatibleMavenized.isEmpty() && incompatibleNotMavenized.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Pair each : incompatibleMavenized) {
            this.myFileToModuleMapping.remove(((MavenProject)each.first).getFile());
            this.myModuleModel.disposeModule((Module)each.second);
            changed = true;
        }
        if (incompatibleNotMavenized.isEmpty()) {
            return changed;
        }
        int[] result = new int[]{0};
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            MavenUtil.invokeAndWait(this.myProject, this.myModelsProvider.getModalityStateForQuestionDialogs(), () -> {
                String message = MavenProjectBundle.message("maven.import.incompatible.modules", incompatibleNotMavenized.size(), MavenProjectImporter.formatProjectsWithModules(incompatibleNotMavenized));
                String[] options = new String[]{MavenProjectBundle.message("maven.import.incompatible.modules.recreate", new Object[0]), MavenProjectBundle.message("maven.import.incompatible.modules.ignore", new Object[0])};
                result[0] = Messages.showOkCancelDialog((Project)this.myProject, (String)message, (String)MavenProjectBundle.message("maven.project.import.title", new Object[0]), (String)options[0], (String)options[1], (Icon)Messages.getQuestionIcon());
            });
        }
        if (result[0] == 0) {
            for (Pair each : incompatibleNotMavenized) {
                this.myFileToModuleMapping.remove(((MavenProject)each.first).getFile());
                this.myModuleModel.disposeModule((Module)each.second);
            }
            changed = true;
        } else {
            this.myProjectsTree.setIgnoredState(MavenUtil.collectFirsts(incompatibleNotMavenized), true, true);
        }
        return changed;
    }

    private Pair<List<Pair<MavenProject, Module>>, List<Pair<MavenProject, Module>>> collectIncompatibleModulesWithProjects() {
        ArrayList<Pair> incompatibleMavenized = new ArrayList<Pair>();
        ArrayList incompatibleNotMavenized = new ArrayList();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(this.myProject);
        for (MavenProject each : this.myAllProjects) {
            Module module = this.myFileToModuleMapping.get(each.getFile());
            if (module == null || !this.shouldCreateModuleFor(each) || ModuleType.get((Module)module).equals(each.getModuleType())) continue;
            (manager.isMavenizedModule(module) ? incompatibleMavenized : incompatibleNotMavenized).add(Pair.create((Object)each, (Object)module));
        }
        return Pair.create(incompatibleMavenized, incompatibleNotMavenized);
    }

    private static String formatProjectsWithModules(List<Pair<MavenProject, Module>> projectsWithModules) {
        return StringUtil.join(projectsWithModules, each -> {
            MavenProject project2 = (MavenProject)each.first;
            Module module = (Module)each.second;
            return ModuleType.get((Module)module).getName() + " '" + module.getName() + "' for Maven project " + project2.getMavenId().getDisplayString();
        }, (String)"<br>");
    }

    private void deleteModules(@NotNull List<Module> modules2) {
        if (modules2 == null) {
            MavenProjectImporter.$$$reportNull$$$0(0);
        }
        for (Module each : modules2) {
            if (each.isDisposed()) continue;
            this.myModuleModel.disposeModule(each);
        }
    }

    private boolean isDeleteObsoleteModules(@NotNull List<Module> obsoleteModules) {
        if (obsoleteModules == null) {
            MavenProjectImporter.$$$reportNull$$$0(1);
        }
        if (obsoleteModules.isEmpty()) {
            return false;
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() || MavenUtil.isMavenUnitTestModeEnabled()) {
            int[] result = new int[1];
            MavenUtil.invokeAndWait(this.myProject, this.myModelsProvider.getModalityStateForQuestionDialogs(), () -> {
                result[0] = Messages.showYesNoDialog((Project)this.myProject, (String)MavenProjectBundle.message("maven.import.message.delete.obsolete", MavenProjectImporter.formatModules(obsoleteModules)), (String)MavenProjectBundle.message("maven.project.import.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            });
            if (result[0] == 1) {
                return false;
            }
        }
        return true;
    }

    private List<Module> collectObsoleteModules() {
        ArrayList remainingModules = new ArrayList();
        Collections.addAll(remainingModules, this.myModuleModel.getModules());
        for (MavenProject each : this.selectProjectsToImport(this.myAllProjects)) {
            remainingModules.remove(this.myMavenProjectToModule.get(each));
        }
        ArrayList<Module> obsolete = new ArrayList<Module>();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(this.myProject);
        for (Module each : remainingModules) {
            if (!manager.isMavenizedModule(each)) continue;
            obsolete.add(each);
        }
        return obsolete;
    }

    private static String formatModules(Collection<Module> modules2) {
        StringBuilder res = new StringBuilder();
        int i = 0;
        for (Module module : modules2) {
            res.append('\'').append(module.getName()).append("'\n");
            if (++i <= 20) continue;
            break;
        }
        if (i > 20) {
            res.append("\n ... and other ").append(modules2.size() - 20).append(" modules");
        }
        return res.toString();
    }

    private static void doRefreshFiles(Set<File> files2) {
        LocalFileSystem.getInstance().refreshIoFiles(files2);
    }

    private void scheduleRefreshResolvedArtifacts(List<MavenProjectsProcessorTask> postTasks) {
        ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
        for (MavenProject each : this.myProjectsToImportWithChanges.keySet()) {
            artifacts.addAll(each.getDependencies());
        }
        final HashSet<File> files2 = new HashSet<File>();
        for (MavenArtifact each : artifacts) {
            if (!MavenArtifactUtilKt.resolved(each)) continue;
            files2.add(each.getFile());
        }
        if (MavenUtil.isMavenUnitTestModeEnabled()) {
            MavenProjectImporter.doRefreshFiles(files2);
        } else {
            postTasks.add(new MavenProjectsProcessorTask(){

                @Override
                public void perform(Project project2, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                    indicator.setText(MavenProjectBundle.message("progress.text.refreshing.files", new Object[0]));
                    MavenProjectImporter.doRefreshFiles(files2);
                }
            });
        }
    }

    private void mapMavenProjectsToModulesAndNames() {
        for (MavenProject each : this.myAllProjects) {
            Module module = this.myFileToModuleMapping.get(each.getFile());
            if (module == null) continue;
            this.myMavenProjectToModule.put(each, module);
        }
        MavenModuleNameMapper.map(this.myAllProjects, this.myMavenProjectToModule, this.myMavenProjectToModuleName, this.myMavenProjectToModulePath, this.myImportingSettings.getDedicatedModuleDir());
    }

    private void removeOutdatedCompilerConfigSettings() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        JpsJavaCompilerOptions javacOptions = JavacConfiguration.getOptions((Project)this.myProject, JavacConfiguration.class);
        String options = javacOptions.ADDITIONAL_OPTIONS_STRING;
        javacOptions.ADDITIONAL_OPTIONS_STRING = options = options.replaceFirst("(-target (\\S+))", "");
    }

    private List<MavenModuleImporter> importModules() {
        Map<MavenProject, MavenProjectChanges> projectsWithChanges = this.myProjectsToImportWithChanges;
        HashSet<MavenProject> projectsWithNewlyCreatedModules = new HashSet<MavenProject>();
        for (MavenProject each : projectsWithChanges.keySet()) {
            if (!this.ensureModuleCreated(each)) continue;
            projectsWithNewlyCreatedModules.add(each);
        }
        ArrayList<MavenModuleImporter> importers = new ArrayList<MavenModuleImporter>();
        for (Map.Entry<MavenProject, MavenProjectChanges> each : projectsWithChanges.entrySet()) {
            MavenProject project2 = each.getKey();
            Module module = this.myMavenProjectToModule.get(project2);
            boolean isNewModule = projectsWithNewlyCreatedModules.contains(project2);
            MavenId mavenId = project2.getMavenId();
            this.myModelsProvider.registerModulePublication(module, (ProjectCoordinate)new ProjectId(mavenId.getGroupId(), mavenId.getArtifactId(), mavenId.getVersion()));
            MavenModuleImporter moduleImporter = this.createModuleImporter(module, project2, each.getValue());
            importers.add(moduleImporter);
            MavenRootModelAdapter rootModelAdapter = new MavenRootModelAdapter(new MavenRootModelAdapterLegacyImpl(project2, module, this.myModelsProvider));
            rootModelAdapter.init(isNewModule);
            moduleImporter.config(rootModelAdapter);
        }
        for (MavenProject project3 : this.myAllProjects) {
            Module module;
            if (projectsWithChanges.containsKey(project3) || (module = this.myMavenProjectToModule.get(project3)) == null) continue;
            importers.add(this.createModuleImporter(module, project3, null));
        }
        return importers;
    }

    private void configFacets(List<MavenProjectsProcessorTask> tasks, List<MavenModuleImporter> importers) {
        for (MavenModuleImporter importer : importers) {
            importer.preConfigFacets();
        }
        for (MavenModuleImporter importer : importers) {
            importer.configFacets(tasks);
        }
        for (MavenModuleImporter importer : importers) {
            importer.postConfigFacets();
        }
    }

    private void setMavenizedModules(Collection<Module> modules2, boolean mavenized) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        WorkspaceEntityStorage initialStorage = WorkspaceModel.getInstance((Project)this.myProject).getEntityStorage().getCurrent();
        WorkspaceEntityStorageBuilder storageBuilder = WorkspaceEntityStorageBuilder.from((WorkspaceEntityStorage)initialStorage);
        for (Module module : modules2) {
            if (module.isDisposed()) continue;
            ExternalSystemModulePropertyManager modulePropertyManager = ExternalSystemModulePropertyManager.getInstance((Module)module);
            if (modulePropertyManager instanceof ExternalSystemModulePropertyManagerBridge && module instanceof ModuleBridge && ((ModuleBridge)module).getDiff() == null) {
                ((ExternalSystemModulePropertyManagerBridge)modulePropertyManager).setMavenized(mavenized, storageBuilder);
                continue;
            }
            modulePropertyManager.setMavenized(mavenized);
        }
        WorkspaceModel.getInstance((Project)this.myProject).updateProjectModel(builder -> {
            builder.addDiff((WorkspaceEntityStorageDiffBuilder)storageBuilder);
            return null;
        });
    }

    private boolean ensureModuleCreated(MavenProject project2) {
        Module existingModule = this.myMavenProjectToModule.get(project2);
        if (existingModule != null && existingModule != this.myDummyModule) {
            return false;
        }
        String path = this.myMavenProjectToModulePath.get(project2);
        String moduleName = ModulePathKt.getModuleNameByFilePath((String)path);
        if (this.isForTheDummyModule(project2, existingModule)) {
            try {
                if (!this.myDummyModule.getName().equals(moduleName)) {
                    this.myModuleModel.renameModule(this.myDummyModule, moduleName);
                }
            }
            catch (ModuleWithNameAlreadyExists e) {
                MavenLog.LOG.error("Cannot rename dummy module:", (Throwable)e);
            }
            this.myMavenProjectToModule.put(project2, this.myDummyModule);
            this.myCreatedModules.add(this.myDummyModule);
            return true;
        }
        this.deleteExistingImlFile(path);
        this.deleteExistingModuleByName(moduleName);
        Module module = this.myModuleModel.newModule(path, project2.getModuleType().getId());
        this.myMavenProjectToModule.put(project2, module);
        this.myCreatedModules.add(module);
        return true;
    }

    private boolean isForTheDummyModule(MavenProject project2, Module existingModule) {
        if (this.myDummyModule == null) {
            return false;
        }
        if (existingModule == this.myDummyModule) {
            return true;
        }
        return MavenProjectsManager.getInstance(this.myProject).getRootProjects().size() == 1 && MavenProjectsManager.getInstance(this.myProject).findRootProject(project2) == project2;
    }

    private void deleteExistingModuleByName(String name) {
        Module module = this.myModuleModel.findModuleByName(name);
        if (module != null) {
            this.myModuleModel.disposeModule(module);
        }
    }

    private void deleteExistingImlFile(final String path) {
        MavenUtil.invokeAndWaitWriteAction(this.myProject, new Runnable(){

            @Override
            public void run() {
                try {
                    VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                    if (file != null) {
                        file.delete((Object)this);
                    }
                }
                catch (IOException e) {
                    MavenLog.LOG.warn("Cannot delete existing iml file: " + path, (Throwable)e);
                }
            }
        });
    }

    private MavenModuleImporter createModuleImporter(Module module, MavenProject mavenProject2, @Nullable MavenProjectChanges changes) {
        return new MavenModuleImporter(module, this.myProjectsTree, mavenProject2, changes, this.myMavenProjectToModuleName, this.myImportingSettings, this.myModelsProvider);
    }

    private void configModuleGroups() {
        if (!this.myImportingSettings.isCreateModuleGroups()) {
            return;
        }
        final Stack groups = new Stack();
        final boolean createTopLevelGroup = this.myProjectsTree.getRootProjects().size() > 1;
        this.myProjectsTree.visit(new MavenProjectsTree.SimpleVisitor(){
            int depth = 0;

            @Override
            public boolean shouldVisit(MavenProject project2) {
                return MavenProjectImporter.this.myMavenProjectToModuleName.containsKey(project2);
            }

            @Override
            public void visit(MavenProject each) {
                ++this.depth;
                String name = MavenProjectImporter.this.myMavenProjectToModuleName.get(each);
                if (this.shouldCreateGroup(each)) {
                    groups.push((Object)MavenProjectBundle.message("module.group.name", name));
                }
                if (!MavenProjectImporter.this.shouldCreateModuleFor(each)) {
                    return;
                }
                Module module = MavenProjectImporter.this.myModuleModel.findModuleByName(name);
                if (module == null) {
                    return;
                }
                MavenProjectImporter.this.myModuleModel.setModuleGroupPath(module, groups.isEmpty() ? null : ArrayUtilRt.toStringArray((Collection)groups));
            }

            @Override
            public void leave(MavenProject each) {
                if (this.shouldCreateGroup(each)) {
                    groups.pop();
                }
                --this.depth;
            }

            private boolean shouldCreateGroup(MavenProject project2) {
                return !MavenProjectImporter.this.myProjectsTree.getModules(project2).isEmpty() && (createTopLevelGroup || this.depth > 1);
            }
        });
    }

    private boolean removeUnusedProjectLibraries() {
        HashSet unusedLibraries = new HashSet();
        Collections.addAll(unusedLibraries, this.myModelsProvider.getAllLibraries());
        for (ModuleRootModel eachModel : this.collectModuleModels()) {
            for (OrderEntry eachEntry : eachModel.getOrderEntries()) {
                if (!(eachEntry instanceof LibraryOrderEntry)) continue;
                unusedLibraries.remove(((LibraryOrderEntry)eachEntry).getLibrary());
            }
        }
        boolean removed = false;
        for (Library each : unusedLibraries) {
            if (MavenProjectImporter.isDisposed(each) || !MavenRootModelAdapter.isMavenLibrary(each) || MavenRootModelAdapter.isChangedByUser(each)) continue;
            this.myModelsProvider.removeLibrary(each);
            removed = true;
        }
        return removed;
    }

    private static boolean isDisposed(Library library) {
        return library instanceof LibraryEx && ((LibraryEx)library).isDisposed();
    }

    private Collection<ModuleRootModel> collectModuleModels() {
        HashMap<Module, ModifiableRootModel> rootModels = new HashMap<Module, ModifiableRootModel>();
        for (MavenProject each : this.myProjectsToImportWithChanges.keySet()) {
            Module module = this.myMavenProjectToModule.get(each);
            ModifiableRootModel rootModel = this.myModelsProvider.getModifiableRootModel(module);
            rootModels.put(module, rootModel);
        }
        for (Module each : this.myModuleModel.getModules()) {
            if (rootModels.containsKey(each)) continue;
            rootModels.put(each, this.myModelsProvider.getModifiableRootModel(each));
        }
        return rootModels.values();
    }

    public List<Module> getCreatedModules() {
        return this.myCreatedModules;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obsoleteModules";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenProjectImporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteModules";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isDeleteObsoleteModules";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

