/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.configurers;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.MavenDisposable;
import org.jetbrains.idea.maven.importing.MavenModuleImporter;
import org.jetbrains.idea.maven.importing.configurers.MavenModuleConfigurer;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenCompilerConfigurer
extends MavenModuleConfigurer {
    public static final Key<Boolean> IGNORE_MAVEN_COMPILER_TARGET_KEY = Key.create((String)"idea.maven.skip.compiler.target.level");

    @Override
    public void configure(@NotNull MavenProject mavenProject2, @NotNull Project project2, @NotNull Module module) {
        if (mavenProject2 == null) {
            MavenCompilerConfigurer.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            MavenCompilerConfigurer.$$$reportNull$$$0(1);
        }
        if (module == null) {
            MavenCompilerConfigurer.$$$reportNull$$$0(2);
        }
        CompilerConfiguration configuration = CompilerConfiguration.getInstance((Project)project2);
        if (!Boolean.TRUE.equals(module.getUserData(IGNORE_MAVEN_COMPILER_TARGET_KEY))) {
            String targetLevel = mavenProject2.getReleaseLevel();
            if (targetLevel == null || StringUtil.compareVersionNumbers((String)MavenUtil.getCompilerPluginVersion(mavenProject2), (String)"3.6") < 0) {
                targetLevel = mavenProject2.getTargetLevel();
            }
            configuration.setBytecodeTargetLevel(module, (String)ObjectUtils.notNull((Object)targetLevel, (Object)MavenModuleImporter.getDefaultLevel(mavenProject2).toJavaVersion().toString()));
        }
        module.putUserData(IGNORE_MAVEN_COMPILER_TARGET_KEY, (Object)Boolean.FALSE);
        VirtualFile dir2 = VfsUtil.findRelativeFile((VirtualFile)mavenProject2.getDirectoryFile(), (String[])new String[]{"src", "main", "resources", "archetype-resources"});
        if (dir2 != null && !configuration.isExcludedFromCompilation(dir2)) {
            ExcludesConfiguration cfg = configuration.getExcludedEntriesConfiguration();
            cfg.addExcludeEntryDescription(new ExcludeEntryDescription(dir2, true, false, (Disposable)MavenDisposable.getInstance(project2)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "mavenProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/importing/configurers/MavenCompilerConfigurer";
        objectArray[2] = "configure";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

