/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.server.BuildManager;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.references.MavenFilteredPropertyPsiReferenceProvider;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.ManifestBuilder;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.jps.maven.model.impl.MavenEjbClientConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenIdBean;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenWebArtifactConfiguration;
import org.jetbrains.jps.maven.model.impl.ResourceRootConfiguration;

@ApiStatus.Internal
public class MavenResourceConfigurationGeneratorCompileTask
implements CompileTask {
    private static final Logger LOG = Logger.getInstance(MavenResourceConfigurationGeneratorCompileTask.class);
    private static final Pattern SIMPLE_NEGATIVE_PATTERN = Pattern.compile("!\\?(\\*\\.\\w+)");
    private static final String IDEA_MAVEN_DISABLE_MANIFEST = System.getProperty("idea.maven.disable.manifest");

    public boolean execute(@NotNull CompileContext context) {
        if (context == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().runReadAction(() -> MavenResourceConfigurationGeneratorCompileTask.generateBuildConfiguration(context.isRebuild(), context.getProject()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateBuildConfiguration(boolean force, @NotNull Project project2) {
        MavenProjectsManager mavenProjectsManager;
        if (project2 == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(1);
        }
        if (!(mavenProjectsManager = MavenProjectsManager.getInstance(project2)).isMavenizedProject()) {
            return;
        }
        BuildManager buildManager = BuildManager.getInstance();
        File projectSystemDir = buildManager.getProjectSystemDirectory(project2);
        if (projectSystemDir == null) {
            return;
        }
        Function<String, String> transformer = MavenResourceConfigurationGeneratorCompileTask.createValueTransformer(project2);
        File mavenConfigFile = new File(projectSystemDir, "maven/configuration.xml");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project2);
        ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        int projectRootModificationCount = (int)projectRootManager.getModificationCount();
        int mavenConfigCrc = mavenProjectsManager.getFilterConfigCrc(fileIndex);
        int crc = mavenConfigCrc + projectRootModificationCount;
        File crcFile = new File(mavenConfigFile.getParent(), "configuration.crc");
        if (!force) {
            try (DataInputStream crcInput = new DataInputStream(new FileInputStream(crcFile));){
                int lastCrc = crcInput.readInt();
                if (lastCrc == crc) {
                    return;
                }
                LOG.debug(String.format("project configuration changed: lastCrc = %d, currentCrc = %d, projectRootModificationCount = %d, mavenConfigCrc = %d", lastCrc, crc, projectRootModificationCount, mavenConfigCrc));
            }
            catch (IOException e) {
                LOG.debug("Unable to read or find config file: " + e.getMessage());
            }
        }
        MavenProjectConfiguration projectConfig = new MavenProjectConfiguration();
        for (MavenProject mavenProject2 : mavenProjectsManager.getProjects()) {
            String string;
            VirtualFile pomXml;
            Module module;
            if ("pom".equals(mavenProject2.getPackaging()) || (module = fileIndex.getModuleForFile(pomXml = mavenProject2.getFile())) == null || !Comparing.equal((Object)mavenProject2.getDirectoryFile(), (Object)fileIndex.getContentRootForFile(pomXml))) continue;
            MavenModuleResourceConfiguration resourceConfig = new MavenModuleResourceConfiguration();
            MavenId projectId = mavenProject2.getMavenId();
            resourceConfig.id = new MavenIdBean(projectId.getGroupId(), projectId.getArtifactId(), projectId.getVersion());
            MavenId parentId = mavenProject2.getParentId();
            if (parentId != null) {
                resourceConfig.parentId = new MavenIdBean(parentId.getGroupId(), parentId.getArtifactId(), parentId.getVersion());
            }
            resourceConfig.directory = transformer.apply(FileUtil.toSystemIndependentName((String)mavenProject2.getDirectory()));
            resourceConfig.delimitersPattern = MavenFilteredPropertyPsiReferenceProvider.getDelimitersPattern(mavenProject2).pattern();
            for (Map.Entry<String, String> entry : mavenProject2.getModelMap().entrySet()) {
                String key = entry.getKey();
                String string2 = entry.getValue();
                if (string2 == null) continue;
                resourceConfig.modelMap.put(key, transformer.apply(string2));
            }
            MavenResourceConfigurationGeneratorCompileTask.addEarModelMapEntries(mavenProject2, resourceConfig.modelMap);
            Element pluginConfiguration = mavenProject2.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
            resourceConfig.outputDirectory = transformer.apply(MavenResourceConfigurationGeneratorCompileTask.getResourcesPluginGoalOutputDirectory(mavenProject2, pluginConfiguration, "resources"));
            resourceConfig.testOutputDirectory = transformer.apply(MavenResourceConfigurationGeneratorCompileTask.getResourcesPluginGoalOutputDirectory(mavenProject2, pluginConfiguration, "testResources"));
            MavenResourceConfigurationGeneratorCompileTask.addResources(transformer, resourceConfig.resources, mavenProject2.getResources());
            MavenResourceConfigurationGeneratorCompileTask.addResources(transformer, resourceConfig.testResources, mavenProject2.getTestResources());
            MavenResourceConfigurationGeneratorCompileTask.addWebResources(transformer, module, projectConfig, mavenProject2);
            MavenResourceConfigurationGeneratorCompileTask.addEjbClientArtifactConfiguration(transformer, module, projectConfig, mavenProject2);
            resourceConfig.filteringExclusions.addAll(MavenProjectsTree.getFilterExclusions(mavenProject2));
            Properties properties = MavenResourceConfigurationGeneratorCompileTask.getFilteringProperties(mavenProject2, mavenProjectsManager);
            for (Map.Entry entry : properties.entrySet()) {
                resourceConfig.properties.put((String)entry.getKey(), transformer.apply((String)entry.getValue()));
            }
            resourceConfig.escapeString = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "escapeString", null);
            String escapeWindowsPaths = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "escapeWindowsPaths");
            if (escapeWindowsPaths != null) {
                resourceConfig.escapeWindowsPaths = Boolean.parseBoolean(escapeWindowsPaths);
            }
            if ((string = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "overwrite")) != null) {
                resourceConfig.overwrite = Boolean.parseBoolean(string);
            }
            projectConfig.moduleConfigurations.put(module.getName(), resourceConfig);
            MavenResourceConfigurationGeneratorCompileTask.generateManifest(mavenProject2, module, resourceConfig);
        }
        MavenResourceConfigurationGeneratorCompileTask.addNonMavenResources(transformer, projectConfig, mavenProjectsManager, project2);
        Element element = new Element("maven-project-configuration");
        XmlSerializer.serializeInto((Object)projectConfig, (Element)element);
        buildManager.runCommand(() -> {
            if (!project2.isDefault()) {
                buildManager.clearState(project2);
            }
            FileUtil.createIfDoesntExist((File)mavenConfigFile);
            try {
                JdomKt.write((Parent)element, (Path)mavenConfigFile.toPath());
                try (DataOutputStream crcOutput = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(crcFile)));){
                    crcOutput.writeInt(crc);
                }
            }
            catch (IOException e) {
                LOG.debug("Unable to write config file", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    private static Function<String, String> createValueTransformer(Project project2) {
        WslPath path = WslPath.parseWindowsUncPath((String)project2.getBasePath());
        if (path == null) {
            return Function.identity();
        }
        return s -> {
            if (s == null) {
                return null;
            }
            WslPath wslPath = WslPath.parseWindowsUncPath((String)s);
            if (wslPath == null) {
                return s;
            }
            return wslPath.getLinuxPath();
        };
    }

    private static void addEarModelMapEntries(@NotNull MavenProject mavenProject2, @NotNull Map<String, String> modelMap) {
        if (mavenProject2 == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(2);
        }
        if (modelMap == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(3);
        }
        Element pluginConfiguration = mavenProject2.getPluginConfiguration("org.apache.maven.plugins", "maven-ear-plugin");
        String skinnyWars = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "skinnyWars", "false");
        modelMap.put("build.plugin.maven-ear-plugin.skinnyWars", skinnyWars);
    }

    @Nullable
    private static String getResourcesPluginGoalOutputDirectory(@NotNull MavenProject mavenProject2, @Nullable Element pluginConfiguration, @NotNull String goal) {
        Element goalConfiguration;
        String outputDirectory;
        if (mavenProject2 == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(4);
        }
        if (goal == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(5);
        }
        if ((outputDirectory = MavenJDOMUtil.findChildValueByPath(goalConfiguration = mavenProject2.getPluginGoalConfiguration("org.apache.maven.plugins", "maven-resources-plugin", goal), "outputDirectory", null)) == null) {
            outputDirectory = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "outputDirectory", null);
        }
        return outputDirectory == null || FileUtil.isAbsolute((String)outputDirectory) ? outputDirectory : mavenProject2.getDirectory() + "/" + outputDirectory;
    }

    private static void generateManifest(@NotNull MavenProject mavenProject2, @NotNull Module module, @NotNull MavenModuleResourceConfiguration resourceConfig) {
        if (mavenProject2 == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(6);
        }
        if (module == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(7);
        }
        if (resourceConfig == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(8);
        }
        if (mavenProject2.isAggregator()) {
            return;
        }
        if (Boolean.valueOf(IDEA_MAVEN_DISABLE_MANIFEST).booleanValue()) {
            resourceConfig.manifest = null;
            return;
        }
        try {
            MavenDomProjectModel domModel;
            int quoteIndex;
            String jdkVersion = null;
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk != null && (jdkVersion = sdk.getVersionString()) != null && (quoteIndex = jdkVersion.indexOf(34)) != -1) {
                jdkVersion = jdkVersion.substring(quoteIndex + 1, jdkVersion.length() - 1);
            }
            if ((domModel = MavenDomUtil.getMavenDomProjectModel(module.getProject(), mavenProject2.getFile())) != null) {
                UnsyncByteArrayOutputStream outputStream = new UnsyncByteArrayOutputStream();
                new ManifestBuilder(mavenProject2).withJdkVersion(jdkVersion).build().write((OutputStream)outputStream);
                String resolvedText = MavenPropertyResolver.resolve(outputStream.toString(), domModel);
                resourceConfig.manifest = Base64.getEncoder().encodeToString(resolvedText.getBytes(StandardCharsets.UTF_8));
            }
            resourceConfig.classpath = ManifestBuilder.getClasspath(mavenProject2);
        }
        catch (ManifestBuilder.ManifestBuilderException e) {
            LOG.warn("Unable to generate artifact manifest", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("Unable to save generated artifact manifest", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getFilteringProperties(MavenProject mavenProject2, MavenProjectsManager mavenProjectsManager) {
        String javaVersion;
        Properties properties = new Properties();
        for (String each : mavenProject2.getFilterPropertiesFiles()) {
            try (FileInputStream in = new FileInputStream(each);){
                properties.load(in);
            }
            catch (IOException iOException) {}
        }
        properties.putAll((Map<?, ?>)mavenProject2.getProperties());
        properties.setProperty("settings.localRepository", mavenProject2.getLocalRepository().getAbsolutePath());
        String jreDir = MavenUtil.getModuleJreHome(mavenProjectsManager, mavenProject2);
        if (jreDir != null) {
            properties.setProperty("java.home", jreDir);
        }
        if ((javaVersion = MavenUtil.getModuleJavaVersion(mavenProjectsManager, mavenProject2)) != null) {
            properties.setProperty("java.version", javaVersion);
        }
        return properties;
    }

    private static void addResources(Function<String, String> transformer, List<ResourceRootConfiguration> container, @NotNull Collection<MavenResource> resources) {
        if (resources == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(9);
        }
        for (MavenResource resource : resources) {
            String dir2 = resource.getDirectory();
            if (dir2 == null) continue;
            ResourceRootConfiguration props = new ResourceRootConfiguration();
            props.directory = transformer.apply(FileUtil.toSystemIndependentName((String)dir2));
            String target = transformer.apply(resource.getTargetPath());
            props.targetPath = target != null ? FileUtil.toSystemIndependentName((String)target) : null;
            props.isFiltered = resource.isFiltered();
            props.includes.clear();
            for (String include : resource.getIncludes()) {
                props.includes.add(include.trim());
            }
            props.excludes.clear();
            for (String exclude : resource.getExcludes()) {
                props.excludes.add(exclude.trim());
            }
            container.add(props);
        }
    }

    private static void addWebResources(Function<String, String> transformer, @NotNull Module module, MavenProjectConfiguration projectCfg, MavenProject mavenProject2) {
        Element warCfg;
        if (module == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(10);
        }
        if ((warCfg = mavenProject2.getPluginConfiguration("org.apache.maven.plugins", "maven-war-plugin")) == null) {
            return;
        }
        boolean filterWebXml = Boolean.parseBoolean(warCfg.getChildTextTrim("filteringDeploymentDescriptors"));
        Element webResources = warCfg.getChild("webResources");
        String webArtifactName = MavenUtil.getArtifactName("war", module, true);
        MavenWebArtifactConfiguration artifactResourceCfg = (MavenWebArtifactConfiguration)projectCfg.webArtifactConfigs.get(webArtifactName);
        if (artifactResourceCfg == null) {
            artifactResourceCfg = new MavenWebArtifactConfiguration();
            artifactResourceCfg.moduleName = module.getName();
            projectCfg.webArtifactConfigs.put(webArtifactName, artifactResourceCfg);
        } else {
            LOG.error("MavenWebArtifactConfiguration already exists.");
        }
        MavenResourceConfigurationGeneratorCompileTask.addSplitAndTrimmed(artifactResourceCfg.packagingIncludes, warCfg.getChildTextTrim("packagingIncludes"));
        MavenResourceConfigurationGeneratorCompileTask.addSplitAndTrimmed(artifactResourceCfg.packagingExcludes, warCfg.getChildTextTrim("packagingExcludes"));
        MavenResourceConfigurationGeneratorCompileTask.addConfigValues(artifactResourceCfg.nonFilteredFileExtensions, "nonFilteredFileExtensions", "nonFilteredFileExtension", warCfg);
        Object warSourceDirectory = warCfg.getChildTextTrim("warSourceDirectory");
        if (warSourceDirectory == null) {
            warSourceDirectory = "src/main/webapp";
        }
        if (!FileUtil.isAbsolute((String)warSourceDirectory)) {
            warSourceDirectory = mavenProject2.getDirectory() + "/" + (String)warSourceDirectory;
        }
        artifactResourceCfg.warSourceDirectory = transformer.apply(FileUtil.toSystemIndependentName((String)StringUtil.trimEnd((String)warSourceDirectory, (char)'/')));
        MavenResourceConfigurationGeneratorCompileTask.addSplitAndTrimmed(artifactResourceCfg.warSourceIncludes, warCfg.getChildTextTrim("warSourceIncludes"));
        MavenResourceConfigurationGeneratorCompileTask.addSplitAndTrimmed(artifactResourceCfg.warSourceExcludes, warCfg.getChildTextTrim("warSourceExcludes"));
        if (webResources != null) {
            for (Element resource : webResources.getChildren("resource")) {
                ResourceRootConfiguration r = new ResourceRootConfiguration();
                Object directory = resource.getChildTextTrim("directory");
                if (StringUtil.isEmptyOrSpaces((String)directory)) continue;
                if (!FileUtil.isAbsolute((String)directory)) {
                    directory = mavenProject2.getDirectory() + "/" + (String)directory;
                }
                r.directory = transformer.apply((String)directory);
                r.isFiltered = Boolean.parseBoolean(resource.getChildTextTrim("filtering"));
                r.targetPath = resource.getChildTextTrim("targetPath");
                MavenResourceConfigurationGeneratorCompileTask.addConfigValues(r.includes, "includes", "include", resource);
                MavenResourceConfigurationGeneratorCompileTask.addConfigValues(r.excludes, "excludes", "exclude", resource);
                artifactResourceCfg.webResources.add(r);
            }
        }
        if (filterWebXml) {
            ResourceRootConfiguration r = new ResourceRootConfiguration();
            r.directory = transformer.apply((String)warSourceDirectory);
            r.includes = Collections.singleton("WEB-INF/web.xml");
            r.isFiltered = true;
            r.targetPath = "";
            artifactResourceCfg.webResources.add(r);
        }
    }

    private static void addConfigValues(Collection<String> collection, String tag, String subTag, Element resource) {
        Element config = resource.getChild(tag);
        if (config != null) {
            for (Element value : config.getChildren(subTag)) {
                String text = value.getTextTrim();
                if (text.isEmpty()) continue;
                collection.add(text);
            }
            if (config.getChildren(subTag).isEmpty()) {
                MavenResourceConfigurationGeneratorCompileTask.addSplitAndTrimmed(collection, config.getTextTrim());
            }
        }
    }

    private static void addSplitAndTrimmed(Collection<String> collection, @Nullable String commaSeparatedList) {
        if (commaSeparatedList != null) {
            for (String s : StringUtil.split((String)commaSeparatedList, (String)",")) {
                collection.add(s.trim());
            }
        }
    }

    private static void addEjbClientArtifactConfiguration(Function<String, String> transformer, Module module, MavenProjectConfiguration projectCfg, MavenProject mavenProject2) {
        Element excludes;
        Element pluginCfg = mavenProject2.getPluginConfiguration("org.apache.maven.plugins", "maven-ejb-plugin");
        if (pluginCfg == null || !Boolean.parseBoolean(pluginCfg.getChildTextTrim("generateClient"))) {
            return;
        }
        MavenEjbClientConfiguration ejbClientCfg = new MavenEjbClientConfiguration();
        Element includes = pluginCfg.getChild("clientIncludes");
        if (includes != null) {
            for (Element include : includes.getChildren("clientInclude")) {
                String includeText = include.getTextTrim();
                if (includeText.isEmpty()) continue;
                ejbClientCfg.includes.add(includeText);
            }
        }
        if ((excludes = pluginCfg.getChild("clientExcludes")) != null) {
            for (Element exclude : excludes.getChildren("clientExclude")) {
                String excludeText = exclude.getTextTrim();
                if (excludeText.isEmpty()) continue;
                ejbClientCfg.excludes.add(excludeText);
            }
        }
        if (!ejbClientCfg.isEmpty()) {
            projectCfg.ejbClientArtifactConfigs.put(MavenUtil.getEjbClientArtifactName(module, true), ejbClientCfg);
        }
    }

    private static void addNonMavenResources(Function<String, String> transformer, @NotNull MavenProjectConfiguration projectCfg, @NotNull MavenProjectsManager mavenProjectsManager, @NotNull Project project2) {
        if (projectCfg == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(11);
        }
        if (mavenProjectsManager == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(12);
        }
        if (project2 == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(13);
        }
        HashSet<VirtualFile> processedRoots = new HashSet<VirtualFile>();
        for (MavenProject mavenProject2 : mavenProjectsManager.getProjects()) {
            for (String dir2 : ContainerUtil.concat(mavenProject2.getSources(), mavenProject2.getTestSources())) {
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(dir2);
                if (file == null) continue;
                processedRoots.add(file);
            }
            for (MavenResource resource : ContainerUtil.concat(mavenProject2.getResources(), mavenProject2.getTestResources())) {
                String directory = resource.getDirectory();
                if (directory == null) continue;
                ContainerUtil.addIfNotNull(processedRoots, (Object)LocalFileSystem.getInstance().findFileByPath(directory));
            }
        }
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)project2);
        for (Module module : ModuleManager.getInstance((Project)project2).getModules()) {
            if (!mavenProjectsManager.isMavenizedModule(module)) continue;
            for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                for (SourceFolder folder : contentEntry.getSourceFolders()) {
                    MavenModuleResourceConfiguration configuration;
                    VirtualFile file = folder.getFile();
                    if (file == null || compilerConfiguration.isExcludedFromCompilation(file) || MavenResourceConfigurationGeneratorCompileTask.isUnderRoots(processedRoots, file) || (configuration = (MavenModuleResourceConfiguration)projectCfg.moduleConfigurations.get(module.getName())) == null) continue;
                    List resourcesList = folder.isTestSource() ? configuration.testResources : configuration.resources;
                    ResourceRootConfiguration cfg = new ResourceRootConfiguration();
                    cfg.directory = transformer.apply(FileUtil.toSystemIndependentName((String)file.getPath()));
                    CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
                    if (compilerModuleExtension == null) continue;
                    String compilerOutputUrl = folder.isTestSource() ? compilerModuleExtension.getCompilerOutputUrlForTests() : compilerModuleExtension.getCompilerOutputUrl();
                    cfg.targetPath = transformer.apply(VfsUtilCore.urlToPath((String)compilerOutputUrl));
                    MavenResourceConfigurationGeneratorCompileTask.convertIdeaExcludesToMavenExcludes(cfg, (CompilerConfigurationImpl)compilerConfiguration);
                    resourcesList.add(cfg);
                }
            }
        }
    }

    private static void convertIdeaExcludesToMavenExcludes(ResourceRootConfiguration cfg, CompilerConfigurationImpl compilerConfiguration) {
        for (String pattern : compilerConfiguration.getResourceFilePatterns()) {
            Matcher matcher = SIMPLE_NEGATIVE_PATTERN.matcher(pattern);
            if (!matcher.matches()) continue;
            cfg.excludes.add("**/" + matcher.group(1));
        }
    }

    private static boolean isUnderRoots(Set<VirtualFile> roots, VirtualFile file) {
        for (VirtualFile f = file; f != null; f = f.getParent()) {
            if (!roots.contains(file)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goal";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceConfig";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectCfg";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProjectsManager";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/MavenResourceConfigurationGeneratorCompileTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "generateBuildConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addEarModelMapEntries";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getResourcesPluginGoalOutputDirectory";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "generateManifest";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addResources";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addWebResources";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "addNonMavenResources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

