/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.idea.maven.server.CannotStartServerException;
import org.jetbrains.idea.maven.server.DownloadArtifactEvent;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenPullDownloadListener;
import org.jetbrains.idea.maven.server.MavenPullServerLogger;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenRemoteProcessSupportFactory;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;
import org.jetbrains.idea.maven.server.ServerLogEvent;
import org.jetbrains.idea.maven.utils.MavenLog;

public class MavenServerConnectorImpl
extends MavenServerConnector {
    public static final Logger LOG = Logger.getInstance(MavenServerConnectorImpl.class);
    private final MavenServerDownloadDispatcher myDownloadListener;
    protected final Integer myDebugPort;
    private ScheduledFuture<?> myLoggerFuture;
    private ScheduledFuture<?> myDownloadListenerFuture;
    private final AtomicInteger myLoggerConnectFailedCount;
    private final AtomicInteger myDownloadConnectFailedCount;
    private final AtomicBoolean myConnectStarted;
    private MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport mySupport;
    private final AsyncPromise<@NotNull MavenServer> myServerPromise;

    public MavenServerConnectorImpl(@NotNull Project project2, @NotNull MavenServerManager manager, @NotNull Sdk jdk2, @NotNull String vmOptions, @Nullable Integer debugPort, @NotNull MavenDistribution mavenDistribution, @NotNull String multimoduleDirectory) {
        if (project2 == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(1);
        }
        if (jdk2 == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(2);
        }
        if (vmOptions == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(3);
        }
        if (mavenDistribution == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(4);
        }
        if (multimoduleDirectory == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(5);
        }
        super(project2, manager, jdk2, vmOptions, mavenDistribution, multimoduleDirectory);
        this.myDownloadListener = new MavenServerDownloadDispatcher();
        this.myLoggerConnectFailedCount = new AtomicInteger(0);
        this.myDownloadConnectFailedCount = new AtomicInteger(0);
        this.myConnectStarted = new AtomicBoolean(false);
        this.myServerPromise = new AsyncPromise<MavenServer>(){

            protected boolean shouldLogErrors() {
                return false;
            }
        };
        this.myDebugPort = debugPort;
    }

    @Override
    boolean isNew() {
        return !this.myConnectStarted.get();
    }

    @Override
    public boolean isCompatibleWith(Sdk jdk2, String vmOptions, MavenDistribution distribution) {
        if (!this.myDistribution.compatibleWith(distribution)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myJdk.getName(), (CharSequence)jdk2.getName())) {
            return false;
        }
        return StringUtil.equals((CharSequence)vmOptions, (CharSequence)this.myVmOptions);
    }

    @Override
    protected void connect() {
        if (!this.myConnectStarted.compareAndSet(false, true)) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)new StartServerTask());
    }

    @Override
    @NotNull
    protected MavenServer getServer() {
        MavenServer mavenServer;
        try {
            MavenServer server = this.waitForServer();
            if (server == null) {
                throw new ProcessCanceledException();
            }
            mavenServer = server;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            try {
                this.shutdown(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.myManager.cleanUp(this);
            throw e instanceof CannotStartServerException ? (CannotStartServerException)e : new CannotStartServerException(e);
        }
        if (mavenServer == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(6);
        }
        return mavenServer;
    }

    @Nullable
    private MavenServer waitForServer() {
        while (!this.myServerPromise.isDone()) {
            try {
                this.myServerPromise.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.myProject.isDisposed()) {
                throw new CannotStartServerException("Project already disposed");
            }
            ProgressManager.checkCanceled();
        }
        return (MavenServer)this.myServerPromise.get();
    }

    private void cleanUp() {
        int count;
        if (this.myLoggerFuture != null) {
            count = this.myLoggerConnectFailedCount.get();
            if (count != 0) {
                MavenLog.LOG.warn("Maven pulling logger was failed: " + count + " times");
            }
            this.myLoggerFuture.cancel(true);
            this.myLoggerFuture = null;
        }
        if (this.myDownloadListenerFuture != null) {
            count = this.myDownloadConnectFailedCount.get();
            if (count != 0) {
                MavenLog.LOG.warn("Maven pulling download listener was failed: " + count + " times");
            }
            this.myDownloadListenerFuture.cancel(true);
            this.myDownloadListenerFuture = null;
        }
    }

    @Override
    public void addDownloadListener(MavenServerDownloadListener listener2) {
        this.myDownloadListener.myListeners.add(listener2);
    }

    @Override
    public void removeDownloadListener(MavenServerDownloadListener listener2) {
        this.myDownloadListener.myListeners.remove(listener2);
    }

    @Override
    @ApiStatus.Internal
    public void shutdown(boolean wait) {
        MavenLog.LOG.debug("[connector] shutdown " + this + " " + (this.mySupport == null));
        super.shutdown(true);
        this.cleanUp();
        MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport support = this.mySupport;
        if (support != null) {
            support.stopAll(wait);
            this.mySupport = null;
        }
    }

    @Override
    protected <R, E extends Exception> R perform(RemoteObjectWrapper.Retriable<R, E> r) throws E {
        RemoteException last = null;
        for (int i = 0; i < 2; ++i) {
            try {
                return r.execute();
            }
            catch (RemoteException e) {
                last = e;
                continue;
            }
        }
        this.cleanUp();
        this.myManager.cleanUp(this);
        MavenLog.LOG.debug("[connector] perform error " + this);
        throw new RuntimeException("Cannot reconnect.", last);
    }

    @Override
    public String getSupportType() {
        MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport support = this.mySupport;
        return support == null ? "???" : support.type();
    }

    @Override
    public MavenServerConnector.State getState() {
        switch (this.myServerPromise.getState()) {
            case SUCCEEDED: {
                return this.mySupport == null ? MavenServerConnector.State.STOPPED : MavenServerConnector.State.RUNNING;
            }
            case REJECTED: {
                return MavenServerConnector.State.FAILED;
            }
        }
        return MavenServerConnector.State.STARTING;
    }

    @Override
    public boolean checkConnected() {
        MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport support = this.mySupport;
        return support != null && !support.getActiveConfigurations().isEmpty();
    }

    private void startPullingDownloadListener(MavenServer server) throws RemoteException {
        MavenPullDownloadListener listener2 = server.createPullDownloadListener(MavenRemoteObjectWrapper.ourToken);
        if (listener2 == null) {
            return;
        }
        this.myDownloadListenerFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
            block4: {
                try {
                    List artifactEvents = listener2.pull();
                    if (artifactEvents == null) {
                        return;
                    }
                    for (DownloadArtifactEvent e : artifactEvents) {
                        this.myDownloadListener.artifactDownloaded(new File(e.getFile()), e.getPath());
                    }
                    this.myDownloadConnectFailedCount.set(0);
                }
                catch (RemoteException e) {
                    if (Thread.currentThread().isInterrupted()) break block4;
                    this.myDownloadConnectFailedCount.incrementAndGet();
                }
            }
        }, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    private void startPullingLogger(MavenServer server) throws RemoteException {
        MavenPullServerLogger logger = server.createPullLogger(MavenRemoteObjectWrapper.ourToken);
        if (logger == null) {
            return;
        }
        this.myLoggerFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
            block9: {
                try {
                    List logEvents = logger.pull();
                    if (logEvents == null) {
                        return;
                    }
                    for (ServerLogEvent e : logEvents) {
                        switch (e.getType()) {
                            case PRINT: 
                            case INFO: {
                                MavenLog.LOG.info(e.getMessage());
                                break;
                            }
                            case WARN: {
                                MavenLog.LOG.warn(e.getMessage());
                                break;
                            }
                            case ERROR: {
                                MavenLog.LOG.error(e.getMessage());
                            }
                        }
                    }
                    this.myLoggerConnectFailedCount.set(0);
                }
                catch (RemoteException e) {
                    if (Thread.currentThread().isInterrupted()) break block9;
                    this.myLoggerConnectFailedCount.incrementAndGet();
                }
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmOptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenDistribution";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multimoduleDirectory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenServerConnectorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerConnectorImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class StartServerTask
    implements Runnable {
        private StartServerTask() {
        }

        @Override
        public void run() {
            EmptyProgressIndicator indicator = new EmptyProgressIndicator();
            String dirForLogs = (String)MavenServerConnectorImpl.this.myMultimoduleDirectories.iterator().next();
            MavenLog.LOG.debug("Connecting maven connector in " + dirForLogs);
            try {
                if (MavenServerConnectorImpl.this.myDebugPort != null) {
                    System.out.println("Listening for transport dt_socket at address: " + MavenServerConnectorImpl.this.myDebugPort);
                }
                MavenRemoteProcessSupportFactory factory = MavenRemoteProcessSupportFactory.forProject(MavenServerConnectorImpl.this.myProject);
                MavenServerConnectorImpl.this.mySupport = factory.create(MavenServerConnectorImpl.this.myJdk, MavenServerConnectorImpl.this.myVmOptions, MavenServerConnectorImpl.this.myDistribution, MavenServerConnectorImpl.this.myProject, MavenServerConnectorImpl.this.myDebugPort);
                MavenServerConnectorImpl.this.mySupport.onTerminate(e -> {
                    MavenLog.LOG.debug("[connector] terminate " + MavenServerConnectorImpl.this);
                    MavenServerConnectorImpl.this.shutdown(false);
                });
                MavenServer server = (MavenServer)MavenServerConnectorImpl.this.mySupport.acquire(this, "", (ProgressIndicator)indicator);
                MavenServerConnectorImpl.this.startPullingDownloadListener(server);
                MavenServerConnectorImpl.this.startPullingLogger(server);
                MavenServerConnectorImpl.this.myServerPromise.setResult((Object)server);
                MavenLog.LOG.debug("[connector] in " + dirForLogs + " has been connected " + MavenServerConnectorImpl.this);
            }
            catch (Throwable e2) {
                MavenLog.LOG.warn("[connector] cannot connect in " + dirForLogs, e2);
                MavenServerConnectorImpl.this.myServerPromise.setError(e2);
            }
        }
    }

    private static class MavenServerDownloadDispatcher
    implements MavenServerDownloadListener {
        private final List<MavenServerDownloadListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

        private MavenServerDownloadDispatcher() {
        }

        public void artifactDownloaded(File file, String relativePath) throws RemoteException {
            for (MavenServerDownloadListener each : this.myListeners) {
                each.artifactDownloaded(file, relativePath);
            }
        }
    }
}

