/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;

public class MavenProgressIndicator {
    private ProgressIndicator myIndicator;
    private final List<Condition<MavenProgressIndicator>> myCancelConditions = new ArrayList<Condition<MavenProgressIndicator>>();
    @Nullable
    private final Supplier<MavenSyncConsole> mySyncSupplier;
    @Nullable
    private final Project myProject;

    public MavenProgressIndicator(@Nullable Project project2, @Nullable Supplier<MavenSyncConsole> syncSupplier) {
        this(project2, (ProgressIndicator)new MyEmptyProgressIndicator(), syncSupplier);
    }

    public MavenProgressIndicator(@Nullable Project project2, ProgressIndicator i, @Nullable Supplier<MavenSyncConsole> syncSupplier) {
        this.myProject = project2;
        this.myIndicator = i;
        this.mySyncSupplier = syncSupplier;
        this.maybeTrackIndicator(i);
    }

    public synchronized void setIndicator(ProgressIndicator i) {
        this.maybeTrackIndicator(i);
        i.setText(this.myIndicator.getText());
        i.setText2(this.myIndicator.getText2());
        if (!i.isIndeterminate()) {
            i.setFraction(this.myIndicator.getFraction());
        }
        if (i.isCanceled()) {
            i.cancel();
        }
        this.myIndicator = i;
    }

    public synchronized ProgressIndicator getIndicator() {
        return this.myIndicator;
    }

    public synchronized void setText(@NlsContexts.ProgressText String text) {
        this.myIndicator.setText(text);
    }

    public synchronized void setText2(@NlsContexts.ProgressDetails String text) {
        this.myIndicator.setText2(text);
    }

    public synchronized void setFraction(double fraction) {
        this.myIndicator.setIndeterminate(false);
        this.myIndicator.setFraction(fraction);
    }

    public synchronized void setIndeterminate(boolean indeterminate) {
        this.myIndicator.setIndeterminate(indeterminate);
    }

    public synchronized void pushState() {
        this.myIndicator.pushState();
    }

    public synchronized void popState() {
        this.myIndicator.popState();
    }

    public synchronized void cancel() {
        this.myIndicator.cancel();
    }

    public synchronized void addCancelCondition(Condition<MavenProgressIndicator> condition) {
        this.myCancelConditions.add(condition);
    }

    public synchronized void removeCancelCondition(Condition<MavenProgressIndicator> condition) {
        this.myCancelConditions.remove(condition);
    }

    public synchronized boolean isCanceled() {
        if (this.myIndicator.isCanceled()) {
            return true;
        }
        for (Condition<MavenProgressIndicator> each : this.myCancelConditions) {
            if (!each.value((Object)this)) continue;
            return true;
        }
        return false;
    }

    public void checkCanceled() throws MavenProcessCanceledException {
        if (this.isCanceled()) {
            throw new MavenProcessCanceledException();
        }
    }

    public void startedDownload(MavenServerProgressIndicator.ResolveType type2, String id) {
        if (this.mySyncSupplier != null) {
            this.mySyncSupplier.get().getListener(type2).downloadStarted(id);
        }
    }

    public void completedDownload(MavenServerProgressIndicator.ResolveType type2, String id) {
        if (this.mySyncSupplier != null) {
            this.mySyncSupplier.get().getListener(type2).downloadCompleted(id);
        }
    }

    public void failedDownload(MavenServerProgressIndicator.ResolveType type2, String id, String message, String trace) {
        if (this.mySyncSupplier != null) {
            this.mySyncSupplier.get().getListener(type2).downloadFailed(id, message, trace);
        }
    }

    private void maybeTrackIndicator(final @Nullable ProgressIndicator indicator) {
        if (this.myProject == null) {
            return;
        }
        if (indicator instanceof ProgressIndicatorEx) {
            ((MavenProgressTracker)this.myProject.getService(MavenProgressTracker.class)).add(indicator);
            ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                public void start() {
                    ((MavenProgressTracker)MavenProgressIndicator.this.myProject.getService(MavenProgressTracker.class)).add(indicator);
                }

                public void stop() {
                    ((MavenProgressTracker)MavenProgressIndicator.this.myProject.getService(MavenProgressTracker.class)).remove(indicator);
                }

                public void cancel() {
                    ((MavenProgressTracker)MavenProgressIndicator.this.myProject.getService(MavenProgressTracker.class)).remove(indicator);
                }
            });
        }
    }

    @Service(value={Service.Level.PROJECT})
    @ApiStatus.Internal
    public static final class MavenProgressTracker
    implements Disposable {
        private final Object myLock = new Object();
        private final Set<ProgressIndicator> myIndicators = Collections.newSetFromMap(new IdentityHashMap());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForProgressCompletion() {
            while (this.hasMavenProgressRunning()) {
                Object lock;
                Object object = lock = new Object();
                synchronized (object) {
                    try {
                        lock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @TestOnly
        public void assertProgressTasksCompleted() {
            Object object = this.myLock;
            synchronized (object) {
                if (!this.myIndicators.isEmpty()) {
                    throw new AssertionError((Object)("Not finished tasks:\n" + StringUtil.join(this.myIndicators, ProgressIndicator::getText, (String)"\n-----")));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(@Nullable ProgressIndicator indicator) {
            Object object = this.myLock;
            synchronized (object) {
                this.myIndicators.add(indicator);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(@Nullable ProgressIndicator indicator) {
            Object object = this.myLock;
            synchronized (object) {
                this.myIndicators.remove(indicator);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean hasMavenProgressRunning() {
            Object object = this.myLock;
            synchronized (object) {
                this.myIndicators.removeIf(indicator -> !indicator.isRunning());
                return !this.myIndicators.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            Object object = this.myLock;
            synchronized (object) {
                this.myIndicators.clear();
            }
        }
    }

    private static class MyEmptyProgressIndicator
    extends EmptyProgressIndicator {
        private @NlsContexts.ProgressText String myText;
        private @NlsContexts.ProgressDetails String myText2;
        private double myFraction;

        private MyEmptyProgressIndicator() {
        }

        public void setText(String text) {
            this.myText = text;
        }

        public String getText() {
            return this.myText;
        }

        public void setText2(String text) {
            this.myText2 = text;
        }

        public String getText2() {
            return this.myText2;
        }

        public void setFraction(double fraction) {
            this.myFraction = fraction;
        }

        public double getFraction() {
            return this.myFraction;
        }
    }
}

