/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettingsKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettingsKt;
import org.jetbrains.kotlin.config.VersionView;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.PluginStartupApplicationService;
import org.jetbrains.kotlin.idea.compiler.configuration.ClearBuildStateExtension;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JsCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCommonCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerWorkspaceSettings;
import org.jetbrains.kotlin.idea.facet.DescriptionListCellRenderer;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.roots.RootUtilsKt;
import org.jetbrains.kotlin.idea.util.CidrUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.PlatformUtilKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformUtil;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformUtil;
import org.jetbrains.kotlin.platform.jvm.JdkPlatform;

public class KotlinCompilerConfigurableTab
implements SearchableConfigurable,
Disposable {
    private static final Map<String, @NlsSafe String> moduleKindDescriptions = new LinkedHashMap<String, String>();
    private static final Map<String, @NlsSafe String> sourceMapSourceEmbeddingDescriptions = new LinkedHashMap<String, String>();
    private static final List<LanguageFeature.State> languageFeatureStates = Arrays.asList(LanguageFeature.State.ENABLED, LanguageFeature.State.ENABLED_WITH_WARNING, LanguageFeature.State.ENABLED_WITH_ERROR);
    private static final int MAX_WARNING_SIZE = 75;
    @Nullable
    private final KotlinCompilerWorkspaceSettings compilerWorkspaceSettings;
    private final Project project;
    private final boolean isProjectSettings;
    private CommonCompilerArguments commonCompilerArguments;
    private K2JSCompilerArguments k2jsCompilerArguments;
    private K2JVMCompilerArguments k2jvmCompilerArguments;
    private CompilerSettings compilerSettings;
    private JPanel contentPane;
    private ThreeStateCheckBox reportWarningsCheckBox;
    private RawCommandLineEditor additionalArgsOptionsField;
    private JLabel additionalArgsLabel;
    private ThreeStateCheckBox generateSourceMapsCheckBox;
    private TextFieldWithBrowseButton outputPrefixFile;
    private TextFieldWithBrowseButton outputPostfixFile;
    private JLabel labelForOutputDirectory;
    private TextFieldWithBrowseButton outputDirectory;
    private ThreeStateCheckBox copyRuntimeFilesCheckBox;
    private ThreeStateCheckBox keepAliveCheckBox;
    private JCheckBox enableIncrementalCompilationForJvmCheckBox;
    private JCheckBox enableIncrementalCompilationForJsCheckBox;
    private JComboBox<String> moduleKindComboBox;
    private JTextField scriptTemplatesField;
    private JTextField scriptTemplatesClasspathField;
    public JLabel scriptTemplatesLabel;
    public JLabel scriptTemplatesClasspathLabel;
    private JPanel k2jvmPanel;
    private JPanel k2jsPanel;
    private JComboBox<String> jvmVersionComboBox;
    private JComboBox<VersionView> languageVersionComboBox;
    private JComboBox<VersionView> apiVersionComboBox;
    private JPanel scriptPanel;
    private JLabel labelForOutputPrefixFile;
    private JLabel labelForOutputPostfixFile;
    private JLabel warningLabel;
    private JTextField sourceMapPrefix;
    public JLabel labelForSourceMapPrefix;
    private JComboBox<String> sourceMapEmbedSources;
    private boolean isEnabled;

    public KotlinCompilerConfigurableTab(Project project2, @NotNull CommonCompilerArguments commonCompilerArguments, @NotNull K2JSCompilerArguments k2jsCompilerArguments, @NotNull K2JVMCompilerArguments k2jvmCompilerArguments, CompilerSettings compilerSettings, @Nullable KotlinCompilerWorkspaceSettings compilerWorkspaceSettings, boolean isProjectSettings, boolean isMultiEditor) {
        if (commonCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(0);
        }
        if (k2jsCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(1);
        }
        if (k2jvmCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(2);
        }
        this.isEnabled = true;
        this.project = project2;
        this.commonCompilerArguments = commonCompilerArguments;
        this.k2jsCompilerArguments = k2jsCompilerArguments;
        this.compilerSettings = compilerSettings;
        this.compilerWorkspaceSettings = compilerWorkspaceSettings;
        this.k2jvmCompilerArguments = k2jvmCompilerArguments;
        this.isProjectSettings = isProjectSettings;
        this.$$$setupUI$$$();
        this.warningLabel.setIcon(AllIcons.General.WarningDialog);
        if (isProjectSettings) {
            this.languageVersionComboBox.addActionListener(e -> this.onLanguageLevelChanged(this.getSelectedLanguageVersionView()));
        }
        this.additionalArgsOptionsField.attachLabel(this.additionalArgsLabel);
        this.fillLanguageAndAPIVersionList();
        if (CidrUtil.isRunningInCidrIde()) {
            this.keepAliveCheckBox.setVisible(false);
            this.k2jvmPanel.setVisible(false);
            this.k2jsPanel.setVisible(false);
        } else {
            this.initializeNonCidrSettings(isMultiEditor);
        }
        this.reportWarningsCheckBox.setThirdStateEnabled(isMultiEditor);
        if (isProjectSettings) {
            List modulesOverridingProjectSettings = ArraysKt.mapNotNull((Object[])ModuleManager.getInstance((Project)project2).getModules(), module2 -> {
                KotlinFacet facet = KotlinFacet.Companion.get((Module)module2);
                if (facet == null) {
                    return null;
                }
                KotlinFacetSettings facetSettings = ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings();
                if (facetSettings.getUseProjectSettings()) {
                    return null;
                }
                return module2.getName();
            });
            CollectionsKt.sort((List)modulesOverridingProjectSettings);
            if (!modulesOverridingProjectSettings.isEmpty()) {
                this.warningLabel.setVisible(true);
                this.warningLabel.setText(KotlinCompilerConfigurableTab.buildOverridingModulesWarning(modulesOverridingProjectSettings));
            }
        }
    }

    public KotlinCompilerConfigurableTab(Project project2) {
        this(project2, (CommonCompilerArguments)((CommonCompilerArguments)KotlinCommonCompilerArgumentsHolder.Companion.getInstance(project2).getSettings()).unfrozen(), (K2JSCompilerArguments)((K2JSCompilerArguments)Kotlin2JsCompilerArgumentsHolder.Companion.getInstance(project2).getSettings()).unfrozen(), (K2JVMCompilerArguments)((K2JVMCompilerArguments)Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance(project2).getSettings()).unfrozen(), (CompilerSettings)((CompilerSettings)KotlinCompilerSettings.Companion.getInstance(project2).getSettings()).unfrozen(), KotlinCompilerWorkspaceSettings.getInstance(project2), true, false);
    }

    private void initializeNonCidrSettings(boolean isMultiEditor) {
        KotlinCompilerConfigurableTab.setupFileChooser(this.labelForOutputPrefixFile, this.outputPrefixFile, KotlinBundle.message("configuration.title.kotlin.compiler.js.option.output.prefix.browse.title", new Object[0]), true);
        KotlinCompilerConfigurableTab.setupFileChooser(this.labelForOutputPostfixFile, this.outputPostfixFile, KotlinBundle.message("configuration.title.kotlin.compiler.js.option.output.postfix.browse.title", new Object[0]), true);
        KotlinCompilerConfigurableTab.setupFileChooser(this.labelForOutputDirectory, this.outputDirectory, KotlinBundle.message("configuration.title.choose.output.directory", new Object[0]), false);
        this.fillModuleKindList();
        this.fillSourceMapSourceEmbeddingList();
        this.fillJvmVersionList();
        this.generateSourceMapsCheckBox.setThirdStateEnabled(isMultiEditor);
        this.generateSourceMapsCheckBox.addActionListener(event -> this.sourceMapPrefix.setEnabled(this.generateSourceMapsCheckBox.isSelected()));
        this.copyRuntimeFilesCheckBox.setThirdStateEnabled(isMultiEditor);
        this.keepAliveCheckBox.setThirdStateEnabled(isMultiEditor);
        if (this.compilerWorkspaceSettings == null) {
            this.keepAliveCheckBox.setVisible(false);
            this.k2jvmPanel.setVisible(false);
            this.enableIncrementalCompilationForJsCheckBox.setVisible(false);
        }
        this.updateOutputDirEnabled();
    }

    public void dispose() {
    }

    private static int calculateNameCountToShowInWarning(List<String> allNames) {
        int lengthSoFar = 0;
        int size = allNames.size();
        for (int i2 = 0; i2 < size; ++i2) {
            lengthSoFar = (i2 > 0 ? lengthSoFar + 2 : 0) + allNames.get(i2).length();
            if (lengthSoFar <= 75) continue;
            return i2;
        }
        return size;
    }

    @NotNull
    @NlsSafe
    private static String buildOverridingModulesWarning(List<String> modulesOverridingProjectSettings) {
        int nameCountToShow = KotlinCompilerConfigurableTab.calculateNameCountToShowInWarning(modulesOverridingProjectSettings);
        int allNamesCount = modulesOverridingProjectSettings.size();
        if (nameCountToShow == 0) {
            String string = KotlinBundle.message("configuration.warning.text.modules.override.project.settings", String.valueOf(allNamesCount));
            if (string == null) {
                KotlinCompilerConfigurableTab.$$$reportNull$$$0(3);
            }
            return string;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        builder.append(KotlinBundle.message("configuration.warning.text.following.modules.override.project.settings", new Object[0])).append(" ");
        CollectionsKt.joinTo(modulesOverridingProjectSettings.subList(0, nameCountToShow), (Appendable)builder, (CharSequence)", ", (CharSequence)"", (CharSequence)"", (int)-1, (CharSequence)"", (Function1)new Function1<String, CharSequence>(){

            public CharSequence invoke(String s) {
                return "<strong>" + s + "</strong>";
            }
        });
        if (nameCountToShow < allNamesCount) {
            builder.append(" ").append(KotlinBundle.message("configuration.text.and", new Object[0])).append(" ").append(allNamesCount - nameCountToShow).append(" ").append(KotlinBundle.message("configuration.text.other.s", new Object[0]));
        }
        String string = builder.toString();
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String getModuleKindDescription(@Nullable String moduleKind) {
        if (moduleKind == null) {
            return "";
        }
        String result2 = moduleKindDescriptions.get(moduleKind);
        assert (result2 != null) : "Module kind " + moduleKind + " was not added to combobox, therefore it should not be here";
        String string = result2;
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String getSourceMapSourceEmbeddingDescription(@Nullable String sourceMapSourceEmbeddingId) {
        if (sourceMapSourceEmbeddingId == null) {
            return "";
        }
        String result2 = sourceMapSourceEmbeddingDescriptions.get(sourceMapSourceEmbeddingId);
        assert (result2 != null) : "Source map source embedding mode " + sourceMapSourceEmbeddingId + " was not added to combobox, therefore it should not be here";
        String string = result2;
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private static String getModuleKindOrDefault(@Nullable String moduleKindId) {
        if (moduleKindId == null) {
            moduleKindId = "plain";
        }
        String string = moduleKindId;
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private static String getSourceMapSourceEmbeddingOrDefault(@Nullable String sourceMapSourceEmbeddingId) {
        if (sourceMapSourceEmbeddingId == null) {
            sourceMapSourceEmbeddingId = "inlining";
        }
        String string = sourceMapSourceEmbeddingId;
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NlsSafe
    private static String getJvmVersionOrDefault(@Nullable String jvmVersion) {
        return jvmVersion != null ? jvmVersion : JvmTarget.DEFAULT.getDescription();
    }

    private static void setupFileChooser(@NotNull JLabel label2, @NotNull TextFieldWithBrowseButton fileChooser2, @NotNull @NlsContexts.DialogTitle String title, boolean forFiles) {
        if (label2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(9);
        }
        if (fileChooser2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(10);
        }
        if (title == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(11);
        }
        label2.setLabelFor((Component)fileChooser2);
        fileChooser2.addBrowseFolderListener(title, null, null, new FileChooserDescriptor(forFiles, !forFiles, false, false, false, false), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
    }

    private static boolean isModifiedWithNullize(@NotNull TextFieldWithBrowseButton chooser2, @Nullable String currentValue) {
        if (chooser2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(12);
        }
        return !StringUtil.equals((CharSequence)StringUtil.nullize((String)chooser2.getText(), (boolean)true), (CharSequence)StringUtil.nullize((String)currentValue, (boolean)true));
    }

    private static boolean isModified(@NotNull TextFieldWithBrowseButton chooser2, @NotNull String currentValue) {
        if (chooser2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(13);
        }
        if (currentValue == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(14);
        }
        return !StringUtil.equals((CharSequence)chooser2.getText(), (CharSequence)currentValue);
    }

    private void updateOutputDirEnabled() {
        if (this.isEnabled && this.copyRuntimeFilesCheckBox != null) {
            this.outputDirectory.setEnabled(this.copyRuntimeFilesCheckBox.isSelected());
            this.labelForOutputDirectory.setEnabled(this.copyRuntimeFilesCheckBox.isSelected());
        }
    }

    private static boolean isLessOrEqual(LanguageVersion version2, LanguageVersion upperBound) {
        return VersionComparatorUtil.compare((String)version2.getVersionString(), (String)upperBound.getVersionString()) <= 0;
    }

    public void onLanguageLevelChanged(@Nullable VersionView languageLevel) {
        if (languageLevel == null) {
            return;
        }
        this.restrictAPIVersions(languageLevel);
    }

    private void restrictAPIVersions(VersionView upperBoundView) {
        VersionView selectedAPIView = this.getSelectedAPIVersionView();
        LanguageVersion selectedAPIVersion = selectedAPIView.getVersion();
        LanguageVersion upperBound = upperBoundView.getVersion();
        ArrayList<VersionView.LatestStable> permittedAPIVersions = new ArrayList<VersionView.LatestStable>(LanguageVersion.values().length + 1);
        if (KotlinCompilerConfigurableTab.isLessOrEqual(VersionView.LatestStable.INSTANCE.getVersion(), upperBound)) {
            permittedAPIVersions.add(VersionView.LatestStable.INSTANCE);
        }
        ArraysKt.mapNotNullTo((Object[])LanguageVersion.values(), permittedAPIVersions, version2 -> KotlinCompilerConfigurableTab.isLessOrEqual(version2, upperBound) && !version2.isUnsupported() ? new VersionView.Specific(version2) : null);
        this.apiVersionComboBox.setModel((ComboBoxModel<VersionView>)new MutableCollectionComboBoxModel(permittedAPIVersions));
        this.apiVersionComboBox.setSelectedItem(VersionComparatorUtil.compare((String)selectedAPIVersion.getVersionString(), (String)upperBound.getVersionString()) <= 0 ? selectedAPIView : upperBoundView);
    }

    private void fillJvmVersionList() {
        for (TargetPlatform jvm : JvmIdePlatformKind.INSTANCE.getPlatforms()) {
            @NlsSafe String description2 = ((JdkPlatform)PlatformUtilKt.subplatformsOfType((TargetPlatform)jvm, JdkPlatform.class).get(0)).getTargetVersion().getDescription();
            this.jvmVersionComboBox.addItem(description2);
        }
    }

    private void fillLanguageAndAPIVersionList() {
        this.languageVersionComboBox.addItem((VersionView)VersionView.LatestStable.INSTANCE);
        this.apiVersionComboBox.addItem((VersionView)VersionView.LatestStable.INSTANCE);
        for (LanguageVersion version2 : LanguageVersion.values()) {
            if (version2.isUnsupported() || !LanguageVersionSettingsKt.isStableOrReadyForPreview((LanguageVersion)version2) && !ApplicationManager.getApplication().isInternal()) continue;
            VersionView.Specific specificVersion = new VersionView.Specific(version2);
            this.languageVersionComboBox.addItem((VersionView)specificVersion);
            this.apiVersionComboBox.addItem((VersionView)specificVersion);
        }
        this.languageVersionComboBox.setRenderer(new DescriptionListCellRenderer());
        this.apiVersionComboBox.setRenderer(new DescriptionListCellRenderer());
    }

    public void setTargetPlatform(@Nullable IdePlatformKind<?> targetPlatform) {
        this.k2jsPanel.setVisible(JsIdePlatformUtil.isJavaScript(targetPlatform));
        this.scriptPanel.setVisible(JvmIdePlatformUtil.isJvm(targetPlatform));
    }

    private void fillModuleKindList() {
        for (String moduleKind : moduleKindDescriptions.keySet()) {
            this.moduleKindComboBox.addItem(moduleKind);
        }
        this.moduleKindComboBox.setRenderer((ListCellRenderer<String>)SimpleListCellRenderer.create((String)"", o -> KotlinCompilerConfigurableTab.getModuleKindDescription(o)));
    }

    private void fillSourceMapSourceEmbeddingList() {
        for (String moduleKind : sourceMapSourceEmbeddingDescriptions.keySet()) {
            this.sourceMapEmbedSources.addItem(moduleKind);
        }
        this.sourceMapEmbedSources.setRenderer((ListCellRenderer<String>)SimpleListCellRenderer.create((String)"", o -> KotlinCompilerConfigurableTab.getSourceMapSourceEmbeddingDescription(o)));
    }

    @NotNull
    public String getId() {
        return "project.kotlinCompiler";
    }

    @Nullable
    public Runnable enableSearch(String option2) {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.contentPane;
    }

    public boolean isModified() {
        return this.isModified((JToggleButton)this.reportWarningsCheckBox, !this.commonCompilerArguments.getSuppressWarnings()) || !this.getSelectedLanguageVersionView().equals(KotlinFacetSettingsKt.getLanguageVersionView((CommonCompilerArguments)this.commonCompilerArguments)) || !this.getSelectedAPIVersionView().equals(KotlinFacetSettingsKt.getApiVersionView((CommonCompilerArguments)this.commonCompilerArguments)) || !this.additionalArgsOptionsField.getText().equals(this.compilerSettings.getAdditionalArguments()) || this.isModified(this.scriptTemplatesField, this.compilerSettings.getScriptTemplates()) || this.isModified(this.scriptTemplatesClasspathField, this.compilerSettings.getScriptTemplatesClasspath()) || this.isModified((JToggleButton)this.copyRuntimeFilesCheckBox, this.compilerSettings.getCopyJsLibraryFiles()) || KotlinCompilerConfigurableTab.isModified(this.outputDirectory, this.compilerSettings.getOutputDirectoryForJsLibraryFiles()) || this.compilerWorkspaceSettings != null && (this.isModified(this.enableIncrementalCompilationForJvmCheckBox, this.compilerWorkspaceSettings.getPreciseIncrementalEnabled()) || this.isModified(this.enableIncrementalCompilationForJsCheckBox, this.compilerWorkspaceSettings.getIncrementalCompilationForJsEnabled()) || this.isModified((JToggleButton)this.keepAliveCheckBox, this.compilerWorkspaceSettings.getEnableDaemon())) || this.isModified((JToggleButton)this.generateSourceMapsCheckBox, this.k2jsCompilerArguments.getSourceMap()) || KotlinCompilerConfigurableTab.isModifiedWithNullize(this.outputPrefixFile, this.k2jsCompilerArguments.getOutputPrefix()) || KotlinCompilerConfigurableTab.isModifiedWithNullize(this.outputPostfixFile, this.k2jsCompilerArguments.getOutputPostfix()) || !this.getSelectedModuleKind().equals(KotlinCompilerConfigurableTab.getModuleKindOrDefault(this.k2jsCompilerArguments.getModuleKind())) || this.isModified(this.sourceMapPrefix, StringUtil.notNullize((String)this.k2jsCompilerArguments.getSourceMapPrefix())) || !this.getSelectedSourceMapSourceEmbedding().equals(KotlinCompilerConfigurableTab.getSourceMapSourceEmbeddingOrDefault(this.k2jsCompilerArguments.getSourceMapEmbedSources())) || !this.getSelectedJvmVersion().equals(KotlinCompilerConfigurableTab.getJvmVersionOrDefault(this.k2jvmCompilerArguments.getJvmTarget()));
    }

    @NotNull
    private String getSelectedModuleKind() {
        return KotlinCompilerConfigurableTab.getModuleKindOrDefault((String)this.moduleKindComboBox.getSelectedItem());
    }

    private String getSelectedSourceMapSourceEmbedding() {
        return KotlinCompilerConfigurableTab.getSourceMapSourceEmbeddingOrDefault((String)this.sourceMapEmbedSources.getSelectedItem());
    }

    @NotNull
    private String getSelectedJvmVersion() {
        String string = KotlinCompilerConfigurableTab.getJvmVersionOrDefault((String)this.jvmVersionComboBox.getSelectedItem());
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public VersionView getSelectedLanguageVersionView() {
        Object item = this.languageVersionComboBox.getSelectedItem();
        Object object = item != null ? (VersionView)item : VersionView.LatestStable.INSTANCE;
        if (object == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(16);
        }
        return object;
    }

    @NotNull
    private VersionView getSelectedAPIVersionView() {
        Object item = this.apiVersionComboBox.getSelectedItem();
        Object object = item != null ? (VersionView)item : VersionView.LatestStable.INSTANCE;
        if (object == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(17);
        }
        return object;
    }

    public void applyTo(CommonCompilerArguments commonCompilerArguments, K2JVMCompilerArguments k2jvmCompilerArguments, K2JSCompilerArguments k2jsCompilerArguments, CompilerSettings compilerSettings) throws ConfigurationException {
        if (this.isProjectSettings) {
            boolean shouldInvalidateCaches;
            boolean bl = shouldInvalidateCaches = !this.getSelectedLanguageVersionView().equals(KotlinFacetSettingsKt.getLanguageVersionView((CommonCompilerArguments)commonCompilerArguments)) || !this.getSelectedAPIVersionView().equals(KotlinFacetSettingsKt.getApiVersionView((CommonCompilerArguments)commonCompilerArguments)) || !this.additionalArgsOptionsField.getText().equals(compilerSettings.getAdditionalArguments());
            if (shouldInvalidateCaches) {
                ApplicationUtilsKt.runWriteAction(new Function0<Object>(){

                    public Object invoke() {
                        RootUtilsKt.invalidateProjectRoots(KotlinCompilerConfigurableTab.this.project);
                        return null;
                    }
                });
            }
        }
        commonCompilerArguments.setSuppressWarnings(!this.reportWarningsCheckBox.isSelected());
        KotlinFacetSettingsKt.setLanguageVersionView((CommonCompilerArguments)commonCompilerArguments, (VersionView)this.getSelectedLanguageVersionView());
        KotlinFacetSettingsKt.setApiVersionView((CommonCompilerArguments)commonCompilerArguments, (VersionView)this.getSelectedAPIVersionView());
        compilerSettings.setAdditionalArguments(this.additionalArgsOptionsField.getText());
        compilerSettings.setScriptTemplates(this.scriptTemplatesField.getText());
        compilerSettings.setScriptTemplatesClasspath(this.scriptTemplatesClasspathField.getText());
        compilerSettings.setCopyJsLibraryFiles(this.copyRuntimeFilesCheckBox.isSelected());
        compilerSettings.setOutputDirectoryForJsLibraryFiles(this.outputDirectory.getText());
        if (this.compilerWorkspaceSettings != null) {
            this.compilerWorkspaceSettings.setPreciseIncrementalEnabled(this.enableIncrementalCompilationForJvmCheckBox.isSelected());
            this.compilerWorkspaceSettings.setIncrementalCompilationForJsEnabled(this.enableIncrementalCompilationForJsCheckBox.isSelected());
            boolean oldEnableDaemon = this.compilerWorkspaceSettings.getEnableDaemon();
            this.compilerWorkspaceSettings.setEnableDaemon(this.keepAliveCheckBox.isSelected());
            if (this.keepAliveCheckBox.isSelected() != oldEnableDaemon) {
                PluginStartupApplicationService.getInstance().resetAliveFlag();
            }
        }
        k2jsCompilerArguments.setSourceMap(this.generateSourceMapsCheckBox.isSelected());
        k2jsCompilerArguments.setOutputPrefix(StringUtil.nullize((String)this.outputPrefixFile.getText(), (boolean)true));
        k2jsCompilerArguments.setOutputPostfix(StringUtil.nullize((String)this.outputPostfixFile.getText(), (boolean)true));
        k2jsCompilerArguments.setModuleKind(this.getSelectedModuleKind());
        k2jsCompilerArguments.setSourceMapPrefix(this.sourceMapPrefix.getText());
        k2jsCompilerArguments.setSourceMapEmbedSources(this.generateSourceMapsCheckBox.isSelected() ? this.getSelectedSourceMapSourceEmbedding() : null);
        k2jvmCompilerArguments.setJvmTarget(this.getSelectedJvmVersion());
        if (this.isProjectSettings) {
            KotlinCommonCompilerArgumentsHolder.Companion.getInstance(this.project).setSettings(commonCompilerArguments);
            Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance(this.project).setSettings(k2jvmCompilerArguments);
            Kotlin2JsCompilerArgumentsHolder.Companion.getInstance(this.project).setSettings(k2jsCompilerArguments);
            KotlinCompilerSettings.Companion.getInstance(this.project).setSettings(compilerSettings);
        }
        for (ClearBuildStateExtension extension : ClearBuildStateExtension.getExtensions()) {
            extension.clearState(this.project);
        }
    }

    public void apply() throws ConfigurationException {
        this.applyTo(this.commonCompilerArguments, this.k2jvmCompilerArguments, this.k2jsCompilerArguments, this.compilerSettings);
    }

    public void reset() {
        this.reportWarningsCheckBox.setSelected(!this.commonCompilerArguments.getSuppressWarnings());
        KotlinCompilerConfigurableTab.setSelectedItem(this.languageVersionComboBox, KotlinFacetSettingsKt.getLanguageVersionView((CommonCompilerArguments)this.commonCompilerArguments));
        this.onLanguageLevelChanged((VersionView)this.languageVersionComboBox.getSelectedItem());
        KotlinCompilerConfigurableTab.setSelectedItem(this.apiVersionComboBox, KotlinFacetSettingsKt.getApiVersionView((CommonCompilerArguments)this.commonCompilerArguments));
        this.additionalArgsOptionsField.setText(this.compilerSettings.getAdditionalArguments());
        this.scriptTemplatesField.setText(this.compilerSettings.getScriptTemplates());
        this.scriptTemplatesClasspathField.setText(this.compilerSettings.getScriptTemplatesClasspath());
        this.copyRuntimeFilesCheckBox.setSelected(this.compilerSettings.getCopyJsLibraryFiles());
        this.outputDirectory.setText(this.compilerSettings.getOutputDirectoryForJsLibraryFiles());
        if (this.compilerWorkspaceSettings != null) {
            this.enableIncrementalCompilationForJvmCheckBox.setSelected(this.compilerWorkspaceSettings.getPreciseIncrementalEnabled());
            this.enableIncrementalCompilationForJsCheckBox.setSelected(this.compilerWorkspaceSettings.getIncrementalCompilationForJsEnabled());
            this.keepAliveCheckBox.setSelected(this.compilerWorkspaceSettings.getEnableDaemon());
        }
        this.generateSourceMapsCheckBox.setSelected(this.k2jsCompilerArguments.getSourceMap());
        this.outputPrefixFile.setText(this.k2jsCompilerArguments.getOutputPrefix());
        this.outputPostfixFile.setText(this.k2jsCompilerArguments.getOutputPostfix());
        this.moduleKindComboBox.setSelectedItem(KotlinCompilerConfigurableTab.getModuleKindOrDefault(this.k2jsCompilerArguments.getModuleKind()));
        this.sourceMapPrefix.setText(this.k2jsCompilerArguments.getSourceMapPrefix());
        this.sourceMapPrefix.setEnabled(this.k2jsCompilerArguments.getSourceMap());
        this.sourceMapEmbedSources.setSelectedItem(KotlinCompilerConfigurableTab.getSourceMapSourceEmbeddingOrDefault(this.k2jsCompilerArguments.getSourceMapEmbedSources()));
        this.jvmVersionComboBox.setSelectedItem(KotlinCompilerConfigurableTab.getJvmVersionOrDefault(this.k2jvmCompilerArguments.getJvmTarget()));
    }

    private static void setSelectedItem(JComboBox<VersionView> comboBox, VersionView versionView) {
        int index2 = ((MutableCollectionComboBoxModel)comboBox.getModel()).getElementIndex((Object)versionView);
        if (index2 == -1) {
            comboBox.addItem(versionView);
        }
        comboBox.setSelectedItem(versionView);
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    @Nls
    public String getDisplayName() {
        return KotlinBundle.message("configuration.name.kotlin.compiler", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.compiler.kotlin";
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public ThreeStateCheckBox getReportWarningsCheckBox() {
        return this.reportWarningsCheckBox;
    }

    public RawCommandLineEditor getAdditionalArgsOptionsField() {
        return this.additionalArgsOptionsField;
    }

    public ThreeStateCheckBox getGenerateSourceMapsCheckBox() {
        return this.generateSourceMapsCheckBox;
    }

    public TextFieldWithBrowseButton getOutputPrefixFile() {
        return this.outputPrefixFile;
    }

    public TextFieldWithBrowseButton getOutputPostfixFile() {
        return this.outputPostfixFile;
    }

    public TextFieldWithBrowseButton getOutputDirectory() {
        return this.outputDirectory;
    }

    public ThreeStateCheckBox getCopyRuntimeFilesCheckBox() {
        return this.copyRuntimeFilesCheckBox;
    }

    public ThreeStateCheckBox getKeepAliveCheckBox() {
        return this.keepAliveCheckBox;
    }

    public JComboBox<String> getModuleKindComboBox() {
        return this.moduleKindComboBox;
    }

    public JTextField getScriptTemplatesField() {
        return this.scriptTemplatesField;
    }

    public JTextField getScriptTemplatesClasspathField() {
        return this.scriptTemplatesClasspathField;
    }

    public JComboBox<VersionView> getLanguageVersionComboBox() {
        return this.languageVersionComboBox;
    }

    public JComboBox<VersionView> getApiVersionComboBox() {
        return this.apiVersionComboBox;
    }

    public void setEnabled(boolean value2) {
        this.isEnabled = value2;
        UIUtil.setEnabled((Component)this.getContentPane(), (boolean)value2, (boolean)true);
    }

    public CommonCompilerArguments getCommonCompilerArguments() {
        return this.commonCompilerArguments;
    }

    public void setCommonCompilerArguments(CommonCompilerArguments commonCompilerArguments) {
        this.commonCompilerArguments = commonCompilerArguments;
    }

    public K2JSCompilerArguments getK2jsCompilerArguments() {
        return this.k2jsCompilerArguments;
    }

    public void setK2jsCompilerArguments(K2JSCompilerArguments k2jsCompilerArguments) {
        this.k2jsCompilerArguments = k2jsCompilerArguments;
    }

    public K2JVMCompilerArguments getK2jvmCompilerArguments() {
        return this.k2jvmCompilerArguments;
    }

    public void setK2jvmCompilerArguments(K2JVMCompilerArguments k2jvmCompilerArguments) {
        this.k2jvmCompilerArguments = k2jvmCompilerArguments;
    }

    public CompilerSettings getCompilerSettings() {
        return this.compilerSettings;
    }

    public void setCompilerSettings(CompilerSettings compilerSettings) {
        this.compilerSettings = compilerSettings;
    }

    private void createUIComponents() {
        this.languageVersionComboBox = new ComboBox((ComboBoxModel)new MutableCollectionComboBoxModel());
        this.apiVersionComboBox = new ComboBox((ComboBoxModel)new MutableCollectionComboBoxModel());
        this.createVersionValidator(this.languageVersionComboBox, "configuration.warning.text.language.version.unsupported");
        this.createVersionValidator(this.apiVersionComboBox, "configuration.warning.text.api.version.unsupported");
        this.copyRuntimeFilesCheckBox = new ThreeStateCheckBox(){

            public void setState(ThreeStateCheckBox.State state2) {
                super.setState(state2);
                KotlinCompilerConfigurableTab.this.updateOutputDirEnabled();
            }
        };
    }

    private void createVersionValidator(JComboBox<VersionView> component2, String messageKey) {
        new ComponentValidator((Disposable)this).withValidator(() -> {
            VersionView selectedItem = (VersionView)component2.getSelectedItem();
            if (selectedItem == null) {
                return null;
            }
            LanguageVersion version2 = selectedItem.getVersion();
            if (version2.isUnsupported()) {
                return new ValidationInfo(KotlinBundle.message(messageKey, version2.getVersionString()), (JComponent)component2);
            }
            return null;
        }).installOn(component2);
        component2.addActionListener(e -> ComponentValidator.getInstance((JComponent)component2).ifPresent(ComponentValidator::revalidate));
    }

    static {
        moduleKindDescriptions.put("plain", KotlinBundle.message("configuration.description.plain.put.to.global.scope", new Object[0]));
        moduleKindDescriptions.put("amd", KotlinBundle.message("configuration.description.amd", new Object[0]));
        moduleKindDescriptions.put("commonjs", KotlinBundle.message("configuration.description.commonjs", new Object[0]));
        moduleKindDescriptions.put("umd", KotlinBundle.message("configuration.description.umd.detect.amd.or.commonjs.if.available.fallback.to.plain", new Object[0]));
        sourceMapSourceEmbeddingDescriptions.put("never", KotlinBundle.message("configuration.description.never", new Object[0]));
        sourceMapSourceEmbeddingDescriptions.put("always", KotlinBundle.message("configuration.description.always", new Object[0]));
        sourceMapSourceEmbeddingDescriptions.put("inlining", KotlinBundle.message("configuration.description.when.inlining.a.function.from.other.module.with.embedded.sources", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonCompilerArguments";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k2jsCompilerArguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k2jvmCompilerArguments";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooser";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooser";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildOverridingModulesWarning";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleKindDescription";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceMapSourceEmbeddingDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleKindOrDefault";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceMapSourceEmbeddingOrDefault";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedJvmVersion";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLanguageVersionView";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedAPIVersionView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setupFileChooser";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isModifiedWithNullize";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ThreeStateCheckBox threeStateCheckBox;
        RawCommandLineEditor rawCommandLineEditor;
        JLabel jLabel;
        ThreeStateCheckBox threeStateCheckBox2;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JLabel jLabel2;
        JLabel jLabel3;
        JTextField jTextField;
        JLabel jLabel4;
        JTextField jTextField2;
        JPanel jPanel3;
        JCheckBox jCheckBox2;
        JTextField jTextField3;
        JLabel jLabel5;
        ThreeStateCheckBox threeStateCheckBox3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel6;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel7;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JLabel jLabel8;
        JPanel jPanel4;
        JPanel jPanel5;
        this.createUIComponents();
        this.contentPane = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(12, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), null, 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(11, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.k2jsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel4).setVisible(true);
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel4, new GridConstraints(8, 0, 1, 2, 1, 1, 3, 3, null, null, null, 0, true));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.compiler.js.option.panel.title"), (int)0, (int)0, null, null));
        this.labelForOutputPrefixFile = jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.compiler.js.option.output.prefix"));
        jPanel4.add((Component)jLabel8, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.outputPrefixFile = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton3, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.labelForOutputPostfixFile = jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.compiler.js.option.output.postfix"));
        jPanel4.add((Component)jLabel7, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.outputPostfixFile = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton2, new GridConstraints(5, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.labelForOutputDirectory = jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("destination.directory"));
        jPanel4.add((Component)jLabel6, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.outputDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText(DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.compiler.lib"));
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(7, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        ThreeStateCheckBox threeStateCheckBox4 = this.copyRuntimeFilesCheckBox;
        threeStateCheckBox4.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox4, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.compiler.js.option.output.copy.files"));
        jPanel4.add((Component)threeStateCheckBox4, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("module.kind"));
        jPanel4.add((Component)jLabel9, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.moduleKindComboBox = jComboBox;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel4.add(jComboBox, new GridConstraints(8, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.generateSourceMapsCheckBox = threeStateCheckBox3 = new ThreeStateCheckBox();
        threeStateCheckBox3.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox3, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.compiler.js.option.generate.sourcemaps"));
        jPanel4.add((Component)threeStateCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.labelForSourceMapPrefix = jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("add.prefix.to.paths.in.source.map"));
        jPanel4.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.sourceMapPrefix = jTextField3 = new JTextField();
        jPanel4.add((Component)jTextField3, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("embed.source.code.into.source.map"));
        jPanel4.add((Component)jLabel10, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.sourceMapEmbedSources = jComboBox2;
        jPanel4.add(jComboBox2, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.enableIncrementalCompilationForJsCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("enable.incremental.compilation"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.scriptPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setVisible(true);
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel3, new GridConstraints(9, 0, 1, 2, 1, 1, 3, 3, null, null, null, 0, true));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("action.new.script.name"), (int)0, (int)0, null, null));
        this.scriptTemplatesField = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.scriptTemplatesClasspathLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("script.templates.classpath"));
        jPanel3.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.scriptTemplatesClasspathField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.scriptTemplatesLabel = jLabel3 = new JLabel();
        ((Component)jLabel3).setEnabled(true);
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("script.template.classes"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.warningLabel = jLabel2 = new JLabel();
        jLabel2.setFocusable(false);
        jLabel2.setInheritsPopupMenu(false);
        jLabel2.setText("");
        ((Component)jLabel2).setVisible(false);
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.k2jvmPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setVisible(true);
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel2, new GridConstraints(7, 0, 1, 2, 1, 1, 3, 3, null, null, null, 0, true));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.compiler.jvm.option.panel.title"), (int)0, (int)0, null, null));
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("target.jvm.version"));
        jPanel2.add((Component)jLabel11, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.enableIncrementalCompilationForJvmCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("enable.incremental.compilation"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JComboBox jComboBox3 = new JComboBox();
        this.jvmVersionComboBox = jComboBox3;
        jPanel2.add(jComboBox3, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.reportWarningsCheckBox = threeStateCheckBox2 = new ThreeStateCheckBox();
        threeStateCheckBox2.setSelected(false);
        threeStateCheckBox2.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox2, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.compiler.option.generate.no.warnings"));
        jPanel7.add((Component)threeStateCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel8, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel12 = new JLabel();
        this.$$$loadLabelText$$$(jLabel12, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("language.version"));
        jPanel8.add((Component)jLabel12, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox<VersionView> jComboBox4 = this.languageVersionComboBox;
        jPanel8.add(jComboBox4, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel9, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel13 = new JLabel();
        this.$$$loadLabelText$$$(jLabel13, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("api.version"));
        jPanel9.add((Component)jLabel13, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox<VersionView> jComboBox5 = this.apiVersionComboBox;
        jPanel9.add(jComboBox5, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.additionalArgsLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.compiler.option.additional.command.line.parameters"));
        jPanel5.add((Component)jLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.additionalArgsOptionsField = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption(ResourceBundle.getBundle("messages/KotlinBundle").getString("additional.command.line.parameters"));
        jPanel5.add((Component)rawCommandLineEditor, new GridConstraints(5, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.keepAliveCheckBox = threeStateCheckBox = new ThreeStateCheckBox();
        threeStateCheckBox.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCompilerConfigurableTab.class).getString("keep.compiler.process.alive.between.invocations"));
        jPanel5.add((Component)threeStateCheckBox, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel9.setLabelFor(jComboBox);
        jLabel5.setLabelFor(jTextField3);
        jLabel4.setLabelFor(jTextField);
        jLabel3.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

