/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt$WhenMappings;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManager;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.KotlinJavaModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.LibraryKindSearchScope;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMap;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMapKt;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.ProjectUtilsKt;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.core.util.RuntimeLibraryUtilsKt;
import org.jetbrains.kotlin.idea.extensions.gradle.RepositoryDescription;
import org.jetbrains.kotlin.idea.framework.JSLibraryKind;
import org.jetbrains.kotlin.idea.quickfix.KotlinAddRequiredModuleFix;
import org.jetbrains.kotlin.idea.util.DumbUtilsKt;
import org.jetbrains.kotlin.idea.util.Java9StructureUtilKt;
import org.jetbrains.kotlin.idea.util.VersioningKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.SuppressNotificationState;
import org.jetbrains.kotlin.idea.vfilefinder.IDEVirtualFileFinder;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000x\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0011\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\u0010\u0017\u001a\u000e\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0005\u001a\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110 2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0016\u001a\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110 2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0016\u001a\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020$0 2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020$0 2\u0006\u0010\u001d\u001a\u00020\u001e\u001a6\u0010&\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u001c0'2\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\b\u0002\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110\u001c\u001a\u0010\u0010)\u001a\u0004\u0018\u00010\u00162\u0006\u0010*\u001a\u00020\u0005\u001a\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00110\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007\u001a\u0010\u0010,\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0019\u001a\u00020\u0005\u001a\u000e\u0010-\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u000200\u001a\u000e\u00101\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u00102\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u00020$\u001a\u000e\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u00020$\u001a\u000e\u00107\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\u0005\u001a\u000e\u00109\u001a\u00020:2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010;\u001a\u00020\u000f*\u00020\u00162\u0006\u00104\u001a\u00020$H\u0002\u001a\u0012\u0010<\u001a\u00020\u0005*\u00020=2\u0006\u0010>\u001a\u00020\u000f\u001a\n\u0010?\u001a\u00020\u0005*\u00020\u0001\u001a\n\u0010@\u001a\u00020\u0005*\u00020\u0001\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\f\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0003\u00a8\u0006A"}, d2={"DEFAULT_GRADLE_PLUGIN_REPOSITORY", "Lorg/jetbrains/kotlin/idea/extensions/gradle/RepositoryDescription;", "getDEFAULT_GRADLE_PLUGIN_REPOSITORY", "()Lorg/jetbrains/kotlin/idea/extensions/gradle/RepositoryDescription;", "JCENTER", "", "KOTLIN_GROUP_ID", "LAST_SNAPSHOT_VERSION", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MAVEN_CENTRAL", "SNAPSHOT_REPOSITORY", "getSNAPSHOT_REPOSITORY", "addStdlibToJavaModuleInfo", "", "module", "Lcom/intellij/openapi/module/Module;", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "allConfigurators", "", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "()[Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "devRepository", "version", "findApplicableConfigurator", "getAbleToRunConfigurators", "", "project", "Lcom/intellij/openapi/project/Project;", "getCanBeConfiguredModules", "", "configurator", "getCanBeConfiguredModulesWithKotlinFiles", "getConfigurableModules", "Lorg/jetbrains/kotlin/idea/configuration/ModuleSourceRootGroup;", "getConfigurableModulesWithKotlinFiles", "getConfigurationPossibilitiesForConfigureNotification", "Lkotlin/Pair;", "excludeModules", "getConfiguratorByName", "name", "getModulesWithKotlinFiles", "getRepositoryForVersion", "hasAnyKotlinRuntimeInScope", "hasKotlinCommonRuntimeInScope", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "hasKotlinJsRuntimeInScope", "hasKotlinJvmRuntimeInScope", "isModuleConfigured", "moduleSourceRootGroup", "isNotConfiguredNotificationRequired", "moduleGroup", "isRepositoryConfigured", "repositoriesBlockText", "showConfigureKotlinNotificationIfNeeded", "", "canConfigure", "toGradleCompileScope", "Lcom/intellij/openapi/roots/DependencyScope;", "isAndroidModule", "toGroovyRepositorySnippet", "toKotlinRepositorySnippet", "kotlin.jvm"})
public final class ConfigureKotlinInProjectUtilsKt {
    private static final Logger LOG;
    @NotNull
    public static final String LAST_SNAPSHOT_VERSION = "1.5.255-SNAPSHOT";
    @NotNull
    private static final RepositoryDescription SNAPSHOT_REPOSITORY;
    @NotNull
    private static final RepositoryDescription DEFAULT_GRADLE_PLUGIN_REPOSITORY;
    @NotNull
    public static final String MAVEN_CENTRAL = "mavenCentral()";
    @NotNull
    public static final String JCENTER = "jcenter()";
    @NotNull
    public static final String KOTLIN_GROUP_ID = "org.jetbrains.kotlin";

    @NotNull
    public static final RepositoryDescription getSNAPSHOT_REPOSITORY() {
        return SNAPSHOT_REPOSITORY;
    }

    @NotNull
    public static final RepositoryDescription getDEFAULT_GRADLE_PLUGIN_REPOSITORY() {
        return DEFAULT_GRADLE_PLUGIN_REPOSITORY;
    }

    @NotNull
    public static final RepositoryDescription devRepository(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return new RepositoryDescription("teamcity.kotlin.dev", "Teamcity Repository of Kotlin Development Builds", "https://teamcity.jetbrains.com/guestAuth/app/rest/builds/buildType:(id:Kotlin_KotlinPublic_Compiler),number:" + version2 + ",branch:(default:any)/artifacts/content/maven", null, false);
    }

    public static final boolean isRepositoryConfigured(@NotNull String repositoriesBlockText) {
        Intrinsics.checkNotNullParameter((Object)repositoriesBlockText, (String)"repositoriesBlockText");
        return StringsKt.contains$default((CharSequence)repositoriesBlockText, (CharSequence)MAVEN_CENTRAL, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)repositoriesBlockText, (CharSequence)JCENTER, (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String toGradleCompileScope(@NotNull DependencyScope $this$toGradleCompileScope, boolean isAndroidModule) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toGradleCompileScope, (String)"$this$toGradleCompileScope");
        switch (ConfigureKotlinInProjectUtilsKt$WhenMappings.$EnumSwitchMapping$0[$this$toGradleCompileScope.ordinal()]) {
            case 1: {
                string = "implementation";
                break;
            }
            case 2: {
                if (isAndroidModule) {
                    string = "implementation";
                    break;
                }
                string = "testImplementation";
                break;
            }
            case 3: {
                string = "runtime";
                break;
            }
            case 4: {
                string = "implementation";
                break;
            }
            default: {
                string = "implementation";
            }
        }
        return string;
    }

    @NotNull
    public static final String toGroovyRepositorySnippet(@NotNull RepositoryDescription $this$toGroovyRepositorySnippet) {
        Intrinsics.checkNotNullParameter((Object)$this$toGroovyRepositorySnippet, (String)"$this$toGroovyRepositorySnippet");
        return "maven { url '" + $this$toGroovyRepositorySnippet.getUrl() + "' }";
    }

    @NotNull
    public static final String toKotlinRepositorySnippet(@NotNull RepositoryDescription $this$toKotlinRepositorySnippet) {
        Intrinsics.checkNotNullParameter((Object)$this$toKotlinRepositorySnippet, (String)"$this$toKotlinRepositorySnippet");
        return "maven(\"" + $this$toKotlinRepositorySnippet.getUrl() + "\")";
    }

    @Nullable
    public static final RepositoryDescription getRepositoryForVersion(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return VersioningKt.isSnapshot(version2) ? SNAPSHOT_REPOSITORY : (VersioningKt.isDev(version2) ? ConfigureKotlinInProjectUtilsKt.devRepository(version2) : null);
    }

    public static final boolean isModuleConfigured(@NotNull ModuleSourceRootGroup moduleSourceRootGroup) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)moduleSourceRootGroup, (String)"moduleSourceRootGroup");
            KotlinProjectConfigurator[] $this$any$iv = ConfigureKotlinInProjectUtilsKt.allConfigurators();
            boolean $i$f$any = false;
            KotlinProjectConfigurator[] kotlinProjectConfiguratorArray = $this$any$iv;
            int n = kotlinProjectConfiguratorArray.length;
            for (int j = 0; j < n; ++j) {
                KotlinProjectConfigurator element$iv;
                KotlinProjectConfigurator it = element$iv = kotlinProjectConfiguratorArray[j];
                boolean bl2 = false;
                if (!(it.getStatus(moduleSourceRootGroup) == ConfigureKotlinStatus.CONFIGURED)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @NotNull
    public static final Collection<Module> getModulesWithKotlinFiles(@NotNull Project project2) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        boolean $i$f$isUnitTestMode = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) {
            boolean $i$f$isDispatchThread = false;
            Application application2 = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
            if (application2.isDispatchThread()) {
                LOG.error("getModulesWithKotlinFiles could be a heavy operation and should not be call on AWT thread");
            }
        }
        Disposable disposable2 = KotlinPluginDisposable.Companion.getInstance(project2);
        Collection kotlinFiles2 = (Collection)ReadAction.nonBlocking((Callable)new Callable(project2){
            final /* synthetic */ Project $project;

            public final Collection<VirtualFile> call() {
                return FileTypeIndex.getFiles((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.$project));
            }
            {
                this.$project = project2;
            }
        }).inSmartMode(project2).expireWith(disposable2).executeSynchronously();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        Collection collection = kotlinFiles2;
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"kotlinFiles");
        Iterable iterable = collection;
        boolean bl = false;
        Collection collection2 = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            Module module2;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl2 = false;
            VirtualFile ktFile = (VirtualFile)element$iv;
            boolean bl3 = false;
            if ((Module)DumbUtilsKt.runReadActionInSmartMode(project2, (Function0)new Function0<Module>(ktFile, project2, projectFileIndex2){
                final /* synthetic */ VirtualFile $ktFile;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ ProjectFileIndex $projectFileIndex$inlined;
                {
                    this.$ktFile = virtualFile2;
                    this.$project$inlined = project2;
                    this.$projectFileIndex$inlined = projectFileIndex;
                    super(0);
                }

                @Nullable
                public final Module invoke() {
                    return this.$projectFileIndex$inlined.isInSourceContent(this.$ktFile) ? this.$projectFileIndex$inlined.getModuleForFile(this.$ktFile) : null;
                }
            }) == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            Module it$iv = module2;
            boolean bl6 = false;
            destination$iv.add(it$iv);
        }
        Set modules2 = (Set)destination$iv;
        return modules2;
    }

    @NotNull
    public static final List<ModuleSourceRootGroup> getConfigurableModulesWithKotlinFiles(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Collection<Module> modules2 = ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(project2);
        if (modules2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return new ModuleSourceRootMap(project2).groupByBaseModules(modules2);
    }

    public static final void showConfigureKotlinNotificationIfNeeded(@NotNull Module module2) {
        DumbService dumbService;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Function0 action2 = (Function0)new Function0<Unit>(module2){
            final /* synthetic */ Module $module;

            public final void invoke() {
                ModuleSourceRootGroup moduleGroup = ModuleSourceRootMapKt.toModuleGroup(this.$module);
                if (ConfigureKotlinInProjectUtilsKt.isNotConfiguredNotificationRequired(moduleGroup)) {
                    Project project2 = this.$module.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
                    ConfigureKotlinNotificationManager.notify$default(ConfigureKotlinNotificationManager.INSTANCE, project2, null, 2, null);
                }
            }
            {
                this.$module = module2;
                super(0);
            }
        };
        DumbService dumbService2 = dumbService = DumbService.getInstance((Project)module2.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)dumbService2, (String)"dumbService");
        if (dumbService2.isDumb()) {
            dumbService.smartInvokeLater(new Runnable(action2){
                final /* synthetic */ Function0 $action;

                public final void run() {
                    this.$action.invoke();
                }
                {
                    this.$action = function0;
                }
            });
        } else {
            action2.invoke();
        }
    }

    public static final boolean isNotConfiguredNotificationRequired(@NotNull ModuleSourceRootGroup moduleGroup) {
        Intrinsics.checkNotNullParameter((Object)moduleGroup, (String)"moduleGroup");
        return !SuppressNotificationState.Companion.isKotlinNotConfiguredSuppressed(moduleGroup) && !ConfigureKotlinInProjectUtilsKt.isModuleConfigured(moduleGroup);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<KotlinProjectConfigurator> getAbleToRunConfigurators(@NotNull Project project2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        List<ModuleSourceRootGroup> modules2 = ConfigureKotlinInProjectUtilsKt.getConfigurableModules(project2);
        KotlinProjectConfigurator[] $this$filter$iv = ConfigureKotlinInProjectUtilsKt.allConfigurators();
        boolean $i$f$filter = false;
        KotlinProjectConfigurator[] kotlinProjectConfiguratorArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var7_7 = $this$filterTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int j = 0; j < n; ++j) {
            boolean bl;
            void element$iv$iv;
            block4: {
                void configurator = element$iv$iv = var7_7[j];
                boolean bl2 = false;
                Iterable $this$any$iv = modules2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ModuleSourceRootGroup it = (ModuleSourceRootGroup)element$iv;
                        boolean bl3 = false;
                        if (!(configurator.getStatus(it) == ConfigureKotlinStatus.CAN_BE_CONFIGURED)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ModuleSourceRootGroup> getConfigurableModules(@NotNull Project project2) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Collection $this$ifEmpty$iv = ConfigureKotlinInProjectUtilsKt.getConfigurableModulesWithKotlinFiles(project2);
        boolean $i$f$ifEmpty = false;
        if ($this$ifEmpty$iv.isEmpty()) {
            boolean bl = false;
            collection = new ModuleSourceRootMap(project2).groupByBaseModules((Collection<? extends Module>)ProjectStructureUtilKt.allModules(project2));
        } else {
            void var1_1;
            collection = var1_1;
        }
        return (List)collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<KotlinProjectConfigurator> getAbleToRunConfigurators(@NotNull Module module2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        ModuleSourceRootGroup moduleGroup = ModuleSourceRootMapKt.toModuleGroup(module2);
        KotlinProjectConfigurator[] $this$filter$iv = ConfigureKotlinInProjectUtilsKt.allConfigurators();
        boolean $i$f$filter = false;
        KotlinProjectConfigurator[] kotlinProjectConfiguratorArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var7_7 = $this$filterTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var7_7[j];
            boolean bl = false;
            if (!(it.getStatus(moduleGroup) == ConfigureKotlinStatus.CAN_BE_CONFIGURED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final KotlinProjectConfigurator getConfiguratorByName(@NotNull String name2) {
        KotlinProjectConfigurator kotlinProjectConfigurator;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            KotlinProjectConfigurator[] $this$firstOrNull$iv = ConfigureKotlinInProjectUtilsKt.allConfigurators();
            boolean $i$f$firstOrNull = false;
            KotlinProjectConfigurator[] kotlinProjectConfiguratorArray = $this$firstOrNull$iv;
            int n = kotlinProjectConfiguratorArray.length;
            for (int j = 0; j < n; ++j) {
                KotlinProjectConfigurator element$iv;
                KotlinProjectConfigurator it = element$iv = kotlinProjectConfiguratorArray[j];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                kotlinProjectConfigurator = element$iv;
                break block1;
            }
            kotlinProjectConfigurator = null;
        }
        return kotlinProjectConfigurator;
    }

    @NotNull
    public static final KotlinProjectConfigurator[] allConfigurators() {
        Object[] objectArray = Extensions.getExtensions(KotlinProjectConfigurator.Companion.getEP_NAME());
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Extensions.getExtensions\u2026jectConfigurator.EP_NAME)");
        return (KotlinProjectConfigurator[])objectArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> getCanBeConfiguredModules(@NotNull Project project2, @NotNull KotlinProjectConfigurator configurator) {
        void $this$mapTo$iv$iv;
        ModuleSourceRootGroup it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configurator, (String)"configurator");
        Iterable $this$filter$iv = new ModuleSourceRootMap(project2).groupByBaseModules((Collection<? extends Module>)ProjectStructureUtilKt.allModules(project2));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ModuleSourceRootGroup)element$iv$iv;
            boolean bl = false;
            if (!ConfigureKotlinInProjectUtilsKt.canConfigure(configurator, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ModuleSourceRootGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Module module2 = it.getBaseModule();
            collection.add(module2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean canConfigure(KotlinProjectConfigurator $this$canConfigure, ModuleSourceRootGroup moduleSourceRootGroup) {
        boolean bl;
        if ($this$canConfigure.getStatus(moduleSourceRootGroup) != ConfigureKotlinStatus.CAN_BE_CONFIGURED) return false;
        Iterable $this$none$iv = CollectionsKt.minus((Iterable)ArraysKt.toList((Object[])ConfigureKotlinInProjectUtilsKt.allConfigurators()), (Object)$this$canConfigure);
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
            boolean bl2 = false;
            if (it.getStatus(moduleSourceRootGroup) == ConfigureKotlinStatus.CONFIGURED) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> getCanBeConfiguredModulesWithKotlinFiles(@NotNull Project project2, @NotNull KotlinProjectConfigurator configurator) {
        void $this$mapTo$iv$iv;
        ModuleSourceRootGroup it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configurator, (String)"configurator");
        List<ModuleSourceRootGroup> modules2 = ConfigureKotlinInProjectUtilsKt.getConfigurableModulesWithKotlinFiles(project2);
        Iterable $this$filter$iv = modules2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ModuleSourceRootGroup)element$iv$iv;
            boolean bl = false;
            if (!(configurator.getStatus(it) == ConfigureKotlinStatus.CAN_BE_CONFIGURED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ModuleSourceRootGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Module module2 = it.getBaseModule();
            collection.add(module2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Pair<Collection<ModuleSourceRootGroup>, Collection<KotlinProjectConfigurator>> getConfigurationPossibilitiesForConfigureNotification(@NotNull Project project2, @NotNull Collection<? extends Module> excludeModules) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
        List<ModuleSourceRootGroup> modulesWithKotlinFiles = ModuleSourceRootMapKt.exclude(ConfigureKotlinInProjectUtilsKt.getConfigurableModulesWithKotlinFiles(project2), excludeModules);
        KotlinProjectConfigurator[] configurators = ConfigureKotlinInProjectUtilsKt.allConfigurators();
        boolean bl = false;
        Set runnableConfigurators = new LinkedHashSet();
        boolean bl2 = false;
        List configurableModules = new ArrayList();
        for (ModuleSourceRootGroup moduleSourceRootGroup : modulesWithKotlinFiles) {
            boolean moduleCanBeConfigured = false;
            boolean moduleAlreadyConfigured = false;
            block5: for (KotlinProjectConfigurator configurator : configurators) {
                if (moduleCanBeConfigured && runnableConfigurators.contains(configurator)) continue;
                switch (ConfigureKotlinInProjectUtilsKt$WhenMappings.$EnumSwitchMapping$1[configurator.getStatus(moduleSourceRootGroup).ordinal()]) {
                    case 1: {
                        moduleCanBeConfigured = true;
                        runnableConfigurators.add(configurator);
                        continue block5;
                    }
                    case 2: {
                        moduleAlreadyConfigured = true;
                        continue block5;
                    }
                }
            }
            if (!moduleCanBeConfigured || moduleAlreadyConfigured || SuppressNotificationState.Companion.isKotlinNotConfiguredSuppressed(moduleSourceRootGroup)) continue;
            configurableModules.add(moduleSourceRootGroup);
        }
        return TuplesKt.to((Object)configurableModules, (Object)runnableConfigurators);
    }

    public static /* synthetic */ Pair getConfigurationPossibilitiesForConfigureNotification$default(Project project2, Collection collection, int n, Object object) {
        if ((n & 2) != 0) {
            collection = CollectionsKt.emptyList();
        }
        return ConfigureKotlinInProjectUtilsKt.getConfigurationPossibilitiesForConfigureNotification(project2, collection);
    }

    @NotNull
    public static final KotlinProjectConfigurator findApplicableConfigurator(@NotNull Module module2) {
        KotlinProjectConfigurator kotlinProjectConfigurator;
        KotlinProjectConfigurator kotlinProjectConfigurator2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            ModuleSourceRootGroup moduleGroup = ModuleSourceRootMapKt.toModuleGroup(module2);
            KotlinProjectConfigurator[] kotlinProjectConfiguratorArray = ConfigureKotlinInProjectUtilsKt.allConfigurators();
            boolean bl = false;
            KotlinProjectConfigurator[] kotlinProjectConfiguratorArray2 = kotlinProjectConfiguratorArray;
            boolean bl2 = false;
            KotlinProjectConfigurator[] kotlinProjectConfiguratorArray3 = kotlinProjectConfiguratorArray2;
            int n = kotlinProjectConfiguratorArray3.length;
            for (int j = 0; j < n; ++j) {
                KotlinProjectConfigurator kotlinProjectConfigurator3;
                KotlinProjectConfigurator it = kotlinProjectConfigurator3 = kotlinProjectConfiguratorArray3[j];
                boolean bl3 = false;
                if (!(it.getStatus(moduleGroup) != ConfigureKotlinStatus.NON_APPLICABLE)) continue;
                kotlinProjectConfigurator2 = kotlinProjectConfigurator3;
                break block2;
            }
            kotlinProjectConfigurator2 = kotlinProjectConfigurator = null;
        }
        if (kotlinProjectConfigurator2 == null) {
            kotlinProjectConfigurator = KotlinJavaModuleConfigurator.Companion.getInstance();
        }
        return kotlinProjectConfigurator;
    }

    public static final boolean hasAnyKotlinRuntimeInScope(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        return (Boolean)DumbUtilsKt.runReadActionInSmartMode(project2, (Function0)new Function0<Boolean>(module2){
            final /* synthetic */ Module $module;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke() {
                GlobalSearchScope globalSearchScope = this.$module.getModuleWithDependenciesAndLibrariesScope(ProjectUtilsKt.hasKotlinFilesOnlyInTests(this.$module));
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"module.getModuleWithDepe\u2026FilesOnlyInTests(module))");
                GlobalSearchScope scope2 = globalSearchScope;
                Project project2 = this.$module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
                if (RuntimeLibraryUtilsKt.getKotlinJvmRuntimeMarkerClass(project2, scope2) != null) return true;
                Project project3 = this.$module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"module.project");
                if (KotlinRuntimeLibraryUtilKt.hasKotlinJsKjsmFile(project3, (GlobalSearchScope)new LibraryKindSearchScope(this.$module, scope2, JSLibraryKind.INSTANCE))) return true;
                if (!ConfigureKotlinInProjectUtilsKt.hasKotlinCommonRuntimeInScope(scope2)) return false;
                return true;
            }
            {
                this.$module = module2;
                super(0);
            }
        });
    }

    public static final boolean hasKotlinJvmRuntimeInScope(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(module2){
            final /* synthetic */ Module $module;

            public final boolean invoke() {
                GlobalSearchScope globalSearchScope = this.$module.getModuleWithDependenciesAndLibrariesScope(ProjectUtilsKt.hasKotlinFilesOnlyInTests(this.$module));
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"module.getModuleWithDepe\u2026FilesOnlyInTests(module))");
                GlobalSearchScope scope2 = globalSearchScope;
                Project project2 = this.$module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
                return RuntimeLibraryUtilsKt.getKotlinJvmRuntimeMarkerClass(project2, scope2) != null;
            }
            {
                this.$module = module2;
                super(0);
            }
        });
    }

    public static final boolean hasKotlinJsRuntimeInScope(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        return (Boolean)DumbUtilsKt.runReadActionInSmartMode(project2, (Function0)new Function0<Boolean>(module2){
            final /* synthetic */ Module $module;

            public final boolean invoke() {
                GlobalSearchScope globalSearchScope = this.$module.getModuleWithDependenciesAndLibrariesScope(ProjectUtilsKt.hasKotlinFilesOnlyInTests(this.$module));
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"module.getModuleWithDepe\u2026FilesOnlyInTests(module))");
                GlobalSearchScope scope2 = globalSearchScope;
                Project project2 = this.$module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
                return KotlinRuntimeLibraryUtilKt.hasKotlinJsKjsmFile(project2, (GlobalSearchScope)new LibraryKindSearchScope(this.$module, scope2, JSLibraryKind.INSTANCE));
            }
            {
                this.$module = module2;
                super(0);
            }
        });
    }

    public static final boolean hasKotlinCommonRuntimeInScope(@NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        return new IDEVirtualFileFinder(scope2).hasMetadataPackage(StandardNames.BUILT_INS_PACKAGE_FQ_NAME);
    }

    public static final boolean addStdlibToJavaModuleInfo(@NotNull Module module2, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        Sdk sdk2 = ProjectStructureUtilKt.getSdk(module2);
        if (sdk2 == null || (sdk2 = ProjectStructureUtilKt.getVersion(sdk2)) == null || !sdk2.isAtLeast(JavaSdkVersion.JDK_1_9)) {
            return false;
        }
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        Project project3 = project2;
        PsiJavaModule psiJavaModule = Java9StructureUtilKt.findFirstPsiJavaModule(module2);
        if (psiJavaModule == null) {
            return false;
        }
        PsiJavaModule javaModule = psiJavaModule;
        Boolean success2 = (Boolean)WriteCommandAction.runWriteCommandAction((Project)project3, (Computable)new Computable(javaModule){
            final /* synthetic */ PsiJavaModule $javaModule;

            public final Boolean compute() {
                return KotlinAddRequiredModuleFix.Companion.addModuleRequirement(this.$javaModule, "kotlin.stdlib");
            }
            {
                this.$javaModule = psiJavaModule;
            }
        });
        if (!success2.booleanValue()) {
            return false;
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = "kotlin.stdlib";
        String string = module2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
        objectArray[1] = string;
        collector2.addMessage(KotlinJvmBundle.message("added.0.requirement.to.module.info.in.1", objectArray));
        return true;
    }

    static {
        Logger logger = Logger.getInstance((String)"#org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtils");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#org\u2026ureKotlinInProjectUtils\")");
        LOG = logger;
        SNAPSHOT_REPOSITORY = new RepositoryDescription("sonatype.oss.snapshots", "Sonatype OSS Snapshot Repository", "https://oss.sonatype.org/content/repositories/snapshots", null, true);
        DEFAULT_GRADLE_PLUGIN_REPOSITORY = new RepositoryDescription("default.gradle.plugins", "Default Gradle Plugin Repository", "https://plugins.gradle.org/m2/", null, false);
    }
}

