/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.DummyLibraryProperties;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CliArgumentStringBuilder;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettingsProvider;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.configuration.ProjectUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.framework.ui.CreateLibraryDialogWithModules;
import org.jetbrains.kotlin.idea.framework.ui.FileUIUtils;
import org.jetbrains.kotlin.idea.quickfix.EnableUnsupportedFeatureFixKt;
import org.jetbrains.kotlin.idea.util.ProgressIndicatorUtils;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.idea.versions.OutdatedKotlinRuntimeCheckerKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 g2\u00020\u0001:\u0002ghB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J.\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016J\u001e\u0010(\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*J(\u0010+\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0011H\u0016J\u001e\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u00102\f\u00103\u001a\b\u0012\u0004\u0012\u00020 04H\u0017J\u0016\u00105\u001a\u00020\u001e2\f\u00106\u001a\b\u0012\u0004\u0012\u00020 0&H\u0014J.\u00107\u001a\u00020\u001e2\u0006\u0010#\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020'2\u0006\u0010)\u001a\u00020*J>\u0010=\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010:2\b\b\u0002\u0010A\u001a\u00020\u0011H\u0016J*\u0010=\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010B\u001a\u00020\u00042\b\u0010C\u001a\u0004\u0018\u00010\u00042\u0006\u0010)\u001a\u00020*H\u0004J>\u0010D\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010:2\b\b\u0002\u0010A\u001a\u00020\u0011H\u0002J\u000e\u0010E\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u0010J$\u0010F\u001a\u0004\u0018\u00010G2\b\u0010H\u001a\u0004\u0018\u00010G2\u0006\u0010I\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*H\u0007J\u0016\u0010J\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u00102\u0006\u0010)\u001a\u00020*J\u001a\u0010K\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010)\u001a\u00020*H\u0014J\u0010\u0010L\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u0010H\u0016J(\u0010M\u001a\u00020:2\u0006\u00102\u001a\u00020\u00102\u0006\u0010N\u001a\u00020G2\u0006\u0010O\u001a\u00020P2\u0006\u0010A\u001a\u00020\u0011H\u0004J\u0010\u0010Q\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010Q\u001a\u0004\u0018\u00010\u000f2\u0006\u00102\u001a\u00020\u0010J\u0018\u0010R\u001a\b\u0012\u0004\u0012\u00020'0&2\b\u0010S\u001a\u0004\u0018\u00010TH&J\u001a\u0010U\u001a\u0004\u0018\u00010\u00042\u0006\u00102\u001a\u00020\u00102\u0006\u0010V\u001a\u00020PH\u0004J*\u0010W\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00102\u0006\u0010O\u001a\u00020P2\u0006\u0010X\u001a\u00020\u00042\b\u0010C\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\H\u0016J\u0010\u0010]\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010^\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H&J\u0018\u0010_\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u0010H\u0002J\u0010\u0010`\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u0010H\u0002J\u0010\u0010a\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u0010H\u0004J4\u0010b\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010c\u001a\u0004\u0018\u00010\u00042\b\u0010d\u001a\u0004\u0018\u00010\u00042\u0006\u0010e\u001a\u00020f2\u0006\u00100\u001a\u00020\u0011H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0006R\u001c\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0006\u00a8\u0006i"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "()V", "dialogTitle", "", "getDialogTitle", "()Ljava/lang/String;", "libraryCaption", "getLibraryCaption", "libraryKind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "getLibraryKind", "()Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "libraryMatcher", "Lkotlin/Function2;", "Lcom/intellij/openapi/roots/libraries/Library;", "Lcom/intellij/openapi/project/Project;", "", "getLibraryMatcher", "()Lkotlin/jvm/functions/Function2;", "libraryName", "getLibraryName", "libraryType", "Lcom/intellij/openapi/roots/libraries/LibraryType;", "Lcom/intellij/openapi/roots/libraries/DummyLibraryProperties;", "getLibraryType", "()Lcom/intellij/openapi/roots/libraries/LibraryType;", "messageForOverrideDialog", "getMessageForOverrideDialog", "addLibraryDependency", "", "module", "Lcom/intellij/openapi/module/Module;", "element", "Lcom/intellij/psi/PsiElement;", "library", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "libraryJarDescriptors", "", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "addLibraryToModuleIfNeeded", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "changeGeneralFeatureConfiguration", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "forTests", "configure", "project", "excludeModules", "", "configureKotlinSettings", "modules", "configureLibraryJar", "Lcom/intellij/openapi/roots/libraries/Library$ModifiableModel;", "jarState", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator$FileState;", "dirToCopyJarTo", "libraryJarDescriptor", "configureModule", "classesPath", "sourcesPath", "forceJarState", "useBundled", "defaultPath", "pathFromDialog", "configureModuleWithLibrary", "configureSilently", "copyFileToDir", "Ljava/nio/file/Path;", "path", "toDir", "createNewLibrary", "findAndFixBrokenKotlinLibrary", "getDefaultPathToJarFile", "getJarState", "targetFile", "jarType", "Lcom/intellij/openapi/roots/OrderRootType;", "getKotlinLibrary", "getLibraryJarDescriptors", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getPathFromLibrary", "type", "getPathToCopyFileTo", "defaultDir", "getStatus", "Lorg/jetbrains/kotlin/idea/configuration/ConfigureKotlinStatus;", "moduleSourceRootGroup", "Lorg/jetbrains/kotlin/idea/configuration/ModuleSourceRootGroup;", "isApplicable", "isConfigured", "isKotlinLibrary", "isProjectLibraryPresent", "needToChooseJarPath", "updateLanguageVersion", "languageVersion", "apiVersion", "requiredStdlibVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "Companion", "FileState", "kotlin.jvm"})
public abstract class KotlinWithLibraryConfigurator
implements KotlinProjectConfigurator {
    @Nullable
    private final LibraryType<DummyLibraryProperties> libraryType;
    @Nullable
    private final PersistentLibraryKind<?> libraryKind;
    @NotNull
    public static final String DEFAULT_LIBRARY_DIR = "lib";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected abstract String getLibraryName();

    @NotNull
    protected abstract String getMessageForOverrideDialog();

    @NotNull
    protected abstract String getDialogTitle();

    @NotNull
    protected abstract String getLibraryCaption();

    @Nullable
    public LibraryType<DummyLibraryProperties> getLibraryType() {
        return this.libraryType;
    }

    @Nullable
    protected final PersistentLibraryKind<?> getLibraryKind() {
        return this.libraryKind;
    }

    @Override
    @NotNull
    public ConfigureKotlinStatus getStatus(@NotNull ModuleSourceRootGroup moduleSourceRootGroup) {
        Intrinsics.checkNotNullParameter((Object)moduleSourceRootGroup, (String)"moduleSourceRootGroup");
        Module module2 = moduleSourceRootGroup.getBaseModule();
        if (!this.isApplicable(module2)) {
            return ConfigureKotlinStatus.NON_APPLICABLE;
        }
        if (this.isConfigured(module2)) {
            return ConfigureKotlinStatus.CONFIGURED;
        }
        return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
    }

    public abstract boolean isConfigured(@NotNull Module var1);

    @Override
    @JvmSuppressWildcards
    public void configure(@NotNull Project project2, @NotNull Collection<Module> excludeModules) {
        List<Module> list2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
        String defaultPathToJar = this.getDefaultPathToJarFile(project2);
        boolean showPathToJarPanel = this.needToChooseJarPath(project2);
        boolean $i$f$isUnitTestMode = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) {
            list2 = (List<Module>)ProgressIndicatorUtils.underModalProgress(project2, KotlinJvmBundle.message("lookup.modules.configurations.progress.text", new Object[0]), (Function0)new Function0<List<? extends Module>>(this, project2){
                final /* synthetic */ KotlinWithLibraryConfigurator this$0;
                final /* synthetic */ Project $project;

                @NotNull
                public final List<Module> invoke() {
                    return ConfigureKotlinInProjectUtilsKt.getCanBeConfiguredModules(this.$project, this.this$0);
                }
                {
                    this.this$0 = kotlinWithLibraryConfigurator;
                    this.$project = project2;
                    super(0);
                }
            });
        } else {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
            Module[] moduleArray = moduleManager.getModules();
            Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
            list2 = CollectionsKt.listOf((Object[])Arrays.copyOf(moduleArray, moduleArray.length));
        }
        List<Module> nonConfiguredModules2 = list2;
        List<Module> modulesToConfigure = nonConfiguredModules2 = CollectionsKt.minus((Iterable)nonConfiguredModules2, (Iterable)excludeModules);
        String copyLibraryIntoPath = null;
        if (nonConfiguredModules2.size() > 1 || showPathToJarPanel) {
            CreateLibraryDialogWithModules dialog2 = new CreateLibraryDialogWithModules(project2, this, defaultPathToJar, showPathToJarPanel, this.getDialogTitle(), this.getLibraryCaption(), excludeModules);
            boolean $i$f$isUnitTestMode2 = false;
            Application application2 = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
            if (!application2.isUnitTestMode()) {
                dialog2.show();
                if (!dialog2.isOK()) {
                    return;
                }
            } else {
                dialog2.close(0);
            }
            List<Module> list3 = dialog2.getModulesToConfigure();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"dialog.modulesToConfigure");
            modulesToConfigure = list3;
            copyLibraryIntoPath = dialog2.getCopyIntoPath();
        }
        NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project2);
        for (Module module2 : modulesToConfigure) {
            this.configureModule(module2, defaultPathToJar, copyLibraryIntoPath, collector2);
        }
        this.configureKotlinSettings((List<? extends Module>)modulesToConfigure);
        collector2.showNotification();
    }

    public final void configureSilently(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String defaultPathToJar = this.getDefaultPathToJarFile(project2);
        NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project2);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        int n = moduleArray.length;
        for (int j = 0; j < n; ++j) {
            Module module2;
            Module module3 = module2 = moduleArray[j];
            Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"module");
            this.configureModule(module3, defaultPathToJar, null, collector2);
        }
    }

    protected final void configureModule(@NotNull Module module2, @NotNull String defaultPath, @Nullable String pathFromDialog, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)defaultPath, (String)"defaultPath");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        OrderRootType orderRootType = OrderRootType.CLASSES;
        Intrinsics.checkNotNullExpressionValue((Object)orderRootType, (String)"OrderRootType.CLASSES");
        String classesPath = this.getPathToCopyFileTo(project2, orderRootType, defaultPath, pathFromDialog);
        Project project3 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"module.project");
        OrderRootType orderRootType2 = OrderRootType.SOURCES;
        Intrinsics.checkNotNullExpressionValue((Object)orderRootType2, (String)"OrderRootType.SOURCES");
        String sourcesPath = this.getPathToCopyFileTo(project3, orderRootType2, defaultPath, pathFromDialog);
        KotlinWithLibraryConfigurator.configureModule$default(this, module2, classesPath, sourcesPath, collector2, null, pathFromDialog == null, 16, null);
    }

    public void configureModule(@NotNull Module module2, @NotNull String classesPath, @NotNull String sourcesPath, @NotNull NotificationMessageCollector collector2, @Nullable FileState forceJarState, boolean useBundled) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)classesPath, (String)"classesPath");
        Intrinsics.checkNotNullParameter((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        this.configureModuleWithLibrary(module2, classesPath, sourcesPath, collector2, forceJarState, useBundled);
    }

    public static /* synthetic */ void configureModule$default(KotlinWithLibraryConfigurator kotlinWithLibraryConfigurator, Module module2, String string, String string2, NotificationMessageCollector notificationMessageCollector, FileState fileState, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureModule");
        }
        if ((n & 0x10) != 0) {
            fileState = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        kotlinWithLibraryConfigurator.configureModule(module2, string, string2, notificationMessageCollector, fileState, bl);
    }

    private final void configureModuleWithLibrary(Module module2, String classesPath, String sourcesPath, NotificationMessageCollector collector2, FileState forceJarState, boolean useBundled) {
        Library library2;
        Library library3;
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        Project project3 = project2;
        Library library4 = this.findAndFixBrokenKotlinLibrary(module2, collector2);
        if (library4 == null) {
            library4 = library3 = this.getKotlinLibrary(module2);
        }
        if (library4 == null) {
            library3 = library2 = this.getKotlinLibrary(project3);
        }
        if (library3 == null) {
            library2 = this.createNewLibrary(project3, collector2);
        }
        Library library5 = library2;
        Sdk sdk2 = ProjectStructureUtilKt.getSdk(module2);
        Library.ModifiableModel modifiableModel = library5.getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"library.modifiableModel");
        Library.ModifiableModel model2 = modifiableModel;
        for (LibraryJarDescriptor descriptor2 : this.getLibraryJarDescriptors(sdk2)) {
            String dirToCopyJar = Intrinsics.areEqual((Object)descriptor2.getOrderRootType(), (Object)OrderRootType.SOURCES) ? sourcesPath : classesPath;
            FileState fileState = forceJarState;
            if (fileState == null) {
                String[] stringArray = new String[]{descriptor2.getJarName()};
                boolean bl = false;
                Path path2 = Paths.get(dirToCopyJar, Arrays.copyOf(stringArray, stringArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(base, *subpaths)");
                fileState = this.getJarState(project3, path2, descriptor2.getOrderRootType(), useBundled);
            }
            FileState runtimeState = fileState;
            this.configureLibraryJar(model2, runtimeState, dirToCopyJar, descriptor2, collector2);
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(model2){
            final /* synthetic */ Library.ModifiableModel $model;

            public final void run() {
                this.$model.commit();
            }
            {
                this.$model = modifiableModel;
            }
        });
        this.addLibraryToModuleIfNeeded(module2, library5, collector2);
    }

    static /* synthetic */ void configureModuleWithLibrary$default(KotlinWithLibraryConfigurator kotlinWithLibraryConfigurator, Module module2, String string, String string2, NotificationMessageCollector notificationMessageCollector, FileState fileState, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureModuleWithLibrary");
        }
        if ((n & 0x10) != 0) {
            fileState = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        kotlinWithLibraryConfigurator.configureModuleWithLibrary(module2, string, string2, notificationMessageCollector, fileState, bl);
    }

    public final void configureLibraryJar(@NotNull Library.ModifiableModel library2, @NotNull FileState jarState, @NotNull String dirToCopyJarTo, @NotNull LibraryJarDescriptor libraryJarDescriptor, @NotNull NotificationMessageCollector collector2) {
        VirtualFile jarVFile;
        Path path2;
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        Intrinsics.checkNotNullParameter((Object)((Object)jarState), (String)"jarState");
        Intrinsics.checkNotNullParameter((Object)dirToCopyJarTo, (String)"dirToCopyJarTo");
        Intrinsics.checkNotNullParameter((Object)((Object)libraryJarDescriptor), (String)"libraryJarDescriptor");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        if (jarState == FileState.DO_NOT_COPY) {
            path2 = libraryJarDescriptor.getPathInPlugin();
        } else {
            String[] stringArray = new String[]{libraryJarDescriptor.getJarName()};
            boolean bl = false;
            Path path3 = Paths.get(dirToCopyJarTo, Arrays.copyOf(stringArray, stringArray.length));
            path2 = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"Paths.get(base, *subpaths)");
        }
        Path jarFile = path2;
        if (jarState == FileState.COPY) {
            this.copyFileToDir(libraryJarDescriptor.getPathInPlugin(), dirToCopyJarTo, collector2);
        }
        if ((jarVFile = LocalFileSystem.getInstance().findFileByNioFile(jarFile)) == null) {
            collector2.addMessage(KotlinJvmBundle.message("can.t.find.library.jar.file.0", jarFile));
            return;
        }
        VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(jarVFile);
        if (jarRoot == null) {
            collector2.addMessage(KotlinJvmBundle.message("couldn.t.configure.library.jar.file.0.may.be.corrupted", jarVFile));
            return;
        }
        Object[] objectArray = library2.getFiles(libraryJarDescriptor.getOrderRootType());
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"library.getFiles(library\u2026Descriptor.orderRootType)");
        if (!ArraysKt.contains((Object[])objectArray, (Object)jarRoot)) {
            library2.addRoot(jarRoot, libraryJarDescriptor.getOrderRootType());
            collector2.addMessage(KotlinJvmBundle.message("added.0.to.library.configuration", jarFile));
        }
    }

    @Nullable
    public final Library getKotlinLibrary(@NotNull Project project2) {
        Library library2;
        block4: {
            Library library3;
            Library it;
            Library element$iv;
            int n;
            int n2;
            Library[] libraryArray;
            boolean $i$f$firstOrNull;
            Library[] $this$firstOrNull$iv;
            block3: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project2);
                Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"LibraryTablesRegistrar.g\u2026.getLibraryTable(project)");
                Library[] libraryArray2 = libraryTable.getLibraries();
                Intrinsics.checkNotNullExpressionValue((Object)libraryArray2, (String)"LibraryTablesRegistrar.g\u2026yTable(project).libraries");
                $this$firstOrNull$iv = libraryArray2;
                $i$f$firstOrNull = false;
                libraryArray = $this$firstOrNull$iv;
                n2 = libraryArray.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = libraryArray[n];
                    boolean bl = false;
                    Library library4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)library4, (String)"it");
                    if (!this.isKotlinLibrary(library4, project2)) continue;
                    library3 = element$iv;
                    break block3;
                }
                library3 = library2 = null;
            }
            if (library3 == null) {
                LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)libraryTablesRegistrar, (String)"LibraryTablesRegistrar.getInstance()");
                LibraryTable libraryTable = libraryTablesRegistrar.getLibraryTable();
                Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"LibraryTablesRegistrar.getInstance().libraryTable");
                Library[] libraryArray3 = libraryTable.getLibraries();
                Intrinsics.checkNotNullExpressionValue((Object)libraryArray3, (String)"LibraryTablesRegistrar.g\u2026().libraryTable.libraries");
                $this$firstOrNull$iv = libraryArray3;
                $i$f$firstOrNull = false;
                libraryArray = $this$firstOrNull$iv;
                n2 = libraryArray.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = libraryArray[n];
                    boolean bl = false;
                    Library library5 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)library5, (String)"it");
                    if (!this.isKotlinLibrary(library5, project2)) continue;
                    library2 = element$iv;
                    break block4;
                }
                library2 = null;
            }
        }
        return library2;
    }

    @Contract(value="!null, _, _ -> !null")
    @Nullable
    public final Path copyFileToDir(@Nullable Path path2, @NotNull String toDir, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)toDir, (String)"toDir");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        if (path2 == null) {
            return null;
        }
        Path copy = FileUIUtils.INSTANCE.copyWithOverwriteDialog(this.getMessageForOverrideDialog(), toDir, path2);
        if (copy != null) {
            collector2.addMessage(KotlinJvmBundle.message("0.was.copied.to.1", PathsKt.getName((Path)path2), toDir));
        }
        return copy;
    }

    @Nullable
    protected final String getPathFromLibrary(@NotNull Project project2, @NotNull OrderRootType type2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return Companion.getPathFromLibrary(this.getKotlinLibrary(project2), type2);
    }

    public final void addLibraryToModuleIfNeeded(@NotNull Module module2, @NotNull Library library2, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        DependencyScope expectedDependencyScope = KotlinWithLibraryConfigurator.Companion.getDependencyScope(module2);
        Library kotlinLibrary = this.getKotlinLibrary(module2);
        if (kotlinLibrary == null) {
            ModuleRootModificationUtil.addDependency((Module)module2, (Library)library2, (DependencyScope)expectedDependencyScope, (boolean)false);
            Object[] objectArray = new Object[2];
            objectArray[0] = String.valueOf(library2.getName());
            String string = module2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
            objectArray[1] = string;
            collector2.addMessage(KotlinJvmBundle.message("0.library.was.added.to.module.1", objectArray));
        } else {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
            Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            OrderEntry[] orderEntryArray = moduleRootManager.getOrderEntries();
            Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray, (String)"ModuleRootManager.getInstance(module).orderEntries");
            LibraryOrderEntry libraryEntry = KotlinWithLibraryConfigurator.Companion.findLibraryOrderEntry(orderEntryArray, kotlinLibrary);
            if (libraryEntry != null) {
                DependencyScope dependencyScope = libraryEntry.getScope();
                Intrinsics.checkNotNullExpressionValue((Object)dependencyScope, (String)"libraryEntry.scope");
                DependencyScope libraryDependencyScope = dependencyScope;
                if (expectedDependencyScope != libraryDependencyScope) {
                    libraryEntry.setScope(expectedDependencyScope);
                    Object[] objectArray = new Object[4];
                    objectArray[0] = String.valueOf(kotlinLibrary.getName());
                    objectArray[1] = libraryDependencyScope;
                    objectArray[2] = expectedDependencyScope;
                    String string = module2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
                    objectArray[3] = string;
                    collector2.addMessage(KotlinJvmBundle.message("0.library.scope.has.changed.from.1.to.2.for.module.3", objectArray));
                }
            }
        }
    }

    @NotNull
    public final Library createNewLibrary(@NotNull Project project2, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project2);
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"LibraryTablesRegistrar.g\u2026.getLibraryTable(project)");
        LibraryTable table = libraryTable;
        Library library2 = (Library)ApplicationUtilsKt.runWriteAction((Function0)new Function0<Library>(this, table){
            final /* synthetic */ KotlinWithLibraryConfigurator this$0;
            final /* synthetic */ LibraryTable $table;

            @NotNull
            public final Library invoke() {
                LibraryTable.ModifiableModel modifiableModel = this.$table.getModifiableModel();
                boolean bl = false;
                boolean bl2 = false;
                LibraryTable.ModifiableModel $this$run = modifiableModel;
                boolean bl3 = false;
                Library library2 = $this$run.createLibrary(this.this$0.getLibraryName(), this.this$0.getLibraryKind());
                Intrinsics.checkNotNullExpressionValue((Object)library2, (String)"createLibrary(libraryName, libraryKind)");
                Library library3 = library2;
                $this$run.commit();
                return library3;
            }
            {
                this.this$0 = kotlinWithLibraryConfigurator;
                this.$table = libraryTable;
                super(0);
            }
        });
        collector2.addMessage(KotlinJvmBundle.message("0.library.was.created", String.valueOf(library2.getName())));
        return library2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProjectLibraryPresent(Project project2) {
        Library library2 = this.getKotlinLibrary(project2);
        if (library2 == null) return false;
        String[] stringArray = library2.getUrls(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"library.getUrls(OrderRootType.CLASSES)");
        String[] stringArray2 = stringArray;
        boolean bl = false;
        String[] stringArray3 = stringArray2;
        boolean bl2 = false;
        if (stringArray3.length != 0) return true;
        return false;
    }

    @NotNull
    protected abstract Function2<Library, Project, Boolean> getLibraryMatcher();

    @Nullable
    public final Library getKotlinLibrary(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return OutdatedKotlinRuntimeCheckerKt.findKotlinRuntimeLibrary(module2, (Function2<? super Library, ? super Project, Boolean>)((Function2)new Function2<Library, Project, Boolean>(this){

            public final boolean invoke(@NotNull Library p1, @NotNull Project p2) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                return KotlinWithLibraryConfigurator.access$isKotlinLibrary((KotlinWithLibraryConfigurator)this.receiver, p1, p2);
            }
        }));
    }

    private final boolean isKotlinLibrary(Library library2, Project project2) {
        return Intrinsics.areEqual((Object)library2.getName(), (Object)this.getLibraryName()) || (Boolean)this.getLibraryMatcher().invoke((Object)library2, (Object)project2) != false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean needToChooseJarPath(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String defaultPath = this.getDefaultPathToJarFile(project2);
        if (this.isProjectLibraryPresent(project2)) return false;
        String[] stringArray = new String[]{((LibraryJarDescriptor)((Object)CollectionsKt.first(this.getLibraryJarDescriptors(null)))).getJarName()};
        boolean bl = false;
        Path path2 = Paths.get(defaultPath, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(base, *subpaths)");
        Path path3 = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl2 = false;
        if (!Files.notExists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        return true;
    }

    @NotNull
    public String getDefaultPathToJarFile(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return FileUIUtils.INSTANCE.createRelativePath(project2, project2.getBaseDir(), DEFAULT_LIBRARY_DIR);
    }

    @NotNull
    protected final FileState getJarState(@NotNull Project project2, @NotNull Path targetFile2, @NotNull OrderRootType jarType, boolean useBundled) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetFile2, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)jarType, (String)"jarType");
        return PathKt.exists((Path)targetFile2) ? FileState.EXISTS : (this.getPathFromLibrary(project2, jarType) != null ? FileState.COPY : (useBundled ? FileState.DO_NOT_COPY : FileState.COPY));
    }

    private final String getPathToCopyFileTo(Project project2, OrderRootType jarType, String defaultDir, String pathFromDialog) {
        if (pathFromDialog != null) {
            return pathFromDialog;
        }
        String pathFromLibrary = this.getPathFromLibrary(project2, jarType);
        if (pathFromLibrary != null) {
            return pathFromLibrary;
        }
        return defaultDir;
    }

    @NotNull
    public abstract List<LibraryJarDescriptor> getLibraryJarDescriptors(@Nullable Sdk var1);

    protected void configureKotlinSettings(@NotNull List<? extends Module> modules2) {
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
    }

    @Nullable
    protected Library findAndFixBrokenKotlinLibrary(@NotNull Module module2, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        return null;
    }

    protected boolean isApplicable(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return BuildSystemTypeKt.getBuildSystemType(module2) == BuildSystemType.JPS;
    }

    @Override
    public void changeGeneralFeatureConfiguration(@NotNull Module module2, @NotNull LanguageFeature feature, @NotNull LanguageFeature.State state2, boolean forTests) {
        KotlinFacetSettings facetSettings;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        ApiVersion sinceVersion = feature.getSinceApiVersion();
        if (state2 != LanguageFeature.State.DISABLED && KotlinVersionInfoProviderKt.toApiVersion(KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module2)).compareTo(sinceVersion) < 0 && !EnableUnsupportedFeatureFixKt.askUpdateRuntime(module2, sinceVersion)) {
            return;
        }
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        KotlinFacetSettingsProvider kotlinFacetSettingsProvider = KotlinFacetSettingsProvider.Companion.getInstance(project2);
        Object object = facetSettings = kotlinFacetSettingsProvider != null ? kotlinFacetSettingsProvider.getInitializedSettings(module2) : null;
        if (facetSettings != null) {
            ModuleRootModificationUtil.updateModel((Module)module2, (Consumer)new Consumer(facetSettings, feature, state2, module2){
                final /* synthetic */ KotlinFacetSettings $facetSettings;
                final /* synthetic */ LanguageFeature $feature;
                final /* synthetic */ LanguageFeature.State $state;
                final /* synthetic */ Module $module;

                public final void consume(ModifiableRootModel it) {
                    block0: {
                        this.$facetSettings.setApiLevel(this.$feature.getSinceVersion());
                        this.$facetSettings.setLanguageLevel(this.$feature.getSinceVersion());
                        CompilerSettings compilerSettings = this.$facetSettings.getCompilerSettings();
                        if (compilerSettings == null) break block0;
                        CompilerSettings compilerSettings2 = compilerSettings;
                        boolean bl = false;
                        boolean bl2 = false;
                        CompilerSettings $this$apply = compilerSettings2;
                        boolean bl3 = false;
                        $this$apply.setAdditionalArguments(CliArgumentStringBuilder.replaceLanguageFeature$default(CliArgumentStringBuilder.INSTANCE, $this$apply.getAdditionalArguments(), this.$feature, this.$state, KotlinVersionInfoProviderKt.getCleanRuntimeLibraryVersion(this.$module), null, null, " ", false, 24, null));
                    }
                }
                {
                    this.$facetSettings = kotlinFacetSettings;
                    this.$feature = languageFeature;
                    this.$state = state2;
                    this.$module = module2;
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void updateLanguageVersion(@NotNull Module module, @Nullable String languageVersion, @Nullable String apiVersion, @NotNull ApiVersion requiredStdlibVersion, boolean forTests) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)requiredStdlibVersion, (String)"requiredStdlibVersion");
        v0 = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module);
        if (v0 == null) ** GOTO lbl-1000
        var7_6 = v0;
        var8_7 = false;
        var9_8 = false;
        it = var7_6;
        $i$a$-let-KotlinWithLibraryConfigurator$updateLanguageVersion$runtimeUpdateRequired$1 = false;
        v0 = ApiVersion.Companion.parse(it);
        if (v0 != null) {
            var7_6 = v0;
            var8_7 = false;
            var9_8 = false;
            runtimeVersion = var7_6;
            $i$a$-let-KotlinWithLibraryConfigurator$updateLanguageVersion$runtimeUpdateRequired$2 = false;
            v1 = runtimeVersion.compareTo(requiredStdlibVersion) < 0;
        } else lbl-1000:
        // 2 sources

        {
            v1 = runtimeUpdateRequired = false;
        }
        if (runtimeUpdateRequired && !EnableUnsupportedFeatureFixKt.askUpdateRuntime(module, requiredStdlibVersion)) {
            return;
        }
        v2 = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"module.project");
        v3 = KotlinFacetSettingsProvider.Companion.getInstance(v2);
        v4 /* !! */  = facetSettings = v3 != null ? v3.getInitializedSettings(module) : null;
        if (facetSettings != null) {
            ModuleRootModificationUtil.updateModel((Module)module, (Consumer)new Consumer(facetSettings, languageVersion, apiVersion){
                final /* synthetic */ KotlinFacetSettings $facetSettings;
                final /* synthetic */ String $languageVersion;
                final /* synthetic */ String $apiVersion;

                public final void consume(ModifiableRootModel it) {
                    KotlinFacetSettings kotlinFacetSettings = this.$facetSettings;
                    boolean bl = false;
                    boolean bl2 = false;
                    KotlinFacetSettings $this$with = kotlinFacetSettings;
                    boolean bl3 = false;
                    if (this.$languageVersion != null) {
                        $this$with.setLanguageLevel(LanguageVersion.Companion.fromVersionString(this.$languageVersion));
                    }
                    if (this.$apiVersion != null) {
                        $this$with.setApiLevel(LanguageVersion.Companion.fromVersionString(this.$apiVersion));
                    }
                }
                {
                    this.$facetSettings = kotlinFacetSettings;
                    this.$languageVersion = string;
                    this.$apiVersion = string2;
                }
            });
        }
    }

    @Override
    public void addLibraryDependency(@NotNull Module module2, @NotNull PsiElement element3, @NotNull ExternalLibraryDescriptor library2, @NotNull List<? extends LibraryJarDescriptor> libraryJarDescriptors) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        Intrinsics.checkNotNullParameter(libraryJarDescriptors, (String)"libraryJarDescriptors");
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        Project project3 = project2;
        NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project3);
        Iterator iterator = KotlinRuntimeLibraryUtilKt.findAllUsedLibraries(project3).keySet().iterator();
        while (iterator.hasNext()) {
            Library.ModifiableModel model2;
            VirtualFile runtimeJar;
            Library lib;
            Library library3 = lib = (Library)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)library3, (String)DEFAULT_LIBRARY_DIR);
            if (LibraryJarDescriptor.RUNTIME_JAR.findExistingJar(library3) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)lib.getModifiableModel(), (String)"lib.modifiableModel");
            Path path2 = VfsUtil.getLocalFile((VirtualFile)runtimeJar).toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"VfsUtil.getLocalFile(runtimeJar).toNioPath()");
            Path libFilesDir = path2.getParent();
            for (LibraryJarDescriptor libraryJarDescriptor : libraryJarDescriptors) {
                Path copied;
                Path path3;
                Path libIoFile;
                Path libFile;
                if (libraryJarDescriptor.findExistingJar(lib) != null) continue;
                Path path4 = libFile = libraryJarDescriptor.getPathInPlugin();
                LinkOption[] linkOptionArray = new LinkOption[]{};
                boolean bl = false;
                if (Files.notExists(path4, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                Path path5 = libIoFile = libFilesDir.resolve(libraryJarDescriptor.getJarName());
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"libIoFile");
                if (PathKt.exists((Path)path5)) {
                    model2.addRoot(VfsUtil.getUrlForLibraryRoot((File)libIoFile.toFile()), libraryJarDescriptor.getOrderRootType());
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)libFilesDir, (String)"libFilesDir");
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)this.copyFileToDir(libFile, ((Object)path3).toString(), collector2));
                model2.addRoot(VfsUtil.getUrlForLibraryRoot((File)copied.toFile()), libraryJarDescriptor.getOrderRootType());
            }
            model2.commit();
        }
        collector2.showNotification();
    }

    protected KotlinWithLibraryConfigurator() {
        LibraryType<DummyLibraryProperties> libraryType = this.getLibraryType();
        this.libraryKind = libraryType != null ? libraryType.getKind() : null;
    }

    public static final /* synthetic */ boolean access$isKotlinLibrary(KotlinWithLibraryConfigurator $this, Library library2, Project project2) {
        return $this.isKotlinLibrary(library2, project2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator$FileState;", "", "(Ljava/lang/String;I)V", "EXISTS", "COPY", "DO_NOT_COPY", "kotlin.jvm"})
    public static final class FileState
    extends Enum<FileState> {
        public static final /* enum */ FileState EXISTS;
        public static final /* enum */ FileState COPY;
        public static final /* enum */ FileState DO_NOT_COPY;
        private static final /* synthetic */ FileState[] $VALUES;

        static {
            FileState[] fileStateArray = new FileState[3];
            FileState[] fileStateArray2 = fileStateArray;
            fileStateArray[0] = EXISTS = new FileState();
            fileStateArray[1] = COPY = new FileState();
            fileStateArray[2] = DO_NOT_COPY = new FileState();
            $VALUES = fileStateArray;
        }

        public static FileState[] values() {
            return (FileState[])$VALUES.clone();
        }

        public static FileState valueOf(String string) {
            return Enum.valueOf(FileState.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator$Companion;", "", "()V", "DEFAULT_LIBRARY_DIR", "", "findLibraryOrderEntry", "Lcom/intellij/openapi/roots/LibraryOrderEntry;", "orderEntries", "", "Lcom/intellij/openapi/roots/OrderEntry;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "([Lcom/intellij/openapi/roots/OrderEntry;Lcom/intellij/openapi/roots/libraries/Library;)Lcom/intellij/openapi/roots/LibraryOrderEntry;", "getDependencyScope", "Lcom/intellij/openapi/roots/DependencyScope;", "module", "Lcom/intellij/openapi/module/Module;", "getPathFromLibrary", "type", "Lcom/intellij/openapi/roots/OrderRootType;", "getPathFromLibraryUrls", "libraryFiles", "([Ljava/lang/String;)Ljava/lang/String;", "kotlin.jvm"})
    public static final class Companion {
        @Nullable
        public final String getPathFromLibrary(@Nullable Library library2, @NotNull OrderRootType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            if (library2 == null) {
                return null;
            }
            String[] libraryFiles = library2.getUrls(type2);
            Intrinsics.checkNotNullExpressionValue((Object)libraryFiles, (String)"libraryFiles");
            return this.getPathFromLibraryUrls(libraryFiles);
        }

        @Nullable
        public final String getPathFromLibraryUrls(@NotNull String[] libraryFiles) {
            Path parentDirFile;
            Intrinsics.checkNotNullParameter((Object)libraryFiles, (String)"libraryFiles");
            String[] stringArray = libraryFiles;
            boolean bl = false;
            if (stringArray.length == 0) {
                return null;
            }
            String string = VfsUtilCore.urlToPath((String)((String)ArraysKt.first((Object[])libraryFiles)));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.urlToPath(libraryFiles.first())");
            String pathToJarInLib = string;
            String string2 = VfsUtil.getParentDir((String)VfsUtil.getParentDir((String)pathToJarInLib));
            if (string2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"VfsUtil.getParentDir(Vfs\u2026JarInLib)) ?: return null");
            String parentDir = string2;
            boolean bl2 = false;
            Path path2 = Paths.get(parentDir, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(path)");
            Path path3 = parentDirFile = path2;
            Object[] objectArray = new LinkOption[]{};
            boolean bl3 = false;
            if (Files.notExists(path3, Arrays.copyOf(objectArray, objectArray.length))) {
                path3 = parentDirFile;
                objectArray = new FileAttribute[]{};
                bl3 = false;
                Path path4 = Files.createDirectories(path3, (FileAttribute[])Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"Files.createDirectories(this, *attributes)");
                path3 = path4;
                boolean bl4 = false;
                bl3 = false;
                Path p1 = path3;
                boolean bl5 = false;
                if ((PathKt.exists((Path)p1) ? path3 : null) == null) {
                    return null;
                }
            }
            return parentDir;
        }

        private final LibraryOrderEntry findLibraryOrderEntry(OrderEntry[] orderEntries, Library library2) {
            for (OrderEntry orderEntry : orderEntries) {
                if (!(orderEntry instanceof LibraryOrderEntry) || !Intrinsics.areEqual((Object)library2, (Object)((LibraryOrderEntry)orderEntry).getLibrary())) continue;
                return (LibraryOrderEntry)orderEntry;
            }
            return null;
        }

        private final DependencyScope getDependencyScope(Module module2) {
            return ProjectUtilsKt.hasKotlinFilesOnlyInTests(module2) ? DependencyScope.TEST : DependencyScope.COMPILE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

