/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Accessible;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InternalException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.core.util.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.FileRankingCalculator;
import org.jetbrains.kotlin.idea.debugger.FileRankingCalculatorKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 B2\u00020\u0001:\u0002BCB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J!\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\f\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\u0006\u0010\u0011\u001a\u00020\u0012J\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0007\u001a\u00020\u0016H\u0082\u0010J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0006H\u0002J(\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020$0#2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J \u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020,2\u0006\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u000201H\u0002J \u00102\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u001c2\u0006\u00103\u001a\u0002042\u0006\u0010!\u001a\u00020\u0006H\u0002J\u0018\u00105\u001a\u00020\n2\u0006\u00106\u001a\u0002072\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u00108\u001a\u00020\n2\u0006\u00109\u001a\u00020:2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010;\u001a\u00020\n2\u0006\u00103\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0002J\u001a\u0010?\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c\u0018\u00010@*\u00020)H\u0002J\f\u0010A\u001a\u00020\u0003*\u00020)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator;", "", "checkClassFqName", "", "(Z)V", "analyze", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "collect", "Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking;", "conditions", "", "([Ljava/lang/Object;)Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking;", "fileRanking", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "location", "Lcom/sun/jdi/Location;", "fileRankingSafe", "findFunctionLiteralOnLine", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "Lcom/intellij/psi/PsiElement;", "findMostAppropriateSource", "files", "", "findNonLocalCallableParent", "getPropertyName", "", "accessorMethodName", "isSetter", "makeTypeMapper", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "bindingContext", "rankFiles", "", "", "rankingForAccessor", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "method", "Lcom/sun/jdi/Method;", "rankingForClass", "clazz", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "type", "Lcom/sun/jdi/ReferenceType;", "fqName", "virtualMachine", "Lcom/sun/jdi/VirtualMachine;", "rankingForClassName", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "rankingForMethod", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "rankingForProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "rankingForVisibility", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "accessible", "Lcom/sun/jdi/Accessible;", "getContainingClassAndMethodNameForLambda", "Lkotlin/Pair;", "isLambda", "Companion", "Ranking", "kotlin.jvm-debugger.util"})
public abstract class FileRankingCalculator {
    private final boolean checkClassFqName;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public abstract BindingContext analyze(@NotNull KtElement var1);

    @NotNull
    public final KtFile findMostAppropriateSource(@NotNull Collection<? extends KtFile> files2, @NotNull Location location2) {
        Object v0;
        Map<KtFile, Integer> fileWithRankings;
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Map<KtFile, Integer> map2 = fileWithRankings = this.rankFiles(files2, location2);
        boolean bl = false;
        Iterable iterable = map2.entrySet();
        boolean bl2 = false;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            v0 = null;
        } else {
            Object t = iterator.next();
            if (!iterator.hasNext()) {
                v0 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl3 = false;
                int n = ((Number)it.getValue()).intValue();
                do {
                    Object t2 = iterator.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-FileRankingCalculator$findMostAppropriateSource$fileWithMaxScore$1 = false;
                    int n2 = ((Number)it2.getValue()).intValue();
                    if (n >= n2) continue;
                    t = t2;
                    n = n2;
                } while (iterator.hasNext());
                v0 = t;
            }
        }
        Map.Entry entry = v0;
        Intrinsics.checkNotNull((Object)entry);
        Map.Entry fileWithMaxScore = entry;
        return (KtFile)fileWithMaxScore.getKey();
    }

    @NotNull
    public final Map<KtFile, Integer> rankFiles(@NotNull Collection<? extends KtFile> files2, @NotNull Location location2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Collection<? extends KtFile> collection = files2;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return CollectionsKt.keysToMap((Iterable)files2, (Function1)((Function1)new Function1<KtFile, Integer>(this, location2){
            final /* synthetic */ FileRankingCalculator this$0;
            final /* synthetic */ Location $location;

            public final int invoke(@NotNull KtFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return FileRankingCalculator.access$fileRankingSafe(this.this$0, it, this.$location).getValue();
            }
            {
                this.this$0 = fileRankingCalculator;
                this.$location = location2;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final Ranking collect(Object ... conditions) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Object $this$map$iv = conditions;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var7_10 = $this$mapTo$iv$iv;
        int n = ((void)var7_10).length;
        for (int j = 0; j < n; ++j) {
            Ranking ranking;
            void condition2;
            void item$iv$iv;
            void var11_17 = item$iv$iv = var7_10[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var13_19 = condition2;
            if (var13_19 instanceof Boolean) {
                ranking = Ranking.Companion.minor((Boolean)condition2);
            } else if (var13_19 instanceof Integer) {
                ranking = new Ranking(((Number)condition2).intValue());
            } else if (var13_19 instanceof Ranking) {
                ranking = (Ranking)condition2;
            } else {
                String string = "Invalid condition type " + condition2.getClass().getName();
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Ranking ranking2 = ranking;
            collection.add(ranking2);
        }
        $this$map$iv = (List)destination$iv$iv;
        Ranking initial$iv = Ranking.Companion.getZERO();
        boolean $i$f$fold = false;
        Ranking accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void r;
            Ranking ranking = (Ranking)element$iv;
            Ranking sum = accumulator$iv;
            boolean bl = false;
            accumulator$iv = sum.plus((Ranking)r);
        }
        return accumulator$iv;
    }

    private final Ranking rankingForClass(KtClassOrObject clazz, String fqName2, VirtualMachine virtualMachine) {
        BindingContext bindingContext2 = this.analyze((KtElement)clazz);
        ClassDescriptor classDescriptor = (ClassDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.CLASS, (Object)clazz);
        if (classDescriptor == null) {
            return Ranking.Companion.getZERO();
        }
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"bindingContext[BindingCo\u2026SS, clazz] ?: return ZERO");
        ClassDescriptor descriptor2 = classDescriptor;
        List<ReferenceType> list2 = virtualMachine.classesByName(fqName2);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"virtualMachine.classesByName(fqName)");
        ReferenceType referenceType = (ReferenceType)kotlin.collections.CollectionsKt.firstOrNull(list2);
        if (referenceType == null) {
            FileRankingCalculator fileRankingCalculator = this;
            boolean bl = false;
            boolean bl2 = false;
            FileRankingCalculator $this$run = fileRankingCalculator;
            boolean bl3 = false;
            return $this$run.rankingForClassName(fqName2, descriptor2, bindingContext2);
        }
        ReferenceType jdiType = referenceType;
        return this.rankingForClass(clazz, jdiType);
    }

    private final Ranking rankingForClass(KtClassOrObject clazz, ReferenceType type2) {
        BindingContext bindingContext2 = this.analyze((KtElement)clazz);
        ClassDescriptor classDescriptor = (ClassDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.CLASS, (Object)clazz);
        if (classDescriptor == null) {
            return Ranking.Companion.getZERO();
        }
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"bindingContext[BindingCo\u2026SS, clazz] ?: return ZERO");
        ClassDescriptor descriptor2 = classDescriptor;
        Object[] objectArray = new Object[5];
        String string = type2.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.name()");
        objectArray[0] = this.rankingForClassName(string, descriptor2, bindingContext2);
        objectArray[1] = Ranking.Companion.minor(type2.isAbstract() && descriptor2.getModality() == Modality.ABSTRACT);
        objectArray[2] = Ranking.Companion.minor(type2.isFinal() && descriptor2.getModality() == Modality.FINAL);
        objectArray[3] = Ranking.Companion.minor(type2.isStatic() && !descriptor2.isInner());
        objectArray[4] = this.rankingForVisibility((DeclarationDescriptorWithVisibility)descriptor2, type2);
        return this.collect(objectArray);
    }

    private final Ranking rankingForClassName(String fqName2, ClassDescriptor descriptor2, BindingContext bindingContext2) {
        Ranking ranking;
        if (DescriptorUtils.isLocal((DeclarationDescriptor)((DeclarationDescriptor)descriptor2))) {
            return Ranking.Companion.getZERO();
        }
        String expectedFqName = this.makeTypeMapper(bindingContext2).mapType((ClassifierDescriptor)descriptor2).getClassName();
        if (this.checkClassFqName) {
            ranking = Intrinsics.areEqual((Object)expectedFqName, (Object)fqName2) ? Ranking.Companion.getMAJOR() : Ranking.Companion.getLOW();
        } else {
            String string = expectedFqName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expectedFqName");
            ranking = Intrinsics.areEqual((Object)FileRankingCalculatorKt.access$simpleName(string), (Object)FileRankingCalculatorKt.access$simpleName(fqName2)) ? Ranking.Companion.getMAJOR() : Ranking.Companion.getLOW();
        }
        return ranking;
    }

    private final Ranking rankingForMethod(KtFunction function2, Method method) {
        BindingContext bindingContext2 = this.analyze((KtElement)function2);
        Object object = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)function2);
        if (!(object instanceof CallableMemberDescriptor)) {
            object = null;
        }
        CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)object;
        if (callableMemberDescriptor == null) {
            return Ranking.Companion.getZERO();
        }
        CallableMemberDescriptor descriptor2 = callableMemberDescriptor;
        if (!(function2 instanceof KtConstructor) && Intrinsics.areEqual((Object)method.name(), (Object)descriptor2.getName().asString()) ^ true) {
            return Ranking.Companion.getLOW();
        }
        Object[] objectArray = new Object[6];
        objectArray[0] = method.isConstructor() && function2 instanceof KtConstructor;
        objectArray[1] = method.isAbstract() && descriptor2.getModality() == Modality.ABSTRACT;
        objectArray[2] = method.isFinal() && descriptor2.getModality() == Modality.FINAL;
        objectArray[3] = method.isVarArgs() && DescriptorUtilsKt.varargParameterPosition((CallableDescriptor)((CallableDescriptor)descriptor2)) >= 0;
        objectArray[4] = this.rankingForVisibility((DeclarationDescriptorWithVisibility)descriptor2, method);
        List<LocalVariable> list2 = SafeUtilKt.safeArguments(method);
        objectArray[5] = descriptor2.getValueParameters().size() == (list2 != null ? list2.size() : 0);
        return this.collect(objectArray);
    }

    private final Ranking rankingForAccessor(KtPropertyAccessor accessor, Method method) {
        String expectedPropertyName;
        String methodName2;
        block7: {
            block8: {
                methodName2 = method.name();
                KtProperty ktProperty = accessor.getProperty();
                Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"accessor.property");
                String string = ktProperty.getName();
                if (string == null) {
                    return Ranking.Companion.getZERO();
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"accessor.property.name ?: return ZERO");
                expectedPropertyName = string;
                if (accessor.isSetter()) {
                    String string2 = methodName2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"methodName");
                    if (!StringsKt.startsWith$default((String)string2, (String)"set", (boolean)false, (int)2, null) || !(method.returnType() instanceof VoidType) || method.argumentTypes().size() != 1) {
                        return Ranking.Companion.getMAJOR().unaryMinus();
                    }
                }
                if (!accessor.isGetter()) break block7;
                String string3 = methodName2;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"methodName");
                if (!StringsKt.startsWith$default((String)string3, (String)"get", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)methodName2, (String)"is", (boolean)false, (int)2, null)) {
                    return Ranking.Companion.getMAJOR().unaryMinus();
                }
                if (method.returnType() instanceof VoidType) break block8;
                List<Type> list2 = method.argumentTypes();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"method.argumentTypes()");
                Collection collection = list2;
                boolean bl = false;
                if (!(!collection.isEmpty())) break block7;
            }
            return Ranking.Companion.getNORMAL().unaryMinus();
        }
        String string = methodName2;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"methodName");
        String actualPropertyName = this.getPropertyName(string, accessor.isSetter());
        return Intrinsics.areEqual((Object)expectedPropertyName, (Object)actualPropertyName) ? Ranking.Companion.getNORMAL() : Ranking.Companion.getNORMAL().unaryMinus();
    }

    private final String getPropertyName(String accessorMethodName, boolean isSetter) {
        if (isSetter) {
            return StringsKt.drop((String)accessorMethodName, (int)3);
        }
        return StringsKt.drop((String)accessorMethodName, (int)(StringsKt.startsWith$default((String)accessorMethodName, (String)"is", (boolean)false, (int)2, null) ? 2 : 3));
    }

    private final Ranking rankingForProperty(KtProperty property2, Method method) {
        String methodName2 = method.name();
        String string = property2.getName();
        if (string == null) {
            return Ranking.Companion.getZERO();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.name ?: return ZERO");
        String propertyName = string;
        if (property2.isTopLevel() && Intrinsics.areEqual((Object)method.name(), (Object)"<clinit>")) {
            return Ranking.Companion.getMINOR();
        }
        String string2 = methodName2;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"methodName");
        if (!StringsKt.startsWith$default((String)string2, (String)"get", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)methodName2, (String)"set", (boolean)false, (int)2, null)) {
            return Ranking.Companion.getMAJOR().unaryMinus();
        }
        return Intrinsics.areEqual((Object)StringsKt.drop((String)methodName2, (int)3), (Object)CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)propertyName)) ? Ranking.Companion.getMAJOR() : Ranking.Companion.getNORMAL().unaryMinus();
    }

    private final Ranking rankingForVisibility(DeclarationDescriptorWithVisibility descriptor2, Accessible accessible) {
        return this.collect(accessible.isPublic() && Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)DescriptorVisibilities.PUBLIC), accessible.isProtected() && Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)DescriptorVisibilities.PROTECTED), accessible.isPrivate() && Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)DescriptorVisibilities.PRIVATE));
    }

    private final Ranking fileRankingSafe(KtFile file2, Location location2) {
        Ranking ranking;
        try {
            ranking = this.fileRanking(file2, location2);
        }
        catch (ClassNotLoadedException e) {
            LOG.error("ClassNotLoadedException should never happen in FileRankingCalculator", (Throwable)e);
            ranking = Ranking.Companion.getZERO();
        }
        catch (AbsentInformationException e) {
            ranking = Ranking.Companion.getZERO();
        }
        catch (InternalException e) {
            ranking = Ranking.Companion.getZERO();
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (RuntimeException e) {
            LOG.error("Exception during Kotlin sources ranking", (Throwable)e);
            ranking = Ranking.Companion.getZERO();
        }
        return ranking;
    }

    /*
     * WARNING - void declaration
     */
    private final Ranking fileRanking(KtFile file2, Location location2) {
        Ranking overallRanking;
        block38: {
            void $this$getParentOfType$iv;
            Ranking ranking;
            PsiElement callable2;
            Method method;
            PsiElement elementAt;
            block35: {
                PsiElement constructorOrInitializer;
                KtClassOrObject containingClass2;
                int locationLineNumber;
                block37: {
                    Object object;
                    PsiElement it;
                    Object object2;
                    boolean $i$f$getParentOfTypes2;
                    PsiElement $this$getParentOfTypes2$iv;
                    block36: {
                        void $this$getParentOfType$iv2;
                        locationLineNumber = location2.lineNumber() - 1;
                        Integer n = PsiLinesUtilsKt.getLineStartOffset((PsiFile)file2, locationLineNumber);
                        if (n == null) {
                            return Ranking.Companion.getLOW();
                        }
                        int lineStartOffset = n;
                        PsiElement psiElement2 = file2.findElementAt(lineStartOffset);
                        if (psiElement2 == null) {
                            return Ranking.Companion.getZERO();
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"file.findElementAt(lineStartOffset) ?: return ZERO");
                        elementAt = psiElement2;
                        overallRanking = Ranking.Companion.getZERO();
                        Method method2 = method = location2.method();
                        Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
                        if (this.isLambda(method2)) {
                            void $this$getParentOfType$iv3;
                            PsiElement containingCallable;
                            void className2;
                            Pair<String, String> pair = this.getContainingClassAndMethodNameForLambda(method);
                            if (pair == null) {
                                return Ranking.Companion.getZERO();
                            }
                            Pair<String, String> pair2 = pair;
                            String string = (String)pair2.component1();
                            String methodName2 = (String)pair2.component2();
                            if (method.isBridge() && method.isSynthetic()) {
                                void $this$getParentOfType$iv4;
                                PsiElement psiElement3 = elementAt;
                                boolean strict$iv = false;
                                boolean $i$f$getParentOfType = false;
                                KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv4, KtClassOrObject.class, (boolean)strict$iv);
                                if (ktClassOrObject == null) {
                                    return Ranking.Companion.getLOW();
                                }
                                KtClassOrObject containingClass3 = ktClassOrObject;
                                VirtualMachine virtualMachine = location2.virtualMachine();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"location.virtualMachine()");
                                return this.rankingForClass(containingClass3, (String)className2, virtualMachine);
                            }
                            KtFunctionLiteral ktFunctionLiteral = this.findFunctionLiteralOnLine(elementAt);
                            if (ktFunctionLiteral == null) {
                                return Ranking.Companion.getLOW();
                            }
                            KtFunctionLiteral containingFunctionLiteral = ktFunctionLiteral;
                            PsiElement psiElement4 = this.findNonLocalCallableParent((PsiElement)containingFunctionLiteral);
                            if (psiElement4 == null) {
                                return Ranking.Companion.getLOW();
                            }
                            PsiElement strict$iv = containingCallable = psiElement4;
                            if (strict$iv instanceof KtFunction) {
                                if (Intrinsics.areEqual((Object)((KtFunction)containingCallable).getName(), (Object)methodName2)) {
                                    overallRanking = overallRanking.plus(Ranking.Companion.getMAJOR());
                                }
                            } else if (strict$iv instanceof KtProperty) {
                                if (Intrinsics.areEqual((Object)((KtProperty)containingCallable).getName(), (Object)methodName2)) {
                                    overallRanking = overallRanking.plus(Ranking.Companion.getMAJOR());
                                }
                            } else if (strict$iv instanceof KtPropertyAccessor) {
                                KtProperty ktProperty = ((KtPropertyAccessor)containingCallable).getProperty();
                                Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"containingCallable.property");
                                if (Intrinsics.areEqual((Object)ktProperty.getName(), (Object)methodName2)) {
                                    overallRanking = overallRanking.plus(Ranking.Companion.getMAJOR());
                                }
                            }
                            PsiElement $i$f$getParentOfType = containingCallable;
                            boolean strict$iv2 = false;
                            boolean $i$f$getParentOfType2 = false;
                            KtClassOrObject containingClass222 = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv3, KtClassOrObject.class, (boolean)strict$iv2);
                            if (containingClass222 != null) {
                                VirtualMachine virtualMachine = location2.virtualMachine();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"location.virtualMachine()");
                                overallRanking = overallRanking.plus(this.rankingForClass(containingClass222, (String)className2, virtualMachine));
                            }
                            return overallRanking;
                        }
                        if (!Intrinsics.areEqual((Object)method.name(), (Object)"<init>")) break block35;
                        PsiElement methodName2 = elementAt;
                        boolean strict$iv = false;
                        boolean $i$f$getParentOfType = false;
                        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv2, KtClassOrObject.class, (boolean)strict$iv);
                        if (ktClassOrObject == null) {
                            return Ranking.Companion.getLOW();
                        }
                        containingClass2 = ktClassOrObject;
                        $this$getParentOfTypes2$iv = elementAt;
                        $i$f$getParentOfTypes2 = false;
                        Class[] containingClass222 = new Class[]{KtConstructor.class, KtClassInitializer.class};
                        object2 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfTypes2$iv, (Class[])containingClass222);
                        if (object2 == null) break block36;
                        $this$getParentOfTypes2$iv = object2;
                        $i$f$getParentOfTypes2 = false;
                        boolean containingClass222 = false;
                        it = $this$getParentOfTypes2$iv;
                        boolean bl = false;
                        object2 = PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)containingClass2), (PsiElement)it, (boolean)false, (int)2, null) ? $this$getParentOfTypes2$iv : null;
                        if (object2 != null) break block37;
                    }
                    KtPrimaryConstructor ktPrimaryConstructor = containingClass2.getPrimaryConstructor();
                    if (ktPrimaryConstructor != null) {
                        $this$getParentOfTypes2$iv = ktPrimaryConstructor;
                        $i$f$getParentOfTypes2 = false;
                        boolean containingClass222 = false;
                        it = $this$getParentOfTypes2$iv;
                        boolean bl = false;
                        object = FileRankingCalculatorKt.access$getLine(it) == FileRankingCalculatorKt.access$getLine((PsiElement)containingClass2) ? $this$getParentOfTypes2$iv : null;
                    } else {
                        object = null;
                    }
                    object2 = constructorOrInitializer = (PsiElement)object;
                }
                if (constructorOrInitializer == null && locationLineNumber < FileRankingCalculatorKt.access$getLine((PsiElement)containingClass2)) {
                    PsiElement psiElement5 = containingClass2.getLastChild();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"containingClass.lastChild");
                    if (locationLineNumber > FileRankingCalculatorKt.access$getLine(psiElement5)) {
                        return Ranking.Companion.getLOW();
                    }
                }
                ReferenceType referenceType = location2.declaringType();
                Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"location.declaringType()");
                overallRanking = overallRanking.plus(this.rankingForClass(containingClass2, referenceType));
                if (constructorOrInitializer instanceof KtConstructor) {
                    overallRanking = overallRanking.plus(this.rankingForMethod((KtFunction)constructorOrInitializer, method));
                }
                break block38;
            }
            PsiElement psiElement6 = this.findNonLocalCallableParent(elementAt);
            if (psiElement6 == null) {
                return Ranking.Companion.getLOW();
            }
            PsiElement constructorOrInitializer = callable2 = psiElement6;
            if (constructorOrInitializer instanceof KtFunction) {
                ranking = this.rankingForMethod((KtFunction)callable2, method);
            } else if (constructorOrInitializer instanceof KtPropertyAccessor) {
                ranking = this.rankingForAccessor((KtPropertyAccessor)callable2, method);
            } else if (constructorOrInitializer instanceof KtProperty) {
                ranking = this.rankingForProperty((KtProperty)callable2, method);
            } else {
                return Ranking.Companion.getLOW();
            }
            overallRanking = overallRanking.plus(ranking);
            PsiElement $this$getParentOfTypes2$iv = elementAt;
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            KtClassOrObject containingClass4 = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClassOrObject.class, (boolean)strict$iv);
            if (containingClass4 != null) {
                ReferenceType referenceType = location2.declaringType();
                Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"location.declaringType()");
                overallRanking = overallRanking.plus(this.rankingForClass(containingClass4, referenceType));
            }
        }
        return overallRanking;
    }

    /*
     * WARNING - void declaration
     */
    private final KtFunctionLiteral findFunctionLiteralOnLine(PsiElement element3) {
        void $this$getParentOfType$iv;
        void $this$getParentOfType$iv2;
        PsiElement psiElement2 = element3;
        boolean strict$iv22 = false;
        boolean $i$f$getParentOfType = false;
        KtFunctionLiteral literal = (KtFunctionLiteral)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv2, KtFunctionLiteral.class, (boolean)strict$iv22);
        if (literal != null) {
            return literal;
        }
        PsiElement strict$iv22 = element3;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType2 = false;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtCallExpression.class, (boolean)strict$iv);
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        for (KtLambdaArgument lambdaArgument : callExpression2.getLambdaArguments()) {
            int n = FileRankingCalculatorKt.access$getLine(element3);
            KtLambdaArgument ktLambdaArgument = lambdaArgument;
            Intrinsics.checkNotNullExpressionValue((Object)ktLambdaArgument, (String)"lambdaArgument");
            if (n != FileRankingCalculatorKt.access$getLine((PsiElement)ktLambdaArgument)) continue;
            KtLambdaExpression ktLambdaExpression2 = lambdaArgument.getLambdaExpression();
            Object functionLiteral = ktLambdaExpression2 != null ? ktLambdaExpression2.getFunctionLiteral() : null;
            if (functionLiteral == null) continue;
            return functionLiteral;
        }
        return null;
    }

    private final PsiElement findNonLocalCallableParent(PsiElement element3) {
        PsiElement containingCallable;
        while (true) {
            findNonLocalCallableParent.1 $fun$isCallableDeclaration$1 = findNonLocalCallableParent.1.INSTANCE;
            findNonLocalCallableParent.2 $fun$isLocalDeclaration$2 = findNonLocalCallableParent.2.INSTANCE;
            if ($fun$isCallableDeclaration$1.invoke(element3) && !$fun$isLocalDeclaration$2.invoke(element3)) {
                return element3;
            }
            PsiElement $this$getParentOfTypes3$iv = element3;
            boolean $i$f$getParentOfTypes3 = false;
            Class[] classArray = new Class[]{KtProperty.class, KtFunction.class, KtAnonymousInitializer.class};
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfTypes3$iv, (Class[])classArray) == null) {
                return null;
            }
            if (!$fun$isLocalDeclaration$2.invoke(containingCallable)) break;
            element3 = containingCallable;
        }
        return containingCallable;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<String, String> getContainingClassAndMethodNameForLambda(Method $this$getContainingClassAndMethodNameForLambda) {
        void className2;
        List list2;
        ReferenceType referenceType = $this$getContainingClassAndMethodNameForLambda.declaringType();
        if (referenceType == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.sun.jdi.ClassType");
        }
        ClassType declaringClass = (ClassType)referenceType;
        String string = declaringClass.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"declaringClass.name()");
        List list3 = StringsKt.split$default((CharSequence)string, (char[])new char[]{'$'}, (boolean)false, (int)3, (int)2, null);
        boolean bl = false;
        boolean bl2 = false;
        List it = list3;
        boolean bl3 = false;
        List list4 = it.size() == 3 ? list3 : null;
        if (list4 == null) {
            return null;
        }
        list3 = list2 = list4;
        bl = false;
        String string2 = (String)list3.get(0);
        list3 = list2;
        bl = false;
        String methodName2 = (String)list3.get(1);
        return new Pair((Object)className2, (Object)methodName2);
    }

    private final boolean isLambda(Method $this$isLambda) {
        ReferenceType referenceType = $this$isLambda.declaringType();
        if (!(referenceType instanceof ClassType)) {
            referenceType = null;
        }
        ClassType classType = (ClassType)referenceType;
        if (classType == null) {
            return false;
        }
        ClassType declaringClass = classType;
        isLambda.1 $fun$isLambdaClass$1 = isLambda.1.INSTANCE;
        ClassType classType2 = declaringClass.superclass();
        return classType2 != null ? $fun$isLambdaClass$1.invoke(classType2) : false;
    }

    private final KotlinTypeMapper makeTypeMapper(BindingContext bindingContext2) {
        ClassBuilderMode classBuilderMode = ClassBuilderMode.LIGHT_CLASSES;
        Intrinsics.checkNotNullExpressionValue((Object)classBuilderMode, (String)"ClassBuilderMode.LIGHT_CLASSES");
        return new KotlinTypeMapper(bindingContext2, classBuilderMode, "debugger", KotlinTypeMapper.Companion.getLANGUAGE_VERSION_SETTINGS_DEFAULT(), false, null, null, false, null, null, 992, null);
    }

    public FileRankingCalculator(boolean checkClassFqName) {
        this.checkClassFqName = checkClassFqName;
    }

    public /* synthetic */ FileRankingCalculator(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public FileRankingCalculator() {
        this(false, 1, null);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)"FileRankingCalculator");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"FileRankingCalculator\")");
        LOG = logger;
    }

    public static final /* synthetic */ Ranking access$fileRankingSafe(FileRankingCalculator $this, KtFile file2, Location location2) {
        return $this.fileRankingSafe(file2, location2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\t\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000H\u0086\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\t\u0010\f\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking;", "", "value", "", "(I)V", "getValue", "()I", "compareTo", "other", "plus", "toString", "", "unaryMinus", "Companion", "kotlin.jvm-debugger.util"})
    private static final class Ranking
    implements Comparable<Ranking> {
        private final int value;
        @NotNull
        private static final Ranking LOW;
        @NotNull
        private static final Ranking ZERO;
        @NotNull
        private static final Ranking MINOR;
        @NotNull
        private static final Ranking NORMAL;
        @NotNull
        private static final Ranking MAJOR;
        @NotNull
        public static final Companion Companion;

        @NotNull
        public final Ranking unaryMinus() {
            return new Ranking(-this.value);
        }

        @NotNull
        public final Ranking plus(@NotNull Ranking other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return new Ranking(this.value + other.value);
        }

        @Override
        public int compareTo(@NotNull Ranking other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.value - other.value;
        }

        @NotNull
        public String toString() {
            return String.valueOf(this.value);
        }

        public final int getValue() {
            return this.value;
        }

        public Ranking(int value2) {
            this.value = value2;
        }

        static {
            Companion = new Companion(null);
            LOW = new Ranking(-1000);
            ZERO = new Ranking(0);
            MINOR = new Ranking(1);
            NORMAL = new Ranking(5);
            MAJOR = new Ranking(10);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking$Companion;", "", "()V", "LOW", "Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking;", "getLOW", "()Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking;", "MAJOR", "getMAJOR", "MINOR", "getMINOR", "NORMAL", "getNORMAL", "ZERO", "getZERO", "minor", "condition", "", "kotlin.jvm-debugger.util"})
        public static final class Companion {
            @NotNull
            public final Ranking getLOW() {
                return LOW;
            }

            @NotNull
            public final Ranking getZERO() {
                return ZERO;
            }

            @NotNull
            public final Ranking getMINOR() {
                return MINOR;
            }

            @NotNull
            public final Ranking getNORMAL() {
                return NORMAL;
            }

            @NotNull
            public final Ranking getMAJOR() {
                return MAJOR;
            }

            @NotNull
            public final Ranking minor(boolean condition2) {
                return condition2 ? this.getMINOR() : this.getZERO();
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.jvm-debugger.util"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

