/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.RangeMapping;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.codegen.inline.SMAPParser;
import org.jetbrains.kotlin.codegen.inline.SourcePosition;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.SmapUtilKt$WhenMappings;
import org.jetbrains.kotlin.idea.debugger.SourceLineKind;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u001a<\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"mapStacktraceLineToSource", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtFile;", "", "smapData", "Lorg/jetbrains/kotlin/codegen/inline/SMAP;", "line", "project", "Lcom/intellij/openapi/project/Project;", "lineKind", "Lorg/jetbrains/kotlin/idea/debugger/SourceLineKind;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "readDebugInfo", "bytes", "", "kotlin.jvm-debugger.util"})
public final class SmapUtilKt {
    @Nullable
    public static final Pair<KtFile, Integer> mapStacktraceLineToSource(@NotNull SMAP smapData, int line, @NotNull Project project2, @NotNull SourceLineKind lineKind, @NotNull GlobalSearchScope searchScope2) {
        SourcePosition sourcePosition2;
        Intrinsics.checkNotNullParameter((Object)smapData, (String)"smapData");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)lineKind), (String)"lineKind");
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        RangeMapping rangeMapping = smapData.findRange(line);
        if (rangeMapping == null) {
            return null;
        }
        RangeMapping interval = rangeMapping;
        switch (SmapUtilKt$WhenMappings.$EnumSwitchMapping$0[lineKind.ordinal()]) {
            case 1: {
                sourcePosition2 = interval.getCallSite();
                break;
            }
            case 2: {
                sourcePosition2 = interval.mapDestToSource(line);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (sourcePosition2 == null) {
            return null;
        }
        SourcePosition location2 = sourcePosition2;
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)location2.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byInternalName(location.path)");
        JvmClassName jvmName = jvmClassName;
        KtFile ktFile = DebuggerUtils.findSourceFileForClassIncludeLibrarySources$default(DebuggerUtils.INSTANCE, project2, searchScope2, jvmName, location2.getFile(), null, 16, null);
        if (ktFile == null) {
            return null;
        }
        KtFile sourceFile2 = ktFile;
        return TuplesKt.to((Object)sourceFile2, (Object)(location2.getLine() - 1));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final SMAP readDebugInfo(@NotNull byte[] bytes2) {
        SMAP sMAP;
        void debugInfo;
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        ClassReader cr = new ClassReader(bytes2);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        cr.accept(new ClassVisitor((Ref.ObjectRef)debugInfo, 589824){
            final /* synthetic */ Ref.ObjectRef $debugInfo;

            public void visitSource(@Nullable String source, @Nullable String debug) {
                this.$debugInfo.element = debug;
            }
            {
                this.$debugInfo = $captured_local_variable$0;
                super($super_call_param$1);
            }
        }, 0);
        String string = (String)debugInfo.element;
        if (string != null) {
            String string2 = string;
            SMAPParser sMAPParser = SMAPParser.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            String p1 = string2;
            boolean bl3 = false;
            sMAP = sMAPParser.parseOrNull(p1);
        } else {
            sMAP = null;
        }
        return sMAP;
    }
}

