/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.data;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.sun.jdi.Location;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinDebuggerCoroutinesBundle;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinVariableNameFinder;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineStackFrameProxysKt;
import org.jetbrains.kotlin.idea.debugger.stackFrame.KotlinStackFrame;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0000\b\u0016\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0013\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0&*\u00020\u0013H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrame;", "Lorg/jetbrains/kotlin/idea/debugger/stackFrame/KotlinStackFrame;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "spilledVariables", "", "Lcom/intellij/debugger/engine/JavaValue;", "includeFrameVariables", "", "location", "Lcom/sun/jdi/Location;", "(Lcom/intellij/debugger/jdi/StackFrameProxyImpl;Lcom/intellij/xdebugger/XSourcePosition;Ljava/util/List;ZLcom/sun/jdi/Location;)V", "addOptimisedVariables", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "children", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "buildVariablesThreadAction", "debuggerContext", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "createOptimisedVariableMessageNode", "Lcom/intellij/xdebugger/frame/XNamedValue;", "kotlin.jvm.PlatformType", "name", "", "equals", "other", "", "findVisibleVariableNames", "getSourcePosition", "hashCode", "", "getUniqueNames", "", "kotlin.jvm-debugger.coroutines"})
public class CoroutineStackFrame
extends KotlinStackFrame {
    private final XSourcePosition position;
    private final List<JavaValue> spilledVariables;
    private final boolean includeFrameVariables;

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!(object instanceof JavaStackFrame)) {
            object = null;
        }
        JavaStackFrame javaStackFrame = (JavaStackFrame)object;
        if (javaStackFrame == null) {
            return false;
        }
        JavaStackFrame frame = javaStackFrame;
        StackFrameDescriptorImpl stackFrameDescriptorImpl = this.getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)stackFrameDescriptorImpl, (String)"descriptor");
        StackFrameProxyImpl stackFrameProxyImpl = stackFrameDescriptorImpl.getFrameProxy();
        StackFrameDescriptorImpl stackFrameDescriptorImpl2 = frame.getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)stackFrameDescriptorImpl2, (String)"frame.descriptor");
        return Intrinsics.areEqual((Object)stackFrameProxyImpl, (Object)stackFrameDescriptorImpl2.getFrameProxy());
    }

    public int hashCode() {
        StackFrameDescriptorImpl stackFrameDescriptorImpl = this.getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)stackFrameDescriptorImpl, (String)"descriptor");
        return stackFrameDescriptorImpl.getFrameProxy().hashCode();
    }

    protected void buildVariablesThreadAction(@NotNull DebuggerContextImpl debuggerContext, @NotNull XValueChildrenList children2, @NotNull XCompositeNode node2) {
        Intrinsics.checkNotNullParameter((Object)debuggerContext, (String)"debuggerContext");
        Intrinsics.checkNotNullParameter((Object)children2, (String)"children");
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        if (this.includeFrameVariables || this.spilledVariables.isEmpty()) {
            super.buildVariablesThreadAction(debuggerContext, children2, node2);
            DebugProcessImpl debugProcessImpl = debuggerContext.getDebugProcess();
            if (debugProcessImpl == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"debuggerContext.debugProcess ?: return");
            DebugProcessImpl debugProcess = debugProcessImpl;
            this.addOptimisedVariables(debugProcess, children2);
        } else {
            for (JavaValue variable2 : this.spilledVariables) {
                children2.add((XNamedValue)variable2);
            }
        }
    }

    private final void addOptimisedVariables(DebugProcessImpl debugProcess, XValueChildrenList children2) {
        boolean bl;
        Object var9_9;
        Lazy lazy;
        Object var4_3 = null;
        Lazy visibleVariableNames2 = LazyKt.lazy((Function0)((Function0)new Function0<Set<String>>(this, children2){
            final /* synthetic */ CoroutineStackFrame this$0;
            final /* synthetic */ XValueChildrenList $children;

            @NotNull
            public final Set<String> invoke() {
                return CoroutineStackFrame.access$getUniqueNames(this.this$0, this.$children);
            }
            {
                this.this$0 = coroutineStackFrame;
                this.$children = xValueChildrenList;
                super(0);
            }
        }));
        for (JavaValue variable2 : this.spilledVariables) {
            String name2;
            Intrinsics.checkNotNullExpressionValue((Object)variable2.getName(), (String)"variable.name");
            lazy = visibleVariableNames2;
            var9_9 = null;
            bl = false;
            if (((Set)lazy.getValue()).contains(name2)) continue;
            children2.add((XNamedValue)variable2);
            lazy = visibleVariableNames2;
            var9_9 = null;
            bl = false;
            ((Set)lazy.getValue()).add(name2);
        }
        List<String> declaredVariableNames = this.findVisibleVariableNames(debugProcess);
        for (String name3 : declaredVariableNames) {
            lazy = visibleVariableNames2;
            var9_9 = null;
            bl = false;
            if (((Set)lazy.getValue()).contains(name3)) continue;
            children2.add(this.createOptimisedVariableMessageNode(name3));
        }
    }

    private final XNamedValue createOptimisedVariableMessageNode(String name2) {
        return JavaStackFrame.createMessageNode((String)KotlinDebuggerCoroutinesBundle.message("optimised.variable.message", '\'' + name2 + '\''), (Icon)AllIcons.General.Information);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getUniqueNames(XValueChildrenList $this$getUniqueNames) {
        int n = 0;
        Set names = new LinkedHashSet();
        n = 0;
        int n2 = $this$getUniqueNames.size();
        while (n < n2) {
            void i2;
            String string = $this$getUniqueNames.getName((int)i2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(i)");
            names.add(string);
            ++i2;
        }
        return names;
    }

    private final List<String> findVisibleVariableNames(DebugProcessImpl debugProcess) {
        StackFrameProxyImpl stackFrameProxyImpl = this.getStackFrameProxy();
        Intrinsics.checkNotNullExpressionValue((Object)stackFrameProxyImpl, (String)"stackFrameProxy");
        Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)stackFrameProxyImpl);
        if (location2 == null) {
            return CollectionsKt.emptyList();
        }
        Location location3 = location2;
        Object object = ReadAction.nonBlocking((Callable)new Callable(debugProcess, location3){
            final /* synthetic */ DebugProcessImpl $debugProcess;
            final /* synthetic */ Location $location;

            public final List<String> call() {
                return new KotlinVariableNameFinder(this.$debugProcess).findVisibleVariableNames(this.$location);
            }
            {
                this.$debugProcess = debugProcessImpl;
                this.$location = location2;
            }
        }).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ReadAction.nonBlocking<L\u2026 }.executeSynchronously()");
        return (List)object;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        XSourcePosition xSourcePosition = this.position;
        if (xSourcePosition == null) {
            xSourcePosition = super.getSourcePosition();
        }
        return xSourcePosition;
    }

    public CoroutineStackFrame(@NotNull StackFrameProxyImpl frame, @Nullable XSourcePosition position, @NotNull List<? extends JavaValue> spilledVariables, boolean includeFrameVariables, @Nullable Location location2) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter(spilledVariables, (String)"spilledVariables");
        super(CoroutineStackFrameProxysKt.safeCoroutineStackFrameProxy(location2, spilledVariables, frame));
        this.position = position;
        this.spilledVariables = spilledVariables;
        this.includeFrameVariables = includeFrameVariables;
        this.getDescriptor().updateRepresentation(null, DescriptorLabelListener.DUMMY_LISTENER);
    }

    public /* synthetic */ CoroutineStackFrame(StackFrameProxyImpl stackFrameProxyImpl, XSourcePosition xSourcePosition, List list2, boolean bl, Location location2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            location2 = SafeUtilKt.safeLocation((StackFrameProxy)stackFrameProxyImpl);
        }
        this(stackFrameProxyImpl, xSourcePosition, list2, bl, location2);
    }

    public static final /* synthetic */ Set access$getUniqueNames(CoroutineStackFrame $this, XValueChildrenList $this$access_u24getUniqueNames) {
        return $this.getUniqueNames($this$access_u24getUniqueNames);
    }
}

