/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.ReflectionCallMethodVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/ReflectionCallClassPatcher;", "", "()V", "newValue", "", "isEnabled", "()Z", "setEnabled", "(Z)V", "patch", "", "bytes", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "kotlin.jvm-debugger.evaluation"})
public final class ReflectionCallClassPatcher {
    @NotNull
    public static final ReflectionCallClassPatcher INSTANCE;

    public final boolean isEnabled() {
        return Registry.is((String)"kotlin.debugger.evaluator.enable.reflection.patching");
    }

    public final void setEnabled(boolean newValue2) {
        Registry.get((String)"kotlin.debugger.evaluator.enable.reflection.patching").setValue(newValue2);
    }

    @RequiresReadLock
    @NotNull
    public final byte[] patch(@NotNull byte[] bytes2, @NotNull Project project2, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        ClassReader reader = new ClassReader(bytes2);
        ClassWriter writer = new ClassWriter(reader, 1);
        reader.accept(new ClassVisitor(project2, scope2, writer, 589824, (ClassVisitor)writer){
            final /* synthetic */ Project $project;
            final /* synthetic */ GlobalSearchScope $scope;
            final /* synthetic */ ClassWriter $writer;

            @NotNull
            public MethodVisitor visitMethod(int access, @Nullable String name2, @Nullable String descriptor2, @Nullable String signature, @Nullable String[] exceptions) {
                MethodVisitor delegate;
                ProgressManager.checkCanceled();
                MethodVisitor methodVisitor = delegate = super.visitMethod(access, name2, descriptor2, signature, exceptions);
                Intrinsics.checkNotNullExpressionValue((Object)methodVisitor, (String)"delegate");
                return new ReflectionCallMethodVisitor(this.$project, this.$scope, methodVisitor);
            }
            {
                this.$project = $captured_local_variable$0;
                this.$scope = $captured_local_variable$1;
                this.$writer = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        }, 0);
        byte[] byArray = writer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"writer.toByteArray()");
        return byArray;
    }

    private ReflectionCallClassPatcher() {
    }

    static {
        ReflectionCallClassPatcher reflectionCallClassPatcher;
        INSTANCE = reflectionCallClassPatcher = new ReflectionCallClassPatcher();
    }
}

