/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinRequestHint;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinStepIntoRequestHint;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinStepOverRequestHint;

public class KotlinStepActionFactory {
    private static final Logger LOG = Logger.getInstance(KotlinStepActionFactory.class);

    @NotNull
    public static DebugProcessImpl.StepOverCommand createKotlinStepOverCommand(final DebugProcessImpl debugProcess, SuspendContextImpl suspendContext, boolean ignoreBreakpoints, final @NotNull KotlinMethodFilter methodFilter) {
        if (methodFilter == null) {
            KotlinStepActionFactory.$$$reportNull$$$0(0);
        }
        DebugProcessImpl debugProcessImpl = debugProcess;
        Objects.requireNonNull(debugProcessImpl);
        return new DebugProcessImpl.StepOverCommand(debugProcessImpl, suspendContext, ignoreBreakpoints, methodFilter, -2){
            {
                DebugProcessImpl debugProcessImpl2 = x0;
                Objects.requireNonNull(debugProcessImpl2);
                super(debugProcessImpl2, arg0, arg1, arg2, arg3);
            }

            @NotNull
            protected String getStatusText() {
                String string = KotlinDebuggerCoreBundle.message("stepping.over.inline", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
                KotlinStepOverRequestHint hint = new KotlinStepOverRequestHint(stepThread, suspendContext, methodFilter, parentHint);
                hint.setResetIgnoreFilters(!debugProcess.getSession().shouldIgnoreSteppingFilters());
                try {
                    debugProcess.getSession().setIgnoreStepFiltersFlag(stepThread.frameCount());
                }
                catch (EvaluateException e) {
                    LOG.info((Throwable)e);
                }
                KotlinStepOverRequestHint kotlinStepOverRequestHint = hint;
                if (kotlinStepOverRequestHint == null) {
                    1.$$$reportNull$$$0(1);
                }
                return kotlinStepOverRequestHint;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/kotlin/idea/debugger/stepping/KotlinStepActionFactory$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getStatusText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHint";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    public static DebugProcessImpl.StepIntoCommand createKotlinStepIntoCommand(final DebugProcessImpl debugProcess, SuspendContextImpl suspendContext, boolean ignoreBreakpoints, final @Nullable MethodFilter methodFilter) {
        DebugProcessImpl debugProcessImpl = debugProcess;
        Objects.requireNonNull(debugProcessImpl);
        return new DebugProcessImpl.StepIntoCommand(debugProcessImpl, suspendContext, ignoreBreakpoints, methodFilter, -2){
            {
                DebugProcessImpl debugProcessImpl2 = x0;
                Objects.requireNonNull(debugProcessImpl2);
                super(debugProcessImpl2, arg0, arg1, arg2, arg3);
            }

            @NotNull
            public RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
                KotlinStepIntoRequestHint hint = new KotlinStepIntoRequestHint(stepThread, suspendContext, methodFilter, parentHint);
                hint.setResetIgnoreFilters(this.myMethodFilter != null && !debugProcess.getSession().shouldIgnoreSteppingFilters());
                KotlinStepIntoRequestHint kotlinStepIntoRequestHint = hint;
                if (kotlinStepIntoRequestHint == null) {
                    2.$$$reportNull$$$0(0);
                }
                return kotlinStepIntoRequestHint;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/debugger/stepping/KotlinStepActionFactory$2", "getHint"));
            }
        };
    }

    @NotNull
    public static DebugProcessImpl.StepIntoCommand createStepIntoCommand(final DebugProcessImpl debugProcess, SuspendContextImpl suspendContext, boolean ignoreFilters, final @Nullable MethodFilter methodFilter, final int stepSize) {
        DebugProcessImpl debugProcessImpl = debugProcess;
        Objects.requireNonNull(debugProcessImpl);
        return new DebugProcessImpl.StepIntoCommand(debugProcessImpl, suspendContext, ignoreFilters, methodFilter, stepSize){
            {
                DebugProcessImpl debugProcessImpl2 = x0;
                Objects.requireNonNull(debugProcessImpl2);
                super(debugProcessImpl2, arg0, arg1, arg2, arg3);
            }

            @NotNull
            public RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
                KotlinRequestHint hint = new KotlinRequestHint(stepThread, suspendContext, stepSize, 1, methodFilter, parentHint);
                hint.setResetIgnoreFilters(this.myMethodFilter != null && !debugProcess.getSession().shouldIgnoreSteppingFilters());
                KotlinRequestHint kotlinRequestHint = hint;
                if (kotlinRequestHint == null) {
                    3.$$$reportNull$$$0(0);
                }
                return kotlinRequestHint;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/debugger/stepping/KotlinStepActionFactory$3", "getHint"));
            }
        };
    }

    @NotNull
    public static DebugProcessImpl.StepOutCommand createStepOutCommand(final DebugProcessImpl debugProcess, SuspendContextImpl suspendContext) {
        DebugProcessImpl debugProcessImpl = debugProcess;
        Objects.requireNonNull(debugProcessImpl);
        return new DebugProcessImpl.StepOutCommand(debugProcessImpl, suspendContext, -2){
            {
                DebugProcessImpl debugProcessImpl2 = x0;
                Objects.requireNonNull(debugProcessImpl2);
                super(debugProcessImpl2, arg0, arg1);
            }

            @NotNull
            public RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
                KotlinRequestHint hint = new KotlinRequestHint(stepThread, suspendContext, -2, 3, null, parentHint);
                hint.setIgnoreFilters(debugProcess.getSession().shouldIgnoreSteppingFilters());
                KotlinRequestHint kotlinRequestHint = hint;
                if (kotlinRequestHint == null) {
                    4.$$$reportNull$$$0(0);
                }
                return kotlinRequestHint;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/debugger/stepping/KotlinStepActionFactory$4", "getHint"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodFilter", "org/jetbrains/kotlin/idea/debugger/stepping/KotlinStepActionFactory", "createKotlinStepOverCommand"));
    }
}

