/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.configuration;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.PlatformUtils;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.gradle.configuration.KotlinResolverUtilKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007\u001a\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007\u001a2\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\b\b\u0001\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0002\"$\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u00018B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0002\u0010\u0003\"\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"$\u0010\b\u001a\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u00018B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\u0003\"\u0004\b\t\u0010\u0005\u00a8\u0006\u0014"}, d2={"value", "", "isKotlinJSInspectionsPackSuggestionEnabled", "()Z", "setKotlinJSInspectionsPackSuggestionEnabled", "(Z)V", "isKotlinJSInspectionsPackSuggestionEnabledPropertyName", "", "isNativeDebugSuggestionEnabled", "setNativeDebugSuggestionEnabled", "suggestKotlinJsInspectionPackPlugin", "", "projectPath", "suggestNativeDebug", "suggestPluginInstall", "notificationContent", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "onDontShowAgainActionPerformed", "Lkotlin/Function0;", "kotlin.gradle.gradle-idea"})
public final class KotlinResolverUtilKt {
    private static final String isKotlinJSInspectionsPackSuggestionEnabledPropertyName = "isKotlinJSInspectionsPackSuggestionEnabled";

    private static final boolean isNativeDebugSuggestionEnabled() {
        return PropertiesComponent.getInstance().getBoolean("isNativeDebugSuggestionEnabled", true);
    }

    private static final void setNativeDebugSuggestionEnabled(boolean value2) {
        PropertiesComponent.getInstance().setValue("isNativeDebugSuggestionEnabled", value2);
    }

    private static final boolean isKotlinJSInspectionsPackSuggestionEnabled() {
        return PropertiesComponent.getInstance().getBoolean(isKotlinJSInspectionsPackSuggestionEnabledPropertyName, true);
    }

    private static final void setKotlinJSInspectionsPackSuggestionEnabled(boolean value2) {
        PropertiesComponent.getInstance().setValue(isKotlinJSInspectionsPackSuggestionEnabledPropertyName, value2);
    }

    public static final void suggestNativeDebug(@NotNull String projectPath2) {
        Intrinsics.checkNotNullParameter((Object)projectPath2, (String)"projectPath");
        if (!KotlinResolverUtilKt.isNativeDebugSuggestionEnabled()) {
            return;
        }
        String string = KotlinIdeaGradleBundle.message("notification.text.native.debug.provides.debugger.for.kotlin.native", new Object[0]);
        PluginId pluginId = PluginId.getId((String)"com.intellij.nativeDebug");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"PluginId.getId(\"com.intellij.nativeDebug\")");
        KotlinResolverUtilKt.suggestPluginInstall(projectPath2, string, pluginId, (Function0<Unit>)((Function0)suggestNativeDebug.1.INSTANCE));
    }

    public static final void suggestKotlinJsInspectionPackPlugin(@NotNull String projectPath2) {
        Intrinsics.checkNotNullParameter((Object)projectPath2, (String)"projectPath");
        if (!KotlinResolverUtilKt.isKotlinJSInspectionsPackSuggestionEnabled()) {
            return;
        }
        String string = KotlinIdeaGradleBundle.message("notification.text.kotlin.js.inspections.pack.provides.inspections.and.quick.fixes.for.kotlin.js", new Object[0]);
        PluginId pluginId = PluginId.getId((String)"org.jetbrains.kotlin-js-inspection-pack-plugin");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"PluginId.getId(\"org.jetb\u2026-inspection-pack-plugin\")");
        KotlinResolverUtilKt.suggestPluginInstall(projectPath2, string, pluginId, (Function0<Unit>)((Function0)suggestKotlinJsInspectionPackPlugin.1.INSTANCE));
    }

    private static final void suggestPluginInstall(String projectPath2, @NlsContexts.NotificationContent String notificationContent, PluginId pluginId, Function0<Unit> onDontShowAgainActionPerformed) {
        Project project2;
        block4: {
            ProjectManager projectManager;
            if (!PlatformUtils.isIdeaUltimate()) {
                return;
            }
            if (PluginManagerCore.isPluginInstalled((PluginId)pluginId)) {
                return;
            }
            ProjectManager projectManager2 = projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager2, (String)"projectManager");
            Project[] projectArray = projectManager2.getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"projectManager.openProjects");
            Project[] $this$firstOrNull$iv = projectArray;
            boolean $i$f$firstOrNull = false;
            Project[] projectArray2 = $this$firstOrNull$iv;
            int n = projectArray2.length;
            for (int j = 0; j < n; ++j) {
                Project element$iv;
                Project it = element$iv = projectArray2[j];
                boolean bl = false;
                Project project3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"it");
                if (!Intrinsics.areEqual((Object)project3.getBasePath(), (Object)projectPath2)) continue;
                project2 = element$iv;
                break block4;
            }
            project2 = null;
        }
        if (project2 == null) {
            return;
        }
        Project project4 = project2;
        PluginsAdvertiser.getNotificationGroup().createNotification(KotlinIdeaGradleBundle.message("notification.title.plugin.suggestion", new Object[0]), notificationContent, NotificationType.INFORMATION).addAction((AnAction)new NotificationAction(project4, pluginId, KotlinIdeaGradleBundle.message("action.text.install", new Object[0])){
            final /* synthetic */ Project $project;
            final /* synthetic */ PluginId $pluginId;

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                PluginsAdvertiser.installAndEnable$default((Project)this.$project, (Set)SetsKt.setOf((Object)this.$pluginId), (boolean)false, (Runnable)new Runnable(notification2){
                    final /* synthetic */ Notification $notification;

                    public final void run() {
                        this.$notification.expire();
                    }
                    {
                        this.$notification = notification2;
                    }
                }, (int)4, null);
            }
            {
                this.$project = $captured_local_variable$0;
                this.$pluginId = $captured_local_variable$1;
                super($super_call_param$2);
            }
        }).addAction((AnAction)new NotificationAction(onDontShowAgainActionPerformed, KotlinIdeaGradleBundle.message("action.text.dontShowAgain", new Object[0])){
            final /* synthetic */ Function0 $onDontShowAgainActionPerformed;

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                this.$onDontShowAgainActionPerformed.invoke();
                notification2.expire();
            }
            {
                this.$onDontShowAgainActionPerformed = $captured_local_variable$0;
                super($super_call_param$1);
            }
        }).notify(project4);
    }

    static /* synthetic */ void suggestPluginInstall$default(String string, String string2, PluginId pluginId, Function0 function0, int n, Object object) {
        if ((n & 8) != 0) {
            function0 = suggestPluginInstall.1.INSTANCE;
        }
        KotlinResolverUtilKt.suggestPluginInstall(string, string2, pluginId, (Function0<Unit>)function0);
    }

    public static final /* synthetic */ boolean access$isNativeDebugSuggestionEnabled$p() {
        return KotlinResolverUtilKt.isNativeDebugSuggestionEnabled();
    }

    public static final /* synthetic */ void access$setNativeDebugSuggestionEnabled$p(boolean bl) {
        KotlinResolverUtilKt.setNativeDebugSuggestionEnabled(bl);
    }

    public static final /* synthetic */ boolean access$isKotlinJSInspectionsPackSuggestionEnabled$p() {
        return KotlinResolverUtilKt.isKotlinJSInspectionsPackSuggestionEnabled();
    }

    public static final /* synthetic */ void access$setKotlinJSInspectionsPackSuggestionEnabled$p(boolean bl) {
        KotlinResolverUtilKt.setKotlinJSInspectionsPackSuggestionEnabled(bl);
    }
}

