/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.extensions.KotlinJvmDebuggerFacade;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0010H\u0016J\u0016\u0010\u0011\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinGradleCoroutineDebugProjectResolver;", "Lorg/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension;", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "enhanceTaskProcessing", "", "taskNames", "", "", "initScriptConsumer", "Lcom/intellij/util/Consumer;", "parameters", "", "setupCoroutineAgentForJvmForkedTestTasks", "kotlin.gradle.gradle-java"})
public final class KotlinGradleCoroutineDebugProjectResolver
extends AbstractProjectResolverExtension {
    @NotNull
    private final Logger log;

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @NotNull Consumer<String> initScriptConsumer, @NotNull Map<String, String> parameters2) {
        Intrinsics.checkNotNullParameter(taskNames, (String)"taskNames");
        Intrinsics.checkNotNullParameter(initScriptConsumer, (String)"initScriptConsumer");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        try {
            boolean allowCoroutineAgent;
            KotlinJvmDebuggerFacade kotlinJvmDebuggerFacade = KotlinJvmDebuggerFacade.Companion.getInstance();
            boolean bl = allowCoroutineAgent = kotlinJvmDebuggerFacade != null ? kotlinJvmDebuggerFacade.isCoroutineAgentAllowedInDebug() : false;
            if (allowCoroutineAgent && parameters2.containsKey("DEBUG_DISPATCH_PORT")) {
                this.setupCoroutineAgentForJvmForkedTestTasks(initScriptConsumer);
            }
        }
        catch (Exception e) {
            this.log.error("Gradle: not possible to attach a coroutine debugger agent.", (Throwable)e);
        }
    }

    private final void setupCoroutineAgentForJvmForkedTestTasks(Consumer<String> initScriptConsumer) {
        String script = "gradle.taskGraph.whenReady { TaskExecutionGraph taskGraph ->\n    taskGraph.allTasks.each { Task task ->\n        if (task instanceof Test || task instanceof JavaExec) {\n            task.doFirst { Task forkedTask ->\n                def kotlinxCoroutinesCoreJar = forkedTask.classpath.find { it.name.startsWith(\"kotlinx-coroutines-core\") }\n                if (kotlinxCoroutinesCoreJar) {\n                    def results = (kotlinxCoroutinesCoreJar.getName() =~ /kotlinx-coroutines-core(\\-jvm)?-(\\d[\\w\\.\\-]+)\\.jar$/).findAll()\n                    if (results) {\n                        def version = results.first()[2]\n                        def referenceVersion = org.gradle.util.VersionNumber.parse('1.3.7-255')\n                        if (org.gradle.util.VersionNumber.parse(version) > referenceVersion) {\n                            forkedTask.jvmArgs (\"-javaagent:${kotlinxCoroutinesCoreJar?.absolutePath}\", \"-ea\")\n                        }\n                    }\n                }\n            }\n        }\n    }\n}";
        initScriptConsumer.consume((Object)script);
    }

    public KotlinGradleCoroutineDebugProjectResolver() {
        Logger logger = Logger.getInstance(((Object)((Object)this)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(this::class.java)");
        this.log = logger;
    }
}

