/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleTooling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinSourceSetContainer;
import org.jetbrains.kotlin.idea.projectModel.KotlinSourceSet;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\r*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0002\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000f"}, d2={"sourceSets", "", "Lorg/jetbrains/kotlin/idea/projectModel/KotlinSourceSet;", "Lorg/jetbrains/kotlin/idea/gradleTooling/KotlinSourceSetContainer;", "getSourceSets", "(Lorg/jetbrains/kotlin/idea/gradleTooling/KotlinSourceSetContainer;)Ljava/util/List;", "isDependsOn", "", "from", "to", "model", "sourceSet", "resolveAllDependsOnSourceSets", "", "resolveDeclaredDependsOnSourceSets", "kotlin.gradle.gradle-tooling"})
public final class KotlinSourceSetContainerKt {
    @NotNull
    public static final List<KotlinSourceSet> getSourceSets(@NotNull KotlinSourceSetContainer $this$sourceSets) {
        Intrinsics.checkNotNullParameter((Object)$this$sourceSets, (String)"$this$sourceSets");
        return CollectionsKt.toList((Iterable)$this$sourceSets.getSourceSetsByName().values());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<KotlinSourceSet> resolveDeclaredDependsOnSourceSets(@NotNull KotlinSourceSetContainer $this$resolveDeclaredDependsOnSourceSets, @NotNull KotlinSourceSet sourceSet) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$resolveDeclaredDependsOnSourceSets, (String)"$this$resolveDeclaredDependsOnSourceSets");
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        Iterable $this$mapNotNull$iv = sourceSet.getDeclaredDependsOnSourceSets();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            KotlinSourceSet kotlinSourceSet;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String name2 = (String)element$iv$iv;
            boolean bl2 = false;
            if ($this$resolveDeclaredDependsOnSourceSets.getSourceSetsByName().get(name2) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            KotlinSourceSet it$iv$iv = kotlinSourceSet;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final Set<KotlinSourceSet> resolveAllDependsOnSourceSets(@NotNull KotlinSourceSetContainer $this$resolveAllDependsOnSourceSets, @NotNull KotlinSourceSet sourceSet) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveAllDependsOnSourceSets, (String)"$this$resolveAllDependsOnSourceSets");
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        if (sourceSet.getDeclaredDependsOnSourceSets().isEmpty()) {
            return SetsKt.emptySet();
        }
        boolean bl = false;
        Set resolvedSourceSets = new LinkedHashSet();
        ArrayDeque declaredDependsOnSourceSetsQueue = new ArrayDeque();
        declaredDependsOnSourceSetsQueue.addAll((Collection)sourceSet.getDeclaredDependsOnSourceSets());
        while (true) {
            Collection collection = (Collection)declaredDependsOnSourceSetsQueue;
            boolean bl2 = false;
            if (!(!collection.isEmpty())) break;
            String sourceSetName = (String)declaredDependsOnSourceSetsQueue.removeFirst();
            KotlinSourceSet resolvedSourceSet = $this$resolveAllDependsOnSourceSets.getSourceSetsByName().get(sourceSetName);
            if (resolvedSourceSet == null || !resolvedSourceSets.add(resolvedSourceSet)) continue;
            declaredDependsOnSourceSetsQueue.addAll((Collection)resolvedSourceSet.getDeclaredDependsOnSourceSets());
        }
        return resolvedSourceSets;
    }

    public static final boolean isDependsOn(@NotNull KotlinSourceSetContainer $this$isDependsOn, @NotNull KotlinSourceSet from, @NotNull KotlinSourceSet to) {
        Intrinsics.checkNotNullParameter((Object)$this$isDependsOn, (String)"$this$isDependsOn");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return KotlinSourceSetContainerKt.resolveAllDependsOnSourceSets($this$isDependsOn, from).contains(to);
    }

    public static final boolean isDependsOn(@NotNull KotlinSourceSet $this$isDependsOn, @NotNull KotlinSourceSetContainer model2, @NotNull KotlinSourceSet sourceSet) {
        Intrinsics.checkNotNullParameter((Object)$this$isDependsOn, (String)"$this$isDependsOn");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        return KotlinSourceSetContainerKt.isDependsOn(model2, $this$isDependsOn, sourceSet);
    }
}

