/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.highlighter.AbstractAnnotationHolderHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.AbstractHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/BeforeResolveHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/AbstractAnnotationHolderHighlightingVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "visitArgument", "", "argument", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "visitElement", "element", "Lcom/intellij/psi/PsiElement;", "visitExpressionWithLabel", "expression", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitSuperTypeCallEntry", "call", "Lorg/jetbrains/kotlin/psi/KtSuperTypeCallEntry;", "visitTypeParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "willApplyRainbowHighlight", "", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocLink;", "kotlin.fir.frontend-independent"})
public final class BeforeResolveHighlightingVisitor
extends AbstractAnnotationHolderHighlightingVisitor {
    public void visitElement(@NotNull PsiElement element3) {
        TextAttributesKey attributes;
        TextAttributesKey textAttributesKey;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        ASTNode aSTNode = element3.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.node");
        IElementType iElementType = aSTNode.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"element.node.elementType");
        IElementType elementType = iElementType;
        if (element3 instanceof KDocLink && !this.willApplyRainbowHighlight((KDocLink)element3)) {
            textAttributesKey = KotlinHighlightingColors.KDOC_LINK;
        } else if (KtTokens.SOFT_KEYWORDS.contains(elementType)) {
            IElementType iElementType2 = elementType;
            textAttributesKey = KtTokens.MODIFIER_KEYWORDS.contains(iElementType2) ? KotlinHighlightingColors.BUILTIN_ANNOTATION : KotlinHighlightingColors.KEYWORD;
        } else if (Intrinsics.areEqual((Object)elementType, (Object)KtTokens.SAFE_ACCESS)) {
            textAttributesKey = KotlinHighlightingColors.SAFE_ACCESS;
        } else if (Intrinsics.areEqual((Object)elementType, (Object)KtTokens.EXCLEXCL)) {
            textAttributesKey = KotlinHighlightingColors.EXCLEXCL;
        } else {
            return;
        }
        TextAttributesKey textAttributesKey2 = attributes = textAttributesKey;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"attributes");
        AbstractHighlightingVisitor.createInfoAnnotation$default((AbstractHighlightingVisitor)this, element3, null, textAttributesKey2, 2, null);
    }

    private final boolean willApplyRainbowHighlight(KDocLink element3) {
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        if (!RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)((TextAttributesScheme)editorColorsManager.getGlobalScheme()), (Language)((Language)KotlinLanguage.INSTANCE))) {
            return false;
        }
        PsiElement psiElement2 = element3.getParent();
        if (!(psiElement2 instanceof KDocTag)) {
            psiElement2 = null;
        }
        KDocTag kDocTag = (KDocTag)psiElement2;
        return (kDocTag != null ? kDocTag.getKnownTag() : null) == KDocKnownTag.PARAM;
    }

    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression2) {
        PsiElement arrow2;
        Intrinsics.checkNotNullParameter((Object)lambdaExpression2, (String)"lambdaExpression");
        boolean $i$f$isUnitTestMode = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        KtFunctionLiteral ktFunctionLiteral = lambdaExpression2.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"lambdaExpression.functionLiteral");
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        PsiElement psiElement2 = functionLiteral.getLBrace();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"functionLiteral.lBrace");
        TextAttributesKey textAttributesKey = KotlinHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"KotlinHighlightingColors\u2026_LITERAL_BRACES_AND_ARROW");
        AbstractHighlightingVisitor.createInfoAnnotation$default((AbstractHighlightingVisitor)this, psiElement2, null, textAttributesKey, 2, null);
        PsiElement closingBrace = functionLiteral.getRBrace();
        if (closingBrace != null) {
            TextAttributesKey textAttributesKey2 = KotlinHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"KotlinHighlightingColors\u2026_LITERAL_BRACES_AND_ARROW");
            AbstractHighlightingVisitor.createInfoAnnotation$default((AbstractHighlightingVisitor)this, closingBrace, null, textAttributesKey2, 2, null);
        }
        if ((arrow2 = functionLiteral.getArrow()) != null) {
            TextAttributesKey textAttributesKey3 = KotlinHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey3, (String)"KotlinHighlightingColors\u2026_LITERAL_BRACES_AND_ARROW");
            AbstractHighlightingVisitor.createInfoAnnotation$default((AbstractHighlightingVisitor)this, arrow2, null, textAttributesKey3, 2, null);
        }
    }

    public void visitArgument(@NotNull KtValueArgument argument2) {
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        KtValueArgumentName ktValueArgumentName = argument2.getArgumentName();
        if (ktValueArgumentName == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktValueArgumentName, (String)"argument.getArgumentName() ?: return");
        KtValueArgumentName argumentName = ktValueArgumentName;
        PsiElement psiElement2 = argument2.getEqualsToken();
        if (psiElement2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"argument.equalsToken ?: return");
        PsiElement eq = psiElement2;
        TextRange textRange = new TextRange(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)argumentName)), PsiUtilsKt.getEndOffset((PsiElement)eq));
        PsiElement psiElement3 = argument2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"argument.parent");
        AbstractHighlightingVisitor.createInfoAnnotation$default((AbstractHighlightingVisitor)this, textRange, null, psiElement3.getParent() instanceof KtAnnotationEntry ? KotlinHighlightingColors.ANNOTATION_ATTRIBUTE_NAME_ATTRIBUTES : KotlinHighlightingColors.NAMED_ARGUMENT, 2, null);
    }

    public void visitExpressionWithLabel(@NotNull KtExpressionWithLabel expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtSimpleNameExpression targetLabel = expression2.getTargetLabel();
        if (targetLabel != null) {
            PsiElement psiElement2 = (PsiElement)targetLabel;
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.LABEL;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"KotlinHighlightingColors.LABEL");
            AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, psiElement2, textAttributesKey, null, 4, null);
        }
    }

    public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call) {
        KtTypeElement typeElement;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        KtConstructorCalleeExpression ktConstructorCalleeExpression = call.getCalleeExpression();
        Intrinsics.checkNotNullExpressionValue((Object)ktConstructorCalleeExpression, (String)"call.calleeExpression");
        KtConstructorCalleeExpression calleeExpression2 = ktConstructorCalleeExpression;
        KtTypeReference ktTypeReference = calleeExpression2.getTypeReference();
        Object object = typeElement = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
        if (typeElement instanceof KtUserType) {
            KtSimpleNameExpression ktSimpleNameExpression = ((KtUserType)typeElement).getReferenceExpression();
            if (ktSimpleNameExpression != null) {
                KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression;
                boolean bl = false;
                boolean bl2 = false;
                KtSimpleNameExpression it = ktSimpleNameExpression2;
                boolean bl3 = false;
                KtSimpleNameExpression ktSimpleNameExpression3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression3, (String)"it");
                PsiElement psiElement2 = (PsiElement)ktSimpleNameExpression3;
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.CONSTRUCTOR_CALL;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"KotlinHighlightingColors.CONSTRUCTOR_CALL");
                AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, psiElement2, textAttributesKey, null, 4, null);
            }
        }
        super.visitSuperTypeCallEntry(call);
    }

    public void visitTypeParameter(@NotNull KtTypeParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        PsiElement psiElement2 = parameter.getNameIdentifier();
        if (psiElement2 != null) {
            PsiElement psiElement3 = psiElement2;
            boolean bl = false;
            boolean bl2 = false;
            PsiElement it = psiElement3;
            boolean bl3 = false;
            PsiElement psiElement4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"it");
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.TYPE_PARAMETER;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"KotlinHighlightingColors.TYPE_PARAMETER");
            AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, psiElement4, textAttributesKey, null, 4, null);
        }
        super.visitTypeParameter(parameter);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)function2;
        TextAttributesKey textAttributesKey = KotlinHighlightingColors.FUNCTION_DECLARATION;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"KotlinHighlightingColors.FUNCTION_DECLARATION");
        this.highlightNamedDeclaration(ktNamedDeclaration, textAttributesKey);
        super.visitNamedFunction(function2);
    }

    public BeforeResolveHighlightingVisitor(@NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(holder);
    }
}

