/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.KotlinIdeaAnalysisBundle;
import org.jetbrains.kotlin.idea.highlighter.AbstractHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingUtil;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ImplicitSmartCasts;
import org.jetbrains.kotlin.resolve.calls.smartcasts.MultipleSmartCasts;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.CaptureKind;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "getSmartCastTarget", "Lcom/intellij/psi/PsiElement;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "highlightVariable", "", "elementToHighlight", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "visitDestructuringDeclarationEntry", "multiDeclarationEntry", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "visitExpression", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitVariableDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "kotlin.core"})
public final class VariablesHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)expression2);
        if (declarationDescriptor == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"bindingContext.get(REFER\u2026ET, expression) ?: return");
        DeclarationDescriptor target2 = declarationDescriptor;
        if (target2 instanceof ValueParameterDescriptor && Intrinsics.areEqual((Object)((Boolean)this.getBindingContext().get((ReadOnlySlice)BindingContext.AUTO_CREATED_IT, (Object)target2)), (Object)true)) {
            PsiElement psiElement2 = (PsiElement)expression2;
            String string = KotlinIdeaAnalysisBundle.message("automatically.declared.based.on.the.expected.type", new Object[0]);
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.FUNCTION_LITERAL_DEFAULT_PARAMETER;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"FUNCTION_LITERAL_DEFAULT_PARAMETER");
            this.createInfoAnnotation(psiElement2, string, textAttributesKey);
        } else if (!(expression2.getParent() instanceof KtValueArgumentName)) {
            this.highlightVariable((PsiElement)expression2, target2);
        }
        super.visitSimpleNameExpression(expression2);
    }

    public void visitProperty(@NotNull KtProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        this.visitVariableDeclaration((KtNamedDeclaration)property2);
        super.visitProperty(property2);
    }

    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, (Object)parameter);
        if (propertyDescriptor == null) {
            this.visitVariableDeclaration((KtNamedDeclaration)parameter);
        }
        super.visitParameter(parameter);
    }

    public void visitDestructuringDeclarationEntry(@NotNull KtDestructuringDeclarationEntry multiDeclarationEntry) {
        Intrinsics.checkNotNullParameter((Object)multiDeclarationEntry, (String)"multiDeclarationEntry");
        this.visitVariableDeclaration((KtNamedDeclaration)multiDeclarationEntry);
        super.visitDestructuringDeclarationEntry(multiDeclarationEntry);
    }

    private final PsiElement getSmartCastTarget(KtExpression expression2) {
        PsiElement psiElement2;
        PsiElement psiElement3;
        PsiElement target2 = (PsiElement)expression2;
        if (target2 instanceof KtParenthesizedExpression) {
            KtExpression ktExpression = KtPsiUtil.deparenthesize((KtExpression)((KtExpression)target2));
            PsiElement psiElement4 = target2 = ktExpression != null ? (PsiElement)ktExpression : (PsiElement)expression2;
        }
        if ((psiElement3 = target2) instanceof KtIfExpression) {
            PsiElement psiElement5 = ((KtIfExpression)target2).getIfKeyword();
            psiElement2 = psiElement5;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"target.ifKeyword");
        } else if (psiElement3 instanceof KtWhenExpression) {
            PsiElement psiElement6 = ((KtWhenExpression)target2).getWhenKeyword();
            psiElement2 = psiElement6;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement6, (String)"target.whenKeyword");
        } else if (psiElement3 instanceof KtBinaryExpression) {
            KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)target2).getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"target.operationReference");
            psiElement2 = (PsiElement)ktOperationReferenceExpression;
        } else {
            psiElement2 = target2;
        }
        return psiElement2;
    }

    /*
     * WARNING - void declaration
     */
    public void visitExpression(@NotNull KtExpression expression2) {
        ExplicitSmartCasts smartCast;
        boolean nullSmartCast;
        Map map2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        ImplicitSmartCasts implicitSmartCast = (ImplicitSmartCasts)this.getBindingContext().get((ReadOnlySlice)BindingContext.IMPLICIT_RECEIVER_SMARTCAST, (Object)expression2);
        if (implicitSmartCast != null) {
            Map map3 = implicitSmartCast.getReceiverTypes();
            boolean bl = false;
            for (Map.Entry entry : map3.entrySet()) {
                void receiver2;
                object = entry;
                boolean bl2 = false;
                map3 = (ImplicitReceiver)object.getKey();
                object = entry;
                bl2 = false;
                KotlinType type2 = (KotlinType)object.getValue();
                map2 = receiver2;
                String receiverName = map2 instanceof ExtensionReceiver ? KotlinIdeaAnalysisBundle.message("extension.implicit.receiver", new Object[0]) : (map2 instanceof ImplicitClassReceiver ? KotlinIdeaAnalysisBundle.message("implicit.receiver", new Object[0]) : KotlinIdeaAnalysisBundle.message("unknown.receiver", new Object[0]));
                PsiElement psiElement2 = (PsiElement)expression2;
                String string = KotlinIdeaAnalysisBundle.message("0.smart.cast.to.1", receiverName, DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type2));
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.SMART_CAST_RECEIVER;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"SMART_CAST_RECEIVER");
                this.createInfoAnnotation(psiElement2, string, textAttributesKey);
            }
        }
        if (nullSmartCast = Intrinsics.areEqual((Object)((Boolean)this.getBindingContext().get((ReadOnlySlice)BindingContext.SMARTCAST_NULL, (Object)expression2)), (Object)true)) {
            PsiElement psiElement3 = (PsiElement)expression2;
            String string = KotlinIdeaAnalysisBundle.message("always.null", new Object[0]);
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.SMART_CONSTANT;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"SMART_CONSTANT");
            this.createInfoAnnotation(psiElement3, string, textAttributesKey);
        }
        if ((smartCast = (ExplicitSmartCasts)this.getBindingContext().get((ReadOnlySlice)BindingContext.SMARTCAST, (Object)expression2)) != null) {
            KotlinType defaultType2 = smartCast.getDefaultType();
            if (defaultType2 != null) {
                PsiElement psiElement4 = this.getSmartCastTarget(expression2);
                String string = KotlinIdeaAnalysisBundle.message("smart.cast.to.0", DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(defaultType2));
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.SMART_CAST_VALUE;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"SMART_CAST_VALUE");
                this.createInfoAnnotation(psiElement4, string, textAttributesKey);
            } else if (smartCast instanceof MultipleSmartCasts) {
                map2 = ((MultipleSmartCasts)smartCast).getMap();
                boolean bl = false;
                object = map2.entrySet().iterator();
                while (object.hasNext()) {
                    void call;
                    Map.Entry entry;
                    Map.Entry entry2 = entry = (Map.Entry)object.next();
                    boolean bl3 = false;
                    map2 = (Call)entry2.getKey();
                    entry2 = entry;
                    bl3 = false;
                    KotlinType type3 = (KotlinType)entry2.getValue();
                    PsiElement psiElement5 = this.getSmartCastTarget(expression2);
                    String string = KotlinIdeaAnalysisBundle.message("smart.cast.to.0.for.1.call", DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type3), String.valueOf(call));
                    TextAttributesKey textAttributesKey = KotlinHighlightingColors.SMART_CAST_VALUE;
                    Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"SMART_CAST_VALUE");
                    this.createInfoAnnotation(psiElement5, string, textAttributesKey);
                }
            }
        }
        super.visitExpression(expression2);
    }

    private final void visitVariableDeclaration(KtNamedDeclaration declaration2) {
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)declaration2);
        PsiElement nameIdentifier = declaration2.getNameIdentifier();
        if (nameIdentifier != null && declarationDescriptor != null) {
            this.highlightVariable(nameIdentifier, declarationDescriptor);
        }
    }

    private final void highlightVariable(PsiElement elementToHighlight, DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof VariableDescriptor) {
            if (DynamicCallsKt.isDynamic((DeclarationDescriptor)descriptor2)) {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.DYNAMIC_PROPERTY_CALL;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DYNAMIC_PROPERTY_CALL");
                AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, elementToHighlight, textAttributesKey, null, 4, null);
                return;
            }
            if (((VariableDescriptor)descriptor2).isVar()) {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.MUTABLE_VARIABLE;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"MUTABLE_VARIABLE");
                AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, elementToHighlight, textAttributesKey, null, 4, null);
            }
            if ((CaptureKind)this.getBindingContext().get((ReadOnlySlice)BindingContext.CAPTURED_IN_CLOSURE, (Object)descriptor2) == CaptureKind.NOT_INLINE) {
                String msg2 = ((VariableDescriptor)descriptor2).isVar() ? KotlinIdeaAnalysisBundle.message("wrapped.into.a.reference.object.to.be.modified.when.captured.in.a.closure", new Object[0]) : KotlinIdeaAnalysisBundle.message("value.captured.in.a.closure", new Object[0]);
                PsiElement parent2 = elementToHighlight.getParent();
                if (!(parent2 instanceof PsiNameIdentifierOwner) || !Intrinsics.areEqual((Object)((PsiNameIdentifierOwner)parent2).getNameIdentifier(), (Object)elementToHighlight)) {
                    TextAttributesKey textAttributesKey = KotlinHighlightingColors.WRAPPED_INTO_REF;
                    Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"WRAPPED_INTO_REF");
                    this.createInfoAnnotation(elementToHighlight, msg2, textAttributesKey);
                    return;
                }
            }
            if (descriptor2 instanceof LocalVariableDescriptor && !(descriptor2 instanceof SyntheticFieldDescriptor)) {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.LOCAL_VARIABLE;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"LOCAL_VARIABLE");
                AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, elementToHighlight, textAttributesKey, null, 4, null);
            }
            if (descriptor2 instanceof ValueParameterDescriptor) {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.PARAMETER;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"PARAMETER");
                AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, elementToHighlight, textAttributesKey, null, 4, null);
            }
            if (descriptor2 instanceof PropertyDescriptor && KotlinHighlightingUtil.INSTANCE.hasCustomPropertyDeclaration((PropertyDescriptor)descriptor2)) {
                boolean isStaticDeclaration = DescriptorUtils.isStaticDeclaration((CallableDescriptor)((CallableDescriptor)descriptor2));
                TextAttributesKey textAttributesKey = isStaticDeclaration ? KotlinHighlightingColors.PACKAGE_PROPERTY_CUSTOM_PROPERTY_DECLARATION : KotlinHighlightingColors.INSTANCE_PROPERTY_CUSTOM_PROPERTY_DECLARATION;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"if (isStaticDeclaration)\u2026STOM_PROPERTY_DECLARATION");
                AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, elementToHighlight, textAttributesKey, null, 4, null);
            }
        }
    }

    public VariablesHighlightingVisitor(@NotNull HighlightInfoHolder holder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
        super(holder, bindingContext2);
    }
}

