/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.configuration.GradleDetectorKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/JavaOutsideModuleDetector;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getKey", "Lcom/intellij/openapi/util/Key;", "Companion", "kotlin.jvm"})
public final class JavaOutsideModuleDetector
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private final Project project;
    private static final Key<EditorNotificationPanel> KEY;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        boolean bl;
        block9: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
            if (Intrinsics.areEqual((Object)file2.getFileType(), (Object)JavaFileType.INSTANCE) ^ true) {
                return null;
            }
            Module module2 = ProjectRootsUtilKt.findModule(file2, this.project);
            if (module2 == null) {
                return null;
            }
            Module module3 = module2;
            if (!GradleDetectorKt.isGradleModule(module3)) {
                return null;
            }
            Object object = KotlinFacet.Companion.get(module3);
            if (object == null || (object = (KotlinFacetConfiguration)object.getConfiguration()) == null || (object = object.getSettings()) == null) {
                return null;
            }
            KotlinFacet facetSettings = object;
            String string = file2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            String filePath = string;
            VirtualFile[] $this$map$iv = ProjectRootsUtilKt.getSourceRoots(module3);
            boolean $i$f$map = false;
            VirtualFile[] virtualFileArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var12_13 = $this$mapTo$iv$iv;
            int n = ((void)var12_13).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var16_18 = item$iv$iv = var12_13[j];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string2 = it.getPath();
                collection.add(string2);
            }
            List nonKotlinPath = CollectionsKt.minus((Iterable)((List)destination$iv$iv), (Iterable)facetSettings.getPureKotlinSourceFolders());
            Iterable $this$any$iv = nonKotlinPath;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    String string3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
                    if (!StringsKt.startsWith$default((String)filePath, (String)string3, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        EditorNotificationPanel editorNotificationPanel = new EditorNotificationPanel();
        boolean bl4 = false;
        boolean bl5 = false;
        EditorNotificationPanel $this$apply = editorNotificationPanel;
        boolean bl6 = false;
        $this$apply.text(KotlinJvmBundle.message("this.java.file.is.outside.of.java.source.roots.and.won.t.be.added.to.the.classpath", new Object[0]));
        $this$apply.icon(AllIcons.General.Warning);
        return editorNotificationPanel;
    }

    public JavaOutsideModuleDetector(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"JavaOutsideModuleDetector");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<EditorNotific\u2026vaOutsideModuleDetector\")");
        KEY = key;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/JavaOutsideModuleDetector$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ui/EditorNotificationPanel;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

