/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.RedundantIfInspection$RemoveRedundantIf$WhenMappings;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0003\f\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "BranchType", "RedundancyType", "RemoveRedundantIf", "kotlin.idea"})
public final class RedundantIfInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)VisitorWrappersKt.ifExpressionVisitor((Function1)((Function1)new Function1<KtIfExpression, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull KtIfExpression expression2) {
                void redundancyType;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (expression2.getCondition() == null) {
                    return;
                }
                Pair<RedundancyType, BranchType> pair = RedundancyType.Companion.of$kotlin_idea(expression2);
                RedundancyType redundancyType2 = (RedundancyType)((Object)pair.component1());
                BranchType branchType = (BranchType)pair.component2();
                if (redundancyType == RedundancyType.NONE) {
                    return;
                }
                this.$holder.registerProblem((PsiElement)expression2, KotlinBundle.message("redundant.if.statement", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveRedundantIf((RedundancyType)redundancyType, branchType)});
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType;", "", "()V", "Assign", "LabeledReturn", "Return", "Simple", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType$Simple;", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType$Return;", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType$LabeledReturn;", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType$Assign;", "kotlin.idea"})
    private static abstract class BranchType {
        private BranchType() {
        }

        public /* synthetic */ BranchType(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType$Simple;", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType;", "()V", "kotlin.idea"})
        public static final class Simple
        extends BranchType {
            @NotNull
            public static final Simple INSTANCE;

            private Simple() {
                super(null);
            }

            static {
                Simple simple;
                INSTANCE = simple = new Simple();
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType$Return;", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType;", "()V", "kotlin.idea"})
        public static final class Return
        extends BranchType {
            @NotNull
            public static final Return INSTANCE;

            private Return() {
                super(null);
            }

            static {
                Return return_;
                INSTANCE = return_ = new Return();
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType$LabeledReturn;", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType;", "label", "", "(Ljava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kotlin.idea"})
        public static final class LabeledReturn
        extends BranchType {
            @NotNull
            private final String label;

            @NotNull
            public final String getLabel() {
                return this.label;
            }

            public LabeledReturn(@NotNull String label2) {
                Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
                super(null);
                this.label = label2;
            }

            @NotNull
            public final String component1() {
                return this.label;
            }

            @NotNull
            public final LabeledReturn copy(@NotNull String label2) {
                Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
                return new LabeledReturn(label2);
            }

            public static /* synthetic */ LabeledReturn copy$default(LabeledReturn labeledReturn, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = labeledReturn.label;
                }
                return labeledReturn.copy(string);
            }

            @NotNull
            public String toString() {
                return "LabeledReturn(label=" + this.label + ")";
            }

            public int hashCode() {
                String string = this.label;
                return string != null ? string.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof LabeledReturn)) break block3;
                        LabeledReturn labeledReturn = (LabeledReturn)object;
                        if (!Intrinsics.areEqual((Object)this.label, (Object)labeledReturn.label)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType$Assign;", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType;", "lvalue", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getLvalue", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "equals", "", "other", "", "hashCode", "", "kotlin.idea"})
        public static final class Assign
        extends BranchType {
            @NotNull
            private final KtExpression lvalue;

            public boolean equals(@Nullable Object other) {
                return other instanceof Assign && Intrinsics.areEqual((Object)this.lvalue.getText(), (Object)((Assign)other).lvalue.getText());
            }

            public int hashCode() {
                return this.lvalue.getText().hashCode();
            }

            @NotNull
            public final KtExpression getLvalue() {
                return this.lvalue;
            }

            public Assign(@NotNull KtExpression lvalue) {
                Intrinsics.checkNotNullParameter((Object)lvalue, (String)"lvalue");
                super(null);
                this.lvalue = lvalue;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RedundancyType;", "", "(Ljava/lang/String;I)V", "NONE", "THEN_TRUE", "ELSE_TRUE", "Companion", "kotlin.idea"})
    private static final class RedundancyType
    extends Enum<RedundancyType> {
        public static final /* enum */ RedundancyType NONE;
        public static final /* enum */ RedundancyType THEN_TRUE;
        public static final /* enum */ RedundancyType ELSE_TRUE;
        private static final /* synthetic */ RedundancyType[] $VALUES;
        @NotNull
        public static final Companion Companion;

        static {
            RedundancyType[] redundancyTypeArray = new RedundancyType[3];
            RedundancyType[] redundancyTypeArray2 = redundancyTypeArray;
            redundancyTypeArray[0] = NONE = new RedundancyType();
            redundancyTypeArray[1] = THEN_TRUE = new RedundancyType();
            redundancyTypeArray[2] = ELSE_TRUE = new RedundancyType();
            $VALUES = redundancyTypeArray;
            Companion = new Companion(null);
        }

        public static RedundancyType[] values() {
            return (RedundancyType[])$VALUES.clone();
        }

        public static RedundancyType valueOf(String string) {
            return Enum.valueOf(RedundancyType.class, string);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u001e\u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004*\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RedundancyType$Companion;", "", "()V", "of", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RedundancyType;", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType;", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "of$kotlin_idea", "getBranchExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.idea"})
        public static final class Companion {
            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Pair<RedundancyType, BranchType> of$kotlin_idea(@NotNull KtIfExpression expression2) {
                void elseReturn;
                void thenReturn;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                KtExpression ktExpression = this.getBranchExpression(expression2.getThen());
                if (ktExpression == null) {
                    return TuplesKt.to((Object)((Object)NONE), (Object)BranchType.Simple.INSTANCE);
                }
                KtExpression ktExpression2 = ktExpression;
                KtExpression ktExpression3 = (KtExpression)ktExpression2.component1();
                BranchType thenType = (BranchType)ktExpression2.component2();
                Pair<KtExpression, BranchType> pair = this.getBranchExpression(expression2.getElse());
                if (pair == null) {
                    return TuplesKt.to((Object)((Object)NONE), (Object)BranchType.Simple.INSTANCE);
                }
                Pair<KtExpression, BranchType> pair2 = pair;
                ktExpression2 = (KtExpression)pair2.component1();
                BranchType elseType = (BranchType)pair2.component2();
                return Intrinsics.areEqual((Object)thenType, (Object)elseType) ^ true ? TuplesKt.to((Object)((Object)NONE), (Object)BranchType.Simple.INSTANCE) : (KtPsiUtil.isTrueConstant((KtExpression)thenReturn) && KtPsiUtil.isFalseConstant((KtExpression)elseReturn) ? TuplesKt.to((Object)((Object)THEN_TRUE), (Object)thenType) : (KtPsiUtil.isFalseConstant((KtExpression)thenReturn) && KtPsiUtil.isTrueConstant((KtExpression)elseReturn) ? TuplesKt.to((Object)((Object)ELSE_TRUE), (Object)thenType) : TuplesKt.to((Object)((Object)NONE), (Object)BranchType.Simple.INSTANCE)));
            }

            private final Pair<KtExpression, BranchType> getBranchExpression(KtExpression $this$getBranchExpression) {
                Object object;
                KtExpression ktExpression = $this$getBranchExpression;
                if (ktExpression instanceof KtReturnExpression) {
                    BranchType branchType;
                    PsiElement psiElement2 = ((KtReturnExpression)$this$getBranchExpression).getLabeledExpression();
                    if (psiElement2 != null) {
                        PsiElement psiElement3 = psiElement2;
                        boolean bl = false;
                        boolean bl2 = false;
                        PsiElement it = psiElement3;
                        boolean bl3 = false;
                        PsiElement psiElement4 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"it");
                        String string = psiElement4.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                        branchType = new BranchType.LabeledReturn(string);
                    } else {
                        branchType = BranchType.Return.INSTANCE;
                    }
                    BranchType branchType2 = branchType;
                    object = TuplesKt.to((Object)((KtReturnExpression)$this$getBranchExpression).getReturnedExpression(), (Object)branchType2);
                } else if (ktExpression instanceof KtBlockExpression) {
                    List list2 = ((KtBlockExpression)$this$getBranchExpression).getStatements();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"statements");
                    KtExpression ktExpression2 = (KtExpression)CollectionsKt.singleOrNull((List)list2);
                    object = ktExpression2 != null ? this.getBranchExpression(ktExpression2) : null;
                } else if (ktExpression instanceof KtBinaryExpression) {
                    if (Intrinsics.areEqual((Object)((KtBinaryExpression)$this$getBranchExpression).getOperationToken(), (Object)KtTokens.EQ) && ((KtBinaryExpression)$this$getBranchExpression).getLeft() != null) {
                        KtExpression ktExpression3 = ((KtBinaryExpression)$this$getBranchExpression).getRight();
                        KtExpression ktExpression4 = ((KtBinaryExpression)$this$getBranchExpression).getLeft();
                        Intrinsics.checkNotNull((Object)ktExpression4);
                        Intrinsics.checkNotNullExpressionValue((Object)ktExpression4, (String)"left!!");
                        object = TuplesKt.to((Object)ktExpression3, (Object)new BranchType.Assign(ktExpression4));
                    } else {
                        object = null;
                    }
                } else {
                    object = ktExpression instanceof KtExpression ? TuplesKt.to((Object)$this$getBranchExpression, (Object)BranchType.Simple.INSTANCE) : null;
                }
                return object;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RemoveRedundantIf;", "Lcom/intellij/codeInspection/LocalQuickFix;", "redundancyType", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RedundancyType;", "branchType", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType;", "(Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RedundancyType;Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
    private static final class RemoveRedundantIf
    implements LocalQuickFix {
        private final RedundancyType redundancyType;
        private final BranchType branchType;

        @NotNull
        public String getName() {
            return KotlinBundle.message("remove.redundant.if.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
            }
            KtIfExpression element3 = (KtIfExpression)psiElement2;
            if (!CodeInsightUtil.preparePsiElementsForWrite((PsiElement[])new PsiElement[]{(PsiElement)element3})) {
                return;
            }
            switch (RedundantIfInspection$RemoveRedundantIf$WhenMappings.$EnumSwitchMapping$0[this.redundancyType.ordinal()]) {
                case 1: {
                    return;
                }
                case 2: {
                    KtExpression ktExpression2 = element3.getCondition();
                    ktExpression = ktExpression2;
                    Intrinsics.checkNotNull((Object)ktExpression2);
                    break;
                }
                case 3: {
                    KtExpression ktExpression3 = element3.getCondition();
                    Intrinsics.checkNotNull((Object)ktExpression3);
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression3, (String)"element.condition!!");
                    ktExpression = UtilsKt.negate$default(ktExpression3, false, 1, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"when (redundancyType) {\n\u2026!!.negate()\n            }");
            KtExpression condition2 = ktExpression;
            KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null);
            BranchType branchType = this.branchType;
            element3.replace((PsiElement)(branchType instanceof BranchType.Return ? CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"return $0", (Object[])new Object[]{condition2}, (boolean)false, (int)4, null) : (branchType instanceof BranchType.LabeledReturn ? CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)("return" + ((BranchType.LabeledReturn)this.branchType).getLabel() + " $0"), (Object[])new Object[]{condition2}, (boolean)false, (int)4, null) : (branchType instanceof BranchType.Assign ? CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"$0 = $1", (Object[])new Object[]{((BranchType.Assign)this.branchType).getLvalue(), condition2}, (boolean)false, (int)4, null) : condition2))));
        }

        public RemoveRedundantIf(@NotNull RedundancyType redundancyType, @NotNull BranchType branchType) {
            Intrinsics.checkNotNullParameter((Object)((Object)redundancyType), (String)"redundancyType");
            Intrinsics.checkNotNullParameter((Object)branchType, (String)"branchType");
            this.redundancyType = redundancyType;
            this.branchType = branchType;
        }
    }
}

