/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.RedundantGetterInspectionKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\f\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0003"}, d2={"isRedundantSetter", "", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "kotlin.idea"})
public final class RedundantSetterInspectionKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isRedundantSetter(@NotNull KtPropertyAccessor $this$isRedundantSetter) {
        Intrinsics.checkNotNullParameter((Object)$this$isRedundantSetter, (String)"$this$isRedundantSetter");
        if (!$this$isRedundantSetter.isSetter()) {
            return false;
        }
        KtExpression ktExpression = $this$isRedundantSetter.getBodyExpression();
        if (ktExpression == null) return RedundantGetterInspectionKt.canBeCompletelyDeleted($this$isRedundantSetter);
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"bodyExpression ?: return canBeCompletelyDeleted()");
        KtExpression expression2 = ktExpression;
        if (!(expression2 instanceof KtBlockExpression)) return false;
        List list2 = ((KtBlockExpression)expression2).getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"expression.statements");
        KtExpression ktExpression2 = (KtExpression)CollectionsKt.singleOrNull((List)list2);
        if (ktExpression2 == null) return false;
        KtExpression statement = ktExpression2;
        List list3 = $this$isRedundantSetter.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"valueParameters");
        KtParameter ktParameter = (KtParameter)CollectionsKt.singleOrNull((List)list3);
        if (ktParameter == null) return false;
        KtParameter parameter = ktParameter;
        KtExpression ktExpression3 = statement;
        if (!(ktExpression3 instanceof KtBinaryExpression)) {
            ktExpression3 = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression3;
        if (ktBinaryExpression == null) return false;
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        if (!Intrinsics.areEqual((Object)binaryExpression.getOperationToken(), (Object)KtTokens.EQ)) return false;
        KtExpression ktExpression4 = binaryExpression.getLeft();
        if (ktExpression4 == null) return false;
        KtProperty ktProperty = $this$isRedundantSetter.getProperty();
        Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"property");
        if (!RedundantGetterInspectionKt.isBackingFieldReferenceTo(ktExpression4, ktProperty)) return false;
        Object object = binaryExpression.getRight();
        if (!Intrinsics.areEqual(object != null && (object = ReferenceUtilsKt.getMainReference((KtElement)object)) != null ? object.resolve() : null, (Object)parameter)) return false;
        return true;
    }
}

