/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.java;

import com.intellij.codeInsight.ClassUtil;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.KtLightClassMarker;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.java.UnimplementedKotlinInterfaceMemberAnnotator;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.load.java.structure.LightClassOriginKind;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/java/UnimplementedKotlinInterfaceMemberAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "isBinaryOrigin", "", "Lcom/intellij/psi/PsiMethod;", "(Lcom/intellij/psi/PsiMethod;)Z", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "findUnimplementedMethod", "Lorg/jetbrains/kotlin/asJava/elements/KtLightMethod;", "psiClass", "Lcom/intellij/psi/PsiClass;", "report", "method", "shouldBeImplemented", "Lcom/intellij/psi/HierarchicalMethodSignature;", "signaturesVisibleThroughKotlinSuperClass", "", "kotlin.core"})
public final class UnimplementedKotlinInterfaceMemberAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element3, @NotNull AnnotationHolder holder) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            if (!(element3 instanceof PsiClass) || Intrinsics.areEqual((Object)((PsiClass)element3).getLanguage(), (Object)KotlinLanguage.INSTANCE)) {
                return;
            }
            if (((PsiClass)element3).isInterface() || ((PsiClass)element3).hasModifierProperty("abstract")) {
                return;
            }
            if (ClassUtil.getAnyMethodToImplement((PsiClass)((PsiClass)element3)) != null) {
                return;
            }
            KtLightMethod ktLightMethod = this.findUnimplementedMethod((PsiClass)element3);
            if (ktLightMethod == null) break block3;
            KtLightMethod ktLightMethod2 = ktLightMethod;
            boolean bl = false;
            boolean bl2 = false;
            KtLightMethod it = ktLightMethod2;
            boolean bl3 = false;
            this.report(it, holder, (PsiClass)element3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final KtLightMethod findUnimplementedMethod(PsiClass psiClass2) {
        Object v5;
        block7: {
            void $this$firstOrNull$iv;
            PsiClass kotlinSuperClass2;
            Object object;
            Object v2;
            List signaturesFromKotlinInterfaces;
            block6: {
                void $this$filterTo$iv$iv;
                Collection collection = psiClass2.getVisibleSignatures();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"psiClass.visibleSignatures");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PsiMethod method;
                    HierarchicalMethodSignature signature = (HierarchicalMethodSignature)element$iv$iv;
                    boolean bl = false;
                    HierarchicalMethodSignature hierarchicalMethodSignature = signature;
                    Intrinsics.checkNotNullExpressionValue((Object)hierarchicalMethodSignature, (String)"signature");
                    Intrinsics.checkNotNullExpressionValue((Object)hierarchicalMethodSignature.getMethod(), (String)"signature.method");
                    if (!(method instanceof KtLightMethod && method.hasModifierProperty("default") && !method.hasModifierProperty("static"))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection $this$ifEmpty$iv = (List)destination$iv$iv;
                boolean $i$f$ifEmpty = false;
                if ($this$ifEmpty$iv.isEmpty()) {
                    boolean bl = false;
                    return null;
                }
                signaturesFromKotlinInterfaces = (List)$this$ifEmpty$iv;
                Sequence $this$firstOrNull$iv2 = SequencesKt.generateSequence((Object)psiClass2, (Function1)findUnimplementedMethod.kotlinSuperClass.1.INSTANCE);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv2) {
                    PsiClass it = (PsiClass)element$iv;
                    boolean bl = false;
                    if (!(it instanceof KtLightClassForSourceDeclaration)) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            if ((object = (kotlinSuperClass2 = (PsiClass)v2)) == null || (object = object.getVisibleSignatures()) == null) {
                object = CollectionsKt.emptyList();
            }
            Object signaturesVisibleThroughKotlinSuperClass = object;
            Iterable $i$f$firstOrNull = signaturesFromKotlinInterfaces;
            boolean $i$f$firstOrNull2 = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HierarchicalMethodSignature it = (HierarchicalMethodSignature)element$iv;
                boolean bl = false;
                HierarchicalMethodSignature hierarchicalMethodSignature = it;
                Intrinsics.checkNotNullExpressionValue((Object)hierarchicalMethodSignature, (String)"it");
                if (!this.shouldBeImplemented(hierarchicalMethodSignature, (Collection<? extends HierarchicalMethodSignature>)signaturesVisibleThroughKotlinSuperClass)) continue;
                v5 = element$iv;
                break block7;
            }
            v5 = null;
        }
        HierarchicalMethodSignature hierarchicalMethodSignature = v5;
        Object object = hierarchicalMethodSignature != null ? hierarchicalMethodSignature.getMethod() : null;
        if (!(object instanceof KtLightMethod)) {
            object = null;
        }
        return (KtLightMethod)object;
    }

    private final boolean shouldBeImplemented(HierarchicalMethodSignature method, Collection<? extends HierarchicalMethodSignature> signaturesVisibleThroughKotlinSuperClass) {
        boolean hasJvmDefaultOrJvmStatic;
        PsiMethod psiMethod;
        block4: {
            boolean bl;
            if (signaturesVisibleThroughKotlinSuperClass.contains(method)) {
                return false;
            }
            PsiMethod psiMethod2 = method.getMethod();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethod2, (String)"method.method");
            psiMethod = psiMethod2;
            if (this.isBinaryOrigin(psiMethod)) {
                return false;
            }
            PsiModifierList psiModifierList = psiMethod.getModifierList();
            Intrinsics.checkNotNullExpressionValue((Object)psiModifierList, (String)"psiMethod.modifierList");
            PsiAnnotation[] psiAnnotationArray = psiModifierList.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"psiMethod.modifierList.annotations");
            PsiAnnotation[] $this$any$iv = psiAnnotationArray;
            boolean $i$f$any = false;
            PsiAnnotation[] psiAnnotationArray2 = $this$any$iv;
            int n = psiAnnotationArray2.length;
            for (int j = 0; j < n; ++j) {
                PsiAnnotation element$iv;
                PsiAnnotation annotation = element$iv = psiAnnotationArray2[j];
                boolean bl2 = false;
                PsiAnnotation psiAnnotation = annotation;
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"annotation");
                String qualifiedName2 = psiAnnotation.getQualifiedName();
                if (!(Intrinsics.areEqual((Object)qualifiedName2, (Object)JvmAnnotationUtilKt.getJVM_DEFAULT_FQ_NAME().asString()) || Intrinsics.areEqual((Object)qualifiedName2, (Object)AnnotationUtilKt.getJVM_STATIC_ANNOTATION_FQ_NAME().asString()))) continue;
                bl = true;
                break block4;
            }
            bl = hasJvmDefaultOrJvmStatic = false;
        }
        if (hasJvmDefaultOrJvmStatic) {
            return false;
        }
        JvmDefaultMode jvmDefaultMode = (JvmDefaultMode)PlatformKt.getLanguageVersionSettings((PsiElement)psiMethod).getFlag(JvmAnalysisFlags.getJvmDefaultMode());
        return jvmDefaultMode != JvmDefaultMode.ALL_COMPATIBILITY && jvmDefaultMode != JvmDefaultMode.ALL_INCOMPATIBLE;
    }

    private final boolean isBinaryOrigin(PsiMethod $this$isBinaryOrigin) {
        PsiClass psiClass2 = $this$isBinaryOrigin.getContainingClass();
        if (!(psiClass2 instanceof KtLightClassMarker)) {
            psiClass2 = null;
        }
        KtLightClassMarker ktLightClassMarker = (KtLightClassMarker)psiClass2;
        return (ktLightClassMarker != null ? ktLightClassMarker.getOriginKind() : null) == LightClassOriginKind.BINARY;
    }

    private final void report(KtLightMethod method, AnnotationHolder holder, PsiClass psiClass2) {
        String key = psiClass2 instanceof PsiEnumConstantInitializer ? "enum.constant.should.implement.method" : "class.must.be.abstract";
        String string = JavaErrorBundle.message((String)key, (Object[])new Object[]{HighlightUtil.formatClass((PsiClass)psiClass2, (boolean)false), JavaHighlightUtil.formatMethod((PsiMethod)((PsiMethod)method)), HighlightUtil.formatClass((PsiClass)method.getContainingClass(), (boolean)false)});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JavaErrorBundle.message(\u2026ngClass, false)\n        )");
        String message2 = string;
        QuickFixFactory quickFixFactory = QuickFixFactory.getInstance();
        AnnotationBuilder annotationBuilder = holder.newAnnotation(HighlightSeverity.ERROR, message2).range(HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)psiClass2)).withFix((IntentionAction)quickFixFactory.createImplementMethodsFix(psiClass2));
        Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"holder.newAnnotation(Hig\u2026mentMethodsFix(psiClass))");
        AnnotationBuilder error2 = annotationBuilder;
        if (!(psiClass2 instanceof PsiAnonymousClass)) {
            PsiModifierList psiModifierList = psiClass2.getModifierList();
            if (psiModifierList == null || !psiModifierList.hasExplicitModifier("final")) {
                AnnotationBuilder annotationBuilder2 = error2.withFix((IntentionAction)quickFixFactory.createModifierListFix((PsiModifierListOwner)psiClass2, "abstract", true, false));
                Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder2, (String)"error.withFix(quickFixFa\u2026r.ABSTRACT, true, false))");
                error2 = annotationBuilder2;
            }
        }
        error2.create();
    }
}

