/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J#\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0003\u001a\u00020\u0002H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddFileAnnotationFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtFile;", "file", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "argumentClassFqName", "existingAnnotationEntry", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/SmartPsiElementPointer;)V", "addArgumentToExistingAnnotation", "", "annotationEntry", "argumentText", "", "getFamilyName", "getText", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
public final class AddFileAnnotationFix
extends KotlinQuickFixAction<KtFile> {
    private final FqName annotationFqName;
    private final FqName argumentClassFqName;
    private final SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry;

    @NotNull
    public String getText() {
        Object object;
        String annotationName;
        block5: {
            block4: {
                String string = this.annotationFqName.shortName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"annotationFqName.shortName().asString()");
                annotationName = string;
                object = this.argumentClassFqName;
                if (object == null || (object = object.shortName()) == null || (object = object.asString()) == null) break block4;
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                object = (String)it + "::class";
                if (object != null) break block5;
            }
            object = "";
        }
        Object innerText = object;
        String annotationText = annotationName + '(' + (String)innerText + ')';
        Object[] objectArray = new Object[2];
        objectArray[0] = annotationText;
        Object object3 = (KtFile)this.getElement();
        if (object3 == null || (object3 = object3.getName()) == null) {
            object3 = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"element?.name ?: \"\"");
        objectArray[1] = object3;
        return KotlinBundle.message("fix.add.annotation.text.containing.file", objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.add.annotation.family", new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        String innerText;
        String string;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtFile ktFile = (KtFile)this.getElement();
        if (ktFile == null) {
            return;
        }
        KtFile fileToAnnotate = ktFile;
        Object object = this.argumentClassFqName;
        if (object != null && (object = RenderingUtilsKt.render((FqName)object)) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            string = (String)it + "::class";
        } else {
            string = null;
        }
        String string2 = innerText = string;
        String annotationText = string2 == null ? RenderingUtilsKt.render((FqName)this.annotationFqName) : RenderingUtilsKt.render((FqName)this.annotationFqName) + '(' + innerText + ')';
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)fileToAnnotate), (boolean)false, (int)2, null);
        if (fileToAnnotate.getFileAnnotationList() == null) {
            KtFileAnnotationList newAnnotationList = psiFactory.createFileAnnotationListWithAnnotation(annotationText);
            KtFileAnnotationList createdAnnotationList = PsiUtilsKt.replaceFileAnnotationList((KtFile)fileToAnnotate, (KtFileAnnotationList)newAnnotationList);
            fileToAnnotate.addAfter(psiFactory.createWhiteSpace("\n"), (PsiElement)createdAnnotationList);
            ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)createdAnnotationList, null, 2, null);
        } else {
            KtFileAnnotationList ktFileAnnotationList = fileToAnnotate.getFileAnnotationList();
            if (ktFileAnnotationList == null) {
                return;
            }
            KtFileAnnotationList annotationList = ktFileAnnotationList;
            if (this.existingAnnotationEntry == null) {
                KtAnnotationEntry newAnnotation = psiFactory.createFileAnnotation(annotationText);
                annotationList.add(psiFactory.createWhiteSpace("\n"));
                annotationList.add((PsiElement)newAnnotation);
                ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)annotationList, null, 2, null);
            } else if (innerText != null) {
                this.addArgumentToExistingAnnotation(this.existingAnnotationEntry, innerText);
            }
        }
    }

    private final void addArgumentToExistingAnnotation(SmartPsiElementPointer<KtAnnotationEntry> annotationEntry2, String argumentText2) {
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)annotationEntry2.getElement();
        if (ktAnnotationEntry == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry, (String)"annotationEntry.element ?: return");
        KtAnnotationEntry entry = ktAnnotationEntry;
        KtValueArgumentList existingArgumentList = entry.getValueArgumentList();
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)entry), (boolean)false, (int)2, null);
        KtValueArgumentList newArgumentList2 = psiFactory.createCallArguments('(' + argumentText2 + ')');
        if (existingArgumentList == null) {
            entry.addAfter((PsiElement)newArgumentList2, entry.getLastChild());
        } else if (existingArgumentList.getArguments().isEmpty()) {
            existingArgumentList.replace((PsiElement)newArgumentList2);
        } else {
            existingArgumentList.addArgument((KtValueArgument)newArgumentList2.getArguments().get(0));
        }
        ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)entry, null, 2, null);
    }

    public AddFileAnnotationFix(@NotNull KtFile file2, @NotNull FqName annotationFqName, @Nullable FqName argumentClassFqName, @Nullable SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
        super((PsiElement)file2);
        this.annotationFqName = annotationFqName;
        this.argumentClassFqName = argumentClassFqName;
        this.existingAnnotationEntry = existingAnnotationEntry;
    }

    public /* synthetic */ AddFileAnnotationFix(KtFile ktFile, FqName fqName2, FqName fqName3, SmartPsiElementPointer smartPsiElementPointer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            fqName3 = null;
        }
        if ((n & 8) != 0) {
            smartPsiElementPointer = null;
        }
        this(ktFile, fqName2, fqName3, (SmartPsiElementPointer<KtAnnotationEntry>)smartPsiElementPointer);
    }
}

