/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.run.JvmMppUtilsKt;
import org.jetbrains.kotlin.idea.run.KotlinRunConfiguration;
import org.jetbrains.kotlin.idea.run.KotlinRunConfigurationProducer;
import org.jetbrains.kotlin.idea.run.KotlinRunConfigurationType;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinRunConfigurationProducer;", "Lcom/intellij/execution/actions/LazyRunConfigurationProducer;", "Lorg/jetbrains/kotlin/idea/run/KotlinRunConfiguration;", "()V", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getEntryPointContainer", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "location", "Lcom/intellij/execution/Location;", "isConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "Companion", "kotlin.jvm"})
public final class KotlinRunConfigurationProducer
extends LazyRunConfigurationProducer<KotlinRunConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected boolean setupConfigurationFromContext(@NotNull KotlinRunConfiguration configuration2, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration2), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        Location location2 = context2.getLocation();
        if (location2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"context.location ?: return false");
        Location location3 = location2;
        Module module2 = location3.getModule();
        if (module2 == null || (module2 = JvmMppUtilsKt.asJvmModule(module2)) == null) {
            return false;
        }
        Module module3 = module2;
        KtDeclarationContainer ktDeclarationContainer = this.getEntryPointContainer(location3);
        if (ktDeclarationContainer == null) {
            return false;
        }
        KtDeclarationContainer container2 = ktDeclarationContainer;
        String string = Companion.getStartClassFqName(container2);
        if (string == null) {
            return false;
        }
        String startClassFQName = string;
        configuration2.setModule(module3);
        configuration2.setRunClass(startClassFQName);
        configuration2.setGeneratedName();
        return true;
    }

    private final KtDeclarationContainer getEntryPointContainer(Location<?> location2) {
        if (location2 == null) {
            return null;
        }
        DumbService dumbService = DumbService.getInstance((Project)location2.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(location.project)");
        if (dumbService.isDumb()) {
            return null;
        }
        PsiElement psiElement2 = location2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"location.psiElement");
        return Companion.getEntryPointContainer(psiElement2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConfigurationFromContext(@NotNull KotlinRunConfiguration configuration2, @NotNull ConfigurationContext context2) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration2), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtDeclarationContainer ktDeclarationContainer = this.getEntryPointContainer(context2.getLocation());
        if (ktDeclarationContainer == null) return false;
        KtDeclarationContainer entryPointContainer = ktDeclarationContainer;
        String string = Companion.getStartClassFqName(entryPointContainer);
        if (string == null) return false;
        String startClassFQName = string;
        if (!Intrinsics.areEqual((Object)configuration2.getRunClass(), (Object)startClassFQName)) return false;
        Module module2 = context2.getModule();
        JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)configuration2.getConfigurationModule();
        if (!Intrinsics.areEqual((Object)(module2 != null ? JvmMppUtilsKt.asJvmModule(module2) : null), (Object)(javaRunConfigurationModule != null ? javaRunConfigurationModule.getModule() : null))) return false;
        return true;
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return (ConfigurationFactory)KotlinRunConfigurationType.Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0004J\u0016\u0010\n\u001a\u0004\u0018\u00010\u0004*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinRunConfigurationProducer$Companion;", "", "()V", "getEntryPointContainer", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "locationElement", "Lcom/intellij/psi/PsiElement;", "getStartClassFqName", "", "container", "declarationContainer", "strict", "", "kotlin.jvm"})
    public static final class Companion {
        @Nullable
        public final KtDeclarationContainer getEntryPointContainer(@NotNull PsiElement locationElement) {
            Intrinsics.checkNotNullParameter((Object)locationElement, (String)"locationElement");
            PsiFile psiFile2 = locationElement.getContainingFile();
            if (!(psiFile2 instanceof KtFile) || !ProjectRootsUtil.isInProjectOrLibSource$default((PsiElement)psiFile2, false, 2, null)) {
                return null;
            }
            MainFunctionDetector mainFunctionDetector2 = new MainFunctionDetector(PlatformKt.getLanguageVersionSettings((PsiElement)psiFile2), (Function1)getEntryPointContainer.mainFunctionDetector.1.INSTANCE);
            KtDeclarationContainer currentElement = this.declarationContainer(locationElement, false);
            while (currentElement != null) {
                KtDeclarationContainer entryPointContainer = currentElement;
                if (entryPointContainer instanceof KtClass) {
                    entryPointContainer = (KtDeclarationContainer)CollectionsKt.singleOrNull((List)((KtClass)entryPointContainer).getCompanionObjects());
                }
                if (entryPointContainer != null) {
                    List list2 = entryPointContainer.getDeclarations();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"entryPointContainer.declarations");
                    if (mainFunctionDetector2.hasMain(list2)) {
                        return entryPointContainer;
                    }
                }
                currentElement = this.declarationContainer((PsiElement)currentElement, true);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String getStartClassFqName(@NotNull KtDeclarationContainer container2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
            KtDeclarationContainer ktDeclarationContainer = container2;
            if (ktDeclarationContainer instanceof KtFile) {
                string = JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)((KtFile)container2)).asString();
            } else if (ktDeclarationContainer instanceof KtClassOrObject) {
                if (!((KtClassOrObject)container2).isValid()) {
                    string = null;
                } else if (container2 instanceof KtObjectDeclaration && ((KtObjectDeclaration)container2).isCompanion()) {
                    void $this$getParentOfType$iv;
                    PsiElement psiElement2 = (PsiElement)container2;
                    boolean strict$iv = true;
                    boolean $i$f$getParentOfType = false;
                    KtClass containerClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClass.class, (boolean)strict$iv);
                    KtClass ktClass2 = containerClass;
                    if (ktClass2 != null && (ktClass2 = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ktClass2))) != null) {
                        psiElement2 = ktClass2;
                        boolean bl = false;
                        $i$f$getParentOfType = false;
                        PsiElement it = psiElement2;
                        boolean bl2 = false;
                        string = ClassUtil.getJVMClassName((PsiClass)((PsiClass)it));
                    } else {
                        string = null;
                    }
                } else {
                    KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)container2));
                    if (ktLightClass != null) {
                        KtLightClass ktLightClass2 = ktLightClass;
                        boolean bl = false;
                        boolean bl3 = false;
                        KtLightClass it = ktLightClass2;
                        boolean bl4 = false;
                        string = ClassUtil.getJVMClassName((PsiClass)((PsiClass)it));
                    } else {
                        string = null;
                    }
                }
            } else {
                string = null;
            }
            return string;
        }

        private final KtDeclarationContainer declarationContainer(PsiElement $this$declarationContainer, boolean strict) {
            PsiElement element3 = strict ? PsiTreeUtil.getParentOfType((PsiElement)$this$declarationContainer, (Class[])new Class[]{KtClassOrObject.class, KtFile.class}) : PsiTreeUtil.getNonStrictParentOfType((PsiElement)$this$declarationContainer, (Class[])new Class[]{KtClassOrObject.class, KtFile.class});
            return (KtDeclarationContainer)element3;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

