/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchEditorLinesTranslator;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchEditorSyncHighlighter;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchEditorSyncHighlighterKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a \u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000e"}, d2={"configureExclusiveCaretRowHighlighting", "", "sourceEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "previewEditor", "configureHighlightUpdateOnDocumentChange", "highlighter", "Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchEditorSyncHighlighter;", "configurePreviewToSourceHighlighting", "configureSourceAndPreviewHighlighting", "translator", "Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchEditorLinesTranslator;", "configureSourceToPreviewHighlighting", "configureSyncHighlighting", "kotlin.jvm"})
public final class ScratchEditorSyncHighlighterKt {
    public static final void configureSyncHighlighting(@NotNull EditorEx sourceEditor, @NotNull EditorEx previewEditor, @NotNull ScratchEditorLinesTranslator translator) {
        Intrinsics.checkNotNullParameter((Object)sourceEditor, (String)"sourceEditor");
        Intrinsics.checkNotNullParameter((Object)previewEditor, (String)"previewEditor");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        ScratchEditorSyncHighlighterKt.configureExclusiveCaretRowHighlighting(sourceEditor, previewEditor);
        ScratchEditorSyncHighlighterKt.configureSourceAndPreviewHighlighting(sourceEditor, previewEditor, translator);
    }

    private static final void configureSourceAndPreviewHighlighting(EditorEx sourceEditor, EditorEx previewEditor, ScratchEditorLinesTranslator translator) {
        ScratchEditorSyncHighlighter syncHighlighter = ScratchEditorSyncHighlighter.Companion.create(sourceEditor, previewEditor, translator);
        ScratchEditorSyncHighlighterKt.configureHighlightUpdateOnDocumentChange(sourceEditor, previewEditor, syncHighlighter);
        ScratchEditorSyncHighlighterKt.configureSourceToPreviewHighlighting(sourceEditor, syncHighlighter);
        ScratchEditorSyncHighlighterKt.configurePreviewToSourceHighlighting(previewEditor, syncHighlighter);
    }

    private static final void configureExclusiveCaretRowHighlighting(EditorEx sourceEditor, EditorEx previewEditor) {
        FocusChangeListener exclusiveCaretHighlightingListener2 = new FocusChangeListener(sourceEditor, previewEditor){
            final /* synthetic */ EditorEx $sourceEditor;
            final /* synthetic */ EditorEx $previewEditor;

            public void focusLost(@NotNull Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            }

            public void focusGained(@NotNull Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                EditorSettings editorSettings = this.$sourceEditor.getSettings();
                Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"sourceEditor.settings");
                editorSettings.setCaretRowShown(false);
                EditorSettings editorSettings2 = this.$previewEditor.getSettings();
                Intrinsics.checkNotNullExpressionValue((Object)editorSettings2, (String)"previewEditor.settings");
                editorSettings2.setCaretRowShown(false);
                EditorSettings editorSettings3 = editor2.getSettings();
                Intrinsics.checkNotNullExpressionValue((Object)editorSettings3, (String)"editor.settings");
                editorSettings3.setCaretRowShown(true);
            }
            {
                this.$sourceEditor = $captured_local_variable$0;
                this.$previewEditor = $captured_local_variable$1;
            }
        };
        sourceEditor.addFocusListener(exclusiveCaretHighlightingListener2);
        previewEditor.addFocusListener(exclusiveCaretHighlightingListener2);
    }

    private static final void configureHighlightUpdateOnDocumentChange(EditorEx sourceEditor, EditorEx previewEditor, ScratchEditorSyncHighlighter highlighter) {
        Project project2 = sourceEditor.getProject();
        Intrinsics.checkNotNull((Object)project2);
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"sourceEditor.project!!");
        Project project3 = project2;
        DocumentListener updateHighlightOnDocumentChangeListener2 = new DocumentListener(project3, highlighter){
            final /* synthetic */ Project $project;
            final /* synthetic */ ScratchEditorSyncHighlighter $highlighter;

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                PsiDocumentManager.getInstance((Project)this.$project).performWhenAllCommitted(new Runnable(this){
                    final /* synthetic */ configureHighlightUpdateOnDocumentChange.updateHighlightOnDocumentChangeListener.1 this$0;

                    public final void run() {
                        this.this$0.$highlighter.highlightByCurrentlyFocusedEditor();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$project = $captured_local_variable$0;
                this.$highlighter = $captured_local_variable$1;
            }
        };
        Disposable disposable2 = KotlinPluginDisposable.Companion.getInstance(project3);
        previewEditor.getDocument().addDocumentListener(updateHighlightOnDocumentChangeListener2, disposable2);
        sourceEditor.getDocument().addDocumentListener(updateHighlightOnDocumentChangeListener2, disposable2);
    }

    private static final void configureSourceToPreviewHighlighting(EditorEx sourceEditor, ScratchEditorSyncHighlighter highlighter) {
        sourceEditor.getCaretModel().addCaretListener(new CaretListener(highlighter){
            final /* synthetic */ ScratchEditorSyncHighlighter $highlighter;

            public void caretPositionChanged(@NotNull CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$highlighter.highlightPreviewBySource();
            }
            {
                this.$highlighter = $captured_local_variable$0;
            }
        });
        sourceEditor.addFocusListener(new FocusChangeListener(highlighter){
            final /* synthetic */ ScratchEditorSyncHighlighter $highlighter;

            public void focusLost(@NotNull Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            }

            public void focusGained(@NotNull Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                this.$highlighter.highlightPreviewBySource();
            }
            {
                this.$highlighter = $captured_local_variable$0;
            }
        });
    }

    private static final void configurePreviewToSourceHighlighting(EditorEx previewEditor, ScratchEditorSyncHighlighter highlighter) {
        previewEditor.getCaretModel().addCaretListener(new CaretListener(highlighter){
            final /* synthetic */ ScratchEditorSyncHighlighter $highlighter;

            public void caretPositionChanged(@NotNull CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$highlighter.highlightSourceByPreview();
            }
            {
                this.$highlighter = $captured_local_variable$0;
            }
        });
        previewEditor.addFocusListener(new FocusChangeListener(highlighter){
            final /* synthetic */ ScratchEditorSyncHighlighter $highlighter;

            public void focusLost(@NotNull Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            }

            public void focusGained(@NotNull Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                this.$highlighter.highlightSourceByPreview();
            }
            {
                this.$highlighter = $captured_local_variable$0;
            }
        });
    }
}

