/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.vcs;

import com.intellij.BundleBase;
import com.intellij.CommonBundle;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.PairConsumer;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.vcs.BunchCheckinHandlerKt;
import org.jetbrains.kotlin.idea.vcs.BunchFileUtils;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/vcs/BunchFileCheckInHandlerFactory;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandlerFactory;", "()V", "createHandler", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "BunchCheckInHandler", "kotlin.jvm"})
public final class BunchFileCheckInHandlerFactory
extends CheckinHandlerFactory {
    @NotNull
    public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel2, @NotNull CommitContext commitContext) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
        return new BunchCheckInHandler(panel2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/vcs/BunchFileCheckInHandlerFactory$BunchCheckInHandler;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "checkInProjectPanel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "(Lcom/intellij/openapi/vcs/CheckinProjectPanel;)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "beforeCheckin", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "executor", "Lcom/intellij/openapi/vcs/changes/CommitExecutor;", "additionalDataConsumer", "Lcom/intellij/util/PairConsumer;", "", "getBeforeCheckinConfigurationPanel", "Lcom/intellij/openapi/vcs/ui/RefreshableOnComponent;", "kotlin.jvm"})
    public static final class BunchCheckInHandler
    extends CheckinHandler {
        private final CheckinProjectPanel checkInProjectPanel;

        private final Project getProject() {
            Project project2 = this.checkInProjectPanel.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"checkInProjectPanel.project");
            return project2;
        }

        @Nullable
        public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
            if (PluginManagerCore.isPluginInstalled((PluginId)BunchCheckinHandlerKt.access$getBUNCH_PLUGIN_ID$p())) {
                return null;
            }
            if (BunchFileUtils.INSTANCE.bunchFile(this.getProject()) == null) {
                return null;
            }
            NonFocusableCheckBox bunchFilesCheckBox = new NonFocusableCheckBox(BundleBase.replaceMnemonicAmpersand((String)KotlinJvmBundle.message("check.bunch.files", new Object[0])));
            return new RefreshableOnComponent(this, bunchFilesCheckBox){
                final /* synthetic */ BunchCheckInHandler this$0;
                final /* synthetic */ NonFocusableCheckBox $bunchFilesCheckBox;

                @NotNull
                public JComponent getComponent() {
                    JPanel panel2 = new JPanel(new GridLayout(1, 0));
                    panel2.add((Component)this.$bunchFilesCheckBox);
                    return panel2;
                }

                public void saveState() {
                    BunchCheckinHandlerKt.access$setBunchFileCheckEnabled$p(BunchCheckInHandler.access$getProject$p(this.this$0), this.$bunchFilesCheckBox.isSelected());
                }

                public void restoreState() {
                    this.$bunchFilesCheckBox.setSelected(BunchCheckinHandlerKt.access$getBunchFileCheckEnabled$p(BunchCheckInHandler.access$getProject$p(this.this$0)));
                }
                {
                    this.this$0 = this$0;
                    this.$bunchFilesCheckBox = $captured_local_variable$1;
                }
            };
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @NotNull
        public CheckinHandler.ReturnResult beforeCheckin(@Nullable CommitExecutor executor, @Nullable PairConsumer<Object, Object> additionalDataConsumer) {
            if (!BunchCheckinHandlerKt.access$getBunchFileCheckEnabled$p(this.getProject())) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            v0 = BunchFileUtils.INSTANCE.bunchExtension(this.getProject());
            if (v0 == null || (v0 = CollectionsKt.toSet((Iterable)v0)) == null) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            extensions = v0;
            forgottenFiles = new HashSet<Path>();
            v1 = this.checkInProjectPanel.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"checkInProjectPanel.files");
            $this$mapNotNull$iv = v1;
            $i$f$mapNotNull = false;
            var8_8 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var13_25 = $this$forEach$iv$iv$iv.iterator();
            while (var13_25.hasNext()) {
                element$iv$iv = element$iv$iv$iv /* !! */  = var13_25.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                file = (File)element$iv$iv;
                $i$a$-mapNotNull-BunchFileCheckInHandlerFactory$BunchCheckInHandler$beforeCheckin$commitFiles$1 = false;
                var19_37 = file.toPath();
                var20_38 = false;
                var21_40 = false;
                it = var19_37;
                $i$a$-takeIf-BunchFileCheckInHandlerFactory$BunchCheckInHandler$beforeCheckin$commitFiles$1$1 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                var25_44 = new LinkOption[]{};
                var26_45 = false;
                if ((Files.isRegularFile(var24_43, Arrays.copyOf(var25_44, var25_44.length)) != false ? var19_37 : null) == null) continue;
                var27_46 = var27_46;
                var28_47 = false;
                var29_48 = false;
                it$iv$iv = var27_46;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            commitFiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            for (Path file : commitFiles) {
                if (extensions.contains(PathsKt.getExtension((Path)file))) continue;
                if (file.getParent() == null) {
                    continue;
                }
                name = PathsKt.getName((Path)file);
                for (String extension : extensions) {
                    bunchFile = parent.resolve(name + '.' + extension);
                    if (commitFiles.contains(bunchFile)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)bunchFile, (String)"bunchFile");
                    element$iv$iv$iv /* !! */  = new LinkOption[]{};
                    element$iv$iv = false;
                    v2 /* !! */  = element$iv$iv$iv /* !! */ ;
                    if (!Files.exists((Path)var13_25, (LinkOption[])Arrays.copyOf(v2 /* !! */ , ((T)v2 /* !! */ ).length))) continue;
                    forgottenFiles.add(bunchFile);
                }
            }
            if (forgottenFiles.isEmpty()) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            v3 = this.getProject().getBasePath();
            if (v3 == null) ** GOTO lbl-1000
            $i$f$mapNotNull = v3;
            parent = false;
            name = false;
            p1 = $i$f$mapNotNull;
            $i$a$-unknown-BunchFileCheckInHandlerFactory$BunchCheckInHandler$beforeCheckin$paths$1 = false;
            bunchFile = false;
            v4 = Paths.get((String)p1, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"Paths.get(path)");
            v3 = v4;
            if (v4 != null) {
                $i$f$mapNotNull = v3;
                parent = false;
                name = false;
                projectBasePath = $i$f$mapNotNull;
                $i$a$-let-BunchFileCheckInHandlerFactory$BunchCheckInHandler$beforeCheckin$paths$2 = false;
                $this$map$iv = forgottenFiles;
                $i$f$map = false;
                element$iv$iv$iv /* !! */  = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var19_37 = (Path)item$iv$iv;
                    var20_39 = destination$iv$iv;
                    $i$a$-map-BunchFileCheckInHandlerFactory$BunchCheckInHandler$beforeCheckin$paths$2$1 = false;
                    var22_41 = PathsKt.relativeTo((Path)it, (Path)projectBasePath);
                    var20_39.add(var22_41);
                }
                v5 = (List)destination$iv$iv;
            } else lbl-1000:
            // 2 sources

            {
                v5 = forgottenFiles;
            }
            paths = v5;
            $this$map$iv = paths;
            $i$f$map = false;
            projectBasePath = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            var13_27 = $this$mapTo$iv$iv.iterator();
            while (var13_27.hasNext()) {
                destination$iv$iv = item$iv$iv = var13_27.next();
                var32_52 = destination$iv$iv;
                $i$a$-unknown-Object = false;
                var33_53 = PathsKt.getPathString((Path)((Path)receiver));
                var32_52.add(var33_53);
            }
            filePaths = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            if (filePaths.size() > 15) {
                filePaths = CollectionsKt.plus((Collection)CollectionsKt.take((Iterable)filePaths, (int)15), (Object)"...");
            }
            switch (Messages.showYesNoCancelDialog((Project)this.getProject(), (String)KotlinJvmBundle.message("several.bunch.files.haven.t.been.updated.0.do.you.want.to.review.them.before.commit", new Object[]{CollectionsKt.joinToString$default((Iterable)filePaths, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)}), (String)KotlinJvmBundle.message("button.text.forgotten.bunch.files", new Object[0]), (String)KotlinJvmBundle.message("button.text.review", new Object[0]), (String)KotlinJvmBundle.message("button.text.commit", new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon())) {
                case 0: {
                    return CheckinHandler.ReturnResult.CLOSE_WINDOW;
                }
                case 1: {
                    return CheckinHandler.ReturnResult.COMMIT;
                }
            }
            return CheckinHandler.ReturnResult.CANCEL;
        }

        public BunchCheckInHandler(@NotNull CheckinProjectPanel checkInProjectPanel) {
            Intrinsics.checkNotNullParameter((Object)checkInProjectPanel, (String)"checkInProjectPanel");
            this.checkInProjectPanel = checkInProjectPanel;
        }

        public static final /* synthetic */ Project access$getProject$p(BunchCheckInHandler $this) {
            return $this.getProject();
        }
    }
}

