/*
 * Decompiled with CFR 0.152.
 */
package andel.text.operation;

import andel.text.operation.IntervalPoint;
import andel.text.operation.ShiftIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010+\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u001f\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00060\u0005J\u0016\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0006H\u0002J\"\u0010\u0011\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00060\u0005H\u0016J0\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\t2\u001e\u0010\u0016\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0004\u0012\u00020\u00180\u0017H\u0016JB\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00060\u00052\u0006\u0010\u0015\u001a\u00020\t2\u001e\u0010\u0016\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\tH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00060\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Landel/text/operation/TrivialShiftIterator2;", "K", "V", "Landel/text/operation/ShiftIterator;", "points", "", "Landel/text/operation/IntervalPoint;", "(Ljava/util/List;)V", "accumulatedShift", "", "current", "iterator", "", "updatedPoints", "Ljava/util/LinkedList;", "buildUpdatedPoints", "getNextAndApplyShift", "insertAll", "", "data", "scanToChar", "offset", "predicate", "Lkotlin/Function1;", "", "scanToCharRemoving", "settleIterator", "shiftSinceCurrent", "diff", "fleet.andel.common"})
final class TrivialShiftIterator2<K, V>
implements ShiftIterator<K, V> {
    private final LinkedList<IntervalPoint<K, V>> updatedPoints;
    private ListIterator<IntervalPoint<K, V>> iterator;
    private IntervalPoint<K, V> current;
    private long accumulatedShift;

    @NotNull
    public final List<IntervalPoint<K, V>> buildUpdatedPoints() {
        while (this.iterator.hasNext()) {
            this.getNextAndApplyShift();
        }
        return new ArrayList(this.updatedPoints);
    }

    @Override
    public void scanToChar(long offset, @NotNull Function1<? super IntervalPoint<K, V>, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        this.settleIterator();
        while (this.current != null) {
            IntervalPoint<K, V> intervalPoint = this.current;
            Intrinsics.checkNotNull(intervalPoint);
            if (intervalPoint.getOffset() >= offset) {
                IntervalPoint<K, V> intervalPoint2 = this.current;
                Intrinsics.checkNotNull(intervalPoint2);
                if (intervalPoint2.getOffset() != offset) break;
                IntervalPoint<K, V> intervalPoint3 = this.current;
                Intrinsics.checkNotNull(intervalPoint3);
                if (((Boolean)predicate.invoke(intervalPoint3)).booleanValue()) break;
            }
            this.getNextAndApplyShift();
        }
    }

    @Override
    @NotNull
    public List<IntervalPoint<K, V>> scanToCharRemoving(long offset, @NotNull Function1<? super IntervalPoint<K, V>, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        this.settleIterator();
        boolean bl = false;
        List result2 = new ArrayList();
        while (this.current != null) {
            IntervalPoint<K, V> intervalPoint = this.current;
            Intrinsics.checkNotNull(intervalPoint);
            if (intervalPoint.getOffset() >= offset) {
                IntervalPoint<K, V> intervalPoint2 = this.current;
                Intrinsics.checkNotNull(intervalPoint2);
                if (intervalPoint2.getOffset() != offset) break;
                IntervalPoint<K, V> intervalPoint3 = this.current;
                Intrinsics.checkNotNull(intervalPoint3);
                if (((Boolean)predicate.invoke(intervalPoint3)).booleanValue()) break;
            }
            IntervalPoint<K, V> intervalPoint4 = this.current;
            Intrinsics.checkNotNull(intervalPoint4);
            result2.add(intervalPoint4);
            this.iterator.remove();
            this.getNextAndApplyShift();
        }
        return result2;
    }

    @Override
    public void shiftSinceCurrent(long diff) {
        this.accumulatedShift += diff;
        if (diff != 0L && this.current != null) {
            IntervalPoint<K, V> intervalPoint = this.current;
            Intrinsics.checkNotNull(intervalPoint);
            IntervalPoint<K, V> intervalPoint2 = this.current;
            Intrinsics.checkNotNull(intervalPoint2);
            IntervalPoint<K, V> shiftedCurrent = intervalPoint.withOffset(intervalPoint2.getOffset() + diff);
            this.iterator.set(shiftedCurrent);
            this.current = shiftedCurrent;
        }
    }

    @Override
    public void insertAll(@NotNull List<IntervalPoint<K, V>> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.settleIterator();
        Collection collection = data;
        boolean bl = false;
        if (!collection.isEmpty()) {
            boolean shouldInsertBeforeCurrent;
            boolean bl2 = shouldInsertBeforeCurrent = this.current != null;
            if (shouldInsertBeforeCurrent) {
                this.iterator.previous();
            }
            Iterable $this$forEach$iv = data;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IntervalPoint it = (IntervalPoint)element$iv;
                boolean bl3 = false;
                this.iterator.add(it);
            }
            if (shouldInsertBeforeCurrent) {
                this.iterator.next();
            }
        }
    }

    private final IntervalPoint<K, V> getNextAndApplyShift() {
        IntervalPoint<K, V> intervalPoint = this.current = this.iterator.hasNext() ? this.iterator.next() : null;
        if (this.current != null && this.accumulatedShift != 0L) {
            IntervalPoint<K, V> intervalPoint2 = this.current;
            Intrinsics.checkNotNull(intervalPoint2);
            IntervalPoint<K, V> intervalPoint3 = this.current;
            Intrinsics.checkNotNull(intervalPoint3);
            IntervalPoint<K, V> shiftedCurrent = intervalPoint2.withOffset(intervalPoint3.getOffset() + this.accumulatedShift);
            this.iterator.set(shiftedCurrent);
            this.current = shiftedCurrent;
        }
        return this.current;
    }

    private final void settleIterator() {
        if (this.current == null && this.iterator.hasNext()) {
            this.current = this.iterator.next();
        }
    }

    public TrivialShiftIterator2(@NotNull List<IntervalPoint<K, V>> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        this.updatedPoints = new LinkedList(points);
        ListIterator listIterator = this.updatedPoints.listIterator();
        Intrinsics.checkNotNullExpressionValue(listIterator, (String)"updatedPoints.listIterator()");
        this.iterator = listIterator;
    }
}

