/*
 * Decompiled with CFR 0.152.
 */
package fleet.rpc.client;

import fleet.api.FleetApi;
import fleet.rpc.client.ApiService;
import fleet.util.UID;
import fleet.util.lifetimes.Lifetime;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J-\u0010\t\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0001R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lfleet/rpc/client/DispatchingApiService;", "Lfleet/rpc/client/ApiService;", "fallback", "(Lfleet/rpc/client/ApiService;)V", "delegates", "Ljava/util/concurrent/ConcurrentHashMap;", "Lfleet/util/UID;", "getDelegates", "()Ljava/util/concurrent/ConcurrentHashMap;", "proxy", "T", "Lfleet/api/FleetApi;", "klass", "Lkotlin/reflect/KClass;", "route", "(Lkotlin/reflect/KClass;Lfleet/util/UID;)Lfleet/api/FleetApi;", "register", "", "lifetime", "Lfleet/util/lifetimes/Lifetime;", "api", "fleet.rpc"})
public final class DispatchingApiService
implements ApiService {
    @NotNull
    private final ApiService fallback;
    @NotNull
    private final ConcurrentHashMap<UID, ApiService> delegates;

    public DispatchingApiService(@NotNull ApiService fallback) {
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        this.fallback = fallback;
        this.delegates = new ConcurrentHashMap();
    }

    @NotNull
    public final ConcurrentHashMap<UID, ApiService> getDelegates() {
        return this.delegates;
    }

    public final void register(@NotNull Lifetime lifetime, @NotNull UID route, @NotNull ApiService api) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        boolean bl = this.delegates.putIfAbsent(route, api) == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Duplicated registration for route ", (Object)route);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        lifetime.add((Function0<Unit>)((Function0)new Function0<Unit>(this, route){
            final /* synthetic */ DispatchingApiService this$0;
            final /* synthetic */ UID $route;
            {
                this.this$0 = $receiver;
                this.$route = $route;
                super(0);
            }

            public final void invoke() {
                this.this$0.getDelegates().remove(this.$route);
            }
        }));
    }

    @Override
    @NotNull
    public <T extends FleetApi> T proxy(@NotNull KClass<T> klass, @NotNull UID route) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        ApiService apiService = this.delegates.get(route);
        T t = apiService == null ? null : (T)apiService.proxy(klass, route);
        return t == null ? (T)this.fallback.proxy(klass, route) : t;
    }
}

