/*
 * Decompiled with CFR 0.152.
 */
package fleet.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\f\u001a\u00020\r\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"DATE_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "DATE_WITH_YEAR_FORMATTER", "FULL_FORMATTER", "TIME_FORMATTER", "utcSeconds", "Ljava/time/LocalDateTime;", "timestamp", "", "formatTimestamp", "", "shorten", "", "fleet.util"})
public final class DateUtilKt {
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("MMM d");
    private static final DateTimeFormatter DATE_WITH_YEAR_FORMATTER = DateTimeFormatter.ofPattern("MMM d, yyyy");
    private static final DateTimeFormatter FULL_FORMATTER = DateTimeFormatter.ofPattern("HH:mm MMM d, yyyy");

    @NotNull
    public static final LocalDateTime utcSeconds(long timestamp) {
        LocalDateTime localDateTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(timestamp * (long)1000), ZoneOffset.UTC).atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"OffsetDateTime.ofInstant\u2026))\n    .toLocalDateTime()");
        return localDateTime;
    }

    @NotNull
    public static final String formatTimestamp(@NotNull LocalDateTime $this$formatTimestamp, boolean shorten) {
        Intrinsics.checkNotNullParameter((Object)$this$formatTimestamp, (String)"$this$formatTimestamp");
        LocalDateTime ldt = $this$formatTimestamp;
        if (shorten) {
            OffsetDateTime now = OffsetDateTime.now();
            int n = ldt.getYear();
            OffsetDateTime offsetDateTime = now;
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"now");
            if (n == offsetDateTime.getYear() && ldt.getDayOfYear() == now.getDayOfYear()) {
                String string = TIME_FORMATTER.format(ldt);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TIME_FORMATTER.format(ldt)");
                return string;
            }
            OffsetDateTime yesterday = now.minusDays(1L);
            int n2 = ldt.getYear();
            OffsetDateTime offsetDateTime2 = yesterday;
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime2, (String)"yesterday");
            if (n2 == offsetDateTime2.getYear() && ldt.getDayOfYear() == yesterday.getDayOfYear()) {
                return "Yesterday";
            }
            if (ldt.getYear() == now.getYear()) {
                String string = DATE_FORMATTER.format(ldt);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DATE_FORMATTER.format(ldt)");
                return string;
            }
            String string = DATE_WITH_YEAR_FORMATTER.format(ldt);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DATE_WITH_YEAR_FORMATTER.format(ldt)");
            return string;
        }
        String string = FULL_FORMATTER.format(ldt);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FULL_FORMATTER.format(ldt)");
        return string;
    }
}

