/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.internal;

import io.opentelemetry.sdk.common.Clock;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MonotonicClock
implements Clock {
    private final Clock clock;
    private final long epochNanos;
    private final long nanoTime;

    private MonotonicClock(Clock clock, long epochNanos, long nanoTime) {
        this.clock = clock;
        this.epochNanos = epochNanos;
        this.nanoTime = nanoTime;
    }

    public static MonotonicClock create(Clock clock) {
        return new MonotonicClock(clock, clock.now(), clock.nanoTime());
    }

    @Override
    public long now() {
        long deltaNanos = this.clock.nanoTime() - this.nanoTime;
        return this.epochNanos + deltaNanos;
    }

    @Override
    public long nanoTime() {
        return this.clock.nanoTime();
    }
}

