/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.resources;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.sdk.resources.AutoValue_Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class Resource {
    private static final int MAX_LENGTH = 255;
    private static final String ERROR_MESSAGE_INVALID_CHARS = " should be a ASCII string with a length greater than 0 and not exceed 255 characters.";
    private static final String ERROR_MESSAGE_INVALID_VALUE = " should be a ASCII string with a length not exceed 255 characters.";
    private static final Resource EMPTY = Resource.create(Attributes.empty());
    private static final Resource TELEMETRY_SDK;
    private static final Resource MANDATORY;
    private static final Resource DEFAULT;

    public static Resource getDefault() {
        return DEFAULT;
    }

    public static Resource empty() {
        return EMPTY;
    }

    public static Resource create(Attributes attributes) {
        Resource.checkAttributes(Objects.requireNonNull(attributes, "attributes"));
        return new AutoValue_Resource(attributes);
    }

    @Nullable
    private static String readVersion() {
        Properties properties = new Properties();
        try {
            properties.load(Resource.class.getResourceAsStream("/io/opentelemetry/sdk/version.properties"));
        }
        catch (Exception e) {
            return "unknown";
        }
        return properties.getProperty("sdk.version");
    }

    Resource() {
    }

    public abstract Attributes getAttributes();

    @Memoized
    public abstract int hashCode();

    public Resource merge(@Nullable Resource other) {
        if (other == null) {
            return this;
        }
        AttributesBuilder attrBuilder = Attributes.builder();
        attrBuilder.putAll(this.getAttributes());
        attrBuilder.putAll(other.getAttributes());
        return new AutoValue_Resource(attrBuilder.build());
    }

    private static void checkAttributes(Attributes attributes) {
        attributes.forEach((key, value) -> {
            Utils.checkArgument(Resource.isValidAndNotEmpty(key), "Attribute key should be a ASCII string with a length greater than 0 and not exceed 255 characters.");
            Objects.requireNonNull(value, "Attribute value should be a ASCII string with a length not exceed 255 characters.");
        });
    }

    private static boolean isValid(String name) {
        return name.length() <= 255 && StringUtils.isPrintableString(name);
    }

    private static boolean isValidAndNotEmpty(AttributeKey<?> name) {
        return !name.getKey().isEmpty() && Resource.isValid(name.getKey());
    }

    public static ResourceBuilder builder() {
        return new ResourceBuilder();
    }

    public ResourceBuilder toBuilder() {
        return Resource.builder().putAll(this);
    }

    static {
        MANDATORY = Resource.create(Attributes.of(ResourceAttributes.SERVICE_NAME, "unknown_service:java"));
        TELEMETRY_SDK = Resource.create(Attributes.builder().put(ResourceAttributes.TELEMETRY_SDK_NAME, "opentelemetry").put(ResourceAttributes.TELEMETRY_SDK_LANGUAGE, "java").put(ResourceAttributes.TELEMETRY_SDK_VERSION, Resource.readVersion()).build());
        DEFAULT = MANDATORY.merge(TELEMETRY_SDK);
    }
}

