/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.sdk.trace.IdGenerator;
import java.util.Random;

enum AndroidFriendlyRandomIdGenerator implements IdGenerator
{
    INSTANCE;

    private static final Random random;
    private static final long INVALID_ID = 0L;

    @Override
    public String generateSpanId() {
        long id;
        while ((id = random.nextLong()) == 0L) {
        }
        return SpanId.fromLong(id);
    }

    @Override
    public String generateTraceId() {
        long idLo;
        long idHi;
        do {
            idHi = random.nextLong();
            idLo = random.nextLong();
        } while (idHi == 0L && idLo == 0L);
        return TraceId.fromLongs(idHi, idLo);
    }

    static {
        random = new Random();
    }
}

