/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import org.gradle.api.Action;
import org.gradle.api.internal.MutationGuard;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.internal.exceptions.Contextual;

public abstract class AbstractMutationGuard
implements MutationGuard {
    @Override
    public void assertMutationAllowed(String methodName, Object target) {
        if (!this.isMutationAllowed()) {
            throw AbstractMutationGuard.createIllegalStateException(new DslObject(target).getPublicType().getConcreteClass(), methodName, target);
        }
    }

    @Override
    public <T> void assertMutationAllowed(String methodName, T target, Class<T> targetType) {
        if (!this.isMutationAllowed()) {
            throw AbstractMutationGuard.createIllegalStateException(targetType, methodName, target);
        }
    }

    private static <T> IllegalStateException createIllegalStateException(Class<T> targetType, String methodName, T target) {
        return new IllegalMutationException(String.format("%s#%s on %s cannot be executed in the current context.", targetType.getSimpleName(), methodName, target));
    }

    protected abstract <T> Action<? super T> newActionWithMutation(Action<? super T> var1, boolean var2);

    @Override
    public <T> Action<? super T> withMutationEnabled(Action<? super T> action) {
        return this.newActionWithMutation(action, true);
    }

    @Override
    public <T> Action<? super T> withMutationDisabled(Action<? super T> action) {
        return this.newActionWithMutation(action, false);
    }

    @Contextual
    private static class IllegalMutationException
    extends IllegalStateException {
        public IllegalMutationException(String message2) {
            super(message2);
        }
    }
}

